/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.fix;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.node.NullNode;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.Binds;
import com.intellij.docker.agent.fix.FixedBindParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@JsonDeserialize(using=FixedDeserializer.class)
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0007B\u001b\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/intellij/docker/agent/fix/FixedBinds;", "Lcom/github/dockerjava/api/model/Binds;", "binds", "", "Lcom/github/dockerjava/api/model/Bind;", "<init>", "([Lcom/github/dockerjava/api/model/Bind;)V", "FixedDeserializer", "intellij.clouds.docker.agent"})
public final class FixedBinds
extends Binds {
    public FixedBinds(Bind ... binds) {
        Intrinsics.checkNotNullParameter((Object)binds, (String)"binds");
        super(Arrays.copyOf(binds, binds.length));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/agent/fix/FixedBinds$FixedDeserializer;", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "Lcom/github/dockerjava/api/model/Binds;", "<init>", "()V", "deserialize", "jsonParser", "Lcom/fasterxml/jackson/core/JsonParser;", "deserializationContext", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "intellij.clouds.docker.agent"})
    @SourceDebugExtension(value={"SMAP\nFixedBinds.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixedBinds.kt\ncom/intellij/docker/agent/fix/FixedBinds$FixedDeserializer\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,44:1\n37#2,2:45\n*S KotlinDebug\n*F\n+ 1 FixedBinds.kt\ncom/intellij/docker/agent/fix/FixedBinds$FixedDeserializer\n*L\n40#1:45,2\n*E\n"})
    public static final class FixedDeserializer
    extends JsonDeserializer<Binds> {
        @NotNull
        public Binds deserialize(@NotNull JsonParser jsonParser, @NotNull DeserializationContext deserializationContext) throws IOException {
            Intrinsics.checkNotNullParameter((Object)jsonParser, (String)"jsonParser");
            Intrinsics.checkNotNullParameter((Object)deserializationContext, (String)"deserializationContext");
            List binds = new ArrayList();
            ObjectCodec oc = jsonParser.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jsonParser);
            Iterator it = node.elements();
            while (it.hasNext()) {
                JsonNode element = (JsonNode)it.next();
                if (Intrinsics.areEqual((Object)element, (Object)NullNode.getInstance())) continue;
                Bind bind = FixedBindParser.parse(element.asText());
                Intrinsics.checkNotNullExpressionValue((Object)bind, (String)"parse(...)");
                binds.add(bind);
            }
            Collection $this$toTypedArray$iv = binds;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Bind[] bindArray = thisCollection$iv.toArray(new Bind[0]);
            return new FixedBinds(Arrays.copyOf(bindArray, bindArray.length));
        }
    }
}

