/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DataSourceBriefConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseConnectivityConfiguration;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DbOptionProvider;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.properties.Level;
import com.intellij.database.util.TreePattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J3\u0010!\u001a\u0004\u0018\u0001H\"\"\u0004\b\u0000\u0010\"2\u001c\u0010#\u001a\u0018\u0012\u0014\b\u0001\u0012\u0010\u0012\u0006\b\u0001\u0012\u00020&\u0012\u0004\u0012\u0002H\"0%0$H\u0016\u00a2\u0006\u0002\u0010'R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\tR\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Lcom/intellij/database/dataSource/ConnectionBriefConfig;", "Lcom/intellij/database/dataSource/DataSourceBriefConfig;", "dcp", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "<init>", "(Lcom/intellij/database/dataSource/DatabaseConnectionPoint;)V", "uniqueId", "", "getUniqueId", "()Ljava/lang/String;", "name", "getName", "dbms", "Lcom/intellij/database/Dbms;", "getDbms", "()Lcom/intellij/database/Dbms;", "boundTo", "Lcom/intellij/database/model/ObjectKind;", "getBoundTo", "()Lcom/intellij/database/model/ObjectKind;", "boundStr", "getBoundStr", "isRewriteBounds", "", "()Z", "introspectionScope", "Lcom/intellij/database/util/TreePattern;", "getIntrospectionScope", "()Lcom/intellij/database/util/TreePattern;", "introspectionLevel", "Lcom/intellij/database/model/properties/Level;", "getIntrospectionLevel", "()Lcom/intellij/database/model/properties/Level;", "getProvidedOptionValue", "T", "providerClass", "Ljava/lang/Class;", "Lcom/intellij/database/dataSource/DbOptionProvider;", "Lcom/intellij/database/dataSource/DatabaseConnectivityConfiguration;", "(Ljava/lang/Class;)Ljava/lang/Object;", "intellij.database.core.impl"})
final class ConnectionBriefConfig
implements DataSourceBriefConfig {
    @NotNull
    private final DatabaseConnectionPoint dcp;

    public ConnectionBriefConfig(@NotNull DatabaseConnectionPoint dcp) {
        Intrinsics.checkNotNullParameter((Object)dcp, (String)"dcp");
        this.dcp = dcp;
    }

    @Override
    @NotNull
    public String getUniqueId() {
        String string = this.dcp.getDataSource().getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUniqueId(...)");
        return string;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.dcp.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @Override
    @NotNull
    public Dbms getDbms() {
        Dbms dbms = this.dcp.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        return dbms;
    }

    @Override
    @Nullable
    public ObjectKind getBoundTo() {
        Object object = this.dcp.getDatabaseDriver();
        return object != null && (object = object.getConnectionBounds()) != null ? ((DatabaseDriver.Bounds)object).boundTo : null;
    }

    @Override
    @Nullable
    public String getBoundStr() {
        Object object = this.dcp.getDatabaseDriver();
        return object != null && (object = object.getConnectionBounds()) != null ? ((DatabaseDriver.Bounds)object).toString() : null;
    }

    @Override
    public boolean isRewriteBounds() {
        return this.dcp.getDataSource().isRewriteBounds();
    }

    @Override
    @NotNull
    public TreePattern getIntrospectionScope() {
        TreePattern treePattern = this.dcp.getDataSource().getIntrospectionScope();
        Intrinsics.checkNotNullExpressionValue((Object)treePattern, (String)"getIntrospectionScope(...)");
        return treePattern;
    }

    @Override
    @Nullable
    public Level getIntrospectionLevel() {
        return this.dcp.getDataSource().getIntrospectionLevel();
    }

    @Override
    @Nullable
    public <T> T getProvidedOptionValue(@NotNull Class<? extends DbOptionProvider<? extends DatabaseConnectivityConfiguration, T>> providerClass) {
        Intrinsics.checkNotNullParameter(providerClass, (String)"providerClass");
        Class<? extends DbOptionProvider<? extends DatabaseConnectivityConfiguration, T>> pClass = providerClass;
        return DbOptionProvider.getOptionValue(this.dcp.getDataSource(), pClass);
    }
}

