/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model;

import com.intellij.database.model.BaseModel;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Service
public final class ModelMemoryManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(ModelMemoryManager.class);
    private final LowMemoryWatcher myMemoryWatcher = LowMemoryWatcher.register(this::compactModels, (LowMemoryWatcher.LowMemoryWatcherType)LowMemoryWatcher.LowMemoryWatcherType.ALWAYS);
    private final Set<BasicModModel> myModels = ContainerUtil.createWeakSet();
    private final Throttle myThrottle = new Throttle(5000L, 300000L);

    public static ModelMemoryManager getInstance() {
        return (ModelMemoryManager)ApplicationManager.getApplication().getService(ModelMemoryManager.class);
    }

    public void dispose() {
        this.myMemoryWatcher.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerModel(@NotNull BasicModModel model) {
        if (model == null) {
            ModelMemoryManager.$$$reportNull$$$0(0);
        }
        Set<BasicModModel> set = this.myModels;
        synchronized (set) {
            this.myModels.add(model);
        }
    }

    public void compactModels() {
        if (this.myThrottle.shed()) {
            return;
        }
        List<BasicModModel> alive = this.alive();
        if (alive.isEmpty()) {
            return;
        }
        LOG.warn("High memory usage, compacting " + alive.size() + " models...");
        ArrayList<BasicModModel> left = new ArrayList<BasicModModel>();
        for (BasicModModel model : alive) {
            if (this.compactModel(model, true)) continue;
            left.add(model);
        }
        if (!left.isEmpty()) {
            LOG.warn(left.size() + " are locked waiting for them...");
            for (BasicModModel model : left) {
                this.compactModel(model, false);
            }
        }
        LOG.warn("Compacting is done");
    }

    public boolean compactModel(@NotNull BasicModModel model, boolean fast) {
        if (model == null) {
            ModelMemoryManager.$$$reportNull$$$0(1);
        }
        return BaseModel.forceUnload(model, fast, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<BasicModModel> alive() {
        ArrayList<BasicModModel> models2 = new ArrayList<BasicModModel>(this.myModels.size());
        Set<BasicModModel> set = this.myModels;
        synchronized (set) {
            models2.addAll(this.myModels);
        }
        ArrayList<BasicModModel> arrayList = models2;
        if (arrayList == null) {
            ModelMemoryManager.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/model/ModelMemoryManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/model/ModelMemoryManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "alive";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerModel";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compactModel";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private static class Throttle {
        private long lastTimestamp;
        private long throttledTimestamp;
        private final long minDelay;
        private final long maxDelay;
        private long delay;
        private long minInterval = Long.MAX_VALUE;

        private Throttle(long minDelay, long maxDelay) {
            this.minDelay = minDelay;
            this.maxDelay = maxDelay;
            this.delay = minDelay;
            this.reset(System.currentTimeMillis());
        }

        public boolean shed() {
            long cur = System.currentTimeMillis();
            long interval = cur - this.lastTimestamp;
            if (interval < this.delay) {
                this.trackRate(cur);
                return true;
            }
            this.delay = this.computeNextDelay();
            this.reset(cur);
            return false;
        }

        private void reset(long curTimestamp) {
            this.lastTimestamp = curTimestamp;
            this.throttledTimestamp = curTimestamp;
            this.minInterval = Long.MAX_VALUE;
        }

        private long computeNextDelay() {
            long newDelay = this.minInterval == Long.MAX_VALUE ? this.delay / 2L : this.delay * 2L;
            return Math.max(this.minDelay, Math.min(this.maxDelay, newDelay));
        }

        private void trackRate(long curTimestamp) {
            long interval = curTimestamp - this.throttledTimestamp;
            if (interval < this.minInterval) {
                this.minInterval = interval;
            }
            this.throttledTimestamp = curTimestamp;
        }
    }
}

