/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.serialization.converters;

import com.intellij.database.Dbms;
import com.intellij.database.model.serialization.Converter;
import com.intellij.database.model.serialization.ModelElementMem;
import com.intellij.database.model.serialization.ModelMem;
import com.intellij.database.model.serialization.MutableNameAndValue;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/model/serialization/converters/Converter_4_1;", "Lcom/intellij/database/model/serialization/Converter;", "<init>", "()V", "convertMem", "", "modelMem", "Lcom/intellij/database/model/serialization/ModelMem;", "guessPostgresRulesAreMeaningful", "", "adjustCascadeRules", "node", "Lcom/intellij/database/model/serialization/ModelElementMem;", "action", "", "adjustCascadeRulesPostgres", "meaningful", "propertyIsCascadeRule", "property", "Lcom/intellij/database/model/serialization/MutableNameAndValue;", "intellij.database.core.impl"})
public final class Converter_4_1
extends Converter {
    @NotNull
    public static final Converter_4_1 INSTANCE = new Converter_4_1();

    private Converter_4_1() {
        int[] nArray = new int[]{4, 1};
        super(nArray);
    }

    @Override
    public void convertMem(@NotNull ModelMem modelMem) {
        Intrinsics.checkNotNullParameter((Object)modelMem, (String)"modelMem");
        boolean isPostgres = Intrinsics.areEqual((Object)modelMem.getDbms(), (Object)Dbms.POSTGRES);
        boolean postgresRulesAreMeaningful = isPostgres ? this.guessPostgresRulesAreMeaningful(modelMem) : false;
        for (ModelElementMem node : modelMem.getNodes()) {
            if (!Intrinsics.areEqual((Object)node.getKind(), (Object)"foreign-key")) continue;
            if (isPostgres) {
                this.adjustCascadeRulesPostgres(node, "update", postgresRulesAreMeaningful);
                this.adjustCascadeRulesPostgres(node, "delete", postgresRulesAreMeaningful);
                continue;
            }
            this.adjustCascadeRules(node, "update");
            this.adjustCascadeRules(node, "delete");
        }
    }

    private final boolean guessPostgresRulesAreMeaningful(ModelMem modelMem) {
        for (ModelElementMem node : modelMem.getNodes()) {
            if (!Intrinsics.areEqual((Object)node.getKind(), (Object)"foreign-key")) continue;
            for (MutableNameAndValue property : node.getProperties()) {
                String v;
                if (!this.propertyIsCascadeRule(property, "update") && !this.propertyIsCascadeRule(property, "delete") || Intrinsics.areEqual((Object)(v = StringUtil.toLowerCase((String)property.getValue())), (Object)"restrict")) continue;
                return true;
            }
        }
        return false;
    }

    private final void adjustCascadeRules(ModelElementMem node, String action) {
        for (MutableNameAndValue property : node.getProperties()) {
            if (!this.propertyIsCascadeRule(property, action) || !Intrinsics.areEqual((Object)property.getValue(), (Object)"update") && !Intrinsics.areEqual((Object)property.getValue(), (Object)"delete")) continue;
            property.setValue("cascade");
        }
    }

    private final void adjustCascadeRulesPostgres(ModelElementMem node, String action, boolean meaningful) {
        boolean found = false;
        for (MutableNameAndValue property : node.getProperties()) {
            if (!this.propertyIsCascadeRule(property, action)) continue;
            if (Intrinsics.areEqual((Object)property.getValue(), (Object)"update") || Intrinsics.areEqual((Object)property.getValue(), (Object)"delete")) {
                property.setValue("cascade");
            }
            if (Intrinsics.areEqual((Object)property.getValue(), (Object)"restrict") && !meaningful) {
                property.setValue("no_action");
            }
            found = true;
        }
        if (!found && meaningful) {
            node.getProperties().add(new MutableNameAndValue("On" + StringsKt.capitalize((String)action), "restrict"));
        }
    }

    private final boolean propertyIsCascadeRule(MutableNameAndValue property, String action) {
        String n = StringUtil.toLowerCase((String)property.getName());
        return Intrinsics.areEqual((Object)n, (Object)("on-" + action)) || Intrinsics.areEqual((Object)n, (Object)("on" + action));
    }
}

