/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index.vfs;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.codeInsight.daemon.SyntheticPsiFileSupport;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCloseListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerListener;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.i18n.GitBundle;
import git4idea.index.GitIndexUtil;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.index.vfs.GitIndexVirtualFileKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.util.GitFileUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0007\u0018\u0000 92\u00020\u0001:\u00049:;<B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0018\u001a\u00020\u000eH\u0002J\u001a\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u000b0\u001cJ\u0014\u0010\u001d\u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001fJ\u0016\u0010 \u001a\u00020\u001a2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u001fH\u0002J\u0016\u0010!\u001a\b\u0018\u00010\"R\u00020\u00002\u0006\u0010#\u001a\u00020\u0010H\u0002J(\u0010!\u001a\b\u0018\u00010\"R\u00020\u00002\u0006\u0010#\u001a\u00020\u00102\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0002J\u001a\u0010(\u001a\u00020\u001a2\u0010\u0010)\u001a\f\u0012\b\u0012\u00060\"R\u00020\u00000\u001fH\u0002J/\u0010*\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00102\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020'H\u0000\u00a2\u0006\u0002\b0J\u001d\u00101\u001a\u00020.2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b2J\u001a\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u00105\u001a\u00020'2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u00106\u001a\u000207H\u0002J\b\u00108\u001a\u00020\u001aH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\u0001\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\t\u0012\u00070\u000e\u00a2\u0006\u0002\b\u000f\u0012\u000b\u0012\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "disposable", "isShutDown", "", "cache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "Lgit4idea/index/vfs/GitIndexFileSystemRefresher$Key;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lgit4idea/index/vfs/GitIndexVirtualFile;", "findFile", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "createFile", "createIndexVirtualFile", "key", "refresh", "", "condition", "Lkotlin/Function1;", "initialRefresh", "filesToRefresh", "", "refreshImpl", "readFromGit", "Lgit4idea/index/vfs/GitIndexFileSystemRefresher$IndexFileData;", "file", "oldData", "Lgit4idea/index/vfs/GitIndexVirtualFile$CachedData;", "oldModificationStamp", "", "applyRefresh", "fileDataList", "write", "requestor", "", "newContent", "", "newModificationStamp", "write$intellij_vcs_git", "readContentFromGit", "readContentFromGit$intellij_vcs_git", "readMetadataFromGit", "Lgit4idea/index/GitIndexUtil$StagedFile;", "readLengthFromGit", "hash", "", "dispose", "Companion", "IndexFileData", "Key", "MyEncodingManagerListener", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitIndexFileSystemRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitIndexFileSystemRefresher.kt\ngit4idea/index/vfs/GitIndexFileSystemRefresher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,360:1\n1#2:361\n1563#3:362\n1634#3,3:363\n1869#3,2:366\n774#3:368\n865#3,2:369\n*S KotlinDebug\n*F\n+ 1 GitIndexFileSystemRefresher.kt\ngit4idea/index/vfs/GitIndexFileSystemRefresher\n*L\n184#1:362\n184#1:363,3\n186#1:366,2\n155#1:368\n155#1:369,2\n*E\n"})
public final class GitIndexFileSystemRefresher
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final ExecutorService executor;
    @NotNull
    private final Disposable disposable;
    private volatile boolean isShutDown;
    @NotNull
    private final LoadingCache<Key, GitIndexVirtualFile> cache;
    @NotNull
    private static final Logger LOG;

    public GitIndexFileSystemRefresher(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Git index file system refresher", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.executor = executorService;
        Disposable disposable = Disposer.newDisposable((String)"Git Index File System");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.disposable = disposable;
        LoadingCache loadingCache = Caffeine.newBuilder().weakValues().build(arg_0 -> GitIndexFileSystemRefresher.cache$lambda$0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.cache = loadingCache;
        MessageBusConnection connection = this.project.getMessageBus().connect(this.disposable);
        Topic<GitRepositoryChangeListener> topic = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"GIT_REPO_CHANGE");
        connection.subscribe(topic, arg_0 -> GitIndexFileSystemRefresher._init_$lambda$0(this, arg_0));
        connection.subscribe(ProjectCloseListener.TOPIC, (Object)new ProjectCloseListener(){

            public void projectClosing(Project p) {
                Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                if (Intrinsics.areEqual((Object)project, (Object)p)) {
                    isShutDown = true;
                    Disposer.dispose((Disposable)disposable);
                    executor.shutdown();
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> 2.projectClosing$lambda$0(this), GitBundle.message((String)"stage.vfs.shutdown.process", (Object[])new Object[0]), false, project);
                }
            }

            private static final void projectClosing$lambda$0(GitIndexFileSystemRefresher this$0) {
                this$0.executor.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
        });
        Topic topic2 = EncodingManagerListener.ENCODING_MANAGER_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"ENCODING_MANAGER_CHANGES");
        connection.subscribe(topic2, (Object)new MyEncodingManagerListener());
    }

    @Nullable
    public final GitIndexVirtualFile findFile(@NotNull VirtualFile root, @NotNull FilePath filePath) {
        GitIndexVirtualFile gitIndexVirtualFile;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        GitIndexVirtualFile gitIndexVirtualFile2 = (GitIndexVirtualFile)((Object)this.cache.get((Object)new Key(root, filePath)));
        if (gitIndexVirtualFile2 != null) {
            GitIndexVirtualFile gitIndexVirtualFile3;
            GitIndexVirtualFile it = gitIndexVirtualFile3 = gitIndexVirtualFile2;
            boolean bl = false;
            gitIndexVirtualFile = it.isValid() ? gitIndexVirtualFile3 : null;
        } else {
            gitIndexVirtualFile = null;
        }
        return gitIndexVirtualFile;
    }

    @RequiresBackgroundThread
    @Nullable
    public final GitIndexVirtualFile createFile(@NotNull VirtualFile root, @NotNull FilePath filePath) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        GitIndexVirtualFile gitIndexVirtualFile = (GitIndexVirtualFile)((Object)this.cache.get((Object)new Key(root, filePath)));
        if (gitIndexVirtualFile == null) {
            return null;
        }
        GitIndexVirtualFile indexFile = gitIndexVirtualFile;
        if (indexFile.getData$intellij_vcs_git() != null) {
            return indexFile;
        }
        GitIndexUtil.StagedFile stagedFile = this.readMetadataFromGit(root, filePath);
        if (stagedFile == null) {
            return null;
        }
        GitIndexUtil.StagedFile stagedFile2 = stagedFile;
        String string = stagedFile2.getBlobHash();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBlobHash(...)");
        long length = this.readLengthFromGit(root, string);
        indexFile.setInitialData$intellij_vcs_git(GitIndexFileSystemRefresher.Companion.hash(stagedFile2), length, stagedFile2.isExecutable());
        return indexFile;
    }

    private final GitIndexVirtualFile createIndexVirtualFile(Key key) {
        if (this.isShutDown) {
            return null;
        }
        GitIndexVirtualFile indexFile = new GitIndexVirtualFile(this.project, key.getRoot(), key.getFilePath());
        SyntheticPsiFileSupport.markFile((VirtualFile)indexFile, (String)key.getFilePath().getPath());
        return indexFile;
    }

    public final void refresh(@NotNull Function1<? super GitIndexVirtualFile, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        List filesToRefresh = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter((Sequence)SequencesKt.filterNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.cache.asMap().values())), GitIndexFileSystemRefresher::refresh$lambda$0), condition));
        if (filesToRefresh.isEmpty()) {
            return;
        }
        this.refreshImpl(filesToRefresh);
    }

    public final void initialRefresh(@NotNull List<GitIndexVirtualFile> filesToRefresh) {
        Intrinsics.checkNotNullParameter(filesToRefresh, (String)"filesToRefresh");
        this.refreshImpl(filesToRefresh);
    }

    private final void refreshImpl(List<GitIndexVirtualFile> filesToRefresh) {
        if (this.isShutDown) {
            return;
        }
        LOG.debug("Starting async refresh for " + CollectionsKt.joinToString$default((Iterable)filesToRefresh, null, null, null, (int)0, null, GitIndexFileSystemRefresher::refreshImpl$lambda$0, (int)31, null));
        BackgroundTaskUtil.execute((Executor)this.executor, (Disposable)this.disposable, () -> GitIndexFileSystemRefresher.refreshImpl$lambda$1(filesToRefresh, this));
    }

    private final IndexFileData readFromGit(GitIndexVirtualFile file) {
        Pair pair = (Pair)ActionsKt.runReadAction(() -> GitIndexFileSystemRefresher.readFromGit$lambda$0(file));
        GitIndexVirtualFile.CachedData oldData = (GitIndexVirtualFile.CachedData)pair.component1();
        long oldModificationStamp = ((Number)pair.component2()).longValue();
        return this.readFromGit(file, oldData, oldModificationStamp);
    }

    private final IndexFileData readFromGit(GitIndexVirtualFile file, GitIndexVirtualFile.CachedData oldData, long oldModificationStamp) {
        Hash newHash;
        GitIndexUtil.StagedFile stagedFile;
        GitIndexUtil.StagedFile stagedFile2 = stagedFile = this.readMetadataFromGit(file.getRoot(), file.getFilePath());
        Hash hash = newHash = stagedFile2 != null ? GitIndexFileSystemRefresher.Companion.hash(stagedFile2) : null;
        if (oldData == null || !Intrinsics.areEqual((Object)oldData.getHash(), (Object)newHash)) {
            long l;
            if (stagedFile != null) {
                VirtualFile virtualFile = file.getRoot();
                String string = stagedFile.getBlobHash();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBlobHash(...)");
                l = this.readLengthFromGit(virtualFile, string);
            } else {
                l = 0L;
            }
            long newLength = l;
            LOG.debug("Preparing refresh for " + file);
            GitIndexUtil.StagedFile stagedFile3 = stagedFile;
            return new IndexFileData(file, oldData, newHash, file.getLength(), newLength, stagedFile3 != null ? stagedFile3.isExecutable() : false, oldModificationStamp);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void applyRefresh(List<IndexFileData> fileDataList) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = fileDataList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IndexFileData indexFileData = (IndexFileData)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getEvent());
        }
        List events = (List)destination$iv$iv;
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        ((BulkFileListener)messageBus.syncPublisher(topic)).before(events);
        Iterable $this$forEach$iv = fileDataList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IndexFileData it = (IndexFileData)element$iv;
            boolean bl = false;
            it.apply();
        }
        MessageBus messageBus2 = ApplicationManager.getApplication().getMessageBus();
        Topic topic2 = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"VFS_CHANGES");
        ((BulkFileListener)messageBus2.syncPublisher(topic2)).after(events);
    }

    public final void write$intellij_vcs_git(@NotNull GitIndexVirtualFile file, @Nullable Object requestor, @NotNull byte[] newContent, long newModificationStamp) {
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        try {
            long newModStamp = newModificationStamp > 0L ? newModificationStamp : LocalTimeCounter.currentTime();
            VFileContentChangeEvent event = new VFileContentChangeEvent(requestor, (VirtualFile)file, file.getModificationStamp(), newModStamp);
            MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
            Topic topic = VirtualFileManager.VFS_CHANGES;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
            ((BulkFileListener)messageBus.syncPublisher(topic)).before(CollectionsKt.listOf((Object)event));
            GitIndexVirtualFile.CachedData oldData = file.getData$intellij_vcs_git();
            long oldModificationStamp = file.getModificationStamp();
            Object[] objectArray = new Object[]{file.getName()};
            String string = GitBundle.message((String)"stage.vfs.write.process", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Function0 applyChanges = (Function0)GitIndexFileSystemRefresher.Companion.computeUnderPotemkinProgress(this.project, string, () -> GitIndexFileSystemRefresher.write$lambda$0(this, file, oldData, oldModificationStamp, newContent, newModStamp));
            applyChanges.invoke();
            MessageBus messageBus2 = ApplicationManager.getApplication().getMessageBus();
            Topic topic2 = VirtualFileManager.VFS_CHANGES;
            Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"VFS_CHANGES");
            ((BulkFileListener)messageBus2.syncPublisher(topic2)).after(CollectionsKt.listOf((Object)event));
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @NotNull
    public final byte[] readContentFromGit$intellij_vcs_git(@NotNull VirtualFile root, @NotNull FilePath filePath) throws IOException {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            byArray = GitFileUtils.getFileContent(this.project, root, "", VcsFileUtil.relativePath((VirtualFile)root, (FilePath)filePath));
            Intrinsics.checkNotNull((Object)byArray);
        }
        catch (VcsException e) {
            throw new IOException(e);
        }
        return byArray;
    }

    private final GitIndexUtil.StagedFile readMetadataFromGit(VirtualFile root, FilePath filePath) {
        List<GitIndexUtil.StagedFile> list = GitIndexUtil.listStaged(this.project, root, CollectionsKt.listOf((Object)filePath));
        Intrinsics.checkNotNullExpressionValue(list, (String)"listStaged(...)");
        return (GitIndexUtil.StagedFile)CollectionsKt.singleOrNull(list);
    }

    private final long readLengthFromGit(VirtualFile root, String hash) {
        try {
            GitLineHandler h = new GitLineHandler(this.project, root, GitCommand.CAT_FILE);
            h.setEnableInteractiveCallbacks(false);
            h.setSilent(true);
            String[] stringArray = new String[]{"-s"};
            h.addParameters(stringArray);
            stringArray = new String[]{hash};
            h.addParameters(stringArray);
            h.endOptions();
            String string = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOutputOrThrow(...)");
            String output2 = string;
            Long l = Long.valueOf(((Object)StringsKt.trim((CharSequence)output2)).toString());
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"valueOf(...)");
            return ((Number)l).longValue();
        }
        catch (VcsException e) {
            LOG.warn((Throwable)e);
            return 0L;
        }
    }

    public void dispose() {
        this.cache.invalidateAll();
    }

    private static final GitIndexVirtualFile cache$lambda$0(GitIndexFileSystemRefresher this$0, Key key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this$0.createIndexVirtualFile(key);
    }

    private static final void _init_$lambda$0(GitIndexFileSystemRefresher this$0, GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        LOG.debug("Scheduling refresh for repository " + repository2.getRoot().getName());
        this$0.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)arg_0 -> GitIndexFileSystemRefresher.lambda$0$0(repository2, arg_0)));
    }

    private static final boolean lambda$0$0(GitRepository $repository, GitIndexVirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return Intrinsics.areEqual((Object)it.getRoot(), (Object)$repository.getRoot());
    }

    private static final boolean refresh$lambda$0(GitIndexVirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.getData$intellij_vcs_git() != null;
    }

    private static final CharSequence refreshImpl$lambda$0(GitIndexVirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        return it.getPath();
    }

    private static final void refreshImpl$lambda$1(List $filesToRefresh, GitIndexFileSystemRefresher this$0) {
        List fileDataList = new ArrayList();
        for (GitIndexVirtualFile file : $filesToRefresh) {
            IndexFileData it;
            if (this$0.readFromGit(file) == null) continue;
            boolean bl = false;
            fileDataList.add(it);
        }
        if (fileDataList.isEmpty()) {
            return;
        }
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (progressIndicator != null) {
            progressIndicator.checkCanceled();
        }
        GitIndexFileSystemRefresher.Companion.writeInEdtAndWait((Function0<Unit>)() -> GitIndexFileSystemRefresher.refreshImpl$lambda$1$1(this$0, fileDataList));
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit refreshImpl$lambda$1$1(GitIndexFileSystemRefresher this$0, List $fileDataList) {
        void $this$filterTo$iv$iv;
        if (this$0.isShutDown) {
            return Unit.INSTANCE;
        }
        Iterable $this$filter$iv = $fileDataList;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            IndexFileData it = (IndexFileData)element$iv$iv;
            boolean bl = false;
            if (!(!it.isOutdated())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List dataToApply = (List)destination$iv$iv;
        if (dataToApply.isEmpty()) {
            return Unit.INSTANCE;
        }
        this$0.applyRefresh(dataToApply);
        return Unit.INSTANCE;
    }

    private static final Pair readFromGit$lambda$0(GitIndexVirtualFile $file) {
        return new Pair((Object)$file.getData$intellij_vcs_git(), (Object)$file.getModificationStamp());
    }

    private static final Function0 write$lambda$0(GitIndexFileSystemRefresher this$0, GitIndexVirtualFile $file, GitIndexVirtualFile.CachedData $oldData, long $oldModificationStamp, byte[] $newContent, long $newModStamp) {
        IndexFileData indexFileData = this$0.readFromGit($file, $oldData, $oldModificationStamp);
        if (indexFileData != null) {
            LOG.info("Detected memory-disk conflict in " + $file);
            return () -> GitIndexFileSystemRefresher.write$lambda$0$0(this$0, indexFileData);
        }
        Hash hash = GitIndexUtil.write(this$0.project, $file.getRoot(), $file.getFilePath(), new ByteArrayInputStream($newContent), $file.isExecutable$intellij_vcs_git());
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"write(...)");
        Hash newHash = hash;
        LOG.debug("Written " + $file + ". newHash=" + newHash);
        return () -> GitIndexFileSystemRefresher.write$lambda$0$1($file, newHash, $newContent, $newModStamp);
    }

    private static final Unit write$lambda$0$0(GitIndexFileSystemRefresher this$0, IndexFileData $indexFileData) {
        this$0.applyRefresh(CollectionsKt.listOf((Object)$indexFileData));
        return Unit.INSTANCE;
    }

    private static final Unit write$lambda$0$1(GitIndexVirtualFile $file, Hash $newHash, byte[] $newContent, long $newModStamp) {
        $file.setDataFromWrite$intellij_vcs_git($newHash, $newContent.length, $newModStamp);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @NotNull
    public static final GitIndexFileSystemRefresher getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    public static final void refreshFilePaths(@NotNull Project project, @NotNull Collection<? extends FilePath> paths) {
        Companion.refreshFilePaths(project, paths);
    }

    @JvmStatic
    public static final void refreshFilePaths(@NotNull Project project, @NotNull Map<VirtualFile, ? extends Collection<? extends FilePath>> paths) {
        Companion.refreshFilePaths(project, paths);
    }

    @JvmStatic
    public static final void refreshVirtualFiles(@NotNull Project project, @NotNull Collection<? extends VirtualFile> paths) {
        Companion.refreshVirtualFiles(project, paths);
    }

    @JvmStatic
    public static final void refreshRoots(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots) {
        Companion.refreshRoots(project, roots);
    }

    static {
        Logger logger = Logger.getInstance(GitIndexFileSystemRefresher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0007J*\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0010H\u0007J\u001e\u0010\u0012\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0007J\u001e\u0010\u0013\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0007J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001aH\u0002J3\u0010\u001b\u001a\u0002H\u001c\"\u0004\b\u0000\u0010\u001c2\u0006\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001aH\u0002\u00a2\u0006\u0002\u0010 R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lgit4idea/index/vfs/GitIndexFileSystemRefresher;", "project", "Lcom/intellij/openapi/project/Project;", "refreshFilePaths", "", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "refreshVirtualFiles", "refreshRoots", "roots", "hash", "Lcom/intellij/vcs/log/Hash;", "Lgit4idea/index/GitIndexUtil$StagedFile;", "writeInEdtAndWait", "action", "Lkotlin/Function0;", "computeUnderPotemkinProgress", "T", "message", "", "computation", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitIndexFileSystemRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitIndexFileSystemRefresher.kt\ngit4idea/index/vfs/GitIndexFileSystemRefresher$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,360:1\n30#2,2:361\n58#2:363\n58#2:364\n58#2:369\n1563#3:365\n1634#3,3:366\n*S KotlinDebug\n*F\n+ 1 GitIndexFileSystemRefresher.kt\ngit4idea/index/vfs/GitIndexFileSystemRefresher$Companion\n*L\n262#1:361,2\n267#1:363\n272#1:364\n284#1:369\n279#1:365\n279#1:366,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GitIndexFileSystemRefresher getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitIndexFileSystemRefresher> serviceClass$iv = GitIndexFileSystemRefresher.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (GitIndexFileSystemRefresher)object;
        }

        @JvmStatic
        public final void refreshFilePaths(@NotNull Project project, @NotNull Collection<? extends FilePath> paths) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(paths, (String)"paths");
                Set pathsSet = CollectionsKt.toSet((Iterable)paths);
                ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
                boolean $i$f$serviceIfCreated = false;
                GitIndexFileSystemRefresher gitIndexFileSystemRefresher = (GitIndexFileSystemRefresher)$this$serviceIfCreated$iv.getServiceIfCreated(GitIndexFileSystemRefresher.class);
                if (gitIndexFileSystemRefresher == null) break block0;
                gitIndexFileSystemRefresher.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)arg_0 -> Companion.refreshFilePaths$lambda$0(pathsSet, arg_0)));
            }
        }

        @JvmStatic
        public final void refreshFilePaths(@NotNull Project project, @NotNull Map<VirtualFile, ? extends Collection<? extends FilePath>> paths) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(paths, (String)"paths");
                ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
                boolean $i$f$serviceIfCreated = false;
                GitIndexFileSystemRefresher gitIndexFileSystemRefresher = (GitIndexFileSystemRefresher)$this$serviceIfCreated$iv.getServiceIfCreated(GitIndexFileSystemRefresher.class);
                if (gitIndexFileSystemRefresher == null) break block0;
                gitIndexFileSystemRefresher.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)arg_0 -> Companion.refreshFilePaths$lambda$1(paths, arg_0)));
            }
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final void refreshVirtualFiles(@NotNull Project project, @NotNull Collection<? extends VirtualFile> paths) {
            Collection<FilePath> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            Iterable iterable = paths;
            Project project2 = project;
            Companion companion = this;
            boolean $i$f$map = false;
            void var5_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(GitIndexVirtualFileKt.filePath((VirtualFile)it));
            }
            collection = (List)destination$iv$iv;
            companion.refreshFilePaths(project2, (Collection<? extends FilePath>)collection);
        }

        @JvmStatic
        public final void refreshRoots(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(roots, (String)"roots");
                ComponentManager $this$serviceIfCreated$iv = (ComponentManager)project;
                boolean $i$f$serviceIfCreated = false;
                GitIndexFileSystemRefresher gitIndexFileSystemRefresher = (GitIndexFileSystemRefresher)$this$serviceIfCreated$iv.getServiceIfCreated(GitIndexFileSystemRefresher.class);
                if (gitIndexFileSystemRefresher == null) break block0;
                gitIndexFileSystemRefresher.refresh((Function1<? super GitIndexVirtualFile, Boolean>)((Function1)arg_0 -> Companion.refreshRoots$lambda$0(roots, arg_0)));
            }
        }

        private final Hash hash(GitIndexUtil.StagedFile $this$hash) {
            Hash hash = HashImpl.build((String)$this$hash.getBlobHash());
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"build(...)");
            return hash;
        }

        private final void writeInEdtAndWait(Function0<Unit> action) {
            ApplicationManager.getApplication().invokeAndWait(() -> Companion.writeInEdtAndWait$lambda$0(action));
        }

        private final <T> T computeUnderPotemkinProgress(Project project, @NlsContexts.ProgressTitle String message, Function0<? extends T> computation) {
            Ref result2 = new Ref(null);
            new PotemkinProgress(message, project, null, null).runInBackground(() -> Companion.computeUnderPotemkinProgress$lambda$0(result2, computation));
            return (T)result2.get();
        }

        private static final boolean refreshFilePaths$lambda$0(Set $pathsSet, GitIndexVirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            return $pathsSet.contains(it.getFilePath());
        }

        private static final boolean refreshFilePaths$lambda$1(Map $paths, GitIndexVirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            Collection collection = (Collection)$paths.get(it.getRoot());
            return collection != null ? collection.contains(it.getFilePath()) : false;
        }

        private static final boolean refreshRoots$lambda$0(Collection $roots, GitIndexVirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
            return $roots.contains(it.getRoot());
        }

        private static final void writeInEdtAndWait$lambda$0(Function0 $action) {
            ApplicationManager.getApplication().runWriteAction(() -> Companion.writeInEdtAndWait$lambda$0$0($action));
        }

        private static final void writeInEdtAndWait$lambda$0$0(Function0 $action) {
            $action.invoke();
        }

        private static final void computeUnderPotemkinProgress$lambda$0(Ref $result, Function0 $computation) {
            $result.set($computation.invoke());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u0015\u001a\u00020\u0016J\r\u0010\u0017\u001a\u00070\u0018\u00a2\u0006\u0002\b\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher$IndexFileData;", "", "file", "Lgit4idea/index/vfs/GitIndexVirtualFile;", "oldData", "Lgit4idea/index/vfs/GitIndexVirtualFile$CachedData;", "newHash", "Lcom/intellij/vcs/log/Hash;", "oldLength", "", "newLength", "newExecutable", "", "oldModificationStamp", "<init>", "(Lgit4idea/index/vfs/GitIndexFileSystemRefresher;Lgit4idea/index/vfs/GitIndexVirtualFile;Lgit4idea/index/vfs/GitIndexVirtualFile$CachedData;Lcom/intellij/vcs/log/Hash;JJZJ)V", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent;", "getEvent", "()Lcom/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent;", "isOutdated", "apply", "", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "intellij.vcs.git"})
    private final class IndexFileData {
        @NotNull
        private final GitIndexVirtualFile file;
        @Nullable
        private final GitIndexVirtualFile.CachedData oldData;
        @Nullable
        private final Hash newHash;
        private final long newLength;
        private final boolean newExecutable;
        @NotNull
        private final VFileContentChangeEvent event;

        public IndexFileData(@Nullable GitIndexVirtualFile file, @Nullable GitIndexVirtualFile.CachedData oldData, Hash newHash, long oldLength, long newLength, boolean newExecutable, long oldModificationStamp) {
            Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
            this.file = file;
            this.oldData = oldData;
            this.newHash = newHash;
            this.newLength = newLength;
            this.newExecutable = newExecutable;
            this.event = new VFileContentChangeEvent(VFileEvent.REFRESH_REQUESTOR, (VirtualFile)this.file, oldModificationStamp, -1L, 0L, 0L, oldLength, this.newLength);
        }

        @NotNull
        public final VFileContentChangeEvent getEvent() {
            return this.event;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isOutdated() {
            if (this.file.getData$intellij_vcs_git() == null) return false;
            GitIndexVirtualFile.CachedData cachedData = this.file.getData$intellij_vcs_git();
            GitIndexVirtualFile.CachedData cachedData2 = this.oldData;
            if (Intrinsics.areEqual((Object)(cachedData != null ? cachedData.getHash() : null), (Object)(cachedData2 != null ? cachedData2.getHash() : null))) return false;
            return true;
        }

        public final void apply() {
            LOG.debug("Refreshing " + this.file);
            this.file.setDataFromRefresh$intellij_vcs_git(this.newHash, this.newLength, this.newExecutable);
        }

        @NotNull
        public String toString() {
            return "IndexFileData: " + this.file;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher$Key;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vcs/FilePath;)V", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.vcs.git"})
    private static final class Key {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final FilePath filePath;

        public Key(@NotNull VirtualFile root, @NotNull FilePath filePath) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            this.root = root;
            this.filePath = filePath;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public final FilePath getFilePath() {
            return this.filePath;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.root;
        }

        @NotNull
        public final FilePath component2() {
            return this.filePath;
        }

        @NotNull
        public final Key copy(@NotNull VirtualFile root, @NotNull FilePath filePath) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return new Key(root, filePath);
        }

        public static /* synthetic */ Key copy$default(Key key, VirtualFile virtualFile, FilePath filePath, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = key.root;
            }
            if ((n & 2) != 0) {
                filePath = key.filePath;
            }
            return key.copy(virtualFile, filePath);
        }

        @NotNull
        public String toString() {
            return "Key(root=" + this.root + ", filePath=" + this.filePath + ")";
        }

        public int hashCode() {
            int result2 = this.root.hashCode();
            result2 = result2 * 31 + this.filePath.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            if (!Intrinsics.areEqual((Object)this.root, (Object)key.root)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.filePath, (Object)key.filePath);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"Lgit4idea/index/vfs/GitIndexFileSystemRefresher$MyEncodingManagerListener;", "Lcom/intellij/openapi/vfs/encoding/EncodingManagerListener;", "<init>", "(Lgit4idea/index/vfs/GitIndexFileSystemRefresher;)V", "propertyChanged", "", "eventDocument", "Lcom/intellij/openapi/editor/Document;", "propertyName", "", "oldValue", "", "newValue", "reloadCachedPropertiesFiles", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitIndexFileSystemRefresher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitIndexFileSystemRefresher.kt\ngit4idea/index/vfs/GitIndexFileSystemRefresher$MyEncodingManagerListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,360:1\n774#2:361\n865#2,2:362\n*S KotlinDebug\n*F\n+ 1 GitIndexFileSystemRefresher.kt\ngit4idea/index/vfs/GitIndexFileSystemRefresher$MyEncodingManagerListener\n*L\n349#1:361\n349#1:362,2\n*E\n"})
    private final class MyEncodingManagerListener
    implements EncodingManagerListener {
        public void propertyChanged(@Nullable Document eventDocument, @NotNull String propertyName, @Nullable Object oldValue, @Nullable Object newValue2) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            if (Intrinsics.areEqual((Object)"native2ascii", (Object)propertyName) || Intrinsics.areEqual((Object)"propertiesFilesEncoding", (Object)propertyName)) {
                ApplicationManager.getApplication().invokeLater(() -> MyEncodingManagerListener.propertyChanged$lambda$0(this));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void reloadCachedPropertiesFiles() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = GitIndexFileSystemRefresher.this.cache.asMap().values();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                GitIndexVirtualFile it = (GitIndexVirtualFile)((Object)element$iv$iv);
                boolean bl = false;
                if (!(it != null && FileTypeRegistry.getInstance().isFileOfType((VirtualFile)it, (FileType)StdFileTypes.PROPERTIES))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List virtualFiles = (List)destination$iv$iv;
            for (GitIndexVirtualFile file : virtualFiles) {
                FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
                GitIndexVirtualFile gitIndexVirtualFile = file;
                Intrinsics.checkNotNull((Object)((Object)gitIndexVirtualFile));
                Document document = fileDocumentManager.getCachedDocument((VirtualFile)gitIndexVirtualFile);
                if (document != null) {
                    FileDocumentManager.getInstance().saveDocument(document);
                }
                file.setCharset(null);
            }
            VirtualFile[] virtualFileArray = VfsUtil.toVirtualFileArray((Collection)virtualFiles);
            FileDocumentManager.getInstance().reloadFiles(Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        }

        private static final void propertyChanged$lambda$0(MyEncodingManagerListener this$0) {
            ApplicationManager.getApplication().runWriteAction(() -> MyEncodingManagerListener.propertyChanged$lambda$0$0(this$0));
        }

        private static final void propertyChanged$lambda$0$0(MyEncodingManagerListener this$0) {
            this$0.reloadCachedPropertiesFiles();
        }
    }
}

