/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.HtmlValuesExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.extractors.TranspositionAwareExtractor;
import com.intellij.database.util.Out;
import com.intellij.ui.ColorUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayHtmlValuesExtractor
extends HtmlValuesExtractor {
    private static final String VALUE_SECTION_OPEN = "<div style='margin:2px 10px 2px 10px'><pre style='white-space: nowrap; margin: 0'>";
    private static final String VALUE_SECTION_CLOSE = "</pre></div>";
    protected final String myHex;
    private final String myBorder;
    private final int myTableWidth;

    public DisplayHtmlValuesExtractor(@NotNull Color background, @NotNull ObjectFormatter converter) {
        if (background == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(0);
        }
        if (converter == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(1);
        }
        this(background, converter, 100);
    }

    public DisplayHtmlValuesExtractor(@NotNull Color background, @NotNull ObjectFormatter converter, int tableWidth) {
        if (background == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(2);
        }
        if (converter == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(3);
        }
        super(converter);
        this.myHex = UIUtil.colorToHex((Color)background);
        Color borderColor = StartupUiUtil.isUnderDarcula() ? ColorUtil.brighter((Color)background, (int)1) : ColorUtil.darker((Color)background, (int)1);
        this.myBorder = UIUtil.colorToHex((Color)borderColor);
        this.myTableWidth = tableWidth;
    }

    @Nullable
    protected String getValueAsString(@NotNull GridRow row, @NotNull GridColumn column, @NotNull ObjectFormatterMode mode, boolean escape) {
        if (row == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(4);
        }
        if (column == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(5);
        }
        if (mode == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(6);
        }
        return super.getValueAsString(row, column, mode, false);
    }

    @NotNull
    public String getDataPrefix() {
        String string = String.format("<div style='margin-top: 2px;'><div style='background-color: #%s'><table border=0 width='%s%%' cellpadding=0 cellspacing=1>", this.myBorder, this.myTableWidth);
        if (string == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getDataSuffix() {
        return "</table></div></div>";
    }

    @NotNull
    public String getLinePrefix() {
        return "<tr align=left>";
    }

    @NotNull
    public String getValuePrefix() {
        String string = "<td align=left style='white-space: nowrap; background-color: #" + this.myHex + "; margin: 0px 0px 0px 0px;'><div style='margin:2px 10px 2px 10px'><pre style='white-space: nowrap; margin: 0'>";
        if (string == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getValueSuffix() {
        return "</pre></div></td>";
    }

    public String getLineSeparator() {
        return "";
    }

    @NotNull
    public String getColumnName(GridColumn column) {
        String string = "<th align=left style='background-color: #" + this.myHex + "'><div style='margin:2px 10px 2px 10px'><pre style='white-space: nowrap; margin: 0'>" + this.getName(column) + "</pre></div></th>";
        if (string == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    protected String getName(@NotNull GridColumn column) {
        if (column == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(10);
        }
        String string = column.getName();
        if (string == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(11);
        }
        return string;
    }

    public TranspositionAwareExtractor.TranspositionAwareExtraction startExtraction(@NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull String query, @NotNull ExtractionConfig config, int ... selectedColumns) {
        if (out == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(12);
        }
        if (allColumns == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(13);
        }
        if (query == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(14);
        }
        if (config == null) {
            DisplayHtmlValuesExtractor.$$$reportNull$$$0(15);
        }
        return new DisplayHtmlExtraction(out, config, allColumns, query, selectedColumns, false);
    }

    @NotNull
    public static String getHeader() {
        return "<html><body>";
    }

    @NotNull
    public static String getTail() {
        return "</body></html>";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/DisplayHtmlValuesExtractor";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allColumns";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/DisplayHtmlValuesExtractor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataPrefix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getValuePrefix";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getValueAsString";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "startExtraction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 11 -> new IllegalStateException(string);
        };
    }

    private class DisplayHtmlExtraction
    extends HtmlValuesExtractor.HtmlExtraction {
        DisplayHtmlExtraction(@NotNull Out output, ExtractionConfig config, List<? extends GridColumn> allColumns, String query, int[] selectedColumnIndices, Boolean isTransposedMode) {
            if (config == null) {
                DisplayHtmlExtraction.$$$reportNull$$$0(0);
            }
            super((HtmlValuesExtractor)DisplayHtmlValuesExtractor.this, output, config, allColumns, query, selectedColumnIndices, isTransposedMode);
        }

        protected String getHeader() {
            return DisplayHtmlValuesExtractor.this.getDataPrefix();
        }

        protected String getFooter() {
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/database/extractors/DisplayHtmlValuesExtractor$DisplayHtmlExtraction", "<init>"));
        }
    }
}

