/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.ruff.codeinsight.actions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.python.lsp.core.PyLspUsageCollector;
import com.intellij.python.ruff.RuffBundle;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.toml.lang.psi.TomlArray;
import org.toml.lang.psi.TomlFile;
import org.toml.lang.psi.TomlFileType;
import org.toml.lang.psi.TomlKey;
import org.toml.lang.psi.TomlKeySegment;
import org.toml.lang.psi.TomlKeyValue;
import org.toml.lang.psi.TomlLiteral;
import org.toml.lang.psi.TomlPsiFactory;
import org.toml.lang.psi.TomlTable;
import org.toml.lang.psi.TomlValue;
import org.toml.lang.psi.ext.TomlLiteralKind;
import org.toml.lang.psi.ext.TomlLiteralKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0004H\u0017J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J!\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\u0018\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0013H\u0002J \u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/python/ruff/codeinsight/actions/RuffDisableRuleIntentionAction;", "Lcom/intellij/codeInsight/intention/impl/BaseIntentionAction;", "Lcom/intellij/openapi/util/Iconable;", "ruleCode", "", "<init>", "(Ljava/lang/String;)V", "getIcon", "Ljavax/swing/Icon;", "flags", "", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "commitAndSave", "psiFile", "findRuffConfigFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "contextFile", "addRuleToIgnoreInSection", "tomlFile", "Lorg/toml/lang/psi/TomlFile;", "sectionName", "intellij.python.ruff"})
@SourceDebugExtension(value={"SMAP\nRuffDisableRuleIntentionAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuffDisableRuleIntentionAction.kt\ncom/intellij/python/ruff/codeinsight/actions/RuffDisableRuleIntentionAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,271:1\n1#2:272\n1#2:286\n2746#3,3:273\n1617#3,9:276\n1869#3:285\n1870#3:287\n1626#3:288\n295#3,2:289\n295#3,2:291\n*S KotlinDebug\n*F\n+ 1 RuffDisableRuleIntentionAction.kt\ncom/intellij/python/ruff/codeinsight/actions/RuffDisableRuleIntentionAction\n*L\n225#1:286\n107#1:273,3\n225#1:276,9\n225#1:285\n225#1:287\n225#1:288\n125#1:289,2\n191#1:291,2\n*E\n"})
public final class RuffDisableRuleIntentionAction
extends BaseIntentionAction
implements Iconable {
    @NotNull
    private final String ruleCode;

    public RuffDisableRuleIntentionAction(@NotNull String ruleCode) {
        Intrinsics.checkNotNullParameter((Object)ruleCode, (String)"ruleCode");
        this.ruleCode = ruleCode;
        this.setText(RuffBundle.INSTANCE.message("intention.name.disable.for.this.project", new Object[0]));
    }

    @NotNull
    public Icon getIcon(int flags) {
        Icon icon = AllIcons.Actions.Cancel;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Cancel");
        return icon;
    }

    @IntentionFamilyName
    @NotNull
    public String getFamilyName() {
        return RuffBundle.INSTANCE.message("intention.family.name.disable.ruff.rule", new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) throws IncorrectOperationException {
        VirtualFile configFile;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        PyLspUsageCollector.Companion.logDisableRule(project, false);
        VirtualFile virtualFile = configFile = this.findRuffConfigFile(project, file);
        boolean isPyProjectTarget = Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getName() : null), (Object)"pyproject.toml");
        String sectionName = isPyProjectTarget ? "tool.ruff.lint" : "lint";
        PsiFile[] psiFileArray = new PsiFile[]{file};
        WriteCommandAction.runWriteCommandAction((Project)project, (String)RuffBundle.INSTANCE.message("command.name.ruff.disable.rule", new Object[0]), (String)"ruff", () -> RuffDisableRuleIntentionAction.invoke$lambda$0(configFile, project, this, sectionName, file), (PsiFile[])psiFileArray);
    }

    private final void commitAndSave(Project project, PsiFile psiFile) {
        block1: {
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
            if (document == null) {
                return;
            }
            Document doc = document;
            PsiDocumentManager pdm = PsiDocumentManager.getInstance((Project)project);
            pdm.commitDocument(doc);
            pdm.doPostponedOperationsAndUnblockDocument(doc);
            pdm.commitDocument(doc);
            FileDocumentManager.getInstance().saveDocument(doc);
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile == null) break block1;
            virtualFile.refresh(false, false);
        }
    }

    private final VirtualFile findRuffConfigFile(Project project, PsiFile contextFile) {
        List candidateDirs = new ArrayList();
        PsiFile psiFile = contextFile;
        if (psiFile != null && (psiFile = psiFile.getVirtualFile()) != null && (psiFile = psiFile.getParent()) != null) {
            PsiFile it = psiFile;
            boolean bl = false;
            candidateDirs.add(it);
        }
        String string = project.getBasePath();
        if (string != null) {
            String base = string;
            boolean bl = false;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(base);
            if (virtualFile != null) {
                boolean bl2;
                VirtualFile baseDir;
                block9: {
                    baseDir = virtualFile;
                    boolean bl3 = false;
                    Iterable $this$none$iv = candidateDirs;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            VirtualFile it = (VirtualFile)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getPath(), (Object)baseDir.getPath())) continue;
                            bl2 = false;
                            break block9;
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    candidateDirs.add(baseDir);
                }
            }
        }
        String[] stringArray = new String[]{".ruff.toml", "ruff.toml", "pyproject.toml"};
        List names = CollectionsKt.listOf((Object[])stringArray);
        for (VirtualFile dir : candidateDirs) {
            for (String name : names) {
                VirtualFile virtualFile = dir.findChild(name);
                if (virtualFile == null) continue;
                VirtualFile it = virtualFile;
                boolean bl = false;
                return it;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void addRuleToIgnoreInSection(TomlFile tomlFile, String ruleCode, String sectionName) {
        TomlKeyValue existingIgnore;
        Iterable ws;
        PsiElement oneNl;
        TomlValue parentTable;
        Project project = tomlFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        TomlPsiFactory factory = new TomlPsiFactory(project, false, 2, null);
        TomlTable table = RuffDisableRuleIntentionAction.addRuleToIgnoreInSection$findTable(tomlFile, sectionName);
        if (table == null) {
            String parentSection;
            int lastDot = StringsKt.lastIndexOf$default((CharSequence)sectionName, (char)'.', (int)0, (boolean)false, (int)6, null);
            String string = parentSection = lastDot != -1 ? StringsKt.take((String)sectionName, (int)lastDot) : null;
            if (string != null) {
                String it = string;
                boolean bl = false;
                v2 = RuffDisableRuleIntentionAction.addRuleToIgnoreInSection$findTable(tomlFile, it);
            } else {
                v2 = parentTable = null;
            }
            if (parentTable != null) {
                if (parentTable.getEntries().isEmpty()) {
                    TomlTable t;
                    PsiElement afterParent = parentTable.getNextSibling();
                    oneNl = factory.createWhitespace("\n");
                    PsiElement ws2 = afterParent instanceof PsiWhiteSpace ? ((PsiWhiteSpace)afterParent).replace(oneNl) : tomlFile.addAfter(oneNl, (PsiElement)parentTable);
                    PsiElement psiElement = tomlFile.addAfter((PsiElement)factory.createTable(sectionName), ws2);
                    Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.toml.lang.psi.TomlTable");
                    v4 = t = (TomlTable)psiElement;
                } else {
                    PsiElement sibling;
                    PsiElement lastInParentBlock = (PsiElement)parentTable;
                    for (sibling = parentTable.getNextSibling(); sibling != null && !(sibling instanceof TomlTable); sibling = sibling.getNextSibling()) {
                        lastInParentBlock = sibling;
                    }
                    PsiElement twoNl = factory.createWhitespace("\n\n");
                    Object object = ws = lastInParentBlock instanceof PsiWhiteSpace ? lastInParentBlock.replace(twoNl) : tomlFile.addAfter(twoNl, lastInParentBlock);
                    if (sibling != null) {
                        PsiElement psiElement = tomlFile.addBefore((PsiElement)factory.createTable(sectionName), sibling);
                        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.toml.lang.psi.TomlTable");
                        v4 = t = (TomlTable)psiElement;
                    } else {
                        PsiElement psiElement = tomlFile.addAfter((PsiElement)factory.createTable(sectionName), (PsiElement)ws);
                        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.toml.lang.psi.TomlTable");
                        v4 = t = (TomlTable)psiElement;
                    }
                }
            } else {
                v4 = table = RuffDisableRuleIntentionAction.addRuleToIgnoreInSection$addAtEnd(tomlFile, factory, sectionName);
            }
        }
        if ((existingIgnore = RuffDisableRuleIntentionAction.addRuleToIgnoreInSection$findIgnoreEntry(table)) != null) {
            TomlValue value = existingIgnore.getValue();
            parentTable = value;
            if (parentTable instanceof TomlArray) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = ((TomlArray)value).getElements();
                boolean $i$f$mapNotNull = false;
                ws = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String string;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    TomlValue it = (TomlValue)element$iv$iv;
                    boolean bl2 = false;
                    if ((it instanceof TomlLiteral ? (TomlLiteral)it : null) != null) {
                        TomlLiteral lit;
                        lit = lit;
                        boolean bl3 = false;
                        string = RuffDisableRuleIntentionAction.addRuleToIgnoreInSection$getStringValue(lit);
                    } else {
                        string = null;
                    }
                    if (string == null) continue;
                    String it$iv$iv = string;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List existingNames = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
                if (existingNames.contains(ruleCode)) {
                    return;
                }
                boolean multiline = !((Collection)existingNames).isEmpty();
                String newValueText = RuffDisableRuleIntentionAction.addRuleToIgnoreInSection$buildArrayText(CollectionsKt.plus((Collection)existingNames, (Object)ruleCode), multiline);
                RuffDisableRuleIntentionAction.addRuleToIgnoreInSection$replaceIgnore(factory, existingIgnore, newValueText);
            } else if (parentTable instanceof TomlLiteral) {
                List items;
                String existing = RuffDisableRuleIntentionAction.addRuleToIgnoreInSection$getStringValue((TomlLiteral)value);
                if (Intrinsics.areEqual((Object)existing, (Object)ruleCode)) {
                    return;
                }
                Object newValueText = new String[]{existing, ruleCode};
                newValueText = RuffDisableRuleIntentionAction.addRuleToIgnoreInSection$buildArrayText(items, (items = CollectionsKt.listOfNotNull((Object[])newValueText)).size() > 1);
                RuffDisableRuleIntentionAction.addRuleToIgnoreInSection$replaceIgnore(factory, existingIgnore, (String)newValueText);
            } else {
                RuffDisableRuleIntentionAction.addRuleToIgnoreInSection$replaceIgnore(factory, existingIgnore, "[\"" + ruleCode + "\"]");
            }
            v9 = Unit.INSTANCE;
        } else {
            TomlKeyValue newKv = factory.createKeyValue("ignore", "[\"" + ruleCode + "\"]");
            TomlKeyValue anchor = (TomlKeyValue)CollectionsKt.lastOrNull((List)table.getEntries());
            if (anchor != null) {
                PsiElement nl = factory.createNewline();
                PsiElement insertedNl = table.addAfter(nl, (PsiElement)anchor);
                PsiElement added = table.addAfter((PsiElement)newKv, insertedNl);
                v9 = table.addAfter(factory.createNewline(), added);
            } else {
                PsiElement afterHeader = table.getFirstChild().getNextSibling();
                oneNl = factory.createNewline();
                PsiElement wsAnchor = afterHeader instanceof PsiWhiteSpace ? ((PsiWhiteSpace)afterHeader).replace(oneNl) : table.addAfter(oneNl, table.getFirstChild());
                v9 = table.addAfter((PsiElement)newKv, wsAnchor);
            }
        }
        PsiElement last = table.getLastChild();
        PsiElement psiElement = table.getNextSibling();
        if (psiElement instanceof PsiWhiteSpace) {
            return;
        }
        PsiElement nl = psiElement == null ? factory.createNewline() : factory.createWhitespace("\n\n");
        PsiElement psiElement2 = last instanceof PsiWhiteSpace ? ((PsiWhiteSpace)last).replace(nl) : table.add(nl);
    }

    private static final void invoke$lambda$0(VirtualFile $configFile, Project $project, RuffDisableRuleIntentionAction this$0, String $sectionName, PsiFile $file) {
        if ($configFile != null) {
            TomlFile psiConfig;
            PsiFile psiFile = PsiManager.getInstance((Project)$project).findFile($configFile);
            TomlFile tomlFile = psiConfig = psiFile instanceof TomlFile ? (TomlFile)psiFile : null;
            if (psiConfig != null) {
                this$0.addRuleToIgnoreInSection(psiConfig, this$0.ruleCode, $sectionName);
                this$0.commitAndSave($project, (PsiFile)psiConfig);
            }
        } else {
            PsiFile addedPsiFile;
            VirtualFile virtualFile = $file.getVirtualFile();
            Object parentVFile = virtualFile != null ? virtualFile.getParent() : null;
            if (!(parentVFile != null)) {
                boolean $i$a$-require-RuffDisableRuleIntentionAction$invoke$1$32 = false;
                String $i$a$-require-RuffDisableRuleIntentionAction$invoke$1$32 = "Cannot determine target directory for ruff.toml";
                throw new IllegalArgumentException($i$a$-require-RuffDisableRuleIntentionAction$invoke$1$32.toString());
            }
            PsiDirectory psiDir = PsiManager.getInstance((Project)$project).findDirectory(parentVFile);
            if (!(psiDir != null)) {
                boolean $i$a$-require-RuffDisableRuleIntentionAction$invoke$1$42 = false;
                String $i$a$-require-RuffDisableRuleIntentionAction$invoke$1$42 = "Cannot find PSI directory for target location";
                throw new IllegalArgumentException($i$a$-require-RuffDisableRuleIntentionAction$invoke$1$42.toString());
            }
            PsiFile psiFile = PsiFileFactory.getInstance((Project)$project).createFileFromText("ruff.toml", (FileType)TomlFileType.INSTANCE, (CharSequence)"");
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.toml.lang.psi.TomlFile");
            TomlFile newPsiFile = (TomlFile)psiFile;
            this$0.addRuleToIgnoreInSection(newPsiFile, this$0.ruleCode, "lint");
            PsiElement added = psiDir.add((PsiElement)newPsiFile);
            PsiFile psiFile2 = added instanceof PsiFile ? (PsiFile)added : null;
            if (psiFile2 == null) {
                PsiFile psiFile3 = added.getContainingFile();
                if (psiFile3 == null || (psiFile3 = psiFile3.getVirtualFile()) == null) {
                    return;
                }
                psiFile2 = PsiManager.getInstance((Project)$project).findFile((VirtualFile)psiFile3);
            }
            if ((addedPsiFile = psiFile2) != null) {
                this$0.commitAndSave($project, addedPsiFile);
            }
        }
        PyLspUsageCollector.Companion.logDisableRule($project, false);
    }

    private static final TomlTable addRuleToIgnoreInSection$findTable(TomlFile $tomlFile, String section) {
        Object v2;
        block3: {
            Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)$tomlFile), TomlTable.class);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(...)");
            Collection tables = collection;
            Iterable $this$firstOrNull$iv = tables;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                TomlTable table = (TomlTable)element$iv;
                boolean bl2 = false;
                if (table.getHeader().getKey() == null) {
                    bl = false;
                } else {
                    TomlKey key;
                    String path = CollectionsKt.joinToString$default((Iterable)key.getSegments(), (CharSequence)".", null, null, (int)0, null, RuffDisableRuleIntentionAction::addRuleToIgnoreInSection$findTable$lambda$0$0, (int)30, null);
                    bl = Intrinsics.areEqual((Object)path, (Object)section);
                }
                if (!bl) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        return v2;
    }

    private static final CharSequence addRuleToIgnoreInSection$findTable$lambda$0$0(TomlKeySegment it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName();
        return string != null ? (CharSequence)string : (CharSequence)"";
    }

    private static final TomlTable addRuleToIgnoreInSection$addAtEnd(TomlFile $tomlFile, TomlPsiFactory factory, String $sectionName) {
        String string = $tomlFile.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (((CharSequence)string).length() > 0) {
            PsiElement twoNl = factory.createWhitespace("\n\n");
            PsiElement last = $tomlFile.getLastChild();
            PsiElement psiElement = last instanceof PsiWhiteSpace ? ((PsiWhiteSpace)last).replace(twoNl) : $tomlFile.add(twoNl);
        }
        PsiElement psiElement = $tomlFile.add((PsiElement)factory.createTable($sectionName));
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.toml.lang.psi.TomlTable");
        return (TomlTable)psiElement;
    }

    private static final TomlKeyValue addRuleToIgnoreInSection$findIgnoreEntry(TomlTable tbl) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = tbl.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TomlKeyValue kv = (TomlKeyValue)element$iv;
                boolean bl = false;
                List segments = kv.getKey().getSegments();
                if (!(segments.size() == 1 && Intrinsics.areEqual((Object)((TomlKeySegment)segments.get(0)).getName(), (Object)"ignore"))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private static final void addRuleToIgnoreInSection$replaceIgnore(TomlPsiFactory factory, TomlKeyValue target, String newValueText) {
        TomlKeyValue newKv = factory.createKeyValue("ignore", newValueText);
        PsiElement psiElement = target.replace((PsiElement)newKv);
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.toml.lang.psi.TomlKeyValue");
        TomlKeyValue replaced = (TomlKeyValue)psiElement;
        PsiElement ws = replaced.getNextSibling();
        if (ws instanceof PsiWhiteSpace) {
            ((PsiWhiteSpace)ws).replace(factory.createNewline());
        }
    }

    private static final String addRuleToIgnoreInSection$getStringValue(TomlLiteral lit) {
        TomlLiteralKind k = TomlLiteralKt.getKind((TomlLiteral)lit);
        return k instanceof TomlLiteralKind.String ? ((TomlLiteralKind.String)k).getValue() : null;
    }

    private static final String addRuleToIgnoreInSection$buildArrayText(List<String> items, boolean multiline) {
        Object object;
        block4: {
            block2: {
                block3: {
                    if (multiline || items.size() > 1) break block2;
                    object = (String)CollectionsKt.firstOrNull(items);
                    if (object == null) break block3;
                    String it = object;
                    boolean bl = false;
                    String string = "[\"" + it + "\"]";
                    object = string;
                    if (string != null) break block4;
                }
                object = "[]";
                break block4;
            }
            String body = CollectionsKt.joinToString$default((Iterable)items, (CharSequence)",\n    ", null, null, (int)0, null, RuffDisableRuleIntentionAction::addRuleToIgnoreInSection$buildArrayText$lambda$4, (int)30, null);
            object = "[\n    " + body + ",\n]";
        }
        return object;
    }

    private static final CharSequence addRuleToIgnoreInSection$buildArrayText$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\"" + it + "\"";
    }
}

