/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.intellij.openapi.util.Pair;
import com.intellij.util.Processor;
import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.AggregatesBuilder;
import com.jetbrains.nodejs.run.profile.heap.calculation.DominatedNodesBuilder;
import com.jetbrains.nodejs.run.profile.heap.calculation.DominatorTreeBuilder;
import com.jetbrains.nodejs.run.profile.heap.calculation.Flags;
import com.jetbrains.nodejs.run.profile.heap.calculation.SelectTopOnConstArray;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8DistancesCalculator;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8FlagsCalculator;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapInMemoryIndexes;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8HeapIndexManager;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8ImportantStringsHolder;
import com.jetbrains.nodejs.run.profile.heap.calculation.V8PostOrderBuilder;
import com.jetbrains.nodejs.run.profile.heap.data.Aggregate;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapNodeType;
import com.jetbrains.nodejs.run.profile.heap.io.SequentialRawReader;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReader;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReaderFactory;
import com.jetbrains.nodejs.util.CloseableThrowableConsumer;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RetainedSizeCalculator
implements Closeable {
    private final long myNodesCnt;
    private final boolean myShowHiddenData;
    private LongArrayList myRetainedSizes;
    private List<Integer> myBiggest;
    private LinksReaderFactory<Long> myAggregatesLinksReaderFactory;
    private V8HeapInMemoryIndexes myInMemoryIndexes;

    public RetainedSizeCalculator(long cnt, boolean showHiddenData) {
        this.myNodesCnt = cnt;
        this.myShowHiddenData = showHiddenData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(@NotNull V8CachingReader cachingReader, @NotNull LinksReaderFactory<V8HeapEdge> reverseLinkIndexProcessor, @NotNull File nodeIndexFile, @NotNull IndexFiles<V8HeapIndexManager.Category> indexFiles, V8ImportantStringsHolder stringsHolder) throws IOException {
        DominatorTreeBuilder dominatorTreeBuilder;
        V8PostOrderBuilder postOrderBuilder;
        if (cachingReader == null) {
            RetainedSizeCalculator.$$$reportNull$$$0(0);
        }
        if (reverseLinkIndexProcessor == null) {
            RetainedSizeCalculator.$$$reportNull$$$0(1);
        }
        if (nodeIndexFile == null) {
            RetainedSizeCalculator.$$$reportNull$$$0(2);
        }
        if (indexFiles == null) {
            RetainedSizeCalculator.$$$reportNull$$$0(3);
        }
        V8FlagsCalculator calculator = new V8FlagsCalculator((int)this.myNodesCnt, cachingReader, stringsHolder);
        Flags flags = calculator.execute();
        V8DistancesCalculator distancesCalculator = new V8DistancesCalculator((int)this.myNodesCnt, cachingReader, calculator.getDocumentDOMRoot(), calculator.getGcRoots(), stringsHolder);
        distancesCalculator.execute();
        IntList distances = distancesCalculator.getDistances();
        IntList parents = distancesCalculator.getParents();
        try (LinksReader<V8HeapEdge> randomReverseReader = reverseLinkIndexProcessor.create(false);){
            postOrderBuilder = new V8PostOrderBuilder((int)this.myNodesCnt, cachingReader, flags, randomReverseReader, this.myShowHiddenData);
            postOrderBuilder.execute();
            dominatorTreeBuilder = new DominatorTreeBuilder((int)this.myNodesCnt, cachingReader, postOrderBuilder, flags, randomReverseReader, this.myShowHiddenData);
            dominatorTreeBuilder.execute();
        }
        this.calculateRetainedSizes(nodeIndexFile, postOrderBuilder, dominatorTreeBuilder.getDominatorsTree());
        this.calculateBiggestObjects(flags, cachingReader, 100);
        DominatedNodesBuilder dominatedNodesBuilder = new DominatedNodesBuilder(dominatorTreeBuilder.getDominatorsTree(), (int)this.myNodesCnt);
        dominatedNodesBuilder.execute();
        AggregatesBuilder aggregatesBuilder = new AggregatesBuilder(indexFiles, cachingReader, flags, this.myShowHiddenData, (int)this.myNodesCnt, dominatedNodesBuilder, this.myRetainedSizes, distances, postOrderBuilder.getUnreachable());
        aggregatesBuilder.execute();
        Map<Long, Aggregate> aggregateMap = aggregatesBuilder.getAggregateMap();
        this.myAggregatesLinksReaderFactory = aggregatesBuilder.createLinksReaderFactory();
        IntList unreachable = postOrderBuilder.getUnreachable();
        IntList onlyWeak = postOrderBuilder.getOnlyWeak();
        this.myInMemoryIndexes = new V8HeapInMemoryIndexes(flags, (LongList)this.myRetainedSizes, parents, this.myBiggest, distances, aggregateMap, unreachable, onlyWeak);
    }

    public V8HeapInMemoryIndexes getInMemoryIndexes() {
        return this.myInMemoryIndexes;
    }

    public LinksReaderFactory<Long> getAggregatesLinksReaderFactory() {
        return this.myAggregatesLinksReaderFactory;
    }

    private void calculateBiggestObjects(Flags flagsCalculator, V8CachingReader cachingReader, int number) {
        SelectTopOnConstArray select = new SelectTopOnConstArray(this.myRetainedSizes, 100, (Processor<? super Integer>)((Processor)integer -> flagsCalculator.isPage((int)integer) && (this.myShowHiddenData || !V8HeapNodeType.kHidden.equals((Object)cachingReader.getNode(integer.intValue()).getType()))));
        select.execute();
        this.myBiggest = new ArrayList<Integer>();
        for (Pair<Long, Integer> pair : select.getTop()) {
            this.myBiggest.add((Integer)pair.getSecond());
            if (this.myBiggest.size() < number) continue;
            break;
        }
    }

    private void calculateRetainedSizes(@NotNull File nodeIndexFile, V8PostOrderBuilder postOrderBuilder, IntList dominatorsTree) throws IOException {
        if (nodeIndexFile == null) {
            RetainedSizeCalculator.$$$reportNull$$$0(4);
        }
        this.myRetainedSizes = new LongArrayList((int)this.myNodesCnt);
        new SequentialRawReader<V8HeapEntry>(nodeIndexFile, V8HeapEntry.MyRawSerializer.getInstance(), this.myNodesCnt).iterate(new CloseableThrowableConsumer<V8HeapEntry, IOException>(){

            @Override
            public void close() {
            }

            public void consume(V8HeapEntry entry) {
                RetainedSizeCalculator.this.myRetainedSizes.add(entry.getSize());
            }
        });
        int postOrder = 0;
        while ((long)postOrder < this.myNodesCnt - 1L) {
            int node = postOrderBuilder.getPostOrderToNode().getInt(postOrder);
            int dominator = dominatorsTree.getInt(node);
            this.myRetainedSizes.set(dominator, this.myRetainedSizes.getLong(node) + this.myRetainedSizes.getLong(dominator));
            ++postOrder;
        }
    }

    @Override
    public void close() throws IOException {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachingReader";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reverseLinkIndexProcessor";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeIndexFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexFiles";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/RetainedSizeCalculator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "calculateRetainedSizes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

