/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.puppet.PuppetTokenTypes;
import com.intellij.lang.puppet.psi.resolve.PuppetResolveUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PuppetHighlightUsagesHandlerBase
extends HighlightUsagesHandlerBase<PsiElement>
implements PuppetTokenTypes {
    public PuppetHighlightUsagesHandlerBase(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            PuppetHighlightUsagesHandlerBase.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PuppetHighlightUsagesHandlerBase.$$$reportNull$$$0(1);
        }
        super(editor, file);
    }

    protected void addWriteUsage(@NotNull PsiElement element) {
        if (element == null) {
            PuppetHighlightUsagesHandlerBase.$$$reportNull$$$0(2);
        }
        this.addUsageRange(this.myWriteUsages, PuppetHighlightUsagesHandlerBase.getRangeToHighlight(element), element);
    }

    protected void addUsageRange(List<? super TextRange> result, TextRange range, PsiElement element) {
        if (range != null) {
            range = InjectedLanguageManager.getInstance((Project)element.getProject()).injectedToHost(element, range);
            result.add((TextRange)range);
        }
    }

    @NotNull
    protected List<PsiElement> getTargetsWithSynonyms(@NotNull PsiFile currentFile, @NotNull Collection<? extends PsiElement> currentTargets) {
        if (currentFile == null) {
            PuppetHighlightUsagesHandlerBase.$$$reportNull$$$0(3);
        }
        if (currentTargets == null) {
            PuppetHighlightUsagesHandlerBase.$$$reportNull$$$0(4);
        }
        HashSet<PsiElement> result = new HashSet<PsiElement>();
        HashSet processedSynonyms = new HashSet();
        for (PsiElement psiElement : currentTargets) {
            if (result.add(psiElement) && currentFile.equals((Object)psiElement.getContainingFile())) {
                this.addWriteUsage(psiElement.getNavigationElement());
            }
            PuppetResolveUtil.processElementSynonims(psiElement, (PsiElement)currentFile, processedSynonyms, (PsiElementProcessor<? super PsiElement>)((PsiElementProcessor)synonym -> {
                if (result.add(synonym) && currentFile.equals((Object)synonym.getContainingFile())) {
                    this.addWriteUsage(synonym.getNavigationElement());
                }
                return true;
            }));
        }
        return new ArrayList<PsiElement>(result);
    }

    protected void selectTargets(@NotNull List<? extends PsiElement> targets, @NotNull Consumer<? super List<? extends PsiElement>> selectionConsumer) {
        if (targets == null) {
            PuppetHighlightUsagesHandlerBase.$$$reportNull$$$0(5);
        }
        if (selectionConsumer == null) {
            PuppetHighlightUsagesHandlerBase.$$$reportNull$$$0(6);
        }
        selectionConsumer.consume(targets);
    }

    public void computeUsages(@NotNull List<? extends PsiElement> targets) {
        if (targets == null) {
            PuppetHighlightUsagesHandlerBase.$$$reportNull$$$0(7);
        }
        for (PsiElement psiElement : targets) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)psiElement, (SearchScope)GlobalSearchScope.fileScope((PsiFile)this.myFile)).asIterable()) {
                PsiElement sourceElement = reference.getElement();
                this.addUsageRange(this.myReadUsages, reference.getRangeInElement().shiftRight(sourceElement.getNode().getStartOffset()), sourceElement);
            }
        }
    }

    @Nullable
    private static TextRange getRangeToHighlight(PsiElement element) {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)element);
        return manipulator == null ? element.getTextRange() : manipulator.getRangeInElement(element).shiftRight(element.getNode().getStartOffset());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTargets";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionConsumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/puppet/ide/highlighting/PuppetHighlightUsagesHandlerBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addWriteUsage";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getTargetsWithSynonyms";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "selectTargets";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "computeUsages";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

