/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssMediaGroupAwareDescriptor;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.descriptor.CssContextType;
import com.intellij.psi.css.descriptor.CssElementDescriptor;
import com.intellij.psi.css.descriptor.CssMediaGroup;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssInspectionsUtil {
    public static void checkForTotalUnresolved(@NotNull PsiElement psiElement, @NotNull ProblemsHolder holder, @NotNull @InspectionMessage String message) {
        if (psiElement == null) {
            CssInspectionsUtil.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CssInspectionsUtil.$$$reportNull$$$0(1);
        }
        if (message == null) {
            CssInspectionsUtil.$$$reportNull$$$0(2);
        }
        CssInspectionsUtil.checkForTotalUnresolved(psiElement, psiElement, holder, message);
    }

    public static void checkForTotalUnresolved(@NotNull PsiElement psiElement, @NotNull PsiElement highlightingElement, @NotNull ProblemsHolder holder, @NotNull @InspectionMessage String message) {
        PsiReference[] references;
        if (psiElement == null) {
            CssInspectionsUtil.$$$reportNull$$$0(3);
        }
        if (highlightingElement == null) {
            CssInspectionsUtil.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            CssInspectionsUtil.$$$reportNull$$$0(5);
        }
        if (message == null) {
            CssInspectionsUtil.$$$reportNull$$$0(6);
        }
        boolean hasProblem = (references = psiElement.getReferences()).length > 0;
        for (PsiReference reference : references) {
            if (reference instanceof PsiPolyVariantReference) {
                if (((PsiPolyVariantReference)reference).multiResolve(false).length <= 0) continue;
                hasProblem = false;
                continue;
            }
            if (reference.resolve() == null) continue;
            hasProblem = false;
        }
        if (hasProblem) {
            holder.registerProblem(highlightingElement, message, new LocalQuickFix[0]);
        }
    }

    public static void checkForProperlyResolving(PsiElement psiElement, ProblemsHolder holder, @InspectionMessage String message) {
        CssInspectionsUtil.checkForProperlyResolving(psiElement, psiElement, holder, message);
    }

    public static void checkForProperlyResolving(PsiElement psiElement, PsiElement highlightingElement, ProblemsHolder holder, @InspectionMessage String message) {
        PsiReference[] references = psiElement.getReferences();
        boolean hasProblem = false;
        Set importedFiles = null;
        for (PsiReference reference : references) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] resolveResults = ((PsiPolyVariantReference)reference).multiResolve(false);
                hasProblem = resolveResults.length > 0;
                for (ResolveResult resolveResult : resolveResults) {
                    if (!resolveResult.isValidResult()) continue;
                    hasProblem = false;
                }
                continue;
            }
            PsiElement resolveResult = reference.resolve();
            if (resolveResult == null) continue;
            hasProblem = true;
            PsiFile file = resolveResult.getContainingFile();
            VirtualFile virtualFile = file.getVirtualFile();
            if (importedFiles == null) {
                importedFiles = CssUtil.getImportedFiles((PsiFile)file, (PsiElement)psiElement, (boolean)false);
            }
            if (virtualFile == null || !importedFiles.contains(virtualFile)) continue;
            hasProblem = false;
        }
        if (hasProblem) {
            holder.registerProblem(highlightingElement, message, new LocalQuickFix[0]);
        }
    }

    public static boolean isPureCssPropertyName(@Nullable PsiElement propertyNameElement) {
        if (propertyNameElement == null || !propertyNameElement.isValid()) {
            return false;
        }
        for (PsiElement prevSibling = propertyNameElement.getPrevSibling(); prevSibling != null && !(prevSibling instanceof PsiWhiteSpace) && prevSibling.getNode().getElementType() != CssElementTypes.CSS_COLON; prevSibling = prevSibling.getPrevSibling()) {
            if (prevSibling.getLanguage().is((Language)CSSLanguage.INSTANCE)) continue;
            return false;
        }
        for (PsiElement nextSibling = propertyNameElement.getNextSibling(); nextSibling != null && !(nextSibling instanceof PsiWhiteSpace) && nextSibling.getNode().getElementType() != CssElementTypes.CSS_COLON; nextSibling = nextSibling.getNextSibling()) {
            if (nextSibling.getLanguage().is((Language)CSSLanguage.INSTANCE)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static <T extends CssElementDescriptor> Collection<T> filterDescriptorsByContextAndCheck(@NotNull Collection<T> descriptors, @NotNull PsiElement nameIdentifier, @NotNull ProblemsHolder holder) {
        Collection filteredByContextDescriptors;
        if (descriptors == null) {
            CssInspectionsUtil.$$$reportNull$$$0(7);
        }
        if (nameIdentifier == null) {
            CssInspectionsUtil.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            CssInspectionsUtil.$$$reportNull$$$0(9);
        }
        if ((filteredByContextDescriptors = CssDescriptorsUtil.filterDescriptorsByContext(descriptors, (PsiElement)nameIdentifier)).isEmpty()) {
            HashMap name2AtRuleTypes = Maps.newHashMap();
            for (CssElementDescriptor cssElementDescriptor : descriptors) {
                Object[] allowedInRules = cssElementDescriptor.getAllowedContextTypes();
                String presentableText = cssElementDescriptor.getElementTypeName() + " <code>" + cssElementDescriptor.getPresentableName() + "</code>";
                if (!name2AtRuleTypes.containsKey(presentableText)) {
                    name2AtRuleTypes.put(presentableText, Sets.newHashSet((Object[])allowedInRules));
                    continue;
                }
                ((Set)name2AtRuleTypes.get(presentableText)).addAll(Sets.newHashSet((Object[])allowedInRules));
            }
            for (Map.Entry entry : name2AtRuleTypes.entrySet()) {
                TreeSet rules = new TreeSet(CssContextType.COMPARATOR);
                rules.addAll((Collection)entry.getValue());
                String errorMessage = !rules.isEmpty() && !rules.contains(CssContextType.ANY) ? CssBundle.message((String)"css.inspections.wrong.context", (Object[])new Object[]{entry.getKey(), StringUtil.join(rules, (String)", ")}) : CssBundle.message((String)"css.inspections.element.not.allowed.here", (Object[])new Object[]{entry.getKey()});
                holder.registerProblem(nameIdentifier, errorMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }
        Collection collection = filteredByContextDescriptors;
        if (collection == null) {
            CssInspectionsUtil.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public static <T extends CssMediaGroupAwareDescriptor> Collection<T> filterDescriptorsByMediaTypeAndCheck(@NotNull Collection<T> descriptors, @NotNull PsiElement nameIdentifier, @NotNull ProblemsHolder holder) {
        Collection filteredByMediaTypeDescriptors;
        if (descriptors == null) {
            CssInspectionsUtil.$$$reportNull$$$0(11);
        }
        if (nameIdentifier == null) {
            CssInspectionsUtil.$$$reportNull$$$0(12);
        }
        if (holder == null) {
            CssInspectionsUtil.$$$reportNull$$$0(13);
        }
        if ((filteredByMediaTypeDescriptors = CssDescriptorsUtil.filterDescriptorsByMediaType(descriptors, (PsiElement)nameIdentifier)).isEmpty()) {
            HashMap name2MediaGroups = Maps.newHashMap();
            for (CssMediaGroupAwareDescriptor cssMediaGroupAwareDescriptor : descriptors) {
                Object[] allowedMediaGroups = cssMediaGroupAwareDescriptor.getMediaGroups();
                String presentableText = cssMediaGroupAwareDescriptor.getElementTypeName() + " <code>" + cssMediaGroupAwareDescriptor.getPresentableName() + "</code>";
                if (!name2MediaGroups.containsKey(presentableText)) {
                    name2MediaGroups.put(presentableText, Sets.newHashSet((Object[])allowedMediaGroups));
                    continue;
                }
                ((Set)name2MediaGroups.get(presentableText)).addAll(Sets.newHashSet((Object[])allowedMediaGroups));
            }
            for (Map.Entry entry : name2MediaGroups.entrySet()) {
                TreeSet groups = new TreeSet(CssMediaGroup.COMPARATOR);
                groups.addAll((Collection)entry.getValue());
                String groupsList = StringUtil.toLowerCase((String)StringUtil.join(groups, (String)", "));
                String errorMessage = !groups.isEmpty() && !groups.contains(CssMediaGroup.ALL) ? CssBundle.message((String)"css.inspections.wrong.media", (Object[])new Object[]{entry.getKey(), groupsList}) : CssBundle.message((String)"css.inspections.element.not.allowed.here", (Object[])new Object[]{entry.getKey()});
                holder.registerProblem(nameIdentifier, errorMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }
        Collection collection = filteredByMediaTypeDescriptors;
        if (collection == null) {
            CssInspectionsUtil.$$$reportNull$$$0(14);
        }
        return collection;
    }

    public static void checkUnclosedComment(@NotNull PsiComment comment, @NotNull AnnotationHolder holder) {
        String commentText;
        if (comment == null) {
            CssInspectionsUtil.$$$reportNull$$$0(15);
        }
        if (holder == null) {
            CssInspectionsUtil.$$$reportNull$$$0(16);
        }
        if (comment.getTokenType() == CssElementTypes.CSS_COMMENT && !(commentText = comment.getText()).endsWith("*/")) {
            int offset = comment.getTextRange().getEndOffset();
            holder.newAnnotation(HighlightSeverity.ERROR, CssBundle.message((String)"css.unclosed.comment", (Object[])new Object[0])).range(TextRange.create((int)offset, (int)offset)).afterEndOfLine().create();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingElement";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameIdentifier";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/inspections/CssInspectionsUtil";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/inspections/CssInspectionsUtil";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDescriptorsByContextAndCheck";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filterDescriptorsByMediaTypeAndCheck";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkForTotalUnresolved";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterDescriptorsByContextAndCheck";
                break;
            }
            case 10: 
            case 14: {
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filterDescriptorsByMediaTypeAndCheck";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "checkUnclosedComment";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 14 -> new IllegalStateException(string);
        };
    }

    public static class CssInvalidValueRangeProvider {
        public static final CssInvalidValueRangeProvider INSTANCE = new CssInvalidValueRangeProvider();

        public TextRange calculateInvalidRange(@NotNull CssValueOwner valueOwner, @Nullable PsiElement lastMatchedElement, @NotNull TextRange defaultValue) {
            if (valueOwner == null) {
                CssInvalidValueRangeProvider.$$$reportNull$$$0(0);
            }
            if (defaultValue == null) {
                CssInvalidValueRangeProvider.$$$reportNull$$$0(1);
            }
            TextRange valueOwnerTextRange = valueOwner.getTextRange();
            return defaultValue.isEmpty() ? valueOwnerTextRange.shiftRight(-valueOwnerTextRange.getStartOffset()) : defaultValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "valueOwner";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defaultValue";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/css/inspections/CssInspectionsUtil$CssInvalidValueRangeProvider";
            objectArray[2] = "calculateInvalidRange";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

