/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactory;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.customization.LspDocumentHighlightsCustomizer;
import com.intellij.platform.lsp.api.customization.LspDocumentHighlightsSupport;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.highlighting.LspHighlightUsagesHandlerFactory;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/platform/lsp/impl/highlighting/LspHighlightUsagesHandlerFactory;", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerFactory;", "Lcom/intellij/openapi/project/DumbAware;", "LspHighlightUsagesHandlerFactory", "()V", "createHighlightUsagesHandler", "Lcom/intellij/codeInsight/highlighting/HighlightUsagesHandlerBase;", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "S", "", "server", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "file", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspHighlightUsagesHandlerFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspHighlightUsagesHandlerFactory.kt\ncom/intellij/platform/lsp/impl/highlighting/LspHighlightUsagesHandlerFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n774#2:61\n865#2,2:62\n*S KotlinDebug\n*F\n+ 1 LspHighlightUsagesHandlerFactory.kt\ncom/intellij/platform/lsp/impl/highlighting/LspHighlightUsagesHandlerFactory\n*L\n24#1:61\n24#1:62,2\n*E\n"})
public final class LspHighlightUsagesHandlerFactory
implements HighlightUsagesHandlerFactory,
DumbAware {
    @Nullable
    public HighlightUsagesHandlerBase<PsiElement> createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 instanceof VirtualFileWindow || !virtualFile2.isInLocalFileSystem()) {
            return null;
        }
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Iterable iterable = LspServerManagerImpl.Companion.getInstanceImpl(project).getServersWithThisFileOpen$intellij_platform_lsp_impl(virtualFile2);
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl2 = false;
        for (Object t2 : iterable2) {
            LspServerImpl lspServerImpl = (LspServerImpl)t2;
            boolean bl3 = false;
            if (!this.S(lspServerImpl, psiFile)) continue;
            collection.add(t2);
        }
        List list = (List)collection;
        if (list.isEmpty()) {
            return null;
        }
        return (HighlightUsagesHandlerBase)new DumbAware(editor, psiFile, list, virtualFile2){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ PsiFile $psiFile;
            final /* synthetic */ List<LspServerImpl> $servers;
            final /* synthetic */ VirtualFile $virtualFile;
            {
                this.$editor = $editor;
                this.$psiFile = $psiFile;
                this.$servers = $servers;
                this.$virtualFile = $virtualFile;
                super($editor, $psiFile);
            }

            public List<PsiElement> getTargets() {
                return CollectionsKt.listOf((Object)this.$psiFile);
            }

            protected void selectTargets(List<? extends PsiElement> targets, Consumer<? super List<? extends PsiElement>> selectionConsumer) {
                Intrinsics.checkNotNullParameter(targets, (String)"targets");
                Intrinsics.checkNotNullParameter(selectionConsumer, (String)"selectionConsumer");
                selectionConsumer.consume((Object)CollectionsKt.toMutableList((Collection)targets));
            }

            public void computeUsages(List<? extends PsiElement> targets) {
                Intrinsics.checkNotNullParameter(targets, (String)"targets");
                Document document = this.$editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Document document2 = document;
                Position position = Lsp4jUtilKt.getLsp4jPosition(document2, this.$editor.getCaretModel().getOffset());
                Iterable iterable = this.$servers;
                VirtualFile virtualFile = this.$virtualFile;
                boolean bl = false;
                Iterable<T> iterable22 = iterable;
                Collection collection = new ArrayList<E>();
                boolean bl2 = false;
                TextRange textRange = iterable22.iterator();
                while (textRange.hasNext()) {
                    T t2 = textRange.next();
                    Object object = (LspServerImpl)t2;
                    boolean bl3 = false;
                    List list = ((LspServerImpl)object).getRequestExecutor().getDocumentHighlightsCaching$intellij_platform_lsp_impl(virtualFile, position);
                    if (list == null) {
                        list = CollectionsKt.emptyList();
                    }
                    object = list;
                    CollectionsKt.addAll((Collection)collection, (Iterable)object);
                }
                iterable = (List)collection;
                boolean bl4 = false;
                for (Iterable<T> iterable22 : iterable) {
                    collection = (DocumentHighlight)iterable22;
                    bl2 = false;
                    Range range = collection.getRange();
                    Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getRange(...)");
                    if (Lsp4jUtilKt.getRangeInDocument(document2, range) == null) continue;
                    DocumentHighlightKind documentHighlightKind = collection.getKind();
                    boolean bl5 = (documentHighlightKind == null ? -1 : createHighlightUsagesHandler.WhenMappings.$EnumSwitchMapping$0[documentHighlightKind.ordinal()]) == 1 ? this.myWriteUsages.add(textRange) : this.myReadUsages.add(textRange);
                }
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean S(LspServerImpl lspServerImpl, PsiFile psiFile) {
        LspDocumentHighlightsCustomizer lspDocumentHighlightsCustomizer = lspServerImpl.getDescriptor().getLspCustomization().getDocumentHighlightsCustomizer();
        if (!(lspDocumentHighlightsCustomizer instanceof LspDocumentHighlightsSupport)) return false;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        if (!lspServerImpl.supportsDocumentHighlights$intellij_platform_lsp_impl(virtualFile)) return false;
        if (!((LspDocumentHighlightsSupport)lspDocumentHighlightsCustomizer).shouldAskServerForDocumentHighlights(psiFile)) return false;
        return true;
    }
}

