/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.UriParser;
import org.apache.commons.vfs2.provider.local.LocalFileRandomAccessContent;
import org.apache.commons.vfs2.provider.local.LocalFileSystem;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.jetbrains.annotations.NotNull;

public class LocalFile
extends AbstractFileObject<LocalFileSystem> {
    private final String rootFile;
    private File file;
    private static final String OS_NAME;
    private static final boolean IS_WINDOWS;
    private static final Method IO_FILE_SET_WRITABLE_METHOD;
    private static final Method IO_FILE_SET_READABLE_METHOD;
    private static final Method IO_FILE_SET_EXECUTABLE_METHOD;

    protected LocalFile(LocalFileSystem fileSystem, String rootFile, @NotNull AbstractFileName name) {
        super(name, fileSystem);
        this.rootFile = rootFile;
    }

    protected File getLocalFile() {
        return this.file;
    }

    @Override
    protected void doAttach() throws Exception {
        if (this.file == null) {
            String fileName = this.rootFile + this.getName().getPathDecoded();
            this.file = new File(fileName);
        }
    }

    @Override
    protected FileType doGetType() {
        if (!this.file.exists()) {
            return FileType.IMAGINARY;
        }
        if (this.file.isDirectory()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    @Override
    protected String[] doListChildren() {
        return UriParser.encode(this.file.list());
    }

    @Override
    protected void doDelete() throws Exception {
        if (!this.file.delete()) {
            throw new FileSystemException("vfs.provider.local/delete-file.error", (Object)this.file);
        }
    }

    @Override
    protected void doRename(FileObject newFile) throws Exception {
        LocalFile newLocalFile = (LocalFile)FileObjectUtils.getAbstractFileObject(newFile);
        if (!this.file.renameTo(newLocalFile.getLocalFile())) {
            throw new FileSystemException("vfs.provider.local/rename-file.error", this.file.toString(), newFile.toString());
        }
    }

    @Override
    protected void doCreateFolder() throws Exception {
        if (!this.file.mkdirs()) {
            throw new FileSystemException("vfs.provider.local/create-folder.error", (Object)this.file);
        }
    }

    @Override
    protected boolean doIsWriteable() {
        return this.file.canWrite();
    }

    @Override
    protected boolean doSetWritable(boolean writable, boolean ownerOnly) {
        return this.file.setWritable(writable, ownerOnly);
    }

    @Override
    protected boolean doIsExecutable() {
        return this.file.canExecute();
    }

    @Override
    protected boolean doIsHidden() {
        return this.file.isHidden();
    }

    @Override
    protected boolean doIsReadable() {
        return this.file.canRead();
    }

    @Override
    protected boolean doSetReadable(boolean readable, boolean ownerOnly) {
        return this.file.setReadable(readable, ownerOnly);
    }

    @Override
    protected boolean doSetExecutable(boolean executable, boolean ownerOnly) {
        return this.file.setExecutable(executable, ownerOnly);
    }

    @Override
    protected long doGetLastModifiedTime() throws FileSystemException {
        try {
            return Files.getLastModifiedTime(this.file.toPath(), new LinkOption[0]).toMillis();
        }
        catch (IOException e) {
            throw new FileSystemException("vfs.provider/get-last-modified.error", (Object)this.file, (Throwable)e);
        }
    }

    @Override
    protected boolean doSetLastModifiedTime(long modtime) {
        return this.file.setLastModified(modtime);
    }

    @Override
    protected InputStream doGetInputStream(int bufferSize) throws Exception {
        return new FileInputStream(this.file);
    }

    @Override
    protected OutputStream doGetOutputStream(boolean append) throws Exception {
        OpenOption[] openOptionArray;
        Path path = this.file.toPath();
        if (append) {
            OpenOption[] openOptionArray2 = new OpenOption[2];
            openOptionArray2[0] = StandardOpenOption.CREATE;
            openOptionArray = openOptionArray2;
            openOptionArray2[1] = StandardOpenOption.APPEND;
        } else {
            OpenOption[] openOptionArray3 = new OpenOption[2];
            openOptionArray3[0] = StandardOpenOption.CREATE;
            openOptionArray = openOptionArray3;
            openOptionArray3[1] = StandardOpenOption.TRUNCATE_EXISTING;
        }
        return Files.newOutputStream(path, openOptionArray);
    }

    @Override
    protected long doGetContentSize() {
        return this.file.length();
    }

    @Override
    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode mode) throws Exception {
        return new LocalFileRandomAccessContent(this.file, mode);
    }

    @Override
    protected boolean doIsSameFile(FileObject destFile) throws FileSystemException {
        if (!FileObjectUtils.isInstanceOf(destFile, LocalFile.class)) {
            return false;
        }
        LocalFile destLocalFile = (LocalFile)FileObjectUtils.getAbstractFileObject(destFile);
        if (!this.exists() || !destLocalFile.exists()) {
            return false;
        }
        try {
            return this.file.getCanonicalPath().equals(destLocalFile.file.getCanonicalPath());
        }
        catch (IOException e) {
            throw new FileSystemException(e);
        }
    }

    @Override
    public String toString() {
        try {
            return UriParser.decode(this.getName().getURI());
        }
        catch (FileSystemException e) {
            return this.getName().getURI();
        }
    }

    @Override
    protected int doGetPermissions() throws Exception {
        if (IS_WINDOWS) {
            return super.doGetPermissions();
        }
        Set<PosixFilePermission> posixPermissions = Files.getPosixFilePermissions(this.file.toPath(), new LinkOption[0]);
        if (posixPermissions.isEmpty()) {
            return super.doGetPermissions();
        }
        int permissions = 0;
        for (PosixFilePermission permission : posixPermissions) {
            permissions += 256 >> permission.ordinal();
        }
        return permissions;
    }

    @Override
    protected boolean doSetPermissions(int mask) throws Exception {
        boolean writeByOthers;
        boolean readByOthers;
        boolean readByUser = LocalFile.test(mask, 256);
        if (!LocalFile.setPermission(this.file, IO_FILE_SET_READABLE_METHOD, readByUser, readByOthers = LocalFile.test(mask, 32) | LocalFile.test(mask, 4))) {
            return false;
        }
        boolean writeByUser = LocalFile.test(mask, 128);
        if (!LocalFile.setPermission(this.file, IO_FILE_SET_WRITABLE_METHOD, writeByUser, writeByOthers = LocalFile.test(mask, 16) | LocalFile.test(mask, 2))) {
            return false;
        }
        boolean execByUser = LocalFile.test(mask, 64);
        boolean execByOthers = LocalFile.test(mask, 8) | LocalFile.test(mask, 1);
        return LocalFile.setPermission(this.file, IO_FILE_SET_EXECUTABLE_METHOD, execByUser, execByOthers);
    }

    private static boolean setPermission(File file, Method method, boolean byUser, boolean byOthers) throws FileSystemException {
        if (byUser && byOthers) {
            return LocalFile.execute(file, method, true, true);
        }
        if (!byUser && !byOthers) {
            return LocalFile.execute(file, method, false, true);
        }
        if (byUser && !byOthers) {
            if (!LocalFile.execute(file, method, false, true)) {
                return false;
            }
            return LocalFile.execute(file, method, true, false);
        }
        if (!LocalFile.execute(file, method, true, true)) {
            return false;
        }
        return LocalFile.execute(file, method, false, false);
    }

    private static boolean execute(File file, Method method, boolean value, boolean forAll) throws FileSystemException {
        if (method != null) {
            try {
                Object[] params = new Object[]{value, forAll};
                Boolean b = (Boolean)method.invoke((Object)file, params);
                return b != null && b != false;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        throw new FileSystemException((String)null){

            @Override
            public String getMessage() {
                return "Changing mounted files permissions is not supported on Java 1.5";
            }
        };
    }

    private static boolean test(int value, int mask) {
        return (value & mask) == mask;
    }

    @Override
    protected boolean doIsSymbolicLink() throws FileSystemException {
        return Files.isSymbolicLink(this.file.toPath());
    }

    @Override
    public FileObject getLinkDestination() throws Exception {
        File canon = this.getCanon();
        return ((LocalFileSystem)this.getAbstractFileSystem()).getFileSystemManager().toFileObject(canon);
    }

    private File getCanon() throws IOException {
        File canon;
        if (this.file.getParent() == null) {
            canon = this.file;
        } else {
            File canonDir = this.file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, this.file.getName());
        }
        return canon;
    }

    static {
        Method method;
        Class[] classes;
        OS_NAME = System.getProperty("os.name");
        IS_WINDOWS = OS_NAME != null && OS_NAME.toLowerCase(Locale.US).startsWith("windows");
        try {
            classes = new Class[]{Boolean.TYPE, Boolean.TYPE};
            method = File.class.getDeclaredMethod("setWritable", classes);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        IO_FILE_SET_WRITABLE_METHOD = method;
        try {
            classes = new Class[]{Boolean.TYPE, Boolean.TYPE};
            method = File.class.getDeclaredMethod("setReadable", classes);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        IO_FILE_SET_READABLE_METHOD = method;
        try {
            classes = new Class[]{Boolean.TYPE, Boolean.TYPE};
            method = File.class.getDeclaredMethod("setExecutable", classes);
        }
        catch (NoSuchMethodException e) {
            method = null;
        }
        IO_FILE_SET_EXECUTABLE_METHOD = method;
    }
}

