/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JsonSchemaSpellcheckerClient {
    @NotNull
    protected abstract PsiElement getElement();

    @Nullable
    protected abstract String getValue();

    public boolean matchesNameFromSchema() {
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)this.getElement());
        if (file == null) {
            return false;
        }
        Project project = this.getElement().getProject();
        JsonSchemaService service = JsonSchemaService.Impl.get(project);
        if (!service.isApplicableToFile(file)) {
            return false;
        }
        JsonSchemaObject rootSchema = service.getSchemaObject(this.getElement().getContainingFile());
        if (rootSchema == null) {
            return false;
        }
        if (this.isXIntellijInjection(service, rootSchema)) {
            return true;
        }
        String value = this.getValue();
        if (StringUtil.isEmpty((String)value)) {
            return false;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(this.getElement(), rootSchema);
        if (walker == null) {
            return false;
        }
        PsiElement checkable = walker.findElementToCheck(this.getElement());
        if (checkable == null) {
            return false;
        }
        ThreeState isName = walker.isName(checkable);
        JsonPointerPosition position = walker.findPosition(checkable, isName == ThreeState.NO);
        if (position == null || position.isEmpty() && isName == ThreeState.NO) {
            return false;
        }
        Collection<JsonSchemaObject> schemas = new JsonSchemaResolver(project, rootSchema, position, walker.createValueAdapter(checkable)).resolve();
        if (schemas.isEmpty()) {
            return false;
        }
        return schemas.stream().anyMatch(s -> {
            if (s.getPropertyByName(value) != null || s.getMatchingPatternPropertySchema(value) != null) {
                return true;
            }
            return ContainerUtil.notNullize(s.getEnum()).stream().anyMatch(e -> e instanceof String && StringUtil.unquoteString((String)((String)e)).equals(value));
        });
    }

    protected boolean isXIntellijInjection(@NotNull JsonSchemaService service, @NotNull JsonSchemaObject rootSchema) {
        JsonProperty property;
        if (service == null) {
            JsonSchemaSpellcheckerClient.$$$reportNull$$$0(0);
        }
        if (rootSchema == null) {
            JsonSchemaSpellcheckerClient.$$$reportNull$$$0(1);
        }
        if (service.isSchemaFile(rootSchema) && (property = (JsonProperty)ObjectUtils.tryCast((Object)this.getElement().getParent(), JsonProperty.class)) != null) {
            PsiElement grandParent;
            PsiElement parent;
            if ("x-intellij-language-injection".equals(property.getName())) {
                return true;
            }
            if ("language".equals(property.getName()) && (parent = property.getParent()) instanceof JsonObject && (grandParent = parent.getParent()) instanceof JsonProperty && "x-intellij-language-injection".equals(((JsonProperty)grandParent).getName())) {
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "service";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "rootSchema";
                break;
            }
        }
        objectArray[1] = "com/intellij/json/JsonSchemaSpellcheckerClient";
        objectArray[2] = "isXIntellijInjection";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

