/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.model.properties;

import com.intellij.openapi.util.text.StringUtil;

public enum PgDataTypeSubCategory {
    NONE('\u0000'),
    ARRAY('A'),
    BOOLEAN('B'),
    COMPOSITE('C'),
    DATE_TIME('D'),
    ENUM('E'),
    GEOMETRIC('G'),
    NETWORK('I'),
    NUMERIC('N'),
    PSEUDO('P'),
    STRING('S'),
    TIME_SPAN('T'),
    USER_DEFINED('U'),
    BIT_STRING('V'),
    UNKNOWN('X'),
    CHAR('Z');

    public final char code;

    private PgDataTypeSubCategory(char code) {
        this.code = code;
    }

    public static PgDataTypeSubCategory of(char c) {
        return switch (Character.toUpperCase(c)) {
            case '\u0000' -> NONE;
            case 'A' -> ARRAY;
            case 'B' -> BOOLEAN;
            case 'C' -> COMPOSITE;
            case 'D' -> DATE_TIME;
            case 'E' -> ENUM;
            case 'G' -> GEOMETRIC;
            case 'I' -> NETWORK;
            case 'N' -> NUMERIC;
            case 'P' -> PSEUDO;
            case 'S' -> STRING;
            case 'T' -> TIME_SPAN;
            case 'U' -> USER_DEFINED;
            case 'V' -> BIT_STRING;
            case 'Z' -> CHAR;
            default -> UNKNOWN;
        };
    }

    public String human_readable_name() {
        return StringUtil.toLowerCase((String)this.name()).replace('_', ' ');
    }
}

