/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.diff;

import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.fragments.DiffFragmentImpl;
import com.intellij.diff.util.Range;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class DiffAlgo {
    private static final int BT_HOR = 1;
    private static final int BT_VER = 2;
    private static final int BT_DIA = 3;

    @NotNull
    public static <E> DiffIterable diff(@NotNull List<? extends E> a, @NotNull List<? extends E> b, @NotNull Comparator<? super E> comparator) {
        if (a == null) {
            DiffAlgo.$$$reportNull$$$0(0);
        }
        if (b == null) {
            DiffAlgo.$$$reportNull$$$0(1);
        }
        if (comparator == null) {
            DiffAlgo.$$$reportNull$$$0(2);
        }
        if (a.isEmpty() || b.isEmpty()) {
            DiffIterable diffIterable = DiffIterableUtil.create(Collections.singletonList(new Range(0, a.size(), 0, b.size())), (int)a.size(), (int)b.size());
            if (diffIterable == null) {
                DiffAlgo.$$$reportNull$$$0(3);
            }
            return diffIterable;
        }
        TwoDimensionalIntArray lengths = new TwoDimensionalIntArray(a.size(), b.size());
        TwoDimensionalIntArray backtrack = new TwoDimensionalIntArray(a.size(), b.size());
        for (int i = 0; i < a.size(); ++i) {
            for (int j = 0; j < b.size(); ++j) {
                int vLength;
                E y;
                E x = a.get(i);
                if (comparator.compare(x, y = b.get(j)) == 0) {
                    lengths.set(i, j, DiffAlgo.getLCSLengths(i - 1, j - 1, lengths) + 1);
                    backtrack.set(i, j, 3);
                    continue;
                }
                int hLength = DiffAlgo.getLCSLengths(i, j - 1, lengths);
                if (hLength < (vLength = DiffAlgo.getLCSLengths(i - 1, j, lengths))) {
                    lengths.set(i, j, vLength);
                    backtrack.set(i, j, 2);
                    continue;
                }
                lengths.set(i, j, hLength);
                backtrack.set(i, j, 1);
            }
        }
        ArrayList<DiffFragmentImpl> fragments = new ArrayList<DiffFragmentImpl>();
        int i = a.size() - 1;
        int j = b.size() - 1;
        while (i >= 0 || j >= 0) {
            while ((i >= 0 || j >= 0) && DiffAlgo.getLCSBacktrack(i, j, backtrack) == 3) {
                --i;
                --j;
            }
            int pi = i;
            int pj = j;
            while ((i >= 0 || j >= 0) && DiffAlgo.getLCSBacktrack(i, j, backtrack) != 3) {
                if (DiffAlgo.getLCSBacktrack(i, j, backtrack) == 1) {
                    --j;
                    continue;
                }
                --i;
            }
            if (pi == i && pj == j) continue;
            fragments.add(new DiffFragmentImpl(i + 1, pi + 1, j + 1, pj + 1));
        }
        Collections.reverse(fragments);
        DiffIterable diffIterable = DiffIterableUtil.createFragments(fragments, (int)a.size(), (int)b.size());
        if (diffIterable == null) {
            DiffAlgo.$$$reportNull$$$0(4);
        }
        return diffIterable;
    }

    private static int getLCSLengths(int i, int j, @NotNull TwoDimensionalIntArray lengths) {
        if (lengths == null) {
            DiffAlgo.$$$reportNull$$$0(5);
        }
        return i < 0 || j < 0 ? 0 : lengths.get(i, j);
    }

    private static int getLCSBacktrack(int i, int j, @NotNull TwoDimensionalIntArray backtracks) {
        if (backtracks == null) {
            DiffAlgo.$$$reportNull$$$0(6);
        }
        if (i < 0 && j < 0) {
            return 3;
        }
        if (i < 0) {
            return 1;
        }
        if (j < 0) {
            return 2;
        }
        return backtracks.get(i, j);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/diff/DiffAlgo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lengths";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backtracks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/diff/DiffAlgo";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "diff";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLCSLengths";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLCSBacktrack";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }

    private static class TwoDimensionalIntArray {
        private final int[] myData;
        private final int myColumns;

        TwoDimensionalIntArray(int n, int m) {
            this.myData = new int[n * m];
            this.myColumns = m;
        }

        public void set(int i, int j, int item) {
            this.myData[i * this.myColumns + j] = item;
        }

        public int get(int i, int j) {
            return this.myData[i * this.myColumns + j];
        }

        public int getColumns() {
            return this.myColumns;
        }

        public int getRows() {
            return this.myData.length / this.myColumns;
        }
    }
}

