/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.inspections.JSDefaultInspectionSuppressor;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSKeywordHighlighterVisitor;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.JSReferenceProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.JavaScriptAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JavaScriptFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAnalysisHandlersFactory {
    public static final LanguageExtension<JSAnalysisHandlersFactory> EP_NAME = new LanguageExtension("JavaScript.analysisHandlersFactory");
    private static final JSAnalysisHandlersFactory DEFAULT_INSTANCE = new JSAnalysisHandlersFactory();

    @NotNull
    public static JSAnalysisHandlersFactory forElement(@Nullable PsiElement element2) {
        Language dialect = element2 != null ? DialectDetector.languageOfElement((PsiElement)element2) : null;
        return JSAnalysisHandlersFactory.forLanguage(dialect);
    }

    @NotNull
    public static JSAnalysisHandlersFactory forLanguage(@Nullable Language dialect) {
        JSAnalysisHandlersFactory dialectSpecificFactory = dialect != null ? (JSAnalysisHandlersFactory)EP_NAME.forLanguage(dialect) : null;
        JSAnalysisHandlersFactory jSAnalysisHandlersFactory = dialectSpecificFactory != null ? dialectSpecificFactory : DEFAULT_INSTANCE;
        if (jSAnalysisHandlersFactory == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(0);
        }
        return jSAnalysisHandlersFactory;
    }

    @NotNull
    public JSAnnotatingVisitor createAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(2);
        }
        return new JavaScriptAnnotatingVisitor(psiElement, holder);
    }

    public JSKeywordHighlighterVisitor createKeywordHighlighterVisitor(@NotNull HighlightInfoHolder holder, @NotNull DialectOptionHolder dialectOptionHolder) {
        if (holder == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(3);
        }
        if (dialectOptionHolder == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(4);
        }
        return new JSKeywordHighlighterVisitor(holder, dialectOptionHolder);
    }

    @NotNull
    public JSReferenceChecker getReferenceChecker(@NotNull JSProblemReporter<?> reporter) {
        if (reporter == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(5);
        }
        return new JSReferenceChecker(reporter);
    }

    @NotNull
    public JSProblemReporter<Void> getProblemReporter(final ProblemsHolder holder) {
        return new JSProblemReporter<Void>(this){

            @Override
            @Nullable
            public Void registerProblem(PsiElement place, TextRange rangeWithinElement, @NotNull @InspectionMessage String message, @Nullable ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
                if (message == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (fixes == null) {
                    1.$$$reportNull$$$0(1);
                }
                TextRange range = JSAnnotatorProblemReporter.shortenTextRange(place, place.getTextRange());
                JSReferenceProblemReporter.registerFixes(place, fixes);
                if (highlightType == null) {
                    highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                }
                holder.registerProblem(place, message, highlightType, range.shiftRight(-place.getTextRange().getStartOffset()), fixes);
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fixes";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/JSAnalysisHandlersFactory$1";
                objectArray[2] = "registerProblem";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public final JSTypeChecker getTypeChecker(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(6);
        }
        JSTypeChecker jSTypeChecker = this.getTypeChecker(this.getProblemReporter(holder));
        if (jSTypeChecker == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(7);
        }
        return jSTypeChecker;
    }

    @NotNull
    public <T> JSTypeChecker getTypeChecker(@NotNull JSProblemReporter<T> problemReporter) {
        if (problemReporter == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(8);
        }
        return new JSTypeChecker(problemReporter);
    }

    @NotNull
    public final JSFunctionSignatureChecker getFunctionSignatureChecker(@NotNull ProblemsHolder holder) {
        if (holder == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(9);
        }
        JSFunctionSignatureChecker jSFunctionSignatureChecker = this.getFunctionSignatureChecker(holder, this.getTypeChecker(holder));
        if (jSFunctionSignatureChecker == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(10);
        }
        return jSFunctionSignatureChecker;
    }

    @NotNull
    public JSFunctionSignatureChecker getFunctionSignatureChecker(final @NotNull ProblemsHolder holder, @NotNull JSTypeChecker typeChecker) {
        if (holder == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(11);
        }
        if (typeChecker == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(12);
        }
        return new JavaScriptFunctionSignatureChecker(this, typeChecker){

            @Override
            protected void registerProblem(JSCallExpression callExpression, @NotNull @InspectionMessage String message, LocalQuickFix ... fixes) {
                if (message == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (fixes == null) {
                    2.$$$reportNull$$$0(1);
                }
                PsiElement place = ValidateTypesUtil.getPlaceForSignatureProblem(callExpression, callExpression.getArgumentList());
                holder.registerProblem(place, message, fixes);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "message";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fixes";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/JSAnalysisHandlersFactory$2";
                objectArray[2] = "registerProblem";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public InspectionSuppressor getInspectionSuppressor() {
        JSDefaultInspectionSuppressor jSDefaultInspectionSuppressor = JSDefaultInspectionSuppressor.INSTANCE;
        if (jSDefaultInspectionSuppressor == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(13);
        }
        return jSDefaultInspectionSuppressor;
    }

    public boolean isSemicolonRequired() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 8, 9, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSAnalysisHandlersFactory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialectOptionHolder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemReporter";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeChecker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSAnalysisHandlersFactory";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeChecker";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionSignatureChecker";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectionSuppressor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotatingVisitor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createKeywordHighlighterVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceChecker";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeChecker";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionSignatureChecker";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 8, 9, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

