/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.documentation;

import com.intellij.lang.javascript.documentation.JSDocParameterInfoBuilder;
import com.intellij.lang.javascript.documentation.JSDocSymbolInfoBuilder;
import com.intellij.lang.javascript.documentation.JSDocSymbolInfoPrinter;
import com.intellij.lang.javascript.documentation.JSDocumentationProvider;
import com.intellij.lang.javascript.documentation.JSQuickNavigateBuilder;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.types.JSParameterTypeDecoratorImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSDocParameterInfoPrinter {
    public static final String PARAMETER_NAME_SEPARATOR = " &ndash; ";
    private final PsiElement context;
    private final JSParameterItem parameterItem;
    @NotNull
    protected final JSDocParameterInfoBuilder myBuilder;

    public JSDocParameterInfoPrinter(@Nullable JSParameterItem parameter) {
        this(null, parameter, null);
    }

    public JSDocParameterInfoPrinter(@Nullable JSParameterItem parameter, @Nullable JSDocParameterInfoBuilder builder2) {
        this(null, parameter, builder2);
    }

    public JSDocParameterInfoPrinter(@Nullable PsiElement context2, @Nullable JSParameterItem parameter, @Nullable JSDocParameterInfoBuilder builder2) {
        this.context = context2;
        this.parameterItem = parameter;
        if (builder2 == null) {
            builder2 = new JSDocParameterInfoBuilder();
            builder2.optional = parameter != null && parameter.isOptional();
            boolean bl = builder2.rest = parameter != null && parameter.getTypeDecorator().isRest();
        }
        if (builder2.type == null) {
            builder2.type = parameter == null ? null : (JSType)ObjectUtils.coalesce((Object)parameter.getSimpleType(), (Object)parameter.getInferredType());
        }
        this.myBuilder = builder2;
    }

    @NotNull
    JSParameterItem getParameterItem() {
        if (this.parameterItem != null) {
            JSParameterItem jSParameterItem = this.parameterItem;
            if (jSParameterItem == null) {
                JSDocParameterInfoPrinter.$$$reportNull$$$0(0);
            }
            return jSParameterItem;
        }
        return new JSParameterTypeDecoratorImpl(null, this.myBuilder.type, this.myBuilder.optional, this.myBuilder.rest, true);
    }

    public void appendDoc(@Nullable String actualName, @NotNull JSDocSymbolInfoBuilder symbolInfo, @NotNull StringBuilder result2, @NotNull JSDocumentationProvider provider, @Nullable PsiElement place) {
        if (symbolInfo == null) {
            JSDocParameterInfoPrinter.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            JSDocParameterInfoPrinter.$$$reportNull$$$0(2);
        }
        if (provider == null) {
            JSDocParameterInfoPrinter.$$$reportNull$$$0(3);
        }
        JSQuickNavigateBuilder quickNavigateBuilder = provider.createQuickNavigateBuilder();
        JSParameterItem jSParameterItem = this.parameterItem;
        if (jSParameterItem instanceof JSFieldVariable) {
            JSFieldVariable field = (JSFieldVariable)jSParameterItem;
            result2.append(StringUtil.notNullize((String)quickNavigateBuilder.getContainerDefinition((PsiNamedElement)field)));
        }
        result2.append("<div class='definition'><pre>");
        StringBuilder options = new StringBuilder();
        JSDocSymbolInfoPrinter.addJSDocVisibilityAndAccess(this.myBuilder, options);
        if (!options.isEmpty()) {
            result2.append((CharSequence)options).append("<br>");
        }
        if (!StringUtil.isEmpty((String)symbolInfo.namespace)) {
            result2.append(symbolInfo.namespace).append('.');
        }
        if (this.parameterItem instanceof JSParameter) {
            PsiElement toUse = place == null ? (PsiElement)this.parameterItem : place;
            String navInfoResult = quickNavigateBuilder.getQuickNavigateInfoForNavigationElement((PsiElement)((JSParameter)this.parameterItem), toUse, true);
            result2.append(navInfoResult);
        } else {
            result2.append(actualName);
            if (this.myBuilder.hasType()) {
                result2.append(": ");
                result2.append(this.myBuilder.getTypeString(this.context));
            }
        }
        result2.append("</pre></div>");
        int contentStart = result2.length();
        result2.append("<div class='content'>");
        result2.append(this.getDescriptionMergedWithConfigOptions());
        if (result2.length() == contentStart + "<div class='content'>".length()) {
            result2.setLength(contentStart);
        } else {
            result2.append("</div>");
        }
    }

    public String getDescriptionMergedWithConfigOptions() {
        if (this.myBuilder.optionsMap != null) {
            StringBuilder optionsBuilder = new StringBuilder();
            optionsBuilder.append("<table class='sections'>");
            optionsBuilder.append("<tr><td valign='top' class='section'><p>");
            optionsBuilder.append("Properties").append(":");
            optionsBuilder.append("</td><td valign='top'>");
            for (Map.Entry<String, JSDocParameterInfoBuilder> field : this.myBuilder.optionsMap.entrySet()) {
                optionsBuilder.append("<p>");
                new JSDocParameterInfoPrinter(null, field.getValue()).appendOptionDescription(field.getKey(), optionsBuilder);
            }
            optionsBuilder.append("</table>");
            String description = this.myBuilder.getFinalDescription();
            int i = description.indexOf("<tr><td valign='top' class='section'><p>See also:</td><td valign='top'>");
            if (i != -1) {
                return new StringBuilder(description).insert(i, optionsBuilder).toString();
            }
            return description + String.valueOf(optionsBuilder);
        }
        return this.myBuilder.getFinalDescription();
    }

    public void appendParameterInfoInSignature(@NotNull String actualName, @NotNull StringBuilder result2) {
        if (actualName == null) {
            JSDocParameterInfoPrinter.$$$reportNull$$$0(4);
        }
        if (result2 == null) {
            JSDocParameterInfoPrinter.$$$reportNull$$$0(5);
        }
        if (this.myBuilder.rest) {
            result2.append("...");
        }
        String qName = !StringUtil.isEmpty((String)this.myBuilder.namespace) ? this.myBuilder.namespace + "." + actualName : actualName;
        result2.append(qName);
        if (this.myBuilder.optional) {
            result2.append("?");
        }
        if (this.myBuilder.hasType()) {
            result2.append(": ");
            if (this.myBuilder.type != null) {
                this.myBuilder.type = this.myBuilder.type.substitute(this.context);
            }
            result2.append(this.myBuilder.getTypeString(this.context));
            if (this.myBuilder.rest && !JSTypeUtils.isArrayLikeType((JSType)this.myBuilder.type)) {
                result2.append("[]");
            }
        }
        if (this.myBuilder.initialValue != null) {
            result2.append(" = ").append(this.myBuilder.initialValue);
        }
    }

    public boolean hasTypeElement() {
        return this.parameterItem instanceof JSParameter && ((JSParameter)this.parameterItem).getTypeElement() != null;
    }

    public void appendOptionDescription(@NotNull String name, @NotNull StringBuilder builder2) {
        if (name == null) {
            JSDocParameterInfoPrinter.$$$reportNull$$$0(6);
        }
        if (builder2 == null) {
            JSDocParameterInfoPrinter.$$$reportNull$$$0(7);
        }
        this.appendParameterInfoInSignature(name, builder2);
        builder2.append(PARAMETER_NAME_SEPARATOR);
        builder2.append(this.myBuilder.getFinalDescription());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/documentation/JSDocParameterInfoPrinter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolInfo";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterItem";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/documentation/JSDocParameterInfoPrinter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendDoc";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterInfoInSignature";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendOptionDescription";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

