/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSDeclarationsAtScopeStartInspection
extends JSInspection {
    public static final String SHORT_NAME = JSDeclarationsAtScopeStartInspection.calcShortNameFromClass(JSDeclarationsAtScopeStartInspection.class);
    public boolean myMakeSingleVarStatement;

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WEAK_WARNING;
        if (highlightDisplayLevel == null) {
            JSDeclarationsAtScopeStartInspection.$$$reportNull$$$0(0);
        }
        return highlightDisplayLevel;
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.checkbox((String)"myMakeSingleVarStatement", (String)JavaScriptBundle.message((String)"js.make.single.var.statement", (Object[])new Object[0]), (OptRegularComponent[])new OptRegularComponent[0])});
        if (optPane == null) {
            JSDeclarationsAtScopeStartInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            JSDeclarationsAtScopeStartInspection.$$$reportNull$$$0(2);
        }
        if (session == null) {
            JSDeclarationsAtScopeStartInspection.$$$reportNull$$$0(3);
        }
        return new JSElementVisitor(){

            public void visitJSVarStatement(@NotNull JSVarStatement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (node.getVarKeyword() != JSVarStatement.VarKeyword.VAR) {
                    return;
                }
                JSStatement firstStatement = JSDeclarationsAtScopeStartInspection.findContainingFunctionFirstStatement((PsiElement)node);
                if (firstStatement != null) {
                    if (!JSDeclarationsAtScopeStartInspection.this.myMakeSingleVarStatement) {
                        while (firstStatement != null && firstStatement != node && (firstStatement instanceof JSVarStatement || !(firstStatement instanceof JSStatement))) {
                            firstStatement = firstStatement.getNextSibling();
                        }
                    }
                    if (firstStatement != node) {
                        LocalQuickFix action = JSFixFactory.getInstance().jsMoveToScopeStartIntentionAction(JSDeclarationsAtScopeStartInspection.this.myMakeSingleVarStatement);
                        holder.registerProblem((PsiElement)node, JavaScriptBundle.message((String)"js.declaration.is.not.at.scope.start", (Object[])new Object[0]), new LocalQuickFix[]{action});
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/inspections/JSDeclarationsAtScopeStartInspection$1", "visitJSVarStatement"));
            }
        };
    }

    @Nullable
    public static JSStatement findContainingFunctionFirstStatement(@Nullable PsiElement element2) {
        return JSPsiImplUtils.findFirstFunctionStatement((JSFunction)((JSFunction)PsiTreeUtil.getParentOfType((PsiElement)element2, JSFunction.class, (boolean)false)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSDeclarationsAtScopeStartInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSDeclarationsAtScopeStartInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

