/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring;

import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFieldVariable;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSGetterSetterRenameUtil {
    private JSGetterSetterRenameUtil() {
    }

    public static boolean isFieldWithAccessors(@Nullable PsiElement element2) {
        if (!(element2 instanceof JSVariable)) {
            return false;
        }
        String name = ((JSVariable)element2).getName();
        PsiElement parent = JSResolveUtil.findParent((PsiElement)element2);
        if (!(parent instanceof JSClass)) {
            return false;
        }
        JSClass jsClass = (JSClass)parent;
        String accessorName = JSFormatterUtil.transformVarNameToAccessorName((String)name, (PsiElement)element2);
        return jsClass.findFunctionByNameAndKind(accessorName, JSFunction.FunctionKind.GETTER) != null || jsClass.findFunctionByNameAndKind(accessorName, JSFunction.FunctionKind.SETTER) != null;
    }

    @Nullable
    static JSFunction.FunctionKind getFunctionKindToSearch(JSFunction function) {
        JSFunction.FunctionKind toFind = null;
        if (function.isGetProperty()) {
            toFind = JSFunction.FunctionKind.SETTER;
        } else if (function.isSetProperty()) {
            toFind = JSFunction.FunctionKind.GETTER;
        }
        return toFind;
    }

    @NotNull
    public static Map<PsiElement, String> getRelatedElementsInClass(@NotNull PsiElement element2, @NotNull JSClass parent, String newName) {
        String name;
        String expectedPropertyName;
        if (element2 == null) {
            JSGetterSetterRenameUtil.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            JSGetterSetterRenameUtil.$$$reportNull$$$0(1);
        }
        HashMap<PsiElement, String> allRenames = new HashMap<PsiElement, String>();
        if (JSGetterSetterRenameUtil.isGetterSetterFunction(element2)) {
            JSFunction function = (JSFunction)element2;
            JSFunction.FunctionKind toFind = JSGetterSetterRenameUtil.getFunctionKindToSearch(function);
            if (toFind != null) {
                JSField field;
                String expectedFieldName;
                String funName = function.getName();
                JSFunction oppositePropertyFunction = parent.findFunctionByNameAndKind(funName, toFind);
                if (oppositePropertyFunction != null) {
                    allRenames.put((PsiElement)oppositePropertyFunction, newName);
                }
                if ((expectedFieldName = JSRefactoringUtil.transformAccessorNameToPropertyName(funName, element2)) != null && !expectedFieldName.equals(funName) && (field = parent.findFieldByName(expectedFieldName)) != null) {
                    allRenames.put((PsiElement)field, JSRefactoringUtil.transformAccessorNameToPropertyName(newName, (PsiElement)field));
                }
            }
        } else if (element2 instanceof JSFieldVariable && !StringUtil.equals((CharSequence)(expectedPropertyName = JSFormatterUtil.transformVarNameToAccessorName((String)(name = ((JSFieldVariable)element2).getName()), (PsiElement)element2)), (CharSequence)name)) {
            JSFunction getter = parent.findFunctionByNameAndKind(expectedPropertyName, JSFunction.FunctionKind.GETTER);
            JSFunction setter = parent.findFunctionByNameAndKind(expectedPropertyName, JSFunction.FunctionKind.SETTER);
            String accessorNewName = JSFormatterUtil.transformVarNameToAccessorName((String)newName, (PsiElement)element2);
            if (getter != null || setter != null) {
                if (!ApplicationManager.getApplication().isUnitTestMode() && !MessageDialogBuilder.yesNo((String)JavaScriptBundle.message((String)"rename.accessors.dialog.title", (Object[])new Object[0]), (String)JavaScriptBundle.message((String)"rename.accessors.dialog.text", (Object[])new Object[]{accessorNewName})).ask(element2.getProject())) {
                    HashMap<PsiElement, String> hashMap = allRenames;
                    if (hashMap == null) {
                        JSGetterSetterRenameUtil.$$$reportNull$$$0(2);
                    }
                    return hashMap;
                }
                String fieldPrefix = JSCodeStyleSettings.getSettings((PsiElement)element2).FIELD_PREFIX;
                if (!StringUtil.isEmpty((String)fieldPrefix) && !newName.startsWith(fieldPrefix)) {
                    allRenames.put(element2, fieldPrefix + newName);
                }
                if (getter != null) {
                    allRenames.put((PsiElement)getter, accessorNewName);
                }
                if (setter != null) {
                    allRenames.put((PsiElement)setter, accessorNewName);
                }
            }
        }
        HashMap<PsiElement, String> hashMap = allRenames;
        if (hashMap == null) {
            JSGetterSetterRenameUtil.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    public static boolean isGetterSetterFunction(@NotNull PsiElement element2) {
        if (element2 == null) {
            JSGetterSetterRenameUtil.$$$reportNull$$$0(4);
        }
        return element2 instanceof JSFunction && (((JSFunction)element2).isGetProperty() || ((JSFunction)element2).isSetProperty());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/JSGetterSetterRenameUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/JSGetterSetterRenameUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedElementsInClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedElementsInClass";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isGetterSetterFunction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

