/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.psi.ES6ExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.flex.XmlBackedJSClassImpl;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSCatchBlock;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExecutionScope;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSExpressionWithOperationNode;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptInterface;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptObjectType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeAlias;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSImportStatement;
import com.intellij.lang.javascript.psi.ecmal4.JSPackageStatement;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClass;
import com.intellij.lang.javascript.psi.ecmal4.XmlBackedJSClassFactory;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSParameterImpl;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSGenericTypesEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSImportHandlingUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.types.JSAnyType;
import com.intellij.lang.javascript.psi.types.JSArrayType;
import com.intellij.lang.javascript.psi.types.JSCodeBasedType;
import com.intellij.lang.javascript.psi.types.JSCompositeTypeFactory;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSResolvableType;
import com.intellij.lang.javascript.psi.types.JSResolvedTypeInfo;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeWithWidening;
import com.intellij.lang.javascript.psi.types.JSUnionOrIntersectionType;
import com.intellij.lang.javascript.psi.types.JSUnionType;
import com.intellij.lang.javascript.psi.types.evaluable.JSClassExpressionType;
import com.intellij.lang.javascript.psi.types.primitives.JSPrimitiveType;
import com.intellij.lang.javascript.psi.types.primitives.JSVoidType;
import com.intellij.lang.javascript.psi.types.typescript.TypeScriptCompilerType;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.html.HtmlFileImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageEditorUtil;
import com.intellij.psi.impl.source.xml.XmlTextImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCreateFix
extends FixAndIntentionAction
implements HighPriorityAction {
    private static final String SCRIPT_TAG_NAME = "Script";
    protected boolean myIsProperty;
    private static final Function<PsiElement, Boolean> ourFilter = psiElement -> BaseCreateFix.toSkipElement(psiElement);
    private static final Function<PsiElement, Boolean> ourEnumFilter = psiElement -> psiElement instanceof PsiComment;
    private static final Function<PsiElement, Boolean> ourObjectLiteralFieldLikeFilter = psiElement -> psiElement instanceof PsiComment || psiElement.getNode().getElementType() == JSTokenTypes.COMMA || psiElement instanceof JSProperty && ((JSProperty)psiElement).tryGetFunctionInitializer() == null;
    private static final TokenSet LBRACE_LIKE_TOKENS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.LBRACE, JSTokenTypes.LBRACE_OR});
    private int uniqueCounter;

    @Override
    protected void applyFix(Project project, PsiElement psiElement, @NotNull PsiFile file, @Nullable Editor editor) {
        if (file == null) {
            BaseCreateFix.$$$reportNull$$$0(0);
        }
        this.doApplyFix(project, psiElement, file, editor);
    }

    protected final void doApplyFix(Project project, PsiElement psiElement, PsiFile file, Editor editor) {
        JSTypeEvaluationLocationProvider.withTypeEvaluationLocation((PsiElement)psiElement, () -> this.doApplyFix(project, psiElement, file, editor, null, null));
    }

    protected boolean isExportWithoutFrom() {
        PsiElement element2 = this.myElementPointer == null ? null : this.myElementPointer.getElement();
        return BaseCreateFix.isExportWithoutFrom(element2);
    }

    protected boolean isExportDefault() {
        PsiElement element2 = this.myElementPointer == null ? null : this.myElementPointer.getElement();
        return element2 instanceof ES6ImportedBinding;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static boolean isExportWithoutFrom(PsiElement element2) {
        return element2 instanceof ES6ExportSpecifier && ES6PsiUtil.computeFromFileForImportExport((PsiElement)element2) == element2.getContainingFile();
    }

    protected final void doApplyFix(Project project, @NotNull PsiElement psiElement, @NotNull PsiFile file, @Nullable Editor editor, @Nullable PsiElement predefinedAnchor, @Nullable PsiElement predefinedScope) {
        JSExpression qualifier;
        if (psiElement == null) {
            BaseCreateFix.$$$reportNull$$$0(1);
        }
        if (file == null) {
            BaseCreateFix.$$$reportNull$$$0(2);
        }
        Pair<@Nullable JSReferenceExpression, @Nullable PsiElement> anchor = this.calculateAnchors(psiElement);
        JSReferenceExpression referenceExpression = (JSReferenceExpression)anchor.first;
        PsiElement nodeForAnchor = (PsiElement)anchor.second;
        boolean isStrictAnchor = false;
        PsiFile realFile = file;
        if (file.getContext() != null) {
            realFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)file);
            editor = editor == null ? null : InjectedLanguageEditorUtil.getTopLevelEditor((Editor)editor);
        }
        this.assertValidContext(psiElement, referenceExpression);
        JSExpression jSExpression = qualifier = referenceExpression == null ? null : referenceExpression.getQualifier();
        if (qualifier != null || psiElement instanceof XmlAttribute || psiElement instanceof ES6ImportExportSpecifier || psiElement instanceof ES6ImportedBinding) {
            PsiElement type2;
            if (psiElement instanceof XmlAttribute) {
                XmlTag tag = (XmlTag)psiElement.getParent();
                XmlElementDescriptor descriptor = tag.getDescriptor();
                type2 = descriptor == null ? null : descriptor.getDeclaration();
            } else if (psiElement instanceof ES6ImportExportSpecifier || psiElement instanceof ES6ImportedBinding) {
                PsiElement fileFromSpecifier = ES6PsiUtil.computeFromFileForImportExport((PsiElement)psiElement);
                if (fileFromSpecifier == null) {
                    return;
                }
                type2 = fileFromSpecifier.getContainingFile();
            } else {
                type2 = BaseCreateFix.getScope(qualifier, file);
            }
            if (type2 == null && DialectDetector.isActionScript((PsiElement)file)) {
                return;
            }
            if (type2 != null) {
                if (type2 instanceof XmlBackedJSClass) {
                    type2 = type2.getParent().getContainingFile();
                }
                editor = null;
                if (type2 instanceof JSClass || type2 instanceof TypeScriptObjectType || type2 instanceof TypeScriptModule || type2 instanceof JSObjectLiteralExpression) {
                    realFile = file = type2.getContainingFile();
                    predefinedScope = type2 instanceof TypeScriptInterface ? ((TypeScriptInterface)type2).getBody() : type2;
                    predefinedAnchor = BaseCreateFix.findInsertionAnchorForScope(type2, this.isIntroducingVariable());
                } else if (type2 instanceof JSFile) {
                    realFile = file = (JSFile)type2;
                    predefinedAnchor = null;
                    nodeForAnchor = file;
                    predefinedScope = file;
                } else if (type2 instanceof XmlFile) {
                    realFile = file = type2.getContainingFile();
                    predefinedAnchor = type2;
                }
            } else {
                JSReferenceExpression qualifierToResolve;
                PsiElement declaration = null;
                JSReferenceExpression jSReferenceExpression = qualifierToResolve = qualifier instanceof JSReferenceExpression ? (JSReferenceExpression)qualifier : (JSReferenceExpression)PsiTreeUtil.findChildOfType((PsiElement)qualifier, JSReferenceExpression.class);
                if (qualifierToResolve != null) {
                    declaration = qualifierToResolve.resolve();
                }
                if (declaration instanceof JSVariable && this.isIntroducingVariable() && declaration.getContainingFile() == qualifierToResolve.getContainingFile()) {
                    predefinedScope = PsiTreeUtil.getParentOfType((PsiElement)declaration, JSExecutionScope.class);
                    predefinedAnchor = BaseCreateFix.getVariableDeclarationAnchor(declaration);
                    if (predefinedScope != null && predefinedAnchor != null) {
                        isStrictAnchor = true;
                    }
                }
            }
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(realFile)) {
            return;
        }
        if (editor == null) {
            editor = BaseCreateFix.getEditor(project, realFile);
        }
        if (editor == null) {
            return;
        }
        boolean canHaveClasses = JSClassUtils.canHaveClasses((PsiElement)((PsiElement)ObjectUtils.coalesce((Object)referenceExpression, (Object)file)));
        boolean isClassTypeOrObjectMember = psiElement instanceof XmlAttribute || this.produceDeclarationInScope(predefinedAnchor == null ? psiElement : predefinedAnchor);
        PsiElement initialAnchor = this.calculateInitialAnchor(predefinedAnchor, nodeForAnchor);
        if (initialAnchor == null) {
            return;
        }
        PsiElement scope2 = BaseCreateFix.getInsertionScope(predefinedScope, initialAnchor, isClassTypeOrObjectMember, this.skipParentIfClass());
        if (!isStrictAnchor) {
            initialAnchor = PsiTreeUtil.findFirstParent((PsiElement)initialAnchor, el -> el.getParent() == scope2 || el == scope2);
        }
        InsertPlaceInfo insertPlaceInfo = new InsertPlaceInfo(initialAnchor, realFile, isClassTypeOrObjectMember, this.isIntroducingVariable());
        if (insertPlaceInfo.anchor != null) {
            boolean isStatic = canHaveClasses && BaseCreateFix.isStatic(psiElement, qualifier);
            referenceExpression = this.beforeStartTemplateAction(referenceExpression, editor, insertPlaceInfo.anchor, isStatic);
            TemplateManager templateManager = TemplateManager.getInstance((Project)project);
            Template template = templateManager.createTemplate("", "");
            template.setToReformat(true);
            if (insertPlaceInfo.addNewLineBefore) {
                template.addTextSegment("\n");
            }
            PsiElement anchorParent = (PsiElement)ObjectUtils.coalesce((Object)scope2, (Object)insertPlaceInfo.anchor);
            PsiUtilCore.ensureValid((PsiElement)anchorParent);
            this.buildTemplate(template, referenceExpression, isStatic, anchorParent);
            if (scope2 instanceof JSObjectLiteralExpression) {
                JSProperty nextProperty;
                JSProperty jSProperty = nextProperty = insertPlaceInfo.anchor instanceof JSProperty && !insertPlaceInfo.insertAtEnd ? (JSProperty)insertPlaceInfo.anchor : (JSProperty)PsiTreeUtil.getNextSiblingOfType((PsiElement)insertPlaceInfo.anchor, JSProperty.class);
                if (nextProperty != null) {
                    template.addTextSegment(",");
                }
            }
            if (insertPlaceInfo.toInsertNewLineAfter) {
                template.addTextSegment("\n");
            }
            int offset = BaseCreateFix.calculateOffset(file, realFile, insertPlaceInfo);
            BaseCreateFix.navigate(project, editor, offset, realFile.getVirtualFile());
            templateManager.startTemplate(editor, template);
        }
    }

    @Nullable
    protected PsiElement calculateInitialAnchor(@Nullable PsiElement predefinedAnchor, @Nullable PsiElement nodeForAnchor) {
        return (PsiElement)ObjectUtils.coalesce((Object)predefinedAnchor, (Object)JSUtils.findStatementAnchor((PsiElement)nodeForAnchor), (Object)nodeForAnchor);
    }

    protected void assertValidContext(@NotNull PsiElement psiElement, @Nullable JSReferenceExpression referenceExpression) {
        if (psiElement == null) {
            BaseCreateFix.$$$reportNull$$$0(3);
        }
        assert (psiElement instanceof XmlAttribute || referenceExpression != null || psiElement instanceof ES6ImportExportSpecifier || psiElement instanceof ES6ImportedBinding || psiElement instanceof JSArgumentList);
    }

    @Nullable
    private static PsiElement getVariableDeclarationAnchor(@NotNull PsiElement declaration) {
        if (declaration == null) {
            BaseCreateFix.$$$reportNull$$$0(4);
        }
        if (!(declaration instanceof JSVariable)) {
            return null;
        }
        if (declaration instanceof JSParameter) {
            JSStatement body;
            JSStatement statement = null;
            JSElement scope2 = JSParameterImpl.getOwner((JSParameterListElement)((JSParameter)declaration));
            if (scope2 instanceof JSFunction) {
                statement = JSPsiImplUtils.findFirstFunctionStatement((JSFunction)((JSFunction)scope2));
            } else if (scope2 instanceof JSCatchBlock && (body = ((JSCatchBlock)scope2).getStatement()) instanceof JSBlockStatement) {
                statement = JSPsiImplUtils.findFirstStatement((PsiElement)body);
            }
            return statement;
        }
        PsiElement statementAnchor = JSUtils.findStatementAnchor((PsiElement)declaration);
        return PsiTreeUtil.skipMatching((PsiElement)statementAnchor, element2 -> element2.getNextSibling(), element2 -> element2 instanceof PsiWhiteSpace && !element2.textContains('\n') || element2 instanceof PsiComment);
    }

    protected boolean skipParentIfClass() {
        return true;
    }

    @Nullable
    private static PsiElement getInsertionScope(@Nullable PsiElement predefinedScope, @NotNull PsiElement initialAnchor, boolean isFieldLevel, boolean skipParentIfClass) {
        if (initialAnchor == null) {
            BaseCreateFix.$$$reportNull$$$0(5);
        }
        if (predefinedScope != null) {
            return predefinedScope;
        }
        if (isFieldLevel) {
            return PsiTreeUtil.getParentOfType((PsiElement)initialAnchor, (Class[])new Class[]{JSClass.class, TypeScriptObjectType.class, JSFile.class, TypeScriptModule.class});
        }
        PsiElement parent = initialAnchor.getParent();
        return skipParentIfClass && parent instanceof JSClass ? parent.getParent() : parent;
    }

    @Nullable
    protected JSReferenceExpression beforeStartTemplateAction(@Nullable JSReferenceExpression referenceExpression, @NotNull Editor editor, @NotNull PsiElement anchor, boolean isStaticContext) {
        if (editor == null) {
            BaseCreateFix.$$$reportNull$$$0(6);
        }
        if (anchor == null) {
            BaseCreateFix.$$$reportNull$$$0(7);
        }
        return referenceExpression;
    }

    private static boolean isStatic(PsiElement psiElement, JSExpression qualifier) {
        if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, ES6Decorator.class) != null) {
            return true;
        }
        if (qualifier != null) {
            if (qualifier instanceof JSReferenceExpression) {
                PsiElement qualifierResolve = ((JSReferenceExpression)qualifier).resolve();
                PsiElement target = qualifierResolve != null ? JSStubBasedPsiTreeUtil.calculateMeaningfulElement((PsiElement)qualifierResolve) : null;
                return target instanceof JSClass && !(target instanceof TypeScriptEnum) || target instanceof XmlFile;
            }
            if (qualifier instanceof JSThisExpression && JSClassUtils.isES6ClassImplementation((PsiElement)psiElement)) {
                return JSResolveUtil.calculateStaticFromContext((PsiElement)psiElement);
            }
            return false;
        }
        return JSResolveUtil.calculateStaticFromContext((PsiElement)psiElement);
    }

    private static int calculateOffset(PsiFile file, PsiFile realFile, InsertPlaceInfo insertPlaceInfo) {
        int offset;
        TextRange anchorRange = insertPlaceInfo.anchor.getTextRange();
        int n = offset = insertPlaceInfo.insertAtEnd ? anchorRange.getEndOffset() : anchorRange.getStartOffset();
        if (file != realFile || file instanceof XmlFile) {
            PsiFile anchorContainingFile = insertPlaceInfo.anchor.getContainingFile();
            PsiElement anchorFileContext = anchorContainingFile.getContext();
            if (anchorFileContext != null) {
                if (anchorFileContext instanceof XmlText) {
                    if (insertPlaceInfo.cdataStartOffset != 0) {
                        offset += insertPlaceInfo.cdataStartOffset;
                    } else {
                        int cdataOffset = 0;
                        if (anchorFileContext instanceof XmlTextImpl) {
                            XmlTextImpl containingText = (XmlTextImpl)anchorFileContext;
                            if (anchorFileContext.getText().contains("<![CDATA[")) {
                                cdataOffset = containingText.getCDATAInterior().getStartOffset() - "<![CDATA[".length();
                            }
                        }
                        offset += ((XmlText)anchorFileContext).displayToPhysical(cdataOffset);
                    }
                }
                offset += anchorFileContext.getTextOffset();
            } else if (insertPlaceInfo.cdataStartOffset != 0) {
                offset = insertPlaceInfo.cdataStartOffset;
            }
        } else if (insertPlaceInfo.anchor instanceof JSFile) {
            JSSourceElement[] statements = ((JSFile)insertPlaceInfo.anchor).getStatements();
            JSSourceElement lastImport = null;
            for (JSSourceElement element2 : statements) {
                if (!(element2 instanceof ES6ImportDeclaration)) break;
                lastImport = element2;
            }
            if (lastImport != null) {
                offset = lastImport.getTextRange().getEndOffset();
            }
        }
        return offset;
    }

    protected boolean produceDeclarationInScope(PsiElement element2) {
        JSElement scope2 = (JSElement)PsiTreeUtil.getParentOfType((PsiElement)element2, (Class[])new Class[]{JSPackageStatement.class, JSClass.class, TypeScriptObjectType.class, JSObjectLiteralExpression.class});
        if (DialectDetector.isActionScript((PsiElement)element2)) {
            return !(scope2 instanceof JSPackageStatement);
        }
        return scope2 != null;
    }

    protected @NotNull Pair<@Nullable JSReferenceExpression, @Nullable PsiElement> calculateAnchors(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            BaseCreateFix.$$$reportNull$$$0(8);
        }
        JSReferenceExpression expression = (JSReferenceExpression)PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])new Class[]{JSReferenceExpression.class});
        return new Pair((Object)expression, (Object)expression);
    }

    public static void navigate(@NotNull Project project, @NotNull Editor editor, int offset, VirtualFile vfile) {
        if (project == null) {
            BaseCreateFix.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            BaseCreateFix.$$$reportNull$$$0(10);
        }
        editor.getCaretModel().moveToOffset(offset);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    protected static PsiElement findInsertionAnchorForScope(PsiElement jsClass, boolean isFieldOrVariable) {
        PsiElement element2;
        PsiElement candidate;
        ASTNode next;
        ASTNode node;
        PsiElement elementContainer = jsClass;
        if (jsClass instanceof TypeScriptInterface && DialectDetector.isTypeScript((PsiElement)jsClass)) {
            elementContainer = ((TypeScriptInterface)jsClass).getBody();
        }
        if (isFieldOrVariable && (node = elementContainer.getNode().findChildByType(LBRACE_LIKE_TOKENS)) != null && (next = node.getTreeNext()) != null && (candidate = JSChangeUtil.findInsertionPlaceStartingFrom((PsiElement)(element2 = next.getPsi()), (boolean)false, elementContainer instanceof JSObjectLiteralExpression ? ourObjectLiteralFieldLikeFilter : (elementContainer instanceof TypeScriptEnum ? ourEnumFilter : ourFilter))) != null) {
            return candidate;
        }
        return elementContainer.getLastChild().getPrevSibling();
    }

    private static boolean doesNotContainNewline(PsiElement nextLeaf) {
        return !(nextLeaf instanceof PsiWhiteSpace) && !(nextLeaf instanceof XmlToken) || nextLeaf.getText().indexOf(10) == -1;
    }

    protected boolean isIntroducingVariable() {
        return false;
    }

    private static PsiElement findInsertionPlaceBackward(PsiElement anchor) {
        ASTNode node;
        PsiElement anchorPrevSibling;
        while (!((anchorPrevSibling = anchor.getPrevSibling()) == null || anchorPrevSibling instanceof JSVarStatement || anchorPrevSibling instanceof JSImportStatement || anchorPrevSibling instanceof JSProperty || anchor instanceof PsiWhiteSpace && anchor.getText().contains("\n") && anchorPrevSibling instanceof PsiComment || (node = anchorPrevSibling.getNode()) != null && (LBRACE_LIKE_TOKENS.contains(node.getElementType()) || node.getElementType() == JSTokenTypes.COMMA))) {
            anchor = anchorPrevSibling;
        }
        return anchor;
    }

    private static boolean toSkipElement(PsiElement nextSibling) {
        return nextSibling instanceof PsiComment || nextSibling instanceof JSImportStatement || nextSibling instanceof JSVarStatement;
    }

    @Nullable
    public static Editor getEditor(@NotNull Project project, @NotNull PsiFile realFile) {
        if (project == null) {
            BaseCreateFix.$$$reportNull$$$0(11);
        }
        if (realFile == null) {
            BaseCreateFix.$$$reportNull$$$0(12);
        }
        return FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, realFile.getVirtualFile(), 0), true);
    }

    protected abstract void buildTemplate(Template var1, @Nullable JSReferenceExpression var2, boolean var3, @NotNull PsiElement var4);

    @Nullable
    public static PsiElement resolveScopeFromQualifier(@NotNull JSReferenceExpression qualifier) {
        PsiElement resolvedElement;
        if (qualifier == null) {
            BaseCreateFix.$$$reportNull$$$0(13);
        }
        if ((resolvedElement = qualifier.resolve()) != null) {
            PsiElement meaningfulElement = JSStubBasedPsiTreeUtil.calculateMeaningfulElement((PsiElement)resolvedElement);
            if (meaningfulElement instanceof JSInitializerOwner) {
                meaningfulElement = ((JSInitializerOwner)meaningfulElement).getInitializer();
            }
            return meaningfulElement instanceof JSObjectLiteralExpression || meaningfulElement instanceof JSClass || meaningfulElement instanceof TypeScriptModule || meaningfulElement instanceof JSFile ? meaningfulElement : null;
        }
        return null;
    }

    public static PsiElement getScope(JSExpression qualifier, PsiFile file) {
        PsiElement sourceElement;
        JSType originalType;
        if (qualifier instanceof JSThisExpression) {
            PsiElement result2 = ((JSThisExpression)qualifier).resolve();
            if (result2 instanceof JSClass) {
                return result2;
            }
            if (result2 instanceof JSInitializerOwner) {
                result2 = ((JSInitializerOwner)result2).getInitializer();
            }
            if (result2 instanceof JSObjectLiteralExpression) {
                return result2;
            }
        }
        JSType type2 = originalType = JSResolveUtil.getExpressionJSType((JSExpression)qualifier);
        PsiElement source = BaseCreateFix.getAcceptableSource(type2);
        if ((type2 = JSTypeUtils.getValuableType((JSType)type2, (PsiElement)qualifier)) instanceof JSGenericTypeImpl) {
            type2 = ((JSGenericTypeImpl)type2).getType();
        }
        type2 = JSTypeUtils.unwrapType((JSType)type2);
        if (source == null) {
            source = BaseCreateFix.getAcceptableSource(type2);
        }
        if (type2 != null && !BaseCreateFix.isAcceptableScope(source)) {
            source = JSClassResolver.findClassFromNamespace((String)type2.getResolvedTypeText(), (PsiElement)file);
        }
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)file);
        if (type2 == null && dialect != null && !dialect.isECMA4 && qualifier instanceof JSReferenceExpression) {
            return BaseCreateFix.resolveScopeFromQualifier((JSReferenceExpression)qualifier);
        }
        if (type2 instanceof JSRecordType && BaseCreateFix.isAcceptableScope(sourceElement = type2.getSourceElement())) {
            return sourceElement;
        }
        if (type2 != null && source == null && dialect != null && dialect.isTypeScript && type2 instanceof JSResolvableType) {
            JSResolvedTypeInfo info = ((JSResolvableType)type2).resolveType();
            JSClass classDeclaration = (JSClass)info.getDeclarationOfType(JSClass.class);
            if (classDeclaration != null) {
                return classDeclaration;
            }
            TypeScriptModule module = (TypeScriptModule)info.getDeclarationOfType(TypeScriptModule.class);
            if (module != null) {
                return module;
            }
            return null;
        }
        if (source == null && qualifier instanceof JSReferenceExpression) {
            JSReferenceExpression referenceExpression = (JSReferenceExpression)qualifier;
            source = BaseCreateFix.findSourceFromReferenceExpression(referenceExpression, originalType, type2);
        }
        return source;
    }

    @Nullable
    private static PsiElement getAcceptableSource(@Nullable JSType type2) {
        if (type2 == null) {
            return null;
        }
        PsiElement typeSource = type2.getSourceElement();
        if ((type2 instanceof JSClassExpressionType || type2 instanceof JSTypeImpl || type2 instanceof JSCodeBasedType) && BaseCreateFix.isAcceptableScope(typeSource)) {
            return typeSource;
        }
        return null;
    }

    private static boolean isAcceptableScope(@Nullable PsiElement sourceElement) {
        return sourceElement instanceof JSClass || sourceElement instanceof TypeScriptObjectType || sourceElement instanceof JSObjectLiteralExpression || sourceElement instanceof XmlFile || sourceElement instanceof JSFile || sourceElement instanceof TypeScriptModule && !(sourceElement instanceof TypeScriptImplicitModule);
    }

    @Nullable
    private static PsiElement findSourceFromReferenceExpression(@NotNull JSReferenceExpression referenceExpression, @Nullable JSType originalType, @Nullable JSType type2) {
        JSTypeDeclarationOwner typeDeclarationOwner;
        PsiElement typeElement;
        JSRecordType recordType;
        boolean isEmptyRecordType;
        if (referenceExpression == null) {
            BaseCreateFix.$$$reportNull$$$0(14);
        }
        PsiElement resolve2 = referenceExpression.resolve();
        boolean bl = isEmptyRecordType = originalType instanceof TypeScriptCompilerType && type2 instanceof JSRecordType && (recordType = (JSRecordType)type2).getTypeMembers().isEmpty();
        if (isEmptyRecordType && resolve2 instanceof JSTypeDeclarationOwner && BaseCreateFix.isAcceptableScope(typeElement = (typeDeclarationOwner = (JSTypeDeclarationOwner)resolve2).getTypeElement())) {
            return typeElement;
        }
        if (resolve2 instanceof TypeScriptModule && originalType instanceof JSAnyType && BaseCreateFix.isAcceptableScope(resolve2)) {
            return resolve2;
        }
        return null;
    }

    protected void addAccessModifier(Template template, @NotNull JSReferenceExpression referenceExpression, boolean staticContext, @NotNull JSClass targetClass) {
        if (referenceExpression == null) {
            BaseCreateFix.$$$reportNull$$$0(15);
        }
        if (targetClass == null) {
            BaseCreateFix.$$$reportNull$$$0(16);
        }
        boolean isConstructor = referenceExpression.getParent() instanceof JSNewExpression;
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)targetClass);
        if (DialectDetector.hasFeature((DialectOptionHolder)dialect, (JSLanguageFeature)JSLanguageFeature.VISIBILITY_MODIFIERS)) {
            JSClass classOfContextRef = JSResolveUtil.getClassOfContext((PsiElement)referenceExpression);
            if (!isConstructor && targetClass.isEquivalentTo((PsiElement)classOfContextRef)) {
                if (!JSUtils.isPrivateNameReference((PsiElement)referenceExpression)) {
                    template.addTextSegment("private ");
                }
            } else if (dialect.isECMA4) {
                if (!targetClass.isInterface()) {
                    JSAttributeList attributeList = targetClass.getAttributeList();
                    if (attributeList != null && attributeList.getAccessType() == JSAttributeList.AccessType.PUBLIC || classOfContextRef != null && JSPsiImplUtils.differentPackageName((String)JSResolveUtil.getPackageName((PsiElement)targetClass), (String)JSResolveUtil.getPackageName((PsiElement)classOfContextRef))) {
                        template.addTextSegment("public ");
                    } else {
                        template.addTextSegment("internal ");
                    }
                }
            } else if (dialect.isTypeScript && !targetClass.isInterface() && !(targetClass instanceof TypeScriptEnum) && TypeScriptCodeStyleSettings.getTypeScriptSettings((PsiElement)targetClass).USE_PUBLIC_MODIFIER) {
                template.addTextSegment("public ");
            }
        }
        if (staticContext) {
            template.addTextSegment("static ");
        }
    }

    protected void addCompletionVar(Template template) {
        MacroCallNode paramTypeExpr = new MacroCallNode(MacroFactory.createMacro((String)"complete"));
        template.addVariable("__Type" + this.uniqueCounter++, (Expression)paramTypeExpr, (Expression)paramTypeExpr, true);
    }

    protected void addSemicolonSegment(Template template, PsiElement context2) {
        String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)context2);
        if (!semicolon.isEmpty()) {
            template.addTextSegment(semicolon);
        }
    }

    public static void addTypeVariable(Template template, String var, PsiElement context2, String typeName) {
        String type2 = (String)WriteAction.compute(() -> (String)ImportUtils.importAndShortenReference((String)typeName, (PsiElement)context2, (boolean)true, (boolean)true).first);
        ConstantNode paramTypeExpr = new ConstantNode(type2);
        template.addVariable(var + "Type", (Expression)paramTypeExpr, (Expression)paramTypeExpr, true);
    }

    protected void guessTypeAndAddTemplateVariable(Template template, JSExpression referenceExpression, PsiElement context2, boolean voidAllowed) {
        List<String> types2 = BaseCreateFix.guessTypesForExpression(referenceExpression, context2, voidAllowed);
        if (types2.isEmpty()) {
            this.addCompletionVar(template);
        } else {
            ConstantNode expression = types2.size() == 1 ? new ConstantNode(types2.get(0)) : new ConstantNode((Result)null).withLookupStrings(types2);
            template.addVariable("__type" + referenceExpression.getText(), (Expression)expression, (Expression)expression, true);
        }
    }

    @NotNull
    public static JSType findExpressionContextualType(@NotNull JSExpression expression) {
        JSExpression lOperand;
        if (expression == null) {
            BaseCreateFix.$$$reportNull$$$0(17);
        }
        if (!DialectDetector.isTypeScript((PsiElement)expression)) {
            JSAnyType jSAnyType = JSAnyType.get((PsiElement)expression);
            if (jSAnyType == null) {
                BaseCreateFix.$$$reportNull$$$0(18);
            }
            return jSAnyType;
        }
        PsiElement parent = expression.getParent();
        if (parent instanceof JSExpression || parent instanceof JSProperty) {
            JSType expectedType;
            JSType jSType = expectedType = parent instanceof JSExpression ? JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)((JSExpression)parent)) : JSDialectSpecificHandlersFactory.findExpectedType((JSProperty)((JSProperty)parent), (JSExpectedTypeKind)JSExpectedTypeKind.EXPECTED);
            if (expectedType != null && !JSTypeUtils.isAnyType((JSType)expectedType) && !(expectedType instanceof JSVoidType)) {
                JSType jSType2 = expectedType;
                if (jSType2 == null) {
                    BaseCreateFix.$$$reportNull$$$0(19);
                }
                return jSType2;
            }
        }
        boolean isCall = false;
        if (parent instanceof JSCallExpression) {
            isCall = true;
            parent = parent.getParent();
        }
        JSType type2 = null;
        if (parent instanceof JSReturnStatement) {
            JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)expression, JSFunction.class);
            if (fun != null) {
                type2 = fun.getReturnType();
            }
        } else if (parent instanceof JSVariable) {
            type2 = ((JSVariable)parent).getJSType();
        } else if (parent instanceof JSArgumentList) {
            JSParameterItem parameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)(isCall ? (JSExpression)expression.getParent() : expression), (JSArgumentList)((JSArgumentList)parent));
            if (parameter instanceof JSParameter && !parameter.isRest()) {
                type2 = ((JSParameter)parameter).getJSType();
            }
        } else if (parent instanceof JSAssignmentExpression && (lOperand = ((JSAssignmentExpression)parent).getLOperand()) != null) {
            type2 = JSResolveUtil.getExpressionJSType((JSExpression)lOperand);
        }
        Object object = type2 != null ? type2 : JSAnyType.get((PsiElement)expression);
        if (object == null) {
            BaseCreateFix.$$$reportNull$$$0(20);
        }
        return object;
    }

    @Nullable
    public static String guessTypeForExpression(JSExpression referenceExpression, PsiElement context2, boolean voidAllowed) {
        List<String> result2 = BaseCreateFix.guessTypesForExpression(referenceExpression, context2, voidAllowed);
        return result2.size() == 1 ? result2.get(0) : null;
    }

    @NotNull
    public static List<String> guessTypesForExpression(JSExpression referenceExpression, PsiElement context2, boolean voidAllowed) {
        JSPostfixExpression postfixExpr;
        JSPrefixExpression prefixExpr;
        PsiElement parent = referenceExpression.getParent();
        boolean isCall = false;
        if (parent instanceof JSCallExpression) {
            isCall = true;
            parent = parent.getParent();
        }
        List<String> types2 = null;
        String type2 = null;
        JSExpression elementForWhichExprTypeToEvaluate = null;
        if (parent instanceof JSDefinitionExpression) {
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof JSAssignmentExpression) {
                elementForWhichExprTypeToEvaluate = ((JSAssignmentExpression)grandParent).getROperand();
            }
        } else if (parent instanceof JSReturnStatement) {
            JSFunction fun = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)referenceExpression, JSFunction.class);
            if (fun != null) {
                JSType returnType2 = fun.getReturnType();
                type2 = BaseCreateFix.isNamedType(returnType2) && !(returnType2 instanceof JSPrimitiveType) ? JSImportHandlingUtil.resolveTypeName((String)JSTypeUtils.getTypeMatchingNamespace((Project)fun.getProject(), (String)returnType2.getTypeText()), (PsiElement)fun) : (returnType2 == null ? null : returnType2.getTypeText(JSType.TypeTextFormat.CODE));
            }
        } else if (parent instanceof JSExpressionStatement && voidAllowed) {
            type2 = "void";
        } else if (parent instanceof JSVariable) {
            JSVariable variable = (JSVariable)parent;
            types2 = BaseCreateFix.getPossibleTypesText(parent, variable.getJSType());
        } else if (parent instanceof JSArgumentList) {
            JSParameterItem parameter = JSResolveUtil.findParameterForUsedArgument((JSExpression)(isCall ? (JSExpression)referenceExpression.getParent() : referenceExpression), (JSArgumentList)((JSArgumentList)parent));
            if (parameter instanceof JSParameter) {
                JSParameter jsParameter = (JSParameter)parameter;
                if (!parameter.isRest()) {
                    JSType parameterType = JSGenericTypesEvaluator.getEvaluator((PsiElement)referenceExpression).evaluateGenerics(jsParameter.getJSType(), ((JSCallExpression)parent.getParent()).getMethodExpression(), (PsiElement)jsParameter.getDeclaringFunction());
                    types2 = BaseCreateFix.getPossibleTypesText((PsiElement)jsParameter, parameterType != null ? parameterType : jsParameter.getJSType());
                }
            }
        } else if (parent instanceof JSAssignmentExpression) {
            JSExpression lOperand = ((JSAssignmentExpression)parent).getLOperand();
            if (lOperand != null) {
                JSType jsType = JSResolveUtil.getExpressionJSType((JSExpression)lOperand);
                type2 = jsType == null ? null : BaseCreateFix.getTypeText(jsType, context2);
            }
        } else if (parent instanceof JSPrefixExpression && BaseCreateFix.isPlusPlusOrMinusMinusOperation((JSExpressionWithOperationNode)(prefixExpr = (JSPrefixExpression)parent))) {
            type2 = BaseCreateFix.getNumberTypeForPrefixSuffixIncrement(context2, type2, prefixExpr.getOperationSign());
        } else if (parent instanceof JSPostfixExpression && BaseCreateFix.isPlusPlusOrMinusMinusOperation((JSExpressionWithOperationNode)(postfixExpr = (JSPostfixExpression)parent))) {
            type2 = BaseCreateFix.getNumberTypeForPrefixSuffixIncrement(context2, type2, postfixExpr.getOperationSign());
        } else if (parent instanceof JSBinaryExpression) {
            JSBinaryExpression binOp = (JSBinaryExpression)parent;
            elementForWhichExprTypeToEvaluate = binOp.getLOperand() == referenceExpression ? binOp.getROperand() : binOp.getLOperand();
        } else if (referenceExpression instanceof JSReferenceExpression || parent instanceof JSProperty) {
            JSExpression parentExpression;
            PsiElement psiElement = referenceExpression.getParent();
            JSType expectedType = JSDialectSpecificHandlersFactory.findExpectedType((JSExpression)(psiElement instanceof JSExpression ? (parentExpression = (JSExpression)psiElement) : referenceExpression));
            if (expectedType != null && (voidAllowed || !(expectedType instanceof JSVoidType))) {
                type2 = BaseCreateFix.getTypeText(expectedType, context2);
            } else {
                elementForWhichExprTypeToEvaluate = referenceExpression;
            }
        }
        if (elementForWhichExprTypeToEvaluate != null) {
            JSType jsType = JSResolveUtil.getExpressionJSType((JSExpression)elementForWhichExprTypeToEvaluate);
            if (jsType == null) {
                jsType = JSAnyType.get((PsiElement)elementForWhichExprTypeToEvaluate);
            }
            type2 = BaseCreateFix.getTypeText(jsType, context2);
        }
        if (type2 != null && type2.equals("*")) {
            type2 = null;
        }
        if (type2 != null && context2.getLanguage().is((Language)FlexSupportLoader.ECMA_SCRIPT_L4)) {
            type2 = type2.endsWith("[]") ? "Array" : (String)ImportUtils.importAndShortenReference((String)type2, (PsiElement)referenceExpression, (boolean)true, (boolean)true).first;
        }
        List<String> list = types2 != null ? types2 : ContainerUtil.createMaybeSingletonList((Object)type2);
        if (list == null) {
            BaseCreateFix.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static boolean isPlusPlusOrMinusMinusOperation(JSExpressionWithOperationNode expression) {
        return expression.getOperationSign() == JSTokenTypes.PLUSPLUS || expression.getOperationSign() == JSTokenTypes.MINUSMINUS;
    }

    @NotNull
    private static List<String> getPossibleTypesText(@NotNull PsiElement context2, JSType variableType) {
        JSType optimized;
        if (context2 == null) {
            BaseCreateFix.$$$reportNull$$$0(22);
        }
        if ((optimized = JSCompositeTypeFactory.optimizeTypeIfComposite((JSType)variableType, (JSUnionOrIntersectionType.OptimizedKind)JSUnionOrIntersectionType.OptimizedKind.OPTIMIZED_NO_RESOLVE)) instanceof JSUnionType) {
            List types2 = ((JSUnionType)optimized).getTypes();
            List nullOrUndefined = ContainerUtil.filter((Collection)types2, JSTypeUtils::isNullOrUndefinedType);
            types2 = ContainerUtil.filter((Collection)types2, t -> !JSTypeUtils.isNullOrUndefinedType((JSType)t) && BaseCreateFix.isNamedType(t));
            List result2 = ContainerUtil.map((Collection)types2, t -> BaseCreateFix.getTypeText(context2, JSCompositeTypeFactory.createUnionType((JSTypeSource)t.getSource(), (Collection)ContainerUtil.prepend((List)nullOrUndefined, (Object[])new JSType[]{t}))));
            List list = ContainerUtil.append((List)ContainerUtil.filter((Collection)result2, t -> !t.equals("*")), (Object[])new String[]{BaseCreateFix.getTypeText(context2, optimized)});
            if (list == null) {
                BaseCreateFix.$$$reportNull$$$0(23);
            }
            return list;
        }
        if (BaseCreateFix.isNamedType(variableType)) {
            String result3 = BaseCreateFix.getTypeText(context2, variableType);
            List list = ContainerUtil.createMaybeSingletonList((Object)result3);
            if (list == null) {
                BaseCreateFix.$$$reportNull$$$0(24);
            }
            return list;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            BaseCreateFix.$$$reportNull$$$0(25);
        }
        return list;
    }

    @Nullable
    private static String getTypeText(@NotNull PsiElement context2, JSType variableType) {
        if (context2 == null) {
            BaseCreateFix.$$$reportNull$$$0(26);
        }
        if (DialectDetector.isTypeScript((PsiElement)context2)) {
            return variableType.getTypeText(JSType.TypeTextFormat.CODE);
        }
        String typeText = variableType.getTypeText();
        return JSImportHandlingUtil.resolveTypeName((String)typeText, (PsiElement)context2);
    }

    private static boolean isNamedType(JSType variableType) {
        TypeScriptCompilerType compilerType;
        return variableType instanceof JSNamedType || variableType instanceof JSGenericTypeImpl || variableType instanceof JSArrayType || variableType instanceof TypeScriptCompilerType && (BaseCreateFix.isNamedType((compilerType = (TypeScriptCompilerType)variableType).asJSType(true)) || BaseCreateFix.isNamedType(compilerType.substitute()));
    }

    private static String getNumberTypeForPrefixSuffixIncrement(@Nullable PsiElement context2, @Nullable String type2, @Nullable IElementType operationSign) {
        if (operationSign == JSTokenTypes.PLUSPLUS || operationSign == JSTokenTypes.MINUSMINUS) {
            DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)context2);
            return holder != null && holder.isECMA4 ? "int" : "Number";
        }
        return type2;
    }

    private static PsiElement getClassLikeFromAlias(@NotNull TypeScriptTypeAlias element2) {
        TypeScriptType typeDeclaration;
        if (element2 == null) {
            BaseCreateFix.$$$reportNull$$$0(27);
        }
        return (typeDeclaration = element2.getTypeDeclaration()) instanceof TypeScriptObjectType ? typeDeclaration : null;
    }

    @Nullable
    protected static PsiElement findClass(PsiElement anchorParent) {
        if (anchorParent instanceof TypeScriptTypeAlias) {
            return BaseCreateFix.getClassLikeFromAlias((TypeScriptTypeAlias)anchorParent);
        }
        if (anchorParent instanceof JSClass) {
            return anchorParent;
        }
        if (anchorParent instanceof TypeScriptObjectType) {
            PsiElement parent = anchorParent.getParent();
            if (parent instanceof JSClass) {
                if (parent instanceof TypeScriptTypeAlias) {
                    return BaseCreateFix.getClassLikeFromAlias((TypeScriptTypeAlias)parent);
                }
                return parent;
            }
            return anchorParent;
        }
        if (anchorParent instanceof JSFile) {
            return JSResolveUtil.getXmlBackedClass((JSFile)((JSFile)anchorParent));
        }
        return null;
    }

    @Override
    protected boolean isAvailable(Project project, PsiElement element2, Editor editor, PsiFile file) {
        JSExpression qualifier;
        DialectOptionHolder dialect = DialectDetector.dialectOfElement((PsiElement)element2);
        Pair<JSReferenceExpression, PsiElement> anchor = this.calculateAnchors(element2);
        JSExpression jSExpression = qualifier = anchor.first == null ? null : ((JSReferenceExpression)anchor.first).getQualifier();
        if (qualifier == null) {
            return true;
        }
        PsiElement scope2 = BaseCreateFix.getScope(qualifier, file);
        this.myIsProperty = scope2 instanceof JSObjectLiteralExpression;
        if (dialect == null || !dialect.isECMA4 && !dialect.isTypeScript && !dialect.isFlow || qualifier instanceof JSThisExpression) {
            return true;
        }
        if (scope2 == null || dialect.isECMA4 && JSProjectUtil.isInLibrary(scope2)) {
            return false;
        }
        if (dialect.isTypeScript) {
            PsiFile containingFile = scope2.getContainingFile();
            if (containingFile == null) {
                return false;
            }
            VirtualFile virtualFile = containingFile.getVirtualFile();
            return virtualFile != null && !JSLibraryUtil.isProbableLibraryFile((VirtualFile)virtualFile);
        }
        return true;
    }

    @NotNull
    public static String getTypeText(@NotNull JSType type2, @Nullable PsiElement contextElement) {
        if (type2 == null) {
            BaseCreateFix.$$$reportNull$$$0(28);
        }
        if (type2 instanceof JSResolvableType && type2 instanceof JSTypeWithWidening) {
            type2 = ((JSTypeWithWidening)type2).widen(true);
        }
        if (contextElement != null) {
            type2 = JSTypeUtils.copyWithLanguageOfContext((JSType)type2, (PsiElement)contextElement);
        }
        String string = type2.getTypeText(JSType.TypeTextFormat.CODE);
        if (string == null) {
            BaseCreateFix.$$$reportNull$$$0(29);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 19, 20, 21, 23, 24, 25, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialAnchor";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceExpression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/BaseCreateFix";
                break;
            }
            case 22: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/BaseCreateFix";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findExpressionContextualType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "guessTypesForExpression";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getPossibleTypesText";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doApplyFix";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "assertValidContext";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVariableDeclarationAnchor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInsertionScope";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "beforeStartTemplateAction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calculateAnchors";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveScopeFromQualifier";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSourceFromReferenceExpression";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addAccessModifier";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findExpressionContextualType";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 29: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleTypesText";
                break;
            }
            case 26: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getTypeText";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getClassLikeFromAlias";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 19, 20, 21, 23, 24, 25, 29 -> new IllegalStateException(string);
        };
    }

    public static class InsertPlaceInfo {
        public PsiElement anchor;
        public boolean insertAtEnd;
        public boolean toInsertNewLineAfter;
        public boolean addNewLineBefore;
        public int cdataStartOffset;

        public InsertPlaceInfo(PsiElement initialAnchor, PsiFile file, boolean isMember, boolean isFieldNotMethod) {
            PsiElement parent;
            this.anchor = initialAnchor;
            if (this.anchor != null && isMember) {
                PsiElement anchorParent = this.anchor.getParent();
                XmlFile contextFile = null;
                if (anchorParent instanceof JSFile && anchorParent.getContext() != null) {
                    PsiElement context2 = anchorParent.getContext();
                    if (context2 instanceof XmlAttributeValue || context2 instanceof XmlText && !BaseCreateFix.SCRIPT_TAG_NAME.equals(((XmlTag)context2.getParent()).getLocalName())) {
                        contextFile = (XmlFile)context2.getContainingFile();
                    }
                } else if (file instanceof XmlFile && !(file instanceof HtmlFileImpl)) {
                    contextFile = (XmlFile)file;
                }
                if (contextFile != null) {
                    XmlTag rootTag = contextFile.getDocument().getRootTag();
                    XmlBackedJSClass jsClass = XmlBackedJSClassFactory.getInstance().getXmlBackedClass(rootTag);
                    JSFile jsFile = ((XmlBackedJSClassImpl)jsClass).findFirstScriptTag();
                    if (jsFile != null) {
                        this.anchor = isFieldNotMethod ? JSChangeUtil.findInsertionPlaceStartingFrom((PsiElement)jsFile.getFirstChild(), (boolean)true, ourFilter) : jsFile.getLastChild();
                    } else {
                        this.anchor = (PsiElement)WriteAction.compute(() -> InsertPlaceInfo.lambda$new$0((JSClass)jsClass));
                        this.insertAtEnd = true;
                    }
                } else if (anchorParent instanceof JSClass || anchorParent instanceof TypeScriptObjectType || anchorParent instanceof JSObjectLiteralExpression || anchorParent instanceof JSFile && anchorParent.getContext() != null) {
                    if (isFieldNotMethod && !(anchorParent instanceof TypeScriptEnum)) {
                        this.anchor = BaseCreateFix.findInsertionPlaceBackward(this.anchor);
                    } else {
                        this.insertAtEnd = true;
                    }
                }
            }
            boolean bl = this.toInsertNewLineAfter = !this.insertAtEnd;
            if (!this.toInsertNewLineAfter) {
                PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)this.anchor);
                if (nextLeaf != null && nextLeaf.getNode() != null && nextLeaf.getNode().getElementType() == XmlTokenType.XML_CDATA_START) {
                    this.cdataStartOffset += nextLeaf.getTextRange().getEndOffset() + 1;
                }
                if (BaseCreateFix.doesNotContainNewline(nextLeaf)) {
                    this.toInsertNewLineAfter = true;
                }
            } else if (!BaseCreateFix.doesNotContainNewline(this.anchor)) {
                this.toInsertNewLineAfter = false;
            }
            if (!this.insertAtEnd && this.anchor instanceof PsiWhiteSpace && this.anchor.textToCharArray()[0] == '\n') {
                this.addNewLineBefore = true;
                this.toInsertNewLineAfter = false;
            }
            if (!this.insertAtEnd && this.anchor instanceof PsiWhiteSpace) {
                int at = this.anchor.getText().indexOf("<![CDATA[");
                if (at != -1) {
                    this.cdataStartOffset += at + "<!CDATA[".length() + 1;
                    this.addNewLineBefore = true;
                } else if (this.anchor.getPrevSibling() == null && this.anchor.getContainingFile().getContext() != null) {
                    this.addNewLineBefore = true;
                }
            }
            if (this.insertAtEnd && this.anchor instanceof XmlToken && ((XmlToken)this.anchor).getTokenType() == XmlTokenType.XML_CDATA_START) {
                this.addNewLineBefore = true;
            }
            if (isMember) {
                if (this.anchor instanceof PsiWhiteSpace && BaseCreateFix.doesNotContainNewline(this.anchor)) {
                    PsiElement prevSibling = this.anchor.getPrevSibling();
                    if (prevSibling != null && !(prevSibling instanceof PsiWhiteSpace)) {
                        this.addNewLineBefore = true;
                    }
                } else if (this.insertAtEnd && (this.anchor instanceof JSVarStatement || this.anchor instanceof JSField)) {
                    this.addNewLineBefore = true;
                }
            }
            PsiElement psiElement = parent = this.anchor != null ? this.anchor.getParent() : null;
            if (parent instanceof JSObjectLiteralExpression) {
                JSProperty prevProperty;
                JSProperty jSProperty = prevProperty = this.anchor instanceof JSProperty && this.insertAtEnd ? (JSProperty)this.anchor : (JSProperty)PsiTreeUtil.getPrevSiblingOfType((PsiElement)this.anchor, JSProperty.class);
                if (prevProperty != null) {
                    this.addTrailingComma((PsiElement)prevProperty);
                    this.anchor = BaseCreateFix.findInsertionAnchorForScope(parent, isFieldNotMethod);
                }
            }
            if (parent instanceof TypeScriptEnum) {
                JSField[] fields = ((TypeScriptEnum)parent).getFields();
                if (fields.length > 0) {
                    this.addTrailingComma((PsiElement)fields[fields.length - 1]);
                    this.anchor = BaseCreateFix.findInsertionAnchorForScope(parent, isFieldNotMethod);
                } else {
                    PsiElement nextSibling;
                    ASTNode brace = parent.getNode().findChildByType(JSTokenTypes.LBRACE);
                    this.anchor = brace != null ? brace.getPsi() : null;
                    PsiElement psiElement2 = nextSibling = this.anchor != null ? this.anchor.getNextSibling() : null;
                    if (!(nextSibling instanceof PsiWhiteSpace) || !nextSibling.textContains('\n')) {
                        this.addNewLineBefore = true;
                        this.toInsertNewLineAfter = true;
                    }
                }
            }
        }

        public void addTrailingComma(@Nullable PsiElement element2) {
            if (element2 == null) {
                return;
            }
            PsiElement nextElement = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)element2);
            if (PsiUtilCore.getElementType((PsiElement)nextElement) != JSTokenTypes.COMMA) {
                PsiElement commaPsiElement = JSChangeUtil.createCommaPsiElement((PsiElement)element2);
                WriteAction.run(() -> element2.getParent().addAfter(commaPsiElement, element2));
            }
        }

        private static /* synthetic */ PsiElement lambda$new$0(JSClass jsClass) throws RuntimeException {
            return PsiTreeUtil.firstChild((PsiElement)((XmlBackedJSClassImpl)jsClass).createScriptTag().getContext());
        }
    }
}

