/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flex.ActionScriptExtensions;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.JSAttributeListWrapper;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class MakeMethodStaticFix
implements IntentionAction,
LocalQuickFix {
    @NotNull
    public String getText() {
        String string = JavaScriptBundle.message((String)"make.method.static", (Object[])new Object[0]);
        if (string == null) {
            MakeMethodStaticFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            MakeMethodStaticFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            MakeMethodStaticFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            MakeMethodStaticFix.$$$reportNull$$$0(3);
        }
        MakeMethodStaticFix.invoke(descriptor.getPsiElement());
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        if (project == null) {
            MakeMethodStaticFix.$$$reportNull$$$0(4);
        }
        if (editor != null) {
            PsiElement element2 = psiFile.findElementAt(editor.getCaretModel().getOffset());
            return element2 != null && element2.isValid() && PsiTreeUtil.getNonStrictParentOfType((PsiElement)element2, (Class[])new Class[]{JSFunction.class}) != null;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            MakeMethodStaticFix.$$$reportNull$$$0(5);
        }
        if (editor != null) {
            PsiElement element2 = psiFile.findElementAt(editor.getCaretModel().getOffset());
            MakeMethodStaticFix.invoke(element2);
        }
    }

    private static void invoke(@NotNull PsiElement element2) {
        if (element2 == null) {
            MakeMethodStaticFix.$$$reportNull$$$0(6);
        }
        JSFunction function = (JSFunction)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element2, (Class[])new Class[]{JSFunction.class});
        Collection usages = Collections.synchronizedCollection(new HashSet());
        ReferencesSearch.search((PsiElement)function, (SearchScope)function.getUseScope()).forEach(psiReference -> {
            PsiElement element1 = psiReference.getElement();
            if (!(element1 instanceof JSReferenceExpression)) {
                return true;
            }
            JSReferenceExpression refExpr = (JSReferenceExpression)element1;
            if (refExpr.getQualifier() == null) {
                return true;
            }
            usages.add(refExpr);
            return true;
        });
        ArrayList<Object> elementsToWrite = new ArrayList<Object>();
        elementsToWrite.add(element2);
        elementsToWrite.addAll(usages);
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(elementsToWrite)) {
            return;
        }
        JSClass clazz = JSUtils.getMemberContainingClass((PsiElement)function);
        WriteAction.run(() -> {
            JSAttributeListWrapper wrapper = new JSAttributeListWrapper((JSAttributeListOwner)function);
            wrapper.overrideModifier(JSAttributeList.ModifierType.STATIC, true);
            wrapper.overrideModifier(JSAttributeList.ModifierType.FINAL, false);
            wrapper.applyTo((JSAttributeListOwner)function);
            ArrayList<FormatFixer> formatters = new ArrayList<FormatFixer>();
            HashSet<PsiFile> filesToOptimizeImports = new HashSet<PsiFile>();
            boolean actionScript = DialectDetector.isActionScript((PsiElement)element2);
            for (JSReferenceExpression refExpr : usages) {
                JSClass currentClass = JSResolveUtil.getClassOfContext((PsiElement)refExpr);
                if (currentClass != null && currentClass.isEquivalentTo((PsiElement)clazz)) {
                    if (actionScript) {
                        JSRefactoringUtil.makeQualified(refExpr, null, false);
                        continue;
                    }
                    JSExpression qualifier = refExpr.getQualifier();
                    if (qualifier instanceof JSThisExpression) {
                        PsiElement dot = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)qualifier);
                        refExpr.deleteChildRange((PsiElement)qualifier, dot);
                    }
                    JSRefactoringUtil.makeQualified(refExpr, (JSQualifiedNamedElement)clazz, true);
                    continue;
                }
                if (actionScript) {
                    if (ImportUtils.needsImport(JSResolveUtil.getPackageNameFromPlace((PsiElement)refExpr), (JSQualifiedNamedElement)clazz)) {
                        FormatFixer formatter = ImportUtils.insertImportStatements((PsiElement)refExpr, Collections.singletonList(clazz.getQualifiedName()));
                        ContainerUtil.addIfNotNull(formatters, (Object)formatter);
                    }
                    filesToOptimizeImports.add(refExpr.getContainingFile());
                }
                JSRefactoringUtil.makeQualified(refExpr, (JSQualifiedNamedElement)clazz, true);
            }
            for (PsiFile file : filesToOptimizeImports) {
                formatters.addAll(ActionScriptExtensions.getInstance().optimizeImports(file));
            }
            FormatFixer.fixAll(formatters);
        });
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean availableInBatchMode() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/validation/fixes/MakeMethodStaticFix";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/validation/fixes/MakeMethodStaticFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

