/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.dbimport;

import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.dbimport.Query;
import com.intellij.database.remote.jdbc.ColumnInfo;
import com.intellij.database.remote.jdbc.RemotePreparedStatement;
import com.intellij.database.remote.jdbc.impl.RemoteBatchPreparedStatementImpl;
import com.intellij.openapi.diagnostic.LoggerRt;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

abstract class QueryWithParameters
implements Query {
    private static final LoggerRt LOG = LoggerRt.getInstance(QueryWithParameters.class);
    protected final RemotePreparedStatement myPreparedStatement;
    private final RemotePreparedStatement myOneLineStatement;
    private final List<ColumnInfo> myInfos;
    private final BatchRecords myParameters;
    private final Consumer<ErrorRecord> myErrorConsumer;

    QueryWithParameters(@NotNull BatchRecords parameters, @NotNull RemotePreparedStatement preparedStatement, @NotNull RemotePreparedStatement oneLineStatement, @NotNull List<ColumnInfo> infos, @NotNull Consumer<ErrorRecord> errorConsumer) {
        if (parameters == null) {
            QueryWithParameters.$$$reportNull$$$0(0);
        }
        if (preparedStatement == null) {
            QueryWithParameters.$$$reportNull$$$0(1);
        }
        if (oneLineStatement == null) {
            QueryWithParameters.$$$reportNull$$$0(2);
        }
        if (infos == null) {
            QueryWithParameters.$$$reportNull$$$0(3);
        }
        if (errorConsumer == null) {
            QueryWithParameters.$$$reportNull$$$0(4);
        }
        this.myParameters = parameters;
        this.myPreparedStatement = preparedStatement;
        this.myOneLineStatement = oneLineStatement;
        this.myInfos = infos;
        this.myErrorConsumer = errorConsumer;
    }

    @Override
    public void execute() throws SQLException, RemoteException {
        try {
            this.completeStatement();
            this.statementCompleted();
        }
        catch (RemoteBatchPreparedStatementImpl.IllegalTransactionStateException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            this.onError();
        }
    }

    final void completeStatement() throws RemoteException, SQLException {
        int idx = 1;
        for (Object[] record : this.myParameters.getRecords()) {
            this.completeStatement(this.myPreparedStatement, record, idx);
            idx += this.myInfos.size();
        }
    }

    final void completeStatement(@NotNull RemotePreparedStatement statement, @NotNull Object[] record, int startIdx) throws RemoteException, SQLException {
        if (statement == null) {
            QueryWithParameters.$$$reportNull$$$0(5);
        }
        if (record == null) {
            QueryWithParameters.$$$reportNull$$$0(6);
        }
        for (ColumnInfo info : this.myInfos) {
            statement.setObject(record[info.getIndex()], info, false, startIdx++);
        }
    }

    final void executeWithoutMultiLines() throws RemoteException, SQLException {
        List<Object[]> records = this.myParameters.getRecords();
        for (int i = 0; i < records.size(); ++i) {
            Object[] line = records.get(i);
            try {
                this.completeStatement(this.myOneLineStatement, line, 1);
                this.myOneLineStatement.executeUpdate();
                continue;
            }
            catch (RemoteBatchPreparedStatementImpl.IllegalTransactionStateException e) {
                throw e;
            }
            catch (Exception e) {
                this.myErrorConsumer.accept(this.myParameters.getErrorRecord(e, i));
            }
        }
    }

    abstract void statementCompleted() throws SQLException, RemoteException;

    abstract void onError() throws SQLException, RemoteException;

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preparedStatement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oneLineStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorConsumer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "record";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/remote/dbimport/QueryWithParameters";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "completeStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

