/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.lang.Language;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.testFramework.GlobalState;
import com.intellij.testFramework.JUnit38AssumeSupportRunner;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.TestApplicationManager;
import com.intellij.tests.DynamicExtensionPointsTester;
import com.intellij.util.Function;
import com.intellij.util.SystemProperties;
import java.util.Collection;
import java.util.HashMap;
import junit.framework.TestCase;
import org.junit.Assume;
import org.junit.FixMethodOrder;
import org.junit.runner.RunWith;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.NAME_ASCENDING)
@RunWith(value=JUnit38AssumeSupportRunner.class)
public class _LastInSuiteTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        Disposer.setDebugMode((boolean)true);
    }

    public String getName() {
        return _LastInSuiteTest.getTestName(super.getName());
    }

    private static String getTestName(String name) {
        String buildConf = System.getProperty("teamcity.buildConfName");
        return buildConf == null ? name : name + "[" + buildConf + "]";
    }

    public void testDynamicExtensions() {
        boolean testDynamicExtensions = SystemProperties.getBooleanProperty((String)"intellij.test.all.dynamic.extension.points", (boolean)false);
        Assume.assumeTrue((String)"intellij.test.all.dynamic.extension.points is off, no dynamic extensions to test", (!DynamicExtensionPointsTester.EXTENSION_POINTS_WHITE_LIST.isEmpty() || testDynamicExtensions ? 1 : 0) != 0);
        DynamicExtensionPointsTester.checkDynamicExtensionPoints((Function<? super String, String>)((Function)_LastInSuiteTest::getTestName));
    }

    public void testProjectLeak() {
        TestApplicationManager.testProjectLeak();
    }

    public void testLanguagesHaveDifferentDisplayNames() {
        Collection languages = Language.getRegisteredLanguages();
        HashMap<String, Language> displayNames = new HashMap<String, Language>();
        for (Language language : languages) {
            Language prev = displayNames.put(language.getDisplayName(), language);
            if (prev == null) continue;
            _LastInSuiteTest.fail((String)"The languages '%s' (%s) and '%s' (%s) have the same display name '%s'".formatted(prev, prev.getClass().getName(), language, language.getClass().getName(), language.getDisplayName()));
        }
    }

    public void testStatistics() {
        long started = _FirstInSuiteTest.getSuiteStartTime();
        if (started != 0L) {
            long testSuiteDuration = System.nanoTime() - started;
            System.out.printf("##teamcity[buildStatisticValue key='ideaTests.totalTimeMs' value='%d']%n", testSuiteDuration / 1000000L);
        }
        LightPlatformTestCase.reportTestExecutionStatistics();
    }

    public void testFilenameIndexConsistency() {
        FSRecords.checkFilenameIndexConsistency();
    }

    public void testGlobalState() {
        GlobalState.checkSystemStreams();
    }
}

