/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.dap;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.dap.DapBreakpointsDescription;
import com.intellij.platform.dap.DapDebugSession;
import com.intellij.platform.dap.DapExceptionBreakpoint;
import com.intellij.platform.dap.DapExceptionInfo;
import com.intellij.platform.dap.DapStartRequest;
import com.intellij.platform.dap.DebugAdapterDescriptor;
import com.intellij.platform.dap.DebugAdapterSupportProvider;
import com.intellij.platform.dap.connection.DebugAdapterHandle;
import com.intellij.platform.dap.xdebugger.DapXDebugProcess;
import com.intellij.python.community.helpersLocator.PythonHelpersLocator;
import com.intellij.python.dap.PythonDapAdapter;
import com.intellij.python.dap.PythonDapBundle;
import com.intellij.python.dap.PythonDapLauncherKt;
import com.intellij.python.dap.PythonDapProtocolServer;
import com.intellij.python.dap.attach.PythonDapAttachConfiguration;
import com.intellij.python.dap.xdebugger.PythonDapDebugProcess;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.PyExceptionBreakpointProperties;
import com.jetbrains.python.debugger.PyExceptionBreakpointType;
import com.jetbrains.python.debugger.PyLineBreakpointType;
import com.jetbrains.python.run.AbstractPythonRunConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.eclipse.lsp4j.debug.services.IDebugProtocolServer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0002R\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/python/dap/PythonDapAdapterSupportProvider;", "Lcom/intellij/platform/dap/DebugAdapterSupportProvider;", "Lcom/intellij/python/dap/PythonDapAdapter;", "<init>", "()V", "adapterId", "getAdapterId", "()Lcom/intellij/python/dap/PythonDapAdapter;", "tempRootDirectory", "Ljava/nio/file/Path;", "createDebugAdapterDescriptor", "Lcom/intellij/platform/dap/DebugAdapterDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getDebugAdapterExecutable", "Companion", "intellij.python.dap"})
public final class PythonDapAdapterSupportProvider
implements DebugAdapterSupportProvider<PythonDapAdapter> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PythonDapAdapter adapterId = PythonDapAdapter.INSTANCE;
    @NotNull
    private Path tempRootDirectory;
    @NotNull
    public static final String DEBUG_ADAPTER_MODULE_DIR = "debugpy";
    @NotNull
    public static final String DEBUG_ADAPTER_EXECUTABLE_PATH = "adapter";

    public PythonDapAdapterSupportProvider() {
        Path path = Files.createTempDirectory(DEBUG_ADAPTER_MODULE_DIR, new FileAttribute[0]).toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        this.tempRootDirectory = path;
    }

    @NotNull
    public PythonDapAdapter getAdapterId() {
        return this.adapterId;
    }

    @NotNull
    public DebugAdapterDescriptor<PythonDapAdapter> createDebugAdapterDescriptor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (DebugAdapterDescriptor)new DebugAdapterDescriptor<PythonDapAdapter>(this, project){
            private final PythonDapAdapter id;
            public RunProfileState pyState;
            private final DapBreakpointsDescription breakpointsDescription;
            final /* synthetic */ PythonDapAdapterSupportProvider this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.id = PythonDapAdapter.INSTANCE;
                Class<PyLineBreakpointType> clazz = PyLineBreakpointType.class;
                Class<PyExceptionBreakpointType> clazz2 = PyExceptionBreakpointType.class;
                this.breakpointsDescription = new DapBreakpointsDescription(clazz, clazz2){

                    public boolean doesExceptionMatchBreakpoint(DapExceptionInfo exceptionInfo, DapExceptionBreakpoint breakpoint) {
                        Object object;
                        Intrinsics.checkNotNullParameter((Object)exceptionInfo, (String)"exceptionInfo");
                        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
                        XBreakpoint ideBreakpoint = breakpoint.getIdeBreakpoint();
                        if (!(ideBreakpoint.getType() instanceof PyExceptionBreakpointType)) {
                            return false;
                        }
                        XBreakpointProperties xBreakpointProperties = ideBreakpoint.getProperties();
                        PyExceptionBreakpointProperties pyExceptionBreakpointProperties = xBreakpointProperties instanceof PyExceptionBreakpointProperties ? (PyExceptionBreakpointProperties)xBreakpointProperties : null;
                        if (pyExceptionBreakpointProperties == null) {
                            return false;
                        }
                        PyExceptionBreakpointProperties exceptionProperties = pyExceptionBreakpointProperties;
                        return exceptionProperties.myException == null || Intrinsics.areEqual((Object)exceptionProperties.myException, (object = exceptionInfo.getRawDetails()) != null && (object = object.getFullTypeName()) != null ? StringsKt.removeSurrounding((String)object, (CharSequence)"\"") : null);
                    }
                };
            }

            public PythonDapAdapter getId() {
                return this.id;
            }

            public final RunProfileState getPyState() {
                RunProfileState runProfileState = this.pyState;
                if (runProfileState != null) {
                    return runProfileState;
                }
                Intrinsics.throwUninitializedPropertyAccessException((String)"pyState");
                return null;
            }

            public final void setPyState(RunProfileState runProfileState) {
                Intrinsics.checkNotNullParameter((Object)runProfileState, (String)"<set-?>");
                this.pyState = runProfileState;
            }

            public void configureProfileState(ExecutionEnvironment environment, RunProfileState state) {
                Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                this.setPyState(state);
            }

            public Class<? extends IDebugProtocolServer> getDebugAdapterServerClass() {
                return PythonDapProtocolServer.class;
            }

            public Object launchDebugAdapter(ExecutionEnvironment environment, ExecutionResult executionResult, String sessionId, Continuation<? super DebugAdapterHandle> $completion) {
                if (environment.getRunProfile() instanceof AbstractPythonRunConfiguration) {
                    CharSequence charSequence;
                    RunProfile runProfile = environment.getRunProfile();
                    Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.jetbrains.python.run.AbstractPythonRunConfiguration<*>");
                    AbstractPythonRunConfiguration profile = (AbstractPythonRunConfiguration)runProfile;
                    int it = Registry.Companion.get("debugpy.dap.debug.port").asInteger();
                    boolean bl = false;
                    Integer debugPort = it < 0 ? null : Boxing.boxInt((int)it);
                    String it2 = Registry.Companion.get("debugpy.dap.log.path").asString();
                    boolean bl2 = false;
                    CharSequence charSequence2 = it2;
                    if (charSequence2.length() == 0) {
                        boolean bl3 = false;
                        charSequence = null;
                    } else {
                        charSequence = charSequence2;
                    }
                    String logDir = (String)charSequence;
                    String debugAdapterExecutable = ((Object)PythonDapAdapterSupportProvider.access$getDebugAdapterExecutable(this.this$0)).toString();
                    if (profile.getSdk() == null) {
                        throw new ExecutionException(PythonDapBundle.message("pythonDap.run.provider.noSdk.error", new Object[0]));
                    }
                    if (debugPort == null) {
                        debugPort = Boxing.boxInt((int)NetUtils.findAvailableSocketPort());
                    }
                    Sdk sdk = profile.getSdk();
                    Intrinsics.checkNotNull((Object)sdk);
                    return PythonDapLauncherKt.createLaunchDebugAdapter(this.$project, sdk, debugAdapterExecutable, debugPort, logDir, $completion);
                }
                RunProfile runProfile = environment.getRunProfile();
                Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.intellij.python.dap.attach.PythonDapAttachConfiguration");
                PythonDapAttachConfiguration runProfile2 = (PythonDapAttachConfiguration)runProfile;
                if (runProfile2.getRemoteAddress() == null) {
                    throw new ExecutionException(PythonDapBundle.message("pythonDap.attach.configuration.missingUrl.error", new Object[0]));
                }
                String string = runProfile2.getRemoteAddress();
                Intrinsics.checkNotNull((Object)string);
                return PythonDapLauncherKt.createAttachDebugAdapter(string, $completion);
            }

            public DapBreakpointsDescription getBreakpointsDescription() {
                return this.breakpointsDescription;
            }

            public DapXDebugProcess createXDebugProcess(XDebugSession session, DapDebugSession dapDebugSession, CoroutineScope xDebugProcessScope, CoroutineScope globalScope, DebugAdapterDescriptor<?> debugAdapterDescriptor, ExecutionEnvironment executionEnvironment, ExecutionResult executionResult, DapStartRequest startRequestType, Map<String, ? extends Object> startRequestArguments) {
                PythonDapDebugProcess pyDebugProcess;
                block0: {
                    Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                    Intrinsics.checkNotNullParameter((Object)dapDebugSession, (String)"dapDebugSession");
                    Intrinsics.checkNotNullParameter((Object)xDebugProcessScope, (String)"xDebugProcessScope");
                    Intrinsics.checkNotNullParameter((Object)globalScope, (String)"globalScope");
                    Intrinsics.checkNotNullParameter(debugAdapterDescriptor, (String)"debugAdapterDescriptor");
                    Intrinsics.checkNotNullParameter((Object)executionEnvironment, (String)"executionEnvironment");
                    Intrinsics.checkNotNullParameter((Object)startRequestType, (String)"startRequestType");
                    Intrinsics.checkNotNullParameter(startRequestArguments, (String)"startRequestArguments");
                    pyDebugProcess = new PythonDapDebugProcess(session, dapDebugSession, xDebugProcessScope, globalScope, debugAdapterDescriptor, executionEnvironment, executionResult, startRequestType, startRequestArguments, this.getPyState());
                    ExecutionResult executionResult2 = executionResult;
                    if (executionResult2 == null) break block0;
                    ExecutionResult executionResult3 = executionResult2;
                    Project project = this.$project;
                    ExecutionResult it = executionResult3;
                    boolean bl = false;
                    PyDebugRunner.createConsoleCommunication((Project)project, (ExecutionResult)it, (XDebugProcess)((XDebugProcess)pyDebugProcess), (XDebugSession)session);
                }
                return pyDebugProcess;
            }
        };
    }

    private final Path getDebugAdapterExecutable() {
        Path path = this.tempRootDirectory.resolve(DEBUG_ADAPTER_MODULE_DIR);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            Path debugpyModulePath = PythonHelpersLocator.Companion.findPathInHelpers(DEBUG_ADAPTER_MODULE_DIR);
            String[] stringArray = new String[]{DEBUG_ADAPTER_MODULE_DIR};
            File tempAdapterRoot = Files.createDirectory(Path.of(((Object)this.tempRootDirectory).toString(), stringArray), new FileAttribute[0]).toFile();
            try {
                NioFiles.copyRecursively((Path)debugpyModulePath, (Path)tempAdapterRoot.toPath());
            }
            catch (IOException e) {
                NioFiles.deleteRecursively((Path)Path.of(this.tempRootDirectory.toUri()));
                throw e;
            }
            ShutDownTracker.getInstance().registerShutdownTask(() -> PythonDapAdapterSupportProvider.getDebugAdapterExecutable$lambda$0(this));
        }
        Path path3 = this.tempRootDirectory.resolve(DEBUG_ADAPTER_MODULE_DIR).resolve(DEBUG_ADAPTER_EXECUTABLE_PATH);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        return path3;
    }

    private static final void getDebugAdapterExecutable$lambda$0(PythonDapAdapterSupportProvider this$0) {
        NioFiles.deleteRecursively((Path)Path.of(this$0.tempRootDirectory.toUri()));
    }

    public static final /* synthetic */ Path access$getDebugAdapterExecutable(PythonDapAdapterSupportProvider $this) {
        return $this.getDebugAdapterExecutable();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/python/dap/PythonDapAdapterSupportProvider$Companion;", "", "<init>", "()V", "DEBUG_ADAPTER_MODULE_DIR", "", "DEBUG_ADAPTER_EXECUTABLE_PATH", "intellij.python.dap"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

