/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.math;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.cast.JSNumberToDoubleNode;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.JSContext;

@GenerateCached(value=false)
public abstract class MinMaxNode
extends JSBuiltinNode {
    public MinMaxNode(JSContext context, JSBuiltin builtin) {
        super(context, builtin);
    }

    protected abstract int minOrMaxInt(int var1, int var2);

    protected abstract double minOrMaxDouble(double var1, double var3);

    @Specialization(guards={"args.length == 1"})
    protected static Object do1(Object[] args, @Cached @Cached.Shared JSToNumberNode toNumber0Node) {
        return toNumber0Node.execute(args[0]);
    }

    @Specialization(guards={"args.length == 2"})
    protected final Object do2(Object[] args, @Cached @Cached.Shared InlinedBranchProfile isIntBranch, @Cached @Cached.Shared JSNumberToDoubleNode numberToDouble, @Cached @Cached.Shared JSToNumberNode toNumber0Node, @Cached @Cached.Shared JSToNumberNode toNumber1Node) {
        Object a0 = args[0];
        Object a1 = args[1];
        if (a0 instanceof Integer) {
            Integer i0 = (Integer)a0;
            if (a1 instanceof Integer) {
                Integer i1 = (Integer)a1;
                isIntBranch.enter(this);
                return this.minOrMaxInt(i0, i1);
            }
        }
        Number n0 = toNumber0Node.executeNumber(a0);
        Number n1 = toNumber1Node.executeNumber(a1);
        if (n0 instanceof Integer) {
            Integer i0 = (Integer)n0;
            if (n1 instanceof Integer) {
                Integer i1 = (Integer)n1;
                isIntBranch.enter(this);
                return this.minOrMaxInt(i0, i1);
            }
        }
        double d0 = numberToDouble.execute(this, n0);
        double d1 = numberToDouble.execute(this, n1);
        return this.minOrMaxDouble(d0, d1);
    }

    @Specialization(guards={"args.length == 3"})
    protected Object do3(Object[] args, @Cached @Cached.Shared InlinedBranchProfile isIntBranch, @Cached @Cached.Shared JSNumberToDoubleNode numberToDouble, @Cached @Cached.Shared JSToNumberNode toNumber0Node, @Cached @Cached.Shared JSToNumberNode toNumber1Node, @Cached @Cached.Shared JSToNumberNode toNumber2Node) {
        Object a0 = args[0];
        Object a1 = args[1];
        Object a2 = args[2];
        if (a0 instanceof Integer) {
            Integer i0 = (Integer)a0;
            if (a1 instanceof Integer) {
                Integer i1 = (Integer)a1;
                if (a2 instanceof Integer) {
                    Integer i2 = (Integer)a2;
                    isIntBranch.enter(this);
                    return this.minOrMaxInt(this.minOrMaxInt(i0, i1), i2);
                }
            }
        }
        Number n0 = toNumber0Node.executeNumber(a0);
        Number n1 = toNumber1Node.executeNumber(a1);
        Number n2 = toNumber2Node.executeNumber(a2);
        if (n0 instanceof Integer) {
            Integer i0 = (Integer)n0;
            if (n1 instanceof Integer) {
                Integer i1 = (Integer)n1;
                if (n2 instanceof Integer) {
                    Integer i2 = (Integer)n2;
                    isIntBranch.enter(this);
                    return this.minOrMaxInt(this.minOrMaxInt(i0, i1), i2);
                }
            }
        }
        double d0 = numberToDouble.execute(this, n0);
        double d1 = numberToDouble.execute(this, n1);
        double d2 = numberToDouble.execute(this, n2);
        double result = this.minOrMaxDouble(d0, d1);
        return this.minOrMaxDouble(result, d2);
    }

    @Specialization(guards={"args.length >= 4"})
    protected Object do4OrMore(Object[] args, @Cached @Cached.Shared InlinedBranchProfile isIntBranch, @Cached @Cached.Shared JSToNumberNode toNumber0Node, @Cached @Cached.Shared JSToNumberNode toNumber1Node, @Cached @Cached.Shared JSToNumberNode toNumber2Node, @Cached @Cached.Shared JSNumberToDoubleNode numberToDouble) {
        double dresult;
        int i;
        block4: {
            Object a0 = args[0];
            Object n0 = toNumber0Node.execute(a0);
            if (n0 instanceof Integer) {
                Integer i0 = (Integer)n0;
                isIntBranch.enter(this);
                int iresult = i0;
                for (i = 1; i < args.length; ++i) {
                    Object ai = args[i];
                    Object ni = toNumber1Node.execute(ai);
                    if (!(ni instanceof Integer)) {
                        dresult = iresult;
                        break block4;
                    }
                    Integer ii = (Integer)ni;
                    iresult = this.minOrMaxInt(iresult, ii);
                }
                return iresult;
            }
            dresult = numberToDouble.execute(this, n0);
        }
        while (i < args.length) {
            Object ai = args[i];
            Number ni = toNumber2Node.executeNumber(ai);
            double di = numberToDouble.execute(this, ni);
            dresult = this.minOrMaxDouble(dresult, di);
            ++i;
        }
        return dresult;
    }
}

