/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 68204395480483L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-314830140 - -26986, 314830140 - 10805, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-314830140 - -26987, -314830140 + -3836, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 96250188039498L;
                thread = Thread.currentThread();
                String string = SshAgentIpcService.S();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (string != null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(29097540 - (char)-16001, 29097540 - (char)-12428, (int)l2) + string + WindowsNamedPipeAgentIpc.b(29097540 - (char)-16000, 29097540 - (char)-16489, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(29097540 - (char)-15999, 29097540 - (char)-7788, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                String string;
                l2 = 26198809991017L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    string = SshAgentIpcService.S();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(490595010 - (char)-3103, -490463940 + -((char)-20783), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(490595010 - (char)-3104, 490463940 + (char)-7240, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(490595010 - (char)-3105, -490463940 + -((char)-6737), (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (string != null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(490595010 - (char)-3114, -490463940 + -((char)-22579), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(490595010 - (char)-3115, 490595010 - (char)-6802, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(490595010 - (char)-3116, 490463940 + (char)-17872, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(490595010 - (char)-3114, -490463940 + -((char)-22579), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(490595010 - (char)-3117, -490463940 + -((char)-1549), (int)l2));
            if (!ActionTimestamp.S()) {
                SshAgentIpcService.S("tBSMd");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                String string;
                block6: {
                    long l2 = 125872116346494L;
                    string = SshAgentIpcService.S();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (string != null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (string != null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        block32: {
            boolean bl;
            block34: {
                block33: {
                    Object object;
                    Object object2;
                    String string;
                    long l2;
                    block28: {
                        block29: {
                            l2 = 67057140120338L;
                            String string2 = SshAgentIpcService.S();
                            this.assertConnectionThread();
                            Object object3 = this.lock;
                            string = string2;
                            synchronized (object3) {
                                boolean bl2;
                                NamedPipeState namedPipeState;
                                NamedPipeState namedPipeState2;
                                block26: {
                                    block27: {
                                        boolean bl3 = false;
                                        try {
                                            namedPipeState2 = this.state;
                                            namedPipeState = NamedPipeState.Closing;
                                            if (string != null) break block26;
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block27;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                                        boolean bl4 = false;
                                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(184284420 - 29297, -184284420 - -26748, (int)l2));
                                        logger.info(WindowsNamedPipeAgentIpc.b(184284420 - 29293, -184284420 - -3608, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(184284420 - 29298, -184284420 - -17293, (int)l2) + this.state);
                                        throw new ClosedChannelException();
                                    }
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Open;
                                }
                                try {
                                    bl2 = namedPipeState2 == namedPipeState;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl2) {
                                    boolean bl5 = false;
                                    String string3 = WindowsNamedPipeAgentIpc.b(184284420 - 29293, -184284420 - -3608, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(184284420 - 29299, -184284420 - -20681, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string3.toString());
                                }
                                this.state = NamedPipeState.Connecting;
                                Unit unit = Unit.INSTANCE;
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl6 = false;
                            try {
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(184284420 - 29297, -184284420 - -26748, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(184284420 - 29293, -184284420 - -3608, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(184284420 - 29300, 184284420 - 14422, (int)l2));
                                object2 = Kernel32.INSTANCE;
                                if (string != null) break block28;
                                if (object2.ConnectNamedPipe(this.hPipe, null)) break block29;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            int n2 = Kernel32.INSTANCE.GetLastError();
                            if (n2 == 535) {
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                                boolean bl7 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(184284420 - 29297, -184284420 - -26748, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(184284420 - 29293, -184284420 - -3608, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(184284420 - 29301, 184284420 - 4282, (int)l2));
                            } else {
                                throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(184284420 - 29293, -184284420 - -3608, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(184284420 - 29302, 184284420 + 785, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                            }
                        }
                        object2 = this.lock;
                    }
                    Kernel32 kernel32 = object2;
                    synchronized (kernel32) {
                        boolean bl8;
                        NamedPipeState namedPipeState;
                        NamedPipeState namedPipeState3;
                        block30: {
                            block31: {
                                boolean bl9 = false;
                                namedPipeState3 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (string != null) break block30;
                                try {
                                    block35: {
                                        if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block31;
                                        break block35;
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                    }
                                    throw new ClosedChannelException();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                            }
                            namedPipeState3 = this.state;
                            namedPipeState = NamedPipeState.Connecting;
                        }
                        try {
                            bl8 = namedPipeState3 == namedPipeState;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        if (!bl8) {
                            boolean bl10 = false;
                            String string4 = WindowsNamedPipeAgentIpc.b(184284420 - 29293, -184284420 - -3608, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(184284420 - 29299, -184284420 - -20681, (int)l2) + this.state;
                            throw new IllegalArgumentException(string4.toString());
                        }
                        this.state = NamedPipeState.Connected;
                        object = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                    boolean bl11 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(184284420 - 29297, -184284420 - -26748, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(184284420 - 29293, -184284420 - -3608, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(184284420 - 29303, 184284420 - 28515, (int)l2));
                    long l3 = this.getRequesterPid();
                    this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
                    object = new PipeReadableByteChannel(this);
                    PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
                    try {
                        try {
                            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                                final /* synthetic */ PipeReadableByteChannel $read;
                                final /* synthetic */ PipeWritableByteChannel $write;
                                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                                private static final String[] a;
                                private static final String[] b;
                                {
                                    this.$read = $read;
                                    this.$write = $write;
                                    this.this$0 = $receiver;
                                }

                                public InputStream getInputStream() {
                                    long l2 = 110647625964548L;
                                    InputStream inputStream = Channels.newInputStream(this.$read);
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-678549390 - -((char)-5075), -678418320 + -((char)-2327), (int)l2));
                                    return inputStream;
                                }

                                public OutputStream getOutputStream() {
                                    long l2 = 137250344903445L;
                                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-370010610 - -21889, -370010610 - -6680, (int)l2));
                                    return outputStream;
                                }

                                public void close() {
                                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                static {
                                    block13: {
                                        var5 = new String[2];
                                        var3_1 = 0;
                                        var2_2 = "Q\u00b7\u00c7u\u001e\u009c\u0081\bt\u00b6\u00c6X\u00a7;\u0000E:n\u0094\u0014O\u00bf\u0004r}\u00be\u0090\u00c9\u00d4\u0088\u0017K_\u00a0\u00de\u00bd\f\u00b7U\u0016";
                                        var4_3 = "Q\u00b7\u00c7u\u001e\u009c\u0081\bt\u00b6\u00c6X\u00a7;\u0000E:n\u0094\u0014O\u00bf\u0004r}\u00be\u0090\u00c9\u00d4\u0088\u0017K_\u00a0\u00de\u00bd\f\u00b7U\u0016".length();
                                        var1_4 = 19;
                                        var0_5 = -1;
lbl7:
                                        // 2 sources

                                        while (true) {
                                            continue;
                                            break;
                                        }
lbl9:
                                        // 1 sources

                                        while (true) {
                                            var5[var3_1++] = new String(v0).intern();
                                            if ((var0_5 += var1_4) < var4_3) {
                                                var1_4 = var2_2.charAt(var0_5);
                                                ** continue;
                                            }
                                            break block13;
                                            break;
                                        }
                                        v1 = ++var0_5;
                                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                                        v3 = v2.length;
                                        var6_6 = 0;
                                        v4 = 27;
                                        v5 = v2;
                                        v6 = v3;
                                        if (v3 > 1) ** GOTO lbl67
                                        do {
                                            v7 = v4;
                                            v5 = v5;
                                            v8 = v5;
                                            v9 = v4;
                                            v10 = var6_6;
                                            while (true) {
                                                switch (var6_6 % 7) {
                                                    case 0: {
                                                        v11 = 67;
                                                        break;
                                                    }
                                                    case 1: {
                                                        v11 = 24;
                                                        break;
                                                    }
                                                    case 2: {
                                                        v11 = 41;
                                                        break;
                                                    }
                                                    case 3: {
                                                        v11 = 120;
                                                        break;
                                                    }
                                                    case 4: {
                                                        v11 = 76;
                                                        break;
                                                    }
                                                    case 5: {
                                                        v11 = 85;
                                                        break;
                                                    }
                                                    default: {
                                                        v11 = 101;
                                                    }
                                                }
                                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                                ++var6_6;
                                                v4 = v7;
                                                if (v7 != 0) break;
                                                v7 = v4;
                                                v5 = v5;
                                                v10 = v4;
                                                v8 = v5;
                                                v9 = v4;
                                            }
lbl67:
                                            // 2 sources

                                            v0 = v5;
                                            v6 = v6;
                                        } while (v6 > var6_6);
                                        ** while (true)
                                    }
                                    accept.3.a = var5;
                                    accept.3.b = new String[2];
                                }

                                private static String a(int n2, int n3, int n4) {
                                    int n5 = (n2 ^ n4 ^ 0xFFFFC89B) & 0xFFFF;
                                    if (b[n5] == null) {
                                        int n6;
                                        char[] cArray = a[n5].toCharArray();
                                        int n7 = switch (cArray[0] & 0xFF) {
                                            case 0 -> 248;
                                            case 1 -> 41;
                                            case 2 -> 31;
                                            case 3 -> 3;
                                            case 4 -> 81;
                                            case 5 -> 57;
                                            case 6 -> 50;
                                            case 7 -> 162;
                                            case 8 -> 214;
                                            case 9 -> 28;
                                            case 10 -> 14;
                                            case 11 -> 199;
                                            case 12 -> 111;
                                            case 13 -> 173;
                                            case 14 -> 230;
                                            case 15 -> 102;
                                            case 16 -> 29;
                                            case 17 -> 152;
                                            case 18 -> 25;
                                            case 19 -> 15;
                                            case 20 -> 112;
                                            case 21 -> 180;
                                            case 22 -> 129;
                                            case 23 -> 186;
                                            case 24 -> 198;
                                            case 25 -> 174;
                                            case 26 -> 73;
                                            case 27 -> 5;
                                            case 28 -> 159;
                                            case 29 -> 149;
                                            case 30 -> 27;
                                            case 31 -> 193;
                                            case 32 -> 139;
                                            case 33 -> 207;
                                            case 34 -> 217;
                                            case 35 -> 130;
                                            case 36 -> 42;
                                            case 37 -> 220;
                                            case 38 -> 176;
                                            case 39 -> 183;
                                            case 40 -> 208;
                                            case 41 -> 97;
                                            case 42 -> 175;
                                            case 43 -> 226;
                                            case 44 -> 146;
                                            case 45 -> 254;
                                            case 46 -> 255;
                                            case 47 -> 84;
                                            case 48 -> 114;
                                            case 49 -> 138;
                                            case 50 -> 99;
                                            case 51 -> 211;
                                            case 52 -> 160;
                                            case 53 -> 143;
                                            case 54 -> 108;
                                            case 55 -> 88;
                                            case 56 -> 237;
                                            case 57 -> 224;
                                            case 58 -> 164;
                                            case 59 -> 128;
                                            case 60 -> 8;
                                            case 61 -> 182;
                                            case 62 -> 11;
                                            case 63 -> 239;
                                            case 64 -> 233;
                                            case 65 -> 20;
                                            case 66 -> 55;
                                            case 67 -> 201;
                                            case 68 -> 101;
                                            case 69 -> 21;
                                            case 70 -> 221;
                                            case 71 -> 91;
                                            case 72 -> 213;
                                            case 73 -> 9;
                                            case 74 -> 191;
                                            case 75 -> 196;
                                            case 76 -> 132;
                                            case 77 -> 59;
                                            case 78 -> 192;
                                            case 79 -> 179;
                                            case 80 -> 219;
                                            case 81 -> 250;
                                            case 82 -> 135;
                                            case 83 -> 157;
                                            case 84 -> 168;
                                            case 85 -> 148;
                                            case 86 -> 150;
                                            case 87 -> 22;
                                            case 88 -> 24;
                                            case 89 -> 93;
                                            case 90 -> 154;
                                            case 91 -> 82;
                                            case 92 -> 85;
                                            case 93 -> 92;
                                            case 94 -> 177;
                                            case 95 -> 194;
                                            case 96 -> 53;
                                            case 97 -> 166;
                                            case 98 -> 43;
                                            case 99 -> 204;
                                            case 100 -> 163;
                                            case 101 -> 140;
                                            case 102 -> 95;
                                            case 103 -> 26;
                                            case 104 -> 122;
                                            case 105 -> 153;
                                            case 106 -> 35;
                                            case 107 -> 115;
                                            case 108 -> 106;
                                            case 109 -> 242;
                                            case 110 -> 2;
                                            case 111 -> 203;
                                            case 112 -> 236;
                                            case 113 -> 124;
                                            case 114 -> 62;
                                            case 115 -> 48;
                                            case 116 -> 125;
                                            case 117 -> 141;
                                            case 118 -> 234;
                                            case 119 -> 251;
                                            case 120 -> 77;
                                            case 121 -> 52;
                                            case 122 -> 69;
                                            case 123 -> 225;
                                            case 124 -> 103;
                                            case 125 -> 240;
                                            case 126 -> 184;
                                            case 127 -> 170;
                                            case 128 -> 75;
                                            case 129 -> 206;
                                            case 130 -> 58;
                                            case 131 -> 18;
                                            case 132 -> 19;
                                            case 133 -> 76;
                                            case 134 -> 30;
                                            case 135 -> 105;
                                            case 136 -> 56;
                                            case 137 -> 33;
                                            case 138 -> 79;
                                            case 139 -> 247;
                                            case 140 -> 238;
                                            case 141 -> 34;
                                            case 142 -> 40;
                                            case 143 -> 83;
                                            case 144 -> 228;
                                            case 145 -> 222;
                                            case 146 -> 243;
                                            case 147 -> 209;
                                            case 148 -> 190;
                                            case 149 -> 165;
                                            case 150 -> 227;
                                            case 151 -> 123;
                                            case 152 -> 142;
                                            case 153 -> 253;
                                            case 154 -> 64;
                                            case 155 -> 113;
                                            case 156 -> 16;
                                            case 157 -> 109;
                                            case 158 -> 72;
                                            case 159 -> 94;
                                            case 160 -> 1;
                                            case 161 -> 6;
                                            case 162 -> 245;
                                            case 163 -> 38;
                                            case 164 -> 116;
                                            case 165 -> 188;
                                            case 166 -> 118;
                                            case 167 -> 231;
                                            case 168 -> 44;
                                            case 169 -> 45;
                                            case 170 -> 70;
                                            case 171 -> 98;
                                            case 172 -> 51;
                                            case 173 -> 89;
                                            case 174 -> 120;
                                            case 175 -> 212;
                                            case 176 -> 46;
                                            case 177 -> 136;
                                            case 178 -> 178;
                                            case 179 -> 151;
                                            case 180 -> 63;
                                            case 181 -> 202;
                                            case 182 -> 80;
                                            case 183 -> 171;
                                            case 184 -> 74;
                                            case 185 -> 158;
                                            case 186 -> 133;
                                            case 187 -> 117;
                                            case 188 -> 172;
                                            case 189 -> 104;
                                            case 190 -> 17;
                                            case 191 -> 90;
                                            case 192 -> 87;
                                            case 193 -> 131;
                                            case 194 -> 215;
                                            case 195 -> 161;
                                            case 196 -> 144;
                                            case 197 -> 200;
                                            case 198 -> 96;
                                            case 199 -> 0;
                                            case 200 -> 155;
                                            case 201 -> 32;
                                            case 202 -> 252;
                                            case 203 -> 37;
                                            case 204 -> 13;
                                            case 205 -> 169;
                                            case 206 -> 119;
                                            case 207 -> 216;
                                            case 208 -> 12;
                                            case 209 -> 167;
                                            case 210 -> 156;
                                            case 211 -> 229;
                                            case 212 -> 54;
                                            case 213 -> 241;
                                            case 214 -> 47;
                                            case 215 -> 68;
                                            case 216 -> 249;
                                            case 217 -> 60;
                                            case 218 -> 86;
                                            case 219 -> 121;
                                            case 220 -> 49;
                                            case 221 -> 10;
                                            case 222 -> 78;
                                            case 223 -> 7;
                                            case 224 -> 134;
                                            case 225 -> 66;
                                            case 226 -> 39;
                                            case 227 -> 232;
                                            case 228 -> 65;
                                            case 229 -> 100;
                                            case 230 -> 147;
                                            case 231 -> 223;
                                            case 232 -> 127;
                                            case 233 -> 195;
                                            case 234 -> 246;
                                            case 235 -> 205;
                                            case 236 -> 36;
                                            case 237 -> 210;
                                            case 238 -> 137;
                                            case 239 -> 189;
                                            case 240 -> 181;
                                            case 241 -> 4;
                                            case 242 -> 218;
                                            case 243 -> 235;
                                            case 244 -> 107;
                                            case 245 -> 67;
                                            case 246 -> 110;
                                            case 247 -> 145;
                                            case 248 -> 23;
                                            case 249 -> 187;
                                            case 250 -> 126;
                                            case 251 -> 185;
                                            case 252 -> 197;
                                            case 253 -> 61;
                                            case 254 -> 71;
                                            default -> 244;
                                        };
                                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                                        if (n8 < 0) {
                                            n8 += 256;
                                        }
                                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                                            n6 += 256;
                                        }
                                        int n9 = 0;
                                        while (n9 < cArray.length) {
                                            int n10 = n9 % 2;
                                            int n11 = n9;
                                            char[] cArray2 = cArray;
                                            char c2 = cArray[n11];
                                            if (n10 == 0) {
                                                cArray2[n11] = (char)(c2 ^ n8);
                                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                                            } else {
                                                cArray2[n11] = (char)(c2 ^ n6);
                                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                                            }
                                            ++n9;
                                        }
                                        accept.3.b[n5] = new String(cArray).intern();
                                    }
                                    return b[n5];
                                }
                            };
                            if (string == null) break block32;
                            if (!ActionTimestamp.S()) break block33;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block34;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            ActionTimestamp.S(bl);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 48362778628455L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    String string = SshAgentIpcService.S();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (string != null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1446881730 + -11608, 1446881730 + 12107, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1446881730 + -11612, 1446881730 + 2463, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1446881730 + -11589, 1446881730 + 21621, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1446881730 + -11608, 1446881730 + 12107, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1446881730 + -11612, 1446881730 + 2463, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1446881730 + -11584, 1446881730 + 14567, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    String string2;
                    block13: {
                        long l2 = 71583782272547L;
                        String string3 = SshAgentIpcService.S();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(437642730 + 25041, -437642730 + -14015, (int)l2));
                        string2 = string3;
                        try {
                            try {
                                try {
                                    try {
                                        if (string2 != null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string4 = object.toString();
                                string = string4;
                                object = string4;
                                if (string2 != null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(437642730 + 25038, 437642730 + (char)-31113, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (string2 != null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        String string;
        long l2;
        block25: {
            block26: {
                l2 = 125378700092426L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    string = SshAgentIpcService.S();
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (string != null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (string != null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-14810910 - -7337, 0xE1FF1E - 4798, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-14810910 - -7341, 0xE1FF1E - 30994, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-14810910 - -7342, -14810910 - -29648, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string2 = WindowsNamedPipeAgentIpc.b(-14810910 - -7341, 0xE1FF1E - 30994, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-14810910 - -7335, 0xE1FF1E - 14913, (int)l2) + this.state;
                        throw new IllegalArgumentException(string2.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-14810910 - -7337, 0xE1FF1E - 4798, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-14810910 - -7341, 0xE1FF1E - 30994, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-14810910 - -7357, 0xE1FF1E - 13572, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (string != null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-14810910 - -7337, 0xE1FF1E - 4798, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-14810910 - -7341, 0xE1FF1E - 30994, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-14810910 - -7356, -14810910 - -29377, (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (string != null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-14810910 - -7337, 0xE1FF1E - 4798, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-14810910 - -7341, 0xE1FF1E - 30994, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-14810910 - -7355, 0xE1FF1E - 5810, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                String string;
                block16: {
                    l2 = 99403405287150L;
                    Object object = this.lock;
                    string = SshAgentIpcService.S();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (string != null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16699), 682219350 - (char)-16174, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16703), 682219350 - 23150, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16690), 682219350 - (char)-32174, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16683), -682219350 - -((char)-18605), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16699), 682219350 - (char)-16174, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16703), 682219350 - 23150, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16684), 682219350 - (char)-26019, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (string != null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (string != null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16699), 682219350 - (char)-16174, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16703), 682219350 - 23150, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16685), 682219350 - (char)-17333, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16699), 682219350 - (char)-16174, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16703), 682219350 - 23150, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16686), -682219350 - -24564, (int)l2));
                    if (string != null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16699), 682219350 - (char)-16174, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16703), 682219350 - 23150, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16743), 682219350 - 30052, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-682219350 - -((char)-16744), 682219350 - (char)-24260, (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u0096\u001e\u0090\u00e9\u009dgh\u00d8\u0014\u0098\u00f3i\u00b3\\\u00a4\u00ff\u00ba0\u00ee\u0002QyV\u00a4:-\u009c8\u00e1\u0006qjlgh\u00f7\u0018\u00e8x\u0007\u00f2\u0013I\u0014\u00c7\u0085<\u00bb{(\u00ec\u00dc\u00ef\u008bO\u00c2\u0006\u0010\u00bb\u00d7\u00cf\t\u00bc\"\u0013\b\u00fa\u00891\u0097\u001d\u0005\u00d4'\u00d8\u00ce\u00e4\b\u00ba\u000f\u0015\u00ba\u007f+2\u00b3\u0014\u007f\u00f9\u00edi\u00a1\u00f7uG\u000f\u008cN\u00a9\u00ba\u00eag@G\u0000\u008c0\u0005E\u008b\u00ea[\u00a2\u001e~\u00c4\u0098\u00d6q\t\u00fa\u00b5\u00fdf\u00ff\u00b7\u00ecU\u00e6\u00bc-\u00b4\u00c4\u008d|\u00e5V\u00c9\u0099\u0010^\u00a4\u0094`\u0010F\u00a5{?Z\u0006i\u00ad\u00f2\u00d7\u0093|gy8\u00a6\t\u00f4\u00b1\u00cckR\u00c2\u0002a\u0095\u0010\u00e6\u00b5o=\u00d8F9\u00a5\u00f8\u00d6\u00d2\\O}=&?\u00f25\u0001\u00e8O\u00c7\u00b8\u0000\u00c4\u0001\u009d\u00a0\u001fA\u00a5\u0007\u0080\u00a6\f\n\u00ebG\u00df\u00fb\u00b8\u00bew\u00c5\u0086\u001a\u001b\u001e`n\u00b1\u00bc\u00ef0\u0085\u0084\u00cd\u00ceb\u00d7a\u00d2A\u007f\u007fe\u00e3\u00ce\u001d\u0007\u00ecEV{\u00d6\u0018\u00f5\u00d9\u008c\b{\u00db- xx\u00d2\u00d9\f\u0015\u0007\u00f0\u00a0\u00de\n\u00e8\u0090\u00eb8\u00e2\u0085F\u0002\u00b2\u0012\u0016\u0082\u00dccJ\u009ao\u00c6\u00ab\u00e2(\u0005\fh\u00a0\u0011eZ\u00f8\u00ea>(-\u0096\u00bc\u0005\u001cQ\u00e2\u0015G\u00dd\u00b8\u00b8\u00fd\u00c4\u00f9vt\u009e{ \u00c2=\u0000\u0017r\u0088\u0086\u009f\u0098\u00aa\u00ad\u0001\u0012\u00aa\u0089I\u0082G\u00ab\u008b\u009d\u00e3\u0093\u00a4\u00a6\u001f\u00c9\u001cn\u00cd\u00afj!\u00d9\u0086\u00eb\u0090\u0006\u0001~Ph\u0080\u00c6\f\t\u00ae\u00f5\u00db`I\u00f5S\u00d4(\u009f\u00f6\u000b\u00fd\u00df\u00ed\u00bb}i\u009c\u00fce\u00b99\u0015\u00bd\u00b3\u00e55{\u00d0\u00b0\u00b6\u00de\u0010\u0086\u00b2}D\u00c2y)p\u00e4\u00a6\u0085)%\u00b1\u00f3x\u001c\u00dcW\u000fH1I]>\u001f)A\u00f0k\u00d9\u001b\u00e4\u00cfT?\u00d7WW\u00f8\u0087\u00ee\u0081\u0082\u00f1\u00ee'\u0000\u00f9\u00f7g\u0011\u00a1\u0007a\u00f9qkh\u00e3B\u0007\u008f\u00ec\u00c8\u00a5\u00b8\u00d5N(o=\u00f6\u00c8\f\u00a0\u00a3\u00a7\u00a6\u00f3\u00be3\u00e3S\u00d0K\u00c8\u0087p\u00c5\u00b0*\u00b1H\u00fb\u0005d\u00c9\u00d6\u00a8pS4\u00bf\u0001\u0087\u0087z;S\u000f\u0013\u00987U\u00dc\u007f\u001c\u009f$yO3}\u0007\u009d\"\u00cd\u0092\u00ee\u001c\u00bfP#\u009e\u00c6\u0003\u0098\u001b\u0007\u00dbj\u0017s\u0088#%Q\bB\u0097\u0086\u0016\u00b0\u000e_\u00028\u0018\u00e8N\u000e\u00e30)@\u001f\u00ddd\u00cb+\u00f3\u00aebM'\u001b)!wg/\u008c\u00f7\u00bd\u000e\u00ba\u0087J8\u0014\u00ab\u00f8\u00e3\u00df\u008cS\u009f\u00f2\u00e8n\u0098D&\nW\u00d6|\u009eZW\u008a\u00ec\n\u00f2\u0018\u0099{a!\u00ec\u00f8\u00aem;i\u00e3\u00af\r\u00fb\u00f1$\u00dfE\u00dcy\u00ed\u00fc\u00fd\u00fc)\u00b9p`@n\u00db\u0019\u00ef\u0081-p\u00de\u001df\u00d2\u0015\u00f1\u0094&!!\u0098\u00a5\u00d9\u009c\u0019\u00a3\u00ddJ\u0016\u0083\f\u0094\u00e1^u\b}Y@f\t\u00c1Nj\u008a\u008c1\u008fD\u0099";
                var4_3 = "\u0096\u001e\u0090\u00e9\u009dgh\u00d8\u0014\u0098\u00f3i\u00b3\\\u00a4\u00ff\u00ba0\u00ee\u0002QyV\u00a4:-\u009c8\u00e1\u0006qjlgh\u00f7\u0018\u00e8x\u0007\u00f2\u0013I\u0014\u00c7\u0085<\u00bb{(\u00ec\u00dc\u00ef\u008bO\u00c2\u0006\u0010\u00bb\u00d7\u00cf\t\u00bc\"\u0013\b\u00fa\u00891\u0097\u001d\u0005\u00d4'\u00d8\u00ce\u00e4\b\u00ba\u000f\u0015\u00ba\u007f+2\u00b3\u0014\u007f\u00f9\u00edi\u00a1\u00f7uG\u000f\u008cN\u00a9\u00ba\u00eag@G\u0000\u008c0\u0005E\u008b\u00ea[\u00a2\u001e~\u00c4\u0098\u00d6q\t\u00fa\u00b5\u00fdf\u00ff\u00b7\u00ecU\u00e6\u00bc-\u00b4\u00c4\u008d|\u00e5V\u00c9\u0099\u0010^\u00a4\u0094`\u0010F\u00a5{?Z\u0006i\u00ad\u00f2\u00d7\u0093|gy8\u00a6\t\u00f4\u00b1\u00cckR\u00c2\u0002a\u0095\u0010\u00e6\u00b5o=\u00d8F9\u00a5\u00f8\u00d6\u00d2\\O}=&?\u00f25\u0001\u00e8O\u00c7\u00b8\u0000\u00c4\u0001\u009d\u00a0\u001fA\u00a5\u0007\u0080\u00a6\f\n\u00ebG\u00df\u00fb\u00b8\u00bew\u00c5\u0086\u001a\u001b\u001e`n\u00b1\u00bc\u00ef0\u0085\u0084\u00cd\u00ceb\u00d7a\u00d2A\u007f\u007fe\u00e3\u00ce\u001d\u0007\u00ecEV{\u00d6\u0018\u00f5\u00d9\u008c\b{\u00db- xx\u00d2\u00d9\f\u0015\u0007\u00f0\u00a0\u00de\n\u00e8\u0090\u00eb8\u00e2\u0085F\u0002\u00b2\u0012\u0016\u0082\u00dccJ\u009ao\u00c6\u00ab\u00e2(\u0005\fh\u00a0\u0011eZ\u00f8\u00ea>(-\u0096\u00bc\u0005\u001cQ\u00e2\u0015G\u00dd\u00b8\u00b8\u00fd\u00c4\u00f9vt\u009e{ \u00c2=\u0000\u0017r\u0088\u0086\u009f\u0098\u00aa\u00ad\u0001\u0012\u00aa\u0089I\u0082G\u00ab\u008b\u009d\u00e3\u0093\u00a4\u00a6\u001f\u00c9\u001cn\u00cd\u00afj!\u00d9\u0086\u00eb\u0090\u0006\u0001~Ph\u0080\u00c6\f\t\u00ae\u00f5\u00db`I\u00f5S\u00d4(\u009f\u00f6\u000b\u00fd\u00df\u00ed\u00bb}i\u009c\u00fce\u00b99\u0015\u00bd\u00b3\u00e55{\u00d0\u00b0\u00b6\u00de\u0010\u0086\u00b2}D\u00c2y)p\u00e4\u00a6\u0085)%\u00b1\u00f3x\u001c\u00dcW\u000fH1I]>\u001f)A\u00f0k\u00d9\u001b\u00e4\u00cfT?\u00d7WW\u00f8\u0087\u00ee\u0081\u0082\u00f1\u00ee'\u0000\u00f9\u00f7g\u0011\u00a1\u0007a\u00f9qkh\u00e3B\u0007\u008f\u00ec\u00c8\u00a5\u00b8\u00d5N(o=\u00f6\u00c8\f\u00a0\u00a3\u00a7\u00a6\u00f3\u00be3\u00e3S\u00d0K\u00c8\u0087p\u00c5\u00b0*\u00b1H\u00fb\u0005d\u00c9\u00d6\u00a8pS4\u00bf\u0001\u0087\u0087z;S\u000f\u0013\u00987U\u00dc\u007f\u001c\u009f$yO3}\u0007\u009d\"\u00cd\u0092\u00ee\u001c\u00bfP#\u009e\u00c6\u0003\u0098\u001b\u0007\u00dbj\u0017s\u0088#%Q\bB\u0097\u0086\u0016\u00b0\u000e_\u00028\u0018\u00e8N\u000e\u00e30)@\u001f\u00ddd\u00cb+\u00f3\u00aebM'\u001b)!wg/\u008c\u00f7\u00bd\u000e\u00ba\u0087J8\u0014\u00ab\u00f8\u00e3\u00df\u008cS\u009f\u00f2\u00e8n\u0098D&\nW\u00d6|\u009eZW\u008a\u00ec\n\u00f2\u0018\u0099{a!\u00ec\u00f8\u00aem;i\u00e3\u00af\r\u00fb\u00f1$\u00dfE\u00dcy\u00ed\u00fc\u00fd\u00fc)\u00b9p`@n\u00db\u0019\u00ef\u0081-p\u00de\u001df\u00d2\u0015\u00f1\u0094&!!\u0098\u00a5\u00d9\u009c\u0019\u00a3\u00ddJ\u0016\u0083\f\u0094\u00e1^u\b}Y@f\t\u00c1Nj\u008a\u008c1\u008fD\u0099".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 16;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "=1U\u00cdm\u00cf\u00dc\u00c8\u009clvSxr\u00db2u\u00d9C\u00a9}\u0013x\u00d3)\u00e1!\"/\u0014\u00a0\u0018\u00cbk\u00ad\u001ad\u00c8\u00e6\u0005}\u00893\u00e8HH\u0015w\u009a9";
                    var4_3 = "=1U\u00cdm\u00cf\u00dc\u00c8\u009clvSxr\u00db2u\u00d9C\u00a9}\u0013x\u00d3)\u00e1!\"/\u0014\u00a0\u0018\u00cbk\u00ad\u001ad\u00c8\u00e6\u0005}\u00893\u00e8HH\u0015w\u009a9".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 21;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 67;
                            break;
                        }
                        case 1: {
                            v15 = 112;
                            break;
                        }
                        case 2: {
                            v15 = 54;
                            break;
                        }
                        case 3: {
                            v15 = 23;
                            break;
                        }
                        case 4: {
                            v15 = 117;
                            break;
                        }
                        case 5: {
                            v15 = 2;
                            break;
                        }
                        default: {
                            v15 = 73;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFB98D) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 162;
                case 1 -> 253;
                case 2 -> 185;
                case 3 -> 177;
                case 4 -> 235;
                case 5 -> 85;
                case 6 -> 14;
                case 7 -> 74;
                case 8 -> 123;
                case 9 -> 102;
                case 10 -> 47;
                case 11 -> 81;
                case 12 -> 195;
                case 13 -> 205;
                case 14 -> 252;
                case 15 -> 132;
                case 16 -> 90;
                case 17 -> 230;
                case 18 -> 208;
                case 19 -> 201;
                case 20 -> 254;
                case 21 -> 43;
                case 22 -> 160;
                case 23 -> 231;
                case 24 -> 193;
                case 25 -> 100;
                case 26 -> 86;
                case 27 -> 213;
                case 28 -> 46;
                case 29 -> 57;
                case 30 -> 151;
                case 31 -> 219;
                case 32 -> 210;
                case 33 -> 192;
                case 34 -> 72;
                case 35 -> 118;
                case 36 -> 174;
                case 37 -> 32;
                case 38 -> 226;
                case 39 -> 207;
                case 40 -> 197;
                case 41 -> 108;
                case 42 -> 154;
                case 43 -> 129;
                case 44 -> 117;
                case 45 -> 38;
                case 46 -> 27;
                case 47 -> 209;
                case 48 -> 20;
                case 49 -> 161;
                case 50 -> 50;
                case 51 -> 250;
                case 52 -> 94;
                case 53 -> 12;
                case 54 -> 101;
                case 55 -> 134;
                case 56 -> 191;
                case 57 -> 48;
                case 58 -> 238;
                case 59 -> 139;
                case 60 -> 156;
                case 61 -> 242;
                case 62 -> 68;
                case 63 -> 183;
                case 64 -> 150;
                case 65 -> 112;
                case 66 -> 24;
                case 67 -> 135;
                case 68 -> 45;
                case 69 -> 229;
                case 70 -> 64;
                case 71 -> 34;
                case 72 -> 82;
                case 73 -> 178;
                case 74 -> 182;
                case 75 -> 166;
                case 76 -> 251;
                case 77 -> 234;
                case 78 -> 96;
                case 79 -> 175;
                case 80 -> 148;
                case 81 -> 237;
                case 82 -> 58;
                case 83 -> 246;
                case 84 -> 84;
                case 85 -> 61;
                case 86 -> 49;
                case 87 -> 248;
                case 88 -> 78;
                case 89 -> 17;
                case 90 -> 95;
                case 91 -> 206;
                case 92 -> 214;
                case 93 -> 222;
                case 94 -> 70;
                case 95 -> 7;
                case 96 -> 236;
                case 97 -> 51;
                case 98 -> 75;
                case 99 -> 144;
                case 100 -> 245;
                case 101 -> 80;
                case 102 -> 29;
                case 103 -> 180;
                case 104 -> 40;
                case 105 -> 184;
                case 106 -> 79;
                case 107 -> 203;
                case 108 -> 227;
                case 109 -> 106;
                case 110 -> 232;
                case 111 -> 88;
                case 112 -> 194;
                case 113 -> 83;
                case 114 -> 163;
                case 115 -> 54;
                case 116 -> 71;
                case 117 -> 141;
                case 118 -> 130;
                case 119 -> 218;
                case 120 -> 92;
                case 121 -> 187;
                case 122 -> 170;
                case 123 -> 25;
                case 124 -> 223;
                case 125 -> 186;
                case 126 -> 190;
                case 127 -> 136;
                case 128 -> 243;
                case 129 -> 16;
                case 130 -> 119;
                case 131 -> 33;
                case 132 -> 199;
                case 133 -> 179;
                case 134 -> 67;
                case 135 -> 11;
                case 136 -> 211;
                case 137 -> 133;
                case 138 -> 19;
                case 139 -> 87;
                case 140 -> 122;
                case 141 -> 99;
                case 142 -> 91;
                case 143 -> 41;
                case 144 -> 44;
                case 145 -> 22;
                case 146 -> 200;
                case 147 -> 6;
                case 148 -> 56;
                case 149 -> 165;
                case 150 -> 164;
                case 151 -> 15;
                case 152 -> 97;
                case 153 -> 77;
                case 154 -> 103;
                case 155 -> 2;
                case 156 -> 173;
                case 157 -> 241;
                case 158 -> 5;
                case 159 -> 52;
                case 160 -> 137;
                case 161 -> 0;
                case 162 -> 36;
                case 163 -> 110;
                case 164 -> 35;
                case 165 -> 181;
                case 166 -> 59;
                case 167 -> 131;
                case 168 -> 65;
                case 169 -> 196;
                case 170 -> 167;
                case 171 -> 115;
                case 172 -> 169;
                case 173 -> 153;
                case 174 -> 31;
                case 175 -> 63;
                case 176 -> 220;
                case 177 -> 69;
                case 178 -> 3;
                case 179 -> 168;
                case 180 -> 121;
                case 181 -> 152;
                case 182 -> 255;
                case 183 -> 228;
                case 184 -> 120;
                case 185 -> 107;
                case 186 -> 225;
                case 187 -> 76;
                case 188 -> 37;
                case 189 -> 42;
                case 190 -> 145;
                case 191 -> 109;
                case 192 -> 13;
                case 193 -> 93;
                case 194 -> 105;
                case 195 -> 172;
                case 196 -> 142;
                case 197 -> 239;
                case 198 -> 128;
                case 199 -> 89;
                case 200 -> 111;
                case 201 -> 138;
                case 202 -> 39;
                case 203 -> 233;
                case 204 -> 146;
                case 205 -> 188;
                case 206 -> 204;
                case 207 -> 116;
                case 208 -> 10;
                case 209 -> 73;
                case 210 -> 26;
                case 211 -> 159;
                case 212 -> 149;
                case 213 -> 23;
                case 214 -> 8;
                case 215 -> 240;
                case 216 -> 98;
                case 217 -> 247;
                case 218 -> 1;
                case 219 -> 215;
                case 220 -> 147;
                case 221 -> 217;
                case 222 -> 224;
                case 223 -> 171;
                case 224 -> 198;
                case 225 -> 189;
                case 226 -> 157;
                case 227 -> 221;
                case 228 -> 60;
                case 229 -> 4;
                case 230 -> 18;
                case 231 -> 104;
                case 232 -> 140;
                case 233 -> 66;
                case 234 -> 21;
                case 235 -> 244;
                case 236 -> 155;
                case 237 -> 143;
                case 238 -> 124;
                case 239 -> 55;
                case 240 -> 125;
                case 241 -> 202;
                case 242 -> 113;
                case 243 -> 9;
                case 244 -> 28;
                case 245 -> 30;
                case 246 -> 53;
                case 247 -> 126;
                case 248 -> 62;
                case 249 -> 114;
                case 250 -> 249;
                case 251 -> 127;
                case 252 -> 212;
                case 253 -> 216;
                case 254 -> 158;
                default -> 176;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 68409726671803L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-512352630 + -((char)-1687), 512352630 + (char)-18402, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        String string;
                        block4: {
                            l2 = 134513654847214L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            string = SshAgentIpcService.S();
                            try {
                                hANDLE2 = hANDLE;
                                if (string != null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (string != null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-425846430 + -((char)-20243), 425977500 - (char)-5408, (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-425846430 + -((char)-20244), 425846430 + (char)-21357, (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-425846430 + -((char)-20245), 425846430 + (char)-24125, (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "#m\u0002\u00b0N\u00fc\u00e3\u00f3\u0010\u00fb<\u00e8;\u00a96\u00e6\u00f3\t8\u00db\u0000\u00de\u0007Wc";
                    var4_3 = "#m\u0002\u00b0N\u00fc\u00e3\u00f3\u0010\u00fb<\u00e8;\u00a96\u00e6\u00f3\t8\u00db\u0000\u00de\u0007Wc".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 15;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00d1\u00c2e|\u00eb5\u00d4Y\u00d2c\u00cf=\u000b\u0000\u00fa\u00c4\u000ef\u00aa\u0018\u00e53\u008b\u00e7B:\u00f6\u00a5\u00e3\u00eeP\u000b\u00fc\u0091\u0006\u0093\u00c7f\u00bfT\u0086\u00db\u00ff\u00eb\u00cd,\u00fd<\u0092R7\u0087\u00c1\u00ce\u0013\u00c4N\u00c2\u00e3";
                        var4_3 = "\u00d1\u00c2e|\u00eb5\u00d4Y\u00d2c\u00cf=\u000b\u0000\u00fa\u00c4\u000ef\u00aa\u0018\u00e53\u008b\u00e7B:\u00f6\u00a5\u00e3\u00eeP\u000b\u00fc\u0091\u0006\u0093\u00c7f\u00bfT\u0086\u00db\u00ff\u00eb\u00cd,\u00fd<\u0092R7\u0087\u00c1\u00ce\u0013\u00c4N\u00c2\u00e3".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 92;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 78;
                                break;
                            }
                            case 1: {
                                v15 = 110;
                                break;
                            }
                            case 2: {
                                v15 = 79;
                                break;
                            }
                            case 3: {
                                v15 = 31;
                                break;
                            }
                            case 4: {
                                v15 = 39;
                                break;
                            }
                            case 5: {
                                v15 = 79;
                                break;
                            }
                            default: {
                                v15 = 14;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x3E9A) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 19;
                    case 1 -> 124;
                    case 2 -> 82;
                    case 3 -> 150;
                    case 4 -> 112;
                    case 5 -> 105;
                    case 6 -> 244;
                    case 7 -> 238;
                    case 8 -> 234;
                    case 9 -> 130;
                    case 10 -> 54;
                    case 11 -> 170;
                    case 12 -> 190;
                    case 13 -> 53;
                    case 14 -> 134;
                    case 15 -> 141;
                    case 16 -> 207;
                    case 17 -> 188;
                    case 18 -> 194;
                    case 19 -> 52;
                    case 20 -> 250;
                    case 21 -> 47;
                    case 22 -> 166;
                    case 23 -> 153;
                    case 24 -> 167;
                    case 25 -> 218;
                    case 26 -> 220;
                    case 27 -> 248;
                    case 28 -> 182;
                    case 29 -> 104;
                    case 30 -> 93;
                    case 31 -> 89;
                    case 32 -> 213;
                    case 33 -> 222;
                    case 34 -> 116;
                    case 35 -> 34;
                    case 36 -> 254;
                    case 37 -> 27;
                    case 38 -> 203;
                    case 39 -> 24;
                    case 40 -> 94;
                    case 41 -> 58;
                    case 42 -> 88;
                    case 43 -> 108;
                    case 44 -> 37;
                    case 45 -> 123;
                    case 46 -> 144;
                    case 47 -> 106;
                    case 48 -> 65;
                    case 49 -> 111;
                    case 50 -> 70;
                    case 51 -> 2;
                    case 52 -> 60;
                    case 53 -> 152;
                    case 54 -> 113;
                    case 55 -> 221;
                    case 56 -> 193;
                    case 57 -> 159;
                    case 58 -> 11;
                    case 59 -> 168;
                    case 60 -> 200;
                    case 61 -> 40;
                    case 62 -> 119;
                    case 63 -> 84;
                    case 64 -> 205;
                    case 65 -> 208;
                    case 66 -> 127;
                    case 67 -> 128;
                    case 68 -> 253;
                    case 69 -> 209;
                    case 70 -> 56;
                    case 71 -> 186;
                    case 72 -> 142;
                    case 73 -> 204;
                    case 74 -> 156;
                    case 75 -> 115;
                    case 76 -> 185;
                    case 77 -> 8;
                    case 78 -> 149;
                    case 79 -> 31;
                    case 80 -> 137;
                    case 81 -> 76;
                    case 82 -> 64;
                    case 83 -> 146;
                    case 84 -> 118;
                    case 85 -> 6;
                    case 86 -> 80;
                    case 87 -> 103;
                    case 88 -> 255;
                    case 89 -> 228;
                    case 90 -> 154;
                    case 91 -> 86;
                    case 92 -> 35;
                    case 93 -> 114;
                    case 94 -> 51;
                    case 95 -> 46;
                    case 96 -> 206;
                    case 97 -> 38;
                    case 98 -> 29;
                    case 99 -> 247;
                    case 100 -> 20;
                    case 101 -> 138;
                    case 102 -> 78;
                    case 103 -> 100;
                    case 104 -> 75;
                    case 105 -> 7;
                    case 106 -> 155;
                    case 107 -> 55;
                    case 108 -> 81;
                    case 109 -> 79;
                    case 110 -> 121;
                    case 111 -> 87;
                    case 112 -> 143;
                    case 113 -> 212;
                    case 114 -> 235;
                    case 115 -> 3;
                    case 116 -> 198;
                    case 117 -> 126;
                    case 118 -> 49;
                    case 119 -> 173;
                    case 120 -> 102;
                    case 121 -> 71;
                    case 122 -> 178;
                    case 123 -> 174;
                    case 124 -> 231;
                    case 125 -> 196;
                    case 126 -> 243;
                    case 127 -> 246;
                    case 128 -> 163;
                    case 129 -> 184;
                    case 130 -> 97;
                    case 131 -> 135;
                    case 132 -> 42;
                    case 133 -> 169;
                    case 134 -> 43;
                    case 135 -> 131;
                    case 136 -> 164;
                    case 137 -> 98;
                    case 138 -> 202;
                    case 139 -> 1;
                    case 140 -> 36;
                    case 141 -> 177;
                    case 142 -> 16;
                    case 143 -> 226;
                    case 144 -> 252;
                    case 145 -> 133;
                    case 146 -> 216;
                    case 147 -> 125;
                    case 148 -> 224;
                    case 149 -> 195;
                    case 150 -> 145;
                    case 151 -> 158;
                    case 152 -> 95;
                    case 153 -> 171;
                    case 154 -> 180;
                    case 155 -> 48;
                    case 156 -> 72;
                    case 157 -> 90;
                    case 158 -> 148;
                    case 159 -> 251;
                    case 160 -> 0;
                    case 161 -> 122;
                    case 162 -> 201;
                    case 163 -> 197;
                    case 164 -> 151;
                    case 165 -> 41;
                    case 166 -> 160;
                    case 167 -> 223;
                    case 168 -> 39;
                    case 169 -> 45;
                    case 170 -> 91;
                    case 171 -> 230;
                    case 172 -> 12;
                    case 173 -> 162;
                    case 174 -> 21;
                    case 175 -> 18;
                    case 176 -> 69;
                    case 177 -> 165;
                    case 178 -> 63;
                    case 179 -> 92;
                    case 180 -> 157;
                    case 181 -> 66;
                    case 182 -> 210;
                    case 183 -> 109;
                    case 184 -> 28;
                    case 185 -> 237;
                    case 186 -> 117;
                    case 187 -> 227;
                    case 188 -> 161;
                    case 189 -> 61;
                    case 190 -> 50;
                    case 191 -> 22;
                    case 192 -> 9;
                    case 193 -> 245;
                    case 194 -> 176;
                    case 195 -> 44;
                    case 196 -> 214;
                    case 197 -> 68;
                    case 198 -> 147;
                    case 199 -> 110;
                    case 200 -> 242;
                    case 201 -> 67;
                    case 202 -> 73;
                    case 203 -> 59;
                    case 204 -> 233;
                    case 205 -> 189;
                    case 206 -> 25;
                    case 207 -> 211;
                    case 208 -> 83;
                    case 209 -> 74;
                    case 210 -> 77;
                    case 211 -> 229;
                    case 212 -> 17;
                    case 213 -> 14;
                    case 214 -> 183;
                    case 215 -> 136;
                    case 216 -> 132;
                    case 217 -> 217;
                    case 218 -> 241;
                    case 219 -> 240;
                    case 220 -> 192;
                    case 221 -> 120;
                    case 222 -> 249;
                    case 223 -> 26;
                    case 224 -> 140;
                    case 225 -> 225;
                    case 226 -> 15;
                    case 227 -> 96;
                    case 228 -> 232;
                    case 229 -> 13;
                    case 230 -> 101;
                    case 231 -> 139;
                    case 232 -> 129;
                    case 233 -> 99;
                    case 234 -> 181;
                    case 235 -> 179;
                    case 236 -> 62;
                    case 237 -> 199;
                    case 238 -> 4;
                    case 239 -> 172;
                    case 240 -> 191;
                    case 241 -> 32;
                    case 242 -> 239;
                    case 243 -> 10;
                    case 244 -> 5;
                    case 245 -> 33;
                    case 246 -> 107;
                    case 247 -> 57;
                    case 248 -> 215;
                    case 249 -> 219;
                    case 250 -> 236;
                    case 251 -> 187;
                    case 252 -> 23;
                    case 253 -> 175;
                    case 254 -> 30;
                    default -> 85;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 9012445744155L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "~n\u0011\u001aLz\u000e'\tyd\u0002\u0010\u00018\u0013;\"";
                    var5_4 = "~n\u0011\u001aLz\u000e'\tyd\u0002\u0010\u00018\u0013;\"".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 46;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 59;
                                    break;
                                }
                                case 1: {
                                    v11 = 37;
                                    break;
                                }
                                case 2: {
                                    v11 = 77;
                                    break;
                                }
                                case 3: {
                                    v11 = 90;
                                    break;
                                }
                                case 4: {
                                    v11 = 7;
                                    break;
                                }
                                case 5: {
                                    v11 = 56;
                                    break;
                                }
                                default: {
                                    v11 = 19;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 67083180094188L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "U\u0017\u001adXc2\u0004S\t\u0016~\n_\u0016\u001d~Ta*u\u0017\u0014\t_\u0016\u001d~Ta*y\u001d\rX\u0010\u0000s^l0y\u001a\u0007y_e";
                    var5_4 = "U\u0017\u001adXc2\u0004S\t\u0016~\n_\u0016\u001d~Ta*u\u0017\u0014\t_\u0016\u001d~Ta*y\u001d\rX\u0010\u0000s^l0y\u001a\u0007y_e".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 85;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "m'.Qj^\u000b\u0006m'.QfT";
                        var5_4 = "m'.Qj^\u000b\u0006m'.QfT".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 103;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 73;
                                break;
                            }
                            case 1: {
                                v15 = 44;
                                break;
                            }
                            case 2: {
                                v15 = 38;
                                break;
                            }
                            case 3: {
                                v15 = 69;
                                break;
                            }
                            case 4: {
                                v15 = 100;
                                break;
                            }
                            case 5: {
                                v15 = 87;
                                break;
                            }
                            default: {
                                v15 = 11;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 17877031325026L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1377414630 + 30942, 1377414630 + 29224, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 82334741703444L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = ">\u00d3\u0017Km\u0003\u00b3G\u0012\u0005\u00c6\u00e5.I\u00a9\r9\u00b0\u00e7\u00a9e\u00dc/\u008e\u00c9\u0083\u00c8(w\u0010\u00f6\u00bd\u00d9\u00e3\u009d\u0000\u001b(\u0086\u00d3\u00c2o\u00d0\u0091\u008b\u0081\u0005\u00da\u00d3\u00ad\u008f\u00d93\u0018!\u00e4\u00a6\u00ef\u00ece\u00a14\u001f\u001f\u00df\u00ad\u00d6\bv\u00af\u0085\u009ab\b\u008cS\u00ea\\?\u0080\u0003\u0013|\u00f3\u0017\u00d3\u00c8\u00a9\u0007\u00e9\u009bn\u0003\u0000\u00c1\u0018\u00d6\u00be\u00b4\u00b5\u0096V\u00db\u001f";
                    var4_3 = ">\u00d3\u0017Km\u0003\u00b3G\u0012\u0005\u00c6\u00e5.I\u00a9\r9\u00b0\u00e7\u00a9e\u00dc/\u008e\u00c9\u0083\u00c8(w\u0010\u00f6\u00bd\u00d9\u00e3\u009d\u0000\u001b(\u0086\u00d3\u00c2o\u00d0\u0091\u008b\u0081\u0005\u00da\u00d3\u00ad\u008f\u00d93\u0018!\u00e4\u00a6\u00ef\u00ece\u00a14\u001f\u001f\u00df\u00ad\u00d6\bv\u00af\u0085\u009ab\b\u008cS\u00ea\\?\u0080\u0003\u0013|\u00f3\u0017\u00d3\u00c8\u00a9\u0007\u00e9\u009bn\u0003\u0000\u00c1\u0018\u00d6\u00be\u00b4\u00b5\u0096V\u00db\u001f".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 70;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "7\u001fc5HX#\u00a1\u0003`\u00f0\u009b\u0014\u008d\u0091\u0080L\u008e\u00fe\u00a3\u00c3zN\u000b\r\u008ff\u00cd\u00e2\u00bd,7\u00cd\u00cf\u00a1\u00eb\u0092\u00cctc\u00d5\u00fb\u00b1\u00d3\u0096\u0001\u0005\u00dc\u00d5\u00a4\u00fc\u00b4\u001f\u00fa\u00c4\u00b4\f\u00ef_\u00a8\u00fa?m\u00cc\u0017\t]\u009eN\u00c0\u00df\u00b7\u00a4\u00fe+:vMs;'\u00c9:\f\u0017\u00efi+\u00b5\u00a3\u0091k\u0003";
                        var4_3 = "7\u001fc5HX#\u00a1\u0003`\u00f0\u009b\u0014\u008d\u0091\u0080L\u008e\u00fe\u00a3\u00c3zN\u000b\r\u008ff\u00cd\u00e2\u00bd,7\u00cd\u00cf\u00a1\u00eb\u0092\u00cctc\u00d5\u00fb\u00b1\u00d3\u0096\u0001\u0005\u00dc\u00d5\u00a4\u00fc\u00b4\u001f\u00fa\u00c4\u00b4\f\u00ef_\u00a8\u00fa?m\u00cc\u0017\t]\u009eN\u00c0\u00df\u00b7\u00a4\u00fe+:vMs;'\u00c9:\f\u0017\u00efi+\u00b5\u00a3\u0091k\u0003".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 41;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 19;
                                break;
                            }
                            case 1: {
                                v15 = 57;
                                break;
                            }
                            case 2: {
                                v15 = 20;
                                break;
                            }
                            case 3: {
                                v15 = 125;
                                break;
                            }
                            case 4: {
                                v15 = 62;
                                break;
                            }
                            case 5: {
                                v15 = 78;
                                break;
                            }
                            default: {
                                v15 = 54;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x2BA6) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 236;
                    case 1 -> 248;
                    case 2 -> 141;
                    case 3 -> 74;
                    case 4 -> 46;
                    case 5 -> 251;
                    case 6 -> 40;
                    case 7 -> 54;
                    case 8 -> 85;
                    case 9 -> 202;
                    case 10 -> 73;
                    case 11 -> 237;
                    case 12 -> 234;
                    case 13 -> 113;
                    case 14 -> 143;
                    case 15 -> 52;
                    case 16 -> 204;
                    case 17 -> 249;
                    case 18 -> 118;
                    case 19 -> 31;
                    case 20 -> 47;
                    case 21 -> 70;
                    case 22 -> 80;
                    case 23 -> 109;
                    case 24 -> 23;
                    case 25 -> 128;
                    case 26 -> 59;
                    case 27 -> 27;
                    case 28 -> 155;
                    case 29 -> 199;
                    case 30 -> 224;
                    case 31 -> 230;
                    case 32 -> 156;
                    case 33 -> 157;
                    case 34 -> 50;
                    case 35 -> 120;
                    case 36 -> 246;
                    case 37 -> 123;
                    case 38 -> 21;
                    case 39 -> 179;
                    case 40 -> 162;
                    case 41 -> 6;
                    case 42 -> 255;
                    case 43 -> 233;
                    case 44 -> 147;
                    case 45 -> 160;
                    case 46 -> 239;
                    case 47 -> 214;
                    case 48 -> 71;
                    case 49 -> 57;
                    case 50 -> 149;
                    case 51 -> 104;
                    case 52 -> 30;
                    case 53 -> 222;
                    case 54 -> 93;
                    case 55 -> 216;
                    case 56 -> 198;
                    case 57 -> 101;
                    case 58 -> 200;
                    case 59 -> 13;
                    case 60 -> 183;
                    case 61 -> 191;
                    case 62 -> 250;
                    case 63 -> 145;
                    case 64 -> 217;
                    case 65 -> 24;
                    case 66 -> 227;
                    case 67 -> 99;
                    case 68 -> 219;
                    case 69 -> 84;
                    case 70 -> 67;
                    case 71 -> 127;
                    case 72 -> 148;
                    case 73 -> 16;
                    case 74 -> 170;
                    case 75 -> 3;
                    case 76 -> 102;
                    case 77 -> 90;
                    case 78 -> 112;
                    case 79 -> 111;
                    case 80 -> 69;
                    case 81 -> 100;
                    case 82 -> 142;
                    case 83 -> 97;
                    case 84 -> 152;
                    case 85 -> 106;
                    case 86 -> 220;
                    case 87 -> 119;
                    case 88 -> 42;
                    case 89 -> 194;
                    case 90 -> 189;
                    case 91 -> 92;
                    case 92 -> 63;
                    case 93 -> 238;
                    case 94 -> 186;
                    case 95 -> 213;
                    case 96 -> 130;
                    case 97 -> 68;
                    case 98 -> 29;
                    case 99 -> 105;
                    case 100 -> 5;
                    case 101 -> 146;
                    case 102 -> 116;
                    case 103 -> 0;
                    case 104 -> 226;
                    case 105 -> 129;
                    case 106 -> 163;
                    case 107 -> 98;
                    case 108 -> 201;
                    case 109 -> 4;
                    case 110 -> 77;
                    case 111 -> 117;
                    case 112 -> 193;
                    case 113 -> 221;
                    case 114 -> 28;
                    case 115 -> 86;
                    case 116 -> 124;
                    case 117 -> 207;
                    case 118 -> 49;
                    case 119 -> 180;
                    case 120 -> 44;
                    case 121 -> 195;
                    case 122 -> 243;
                    case 123 -> 229;
                    case 124 -> 197;
                    case 125 -> 56;
                    case 126 -> 10;
                    case 127 -> 75;
                    case 128 -> 154;
                    case 129 -> 103;
                    case 130 -> 254;
                    case 131 -> 177;
                    case 132 -> 83;
                    case 133 -> 241;
                    case 134 -> 210;
                    case 135 -> 62;
                    case 136 -> 131;
                    case 137 -> 235;
                    case 138 -> 58;
                    case 139 -> 231;
                    case 140 -> 22;
                    case 141 -> 175;
                    case 142 -> 110;
                    case 143 -> 158;
                    case 144 -> 190;
                    case 145 -> 136;
                    case 146 -> 95;
                    case 147 -> 17;
                    case 148 -> 61;
                    case 149 -> 151;
                    case 150 -> 164;
                    case 151 -> 211;
                    case 152 -> 82;
                    case 153 -> 165;
                    case 154 -> 96;
                    case 155 -> 245;
                    case 156 -> 223;
                    case 157 -> 41;
                    case 158 -> 212;
                    case 159 -> 125;
                    case 160 -> 173;
                    case 161 -> 107;
                    case 162 -> 205;
                    case 163 -> 45;
                    case 164 -> 244;
                    case 165 -> 35;
                    case 166 -> 192;
                    case 167 -> 196;
                    case 168 -> 247;
                    case 169 -> 51;
                    case 170 -> 11;
                    case 171 -> 252;
                    case 172 -> 72;
                    case 173 -> 91;
                    case 174 -> 140;
                    case 175 -> 178;
                    case 176 -> 121;
                    case 177 -> 108;
                    case 178 -> 185;
                    case 179 -> 33;
                    case 180 -> 66;
                    case 181 -> 48;
                    case 182 -> 36;
                    case 183 -> 32;
                    case 184 -> 26;
                    case 185 -> 218;
                    case 186 -> 94;
                    case 187 -> 225;
                    case 188 -> 228;
                    case 189 -> 19;
                    case 190 -> 115;
                    case 191 -> 171;
                    case 192 -> 114;
                    case 193 -> 43;
                    case 194 -> 34;
                    case 195 -> 209;
                    case 196 -> 39;
                    case 197 -> 126;
                    case 198 -> 242;
                    case 199 -> 81;
                    case 200 -> 134;
                    case 201 -> 232;
                    case 202 -> 188;
                    case 203 -> 169;
                    case 204 -> 7;
                    case 205 -> 15;
                    case 206 -> 159;
                    case 207 -> 18;
                    case 208 -> 253;
                    case 209 -> 53;
                    case 210 -> 153;
                    case 211 -> 144;
                    case 212 -> 12;
                    case 213 -> 168;
                    case 214 -> 2;
                    case 215 -> 38;
                    case 216 -> 182;
                    case 217 -> 64;
                    case 218 -> 174;
                    case 219 -> 65;
                    case 220 -> 138;
                    case 221 -> 172;
                    case 222 -> 176;
                    case 223 -> 1;
                    case 224 -> 9;
                    case 225 -> 122;
                    case 226 -> 184;
                    case 227 -> 187;
                    case 228 -> 20;
                    case 229 -> 25;
                    case 230 -> 132;
                    case 231 -> 150;
                    case 232 -> 206;
                    case 233 -> 139;
                    case 234 -> 87;
                    case 235 -> 181;
                    case 236 -> 76;
                    case 237 -> 78;
                    case 238 -> 8;
                    case 239 -> 37;
                    case 240 -> 137;
                    case 241 -> 161;
                    case 242 -> 55;
                    case 243 -> 60;
                    case 244 -> 208;
                    case 245 -> 89;
                    case 246 -> 79;
                    case 247 -> 14;
                    case 248 -> 203;
                    case 249 -> 166;
                    case 250 -> 133;
                    case 251 -> 88;
                    case 252 -> 215;
                    case 253 -> 240;
                    case 254 -> 167;
                    default -> 135;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 43375148156105L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(-273412020 + -21675, 273412020 + 28317, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 79040659599910L;
                    String string = SshAgentIpcService.S();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-376433040 + -18721, -376433040 + -((char)-29493), (int)l2));
                    String string2 = string;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (string2 != null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 125644566334201L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u0006\u00de\u00fc\u0087\u0003\u0003\u009c\u0089\u00f9";
                var4_3 = "\u0006\u00de\u00fc\u0087\u0003\u0003\u009c\u0089\u00f9".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 127;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 28;
                                break;
                            }
                            case 1: {
                                v11 = 64;
                                break;
                            }
                            case 2: {
                                v11 = 7;
                                break;
                            }
                            case 3: {
                                v11 = 33;
                                break;
                            }
                            case 4: {
                                v11 = 81;
                                break;
                            }
                            case 5: {
                                v11 = 42;
                                break;
                            }
                            default: {
                                v11 = 59;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFFF68) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 17;
                    case 1 -> 166;
                    case 2 -> 72;
                    case 3 -> 255;
                    case 4 -> 170;
                    case 5 -> 91;
                    case 6 -> 84;
                    case 7 -> 65;
                    case 8 -> 52;
                    case 9 -> 219;
                    case 10 -> 152;
                    case 11 -> 183;
                    case 12 -> 22;
                    case 13 -> 136;
                    case 14 -> 174;
                    case 15 -> 240;
                    case 16 -> 96;
                    case 17 -> 231;
                    case 18 -> 48;
                    case 19 -> 124;
                    case 20 -> 216;
                    case 21 -> 35;
                    case 22 -> 110;
                    case 23 -> 25;
                    case 24 -> 14;
                    case 25 -> 39;
                    case 26 -> 226;
                    case 27 -> 243;
                    case 28 -> 54;
                    case 29 -> 199;
                    case 30 -> 5;
                    case 31 -> 129;
                    case 32 -> 43;
                    case 33 -> 101;
                    case 34 -> 181;
                    case 35 -> 26;
                    case 36 -> 156;
                    case 37 -> 19;
                    case 38 -> 237;
                    case 39 -> 212;
                    case 40 -> 115;
                    case 41 -> 104;
                    case 42 -> 213;
                    case 43 -> 117;
                    case 44 -> 224;
                    case 45 -> 132;
                    case 46 -> 141;
                    case 47 -> 202;
                    case 48 -> 185;
                    case 49 -> 127;
                    case 50 -> 249;
                    case 51 -> 128;
                    case 52 -> 13;
                    case 53 -> 68;
                    case 54 -> 239;
                    case 55 -> 220;
                    case 56 -> 233;
                    case 57 -> 8;
                    case 58 -> 94;
                    case 59 -> 37;
                    case 60 -> 195;
                    case 61 -> 204;
                    case 62 -> 42;
                    case 63 -> 93;
                    case 64 -> 144;
                    case 65 -> 73;
                    case 66 -> 138;
                    case 67 -> 36;
                    case 68 -> 76;
                    case 69 -> 234;
                    case 70 -> 250;
                    case 71 -> 55;
                    case 72 -> 53;
                    case 73 -> 130;
                    case 74 -> 140;
                    case 75 -> 66;
                    case 76 -> 1;
                    case 77 -> 23;
                    case 78 -> 44;
                    case 79 -> 218;
                    case 80 -> 151;
                    case 81 -> 209;
                    case 82 -> 177;
                    case 83 -> 137;
                    case 84 -> 158;
                    case 85 -> 18;
                    case 86 -> 59;
                    case 87 -> 184;
                    case 88 -> 193;
                    case 89 -> 187;
                    case 90 -> 61;
                    case 91 -> 246;
                    case 92 -> 227;
                    case 93 -> 164;
                    case 94 -> 98;
                    case 95 -> 236;
                    case 96 -> 189;
                    case 97 -> 81;
                    case 98 -> 82;
                    case 99 -> 116;
                    case 100 -> 111;
                    case 101 -> 148;
                    case 102 -> 90;
                    case 103 -> 201;
                    case 104 -> 15;
                    case 105 -> 114;
                    case 106 -> 92;
                    case 107 -> 208;
                    case 108 -> 113;
                    case 109 -> 108;
                    case 110 -> 149;
                    case 111 -> 122;
                    case 112 -> 30;
                    case 113 -> 10;
                    case 114 -> 205;
                    case 115 -> 253;
                    case 116 -> 238;
                    case 117 -> 162;
                    case 118 -> 75;
                    case 119 -> 47;
                    case 120 -> 134;
                    case 121 -> 29;
                    case 122 -> 126;
                    case 123 -> 143;
                    case 124 -> 12;
                    case 125 -> 77;
                    case 126 -> 123;
                    case 127 -> 254;
                    case 128 -> 87;
                    case 129 -> 222;
                    case 130 -> 16;
                    case 131 -> 223;
                    case 132 -> 38;
                    case 133 -> 56;
                    case 134 -> 119;
                    case 135 -> 228;
                    case 136 -> 251;
                    case 137 -> 0;
                    case 138 -> 85;
                    case 139 -> 248;
                    case 140 -> 245;
                    case 141 -> 40;
                    case 142 -> 88;
                    case 143 -> 27;
                    case 144 -> 171;
                    case 145 -> 190;
                    case 146 -> 50;
                    case 147 -> 155;
                    case 148 -> 244;
                    case 149 -> 203;
                    case 150 -> 207;
                    case 151 -> 49;
                    case 152 -> 28;
                    case 153 -> 9;
                    case 154 -> 32;
                    case 155 -> 107;
                    case 156 -> 198;
                    case 157 -> 51;
                    case 158 -> 58;
                    case 159 -> 2;
                    case 160 -> 64;
                    case 161 -> 97;
                    case 162 -> 83;
                    case 163 -> 139;
                    case 164 -> 235;
                    case 165 -> 131;
                    case 166 -> 102;
                    case 167 -> 188;
                    case 168 -> 225;
                    case 169 -> 179;
                    case 170 -> 175;
                    case 171 -> 99;
                    case 172 -> 33;
                    case 173 -> 182;
                    case 174 -> 70;
                    case 175 -> 86;
                    case 176 -> 153;
                    case 177 -> 230;
                    case 178 -> 24;
                    case 179 -> 74;
                    case 180 -> 169;
                    case 181 -> 69;
                    case 182 -> 146;
                    case 183 -> 154;
                    case 184 -> 160;
                    case 185 -> 109;
                    case 186 -> 147;
                    case 187 -> 194;
                    case 188 -> 214;
                    case 189 -> 7;
                    case 190 -> 172;
                    case 191 -> 60;
                    case 192 -> 178;
                    case 193 -> 120;
                    case 194 -> 229;
                    case 195 -> 221;
                    case 196 -> 105;
                    case 197 -> 135;
                    case 198 -> 145;
                    case 199 -> 62;
                    case 200 -> 173;
                    case 201 -> 196;
                    case 202 -> 150;
                    case 203 -> 89;
                    case 204 -> 211;
                    case 205 -> 41;
                    case 206 -> 95;
                    case 207 -> 186;
                    case 208 -> 168;
                    case 209 -> 192;
                    case 210 -> 103;
                    case 211 -> 241;
                    case 212 -> 31;
                    case 213 -> 159;
                    case 214 -> 112;
                    case 215 -> 215;
                    case 216 -> 34;
                    case 217 -> 63;
                    case 218 -> 45;
                    case 219 -> 78;
                    case 220 -> 176;
                    case 221 -> 200;
                    case 222 -> 167;
                    case 223 -> 21;
                    case 224 -> 121;
                    case 225 -> 118;
                    case 226 -> 163;
                    case 227 -> 242;
                    case 228 -> 232;
                    case 229 -> 180;
                    case 230 -> 20;
                    case 231 -> 165;
                    case 232 -> 80;
                    case 233 -> 3;
                    case 234 -> 79;
                    case 235 -> 252;
                    case 236 -> 57;
                    case 237 -> 67;
                    case 238 -> 157;
                    case 239 -> 210;
                    case 240 -> 4;
                    case 241 -> 217;
                    case 242 -> 11;
                    case 243 -> 161;
                    case 244 -> 197;
                    case 245 -> 106;
                    case 246 -> 133;
                    case 247 -> 100;
                    case 248 -> 142;
                    case 249 -> 191;
                    case 250 -> 46;
                    case 251 -> 125;
                    case 252 -> 6;
                    case 253 -> 71;
                    case 254 -> 206;
                    default -> 247;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

