/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.action.containers;

import com.intellij.docker.action.containers.ContainerActionBase;
import com.intellij.docker.agent.DockerAgentContainer;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.ijent.DockerIjentDeployingStrategy;
import com.intellij.docker.runtimes.DockerApplicationRuntime;
import com.intellij.docker.ui.components.DockerDisposablePanel;
import com.intellij.docker.ui.fileTree.FileSystemTree;
import com.intellij.docker.view.details.DockerDetailsTab;
import com.intellij.docker.view.details.DockerTabManager;
import com.intellij.docker.view.details.container.ContainerBrowserTab;
import com.intellij.docker.view.details.container.DockerContainerBrowser;
import com.intellij.docker.view.details.container.FileSystemTreeFactoryKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.eel.EelApi;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.platform.ijent.IjentPosixApi;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0094@\u00a2\u0006\u0002\u0010\nJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/docker/action/containers/ShowFilesAction;", "Lcom/intellij/docker/action/containers/ContainerActionBase;", "<init>", "()V", "doPerformAction", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "runtime", "Lcom/intellij/docker/runtimes/DockerApplicationRuntime;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lcom/intellij/docker/runtimes/DockerApplicationRuntime;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createFilesPanel", "Lcom/intellij/docker/ui/components/DockerDisposablePanel;", "project", "Lcom/intellij/openapi/project/Project;", "tabManager", "Lcom/intellij/docker/view/details/DockerTabManager;", "createToolbar", "Ljavax/swing/JComponent;", "fileSystemTree", "Lcom/intellij/docker/ui/fileTree/FileSystemTree;", "isEnabled", "", "RefreshAction", "intellij.clouds.docker"})
public final class ShowFilesAction
extends ContainerActionBase {
    @Override
    @Nullable
    protected Object doPerformAction(@NotNull AnActionEvent e, @NotNull DockerApplicationRuntime runtime, @NotNull Continuation<? super Unit> $completion) {
        DockerTabManager tabManager = runtime.getTabManager();
        Project project = e.getProject();
        if (project == null) {
            return Unit.INSTANCE;
        }
        Project project2 = project;
        DockerDetailsTab tab2 = tabManager.findTab(ShowFilesAction::doPerformAction$lambda$0);
        if (tab2 == null) {
            tab2 = new ContainerBrowserTab(tabManager, runtime, (Function0<? extends DockerDisposablePanel>)((Function0)() -> ShowFilesAction.doPerformAction$lambda$1(this, project2, tabManager, runtime)));
            tabManager.addTab(tab2);
            tabManager.selectContent(((ContainerBrowserTab)tab2).getContent());
        } else {
            tabManager.selectContent(tab2.getContent());
        }
        return Unit.INSTANCE;
    }

    private final DockerDisposablePanel createFilesPanel(Project project, DockerTabManager tabManager, DockerApplicationRuntime runtime) {
        if (Registry.Companion.is("docker.containers.show.files.action.with.eel")) {
            JBScrollPane jBScrollPane;
            DockerAgentContainer container = runtime.getAgentContainer();
            Disposable disposable = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
            Disposable disposable2 = disposable;
            String string = DockerBundle.message((String)"ShowFiles.action.progress", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            IjentPosixApi eelApi2 = (IjentPosixApi)TasksKt.runWithModalProgressBlocking((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super IjentPosixApi>, Object>(container, runtime, null){
                int label;
                final /* synthetic */ DockerAgentContainer $container;
                final /* synthetic */ DockerApplicationRuntime $runtime;
                {
                    this.$container = $container;
                    this.$runtime = $runtime;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = DockerIjentDeployingStrategy.Companion.getOrCreateIjentApi(this.$container, this.$runtime.getServer(), (Continuation<? super IjentPosixApi>)((Continuation)this));
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super IjentPosixApi> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            EelApi eelApi3 = (EelApi)eelApi2;
            Project project2 = tabManager.getProject();
            String string2 = container.getContainerName();
            if (string2 == null) {
                string2 = "";
            }
            FileSystemTree fileSystemTree = FileSystemTreeFactoryKt.createTree(eelApi3, project2, string2, disposable2);
            JBScrollPane $this$createFilesPanel_u24lambda_u240 = jBScrollPane = new JBScrollPane((Component)((Object)fileSystemTree));
            boolean bl = false;
            $this$createFilesPanel_u24lambda_u240.setVerticalScrollBarPolicy(20);
            $this$createFilesPanel_u24lambda_u240.setHorizontalScrollBarPolicy(30);
            JBScrollPane tree = jBScrollPane;
            JComponent toolbar = this.createToolbar(fileSystemTree);
            DockerDisposablePanel mainPanel2 = new DockerDisposablePanel((LayoutManager)new BorderLayout());
            Disposer.register((Disposable)((Disposable)mainPanel2), (Disposable)disposable2);
            mainPanel2.add((Component)tree, (Object)"Center");
            mainPanel2.add((Component)toolbar, (Object)"East");
            return mainPanel2;
        }
        return new DockerContainerBrowser(tabManager.getProject(), runtime);
    }

    private final JComponent createToolbar(FileSystemTree fileSystemTree) {
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup $this$createToolbar_u24lambda_u240 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        $this$createToolbar_u24lambda_u240.add((AnAction)new RefreshAction(fileSystemTree));
        DefaultActionGroup actionGroup = defaultActionGroup;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("ShowFilesActionToolbar", (ActionGroup)actionGroup, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar actionToolbar2 = actionToolbar;
        actionToolbar2.setTargetComponent((JComponent)((Object)fileSystemTree));
        JComponent jComponent = actionToolbar2.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @Override
    public boolean isEnabled(@NotNull DockerApplicationRuntime runtime) {
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        return runtime.isRunning();
    }

    private static final boolean doPerformAction$lambda$0(DockerDetailsTab it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof ContainerBrowserTab;
    }

    private static final DockerDisposablePanel doPerformAction$lambda$1(ShowFilesAction this$0, Project $project, DockerTabManager $tabManager, DockerApplicationRuntime $runtime) {
        return this$0.createFilesPanel($project, $tabManager, $runtime);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/docker/action/containers/ShowFilesAction$RefreshAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "fileSystemTree", "Lcom/intellij/docker/ui/fileTree/FileSystemTree;", "<init>", "(Lcom/intellij/docker/action/containers/ShowFilesAction;Lcom/intellij/docker/ui/fileTree/FileSystemTree;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.clouds.docker"})
    public final class RefreshAction
    extends AnAction {
        @NotNull
        private final FileSystemTree fileSystemTree;

        public RefreshAction(FileSystemTree fileSystemTree) {
            Intrinsics.checkNotNullParameter((Object)((Object)fileSystemTree), (String)"fileSystemTree");
            super(DockerBundle.message((String)"ShowFiles.action.refresh.text", (Object[])new Object[0]), DockerBundle.message((String)"ShowFiles.action.refresh.file.tree.description", (Object[])new Object[0]), AllIcons.Actions.Refresh);
            this.fileSystemTree = fileSystemTree;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            FileSystemTree.updateTree$default(this.fileSystemTree, null, 1, null);
        }
    }
}

