/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.deploymentSource;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.deployment.ui.DockerFileDeploymentEditor;
import com.intellij.docker.deployment.ui.DockerImageDeploymentEditor;
import com.intellij.docker.deployment.ui.compose.DockerComposeDeploymentEditor;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerImageDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerDeploymentConfigurator
extends DeploymentConfigurator<DockerDeploymentConfiguration, DockerCloudConfiguration> {
    private final Project myProject;

    public DockerDeploymentConfigurator(Project project) {
        this.myProject = project;
    }

    @NotNull
    public List<DeploymentSource> getAvailableDeploymentSources() {
        List<DeploymentSource> list = Collections.emptyList();
        if (list == null) {
            DockerDeploymentConfigurator.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public DockerDeploymentConfiguration createDefaultConfiguration(@NotNull DeploymentSource source) {
        if (source == null) {
            DockerDeploymentConfigurator.$$$reportNull$$$0(1);
        }
        return new DockerDeploymentConfiguration();
    }

    public SettingsEditor<DockerDeploymentConfiguration> createEditor(@NotNull DeploymentSource source, @Nullable RemoteServer<DockerCloudConfiguration> server2) {
        DeploymentSourceType sourceType;
        if (source == null) {
            DockerDeploymentConfigurator.$$$reportNull$$$0(2);
        }
        if ((sourceType = source.getType()) instanceof DockerComposeDeploymentSourceType && server2 != null) {
            return new DockerComposeDeploymentEditor(this.myProject, server2);
        }
        if (sourceType instanceof DockerImageDeploymentSourceType) {
            return new DockerImageDeploymentEditor(this.myProject);
        }
        return new DockerFileDeploymentEditor(this.myProject);
    }

    public boolean isGeneratedConfigurationName(@NotNull String name, @NotNull DeploymentSource deploymentSource, @NotNull DockerDeploymentConfiguration deploymentConfiguration) {
        if (name == null) {
            DockerDeploymentConfigurator.$$$reportNull$$$0(3);
        }
        if (deploymentSource == null) {
            DockerDeploymentConfigurator.$$$reportNull$$$0(4);
        }
        if (deploymentConfiguration == null) {
            DockerDeploymentConfigurator.$$$reportNull$$$0(5);
        }
        String suggested = this.suggestConfigurationName(deploymentSource, deploymentConfiguration);
        return name.equals(suggested);
    }

    @Nullable
    public String suggestConfigurationName(@NotNull DeploymentSource deploymentSource, @NotNull DockerDeploymentConfiguration deploymentConfiguration) {
        if (deploymentSource == null) {
            DockerDeploymentConfigurator.$$$reportNull$$$0(6);
        }
        if (deploymentConfiguration == null) {
            DockerDeploymentConfigurator.$$$reportNull$$$0(7);
        }
        return Optional.of(deploymentSource.getType()).map(o -> (DockerSingletonDeploymentSourceType)((Object)((Object)ObjectUtils.tryCast((Object)o, DockerSingletonDeploymentSourceType.class)))).map(type -> type.suggestConfigurationName(deploymentConfiguration)).orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/deploymentSource/DockerDeploymentConfigurator";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentSource";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deploymentConfiguration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableDeploymentSources";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/deploymentSource/DockerDeploymentConfigurator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isGeneratedConfigurationName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suggestConfigurationName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

