/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.scss.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.plugins.scss.SCSSFileType;
import org.jetbrains.plugins.scss.psi.ISassScssInclude;
import org.jetbrains.plugins.scss.psi.SCSSDeclaration;
import org.jetbrains.plugins.scss.psi.SCSSFile;
import org.jetbrains.plugins.scss.psi.SassScssFunctionDeclaration;
import org.jetbrains.plugins.scss.psi.SassScssVariable;
import org.jetbrains.plugins.scss.psi.SassScssVariableDeclaration;

public final class SCSSElementGenerator {
    private static final Logger LOG = Logger.getInstance(SCSSElementGenerator.class);

    public static PsiElement createFunctionName(Project project, String name) {
        SCSSFile file = SCSSElementGenerator.createFileFromText(project, "@function " + name + "() {\n}");
        SassScssFunctionDeclaration functionDeclaration = (SassScssFunctionDeclaration)PsiTreeUtil.findChildOfType((PsiElement)file, SassScssFunctionDeclaration.class);
        LOG.assertTrue(functionDeclaration != null, (Object)name);
        PsiElement identifier = functionDeclaration.getNameIdentifier();
        LOG.assertTrue(identifier != null, (Object)name);
        return identifier;
    }

    public static SCSSFile createFileFromText(Project project, String text) {
        return (SCSSFile)PsiFileFactory.getInstance((Project)project).createFileFromText("foo.scss", (FileType)SCSSFileType.SCSS, (CharSequence)text);
    }

    public static SassScssVariableDeclaration createVariableDeclaration(Project project, String name, String value) {
        String assignmentText = "$" + name + ": " + value + ";";
        SCSSFile file = SCSSElementGenerator.createFileFromText(project, assignmentText);
        SassScssVariableDeclaration variableDeclaration = (SassScssVariableDeclaration)PsiTreeUtil.findChildOfType((PsiElement)file, SassScssVariableDeclaration.class);
        LOG.assertTrue(variableDeclaration != null, (Object)assignmentText);
        return variableDeclaration;
    }

    public static SassScssVariable createSCSSVariable(Project project, String text) {
        SCSSFile file = SCSSElementGenerator.createFileFromText(project, "#header {\n fake: " + SCSSElementGenerator.createNewVariableName(text) + ";\n}");
        CssDeclaration declaration = (CssDeclaration)PsiTreeUtil.findChildOfType((PsiElement)file, CssDeclaration.class);
        LOG.assertTrue(declaration != null, (Object)text);
        SassScssVariable variable = (SassScssVariable)PsiTreeUtil.findChildOfType((PsiElement)declaration, SassScssVariable.class);
        LOG.assertTrue(variable != null, (Object)text);
        return variable;
    }

    public static PsiElement createMixinName(Project project, String name) {
        SCSSFile file = SCSSElementGenerator.createFileFromText(project, "@mixin " + name + " {\n}");
        SCSSDeclaration mixinDeclaration = (SCSSDeclaration)PsiTreeUtil.findChildOfType((PsiElement)file, SCSSDeclaration.class);
        LOG.assertTrue(mixinDeclaration != null, (Object)name);
        PsiElement identifier = mixinDeclaration.getNameIdentifier();
        LOG.assertTrue(identifier != null, (Object)name);
        return identifier;
    }

    public static PsiElement createIncludeName(Project project, String name) {
        SCSSFile file = SCSSElementGenerator.createFileFromText(project, "#head {\n @include " + name + ";\n}");
        ISassScssInclude include = (ISassScssInclude)PsiTreeUtil.findChildOfType((PsiElement)file, ISassScssInclude.class);
        LOG.assertTrue(include != null, (Object)name);
        PsiElement mixinNameElement = include.getMixinNameElement();
        LOG.assertTrue(mixinNameElement != null, (Object)name);
        return mixinNameElement;
    }

    public static String createNewVariableName(String name) {
        return StringUtil.startsWithChar((CharSequence)name, (char)'$') ? name : "$" + name;
    }
}

