/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssStylesheetResolver;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.impl.CssStubStylesheet;
import com.intellij.psi.css.util.CssResolveUtil;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001b\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\tJ\u001b\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\fJ#\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J0\u0010\u0013\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u00142\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0002J1\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\u0006\u0010\b\u001a\u00020\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u0017J)\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\u00022\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016H\u0002\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/intellij/psi/css/impl/CssStubStylesheetResolver;", "Lcom/intellij/psi/css/CssStylesheetResolver;", "Lcom/intellij/psi/css/impl/CssStubStylesheet;", "<init>", "()V", "getAtRules", "", "Lcom/intellij/psi/css/CssAtRule;", "styleSheet", "(Lcom/intellij/psi/css/impl/CssStubStylesheet;)[Lcom/intellij/psi/css/CssAtRule;", "getRulesets", "Lcom/intellij/psi/css/CssRuleset;", "(Lcom/intellij/psi/css/impl/CssStubStylesheet;)[Lcom/intellij/psi/css/CssRuleset;", "allMedias", "", "(Lcom/intellij/psi/css/impl/CssStubStylesheet;Z)[Lcom/intellij/psi/css/CssRuleset;", "getDependentStylesheets", "", "Lcom/intellij/psi/css/CssStylesheet;", "getRulesetsAndDependentStylesheets", "Lkotlin/Pair;", "includedFiles", "", "(Lcom/intellij/psi/css/impl/CssStubStylesheet;Ljava/util/Set;Z)[Lcom/intellij/psi/css/CssRuleset;", "(Lcom/intellij/psi/css/impl/CssStubStylesheet;Ljava/util/Set;)[Lcom/intellij/psi/css/CssAtRule;", "intellij.css.backend"})
@SourceDebugExtension(value={"SMAP\nCssStubStylesheetResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CssStubStylesheetResolver.kt\ncom/intellij/psi/css/impl/CssStubStylesheetResolver\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,82:1\n37#2,2:83\n37#2,2:85\n*S KotlinDebug\n*F\n+ 1 CssStubStylesheetResolver.kt\ncom/intellij/psi/css/impl/CssStubStylesheetResolver\n*L\n54#1:83,2\n79#1:85,2\n*E\n"})
public final class CssStubStylesheetResolver
implements CssStylesheetResolver<CssStubStylesheet> {
    @NotNull
    public CssAtRule[] getAtRules(@NotNull CssStubStylesheet styleSheet) {
        Intrinsics.checkNotNullParameter((Object)styleSheet, (String)"styleSheet");
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)styleSheet), () -> CssStubStylesheetResolver.getAtRules$lambda$0(this, styleSheet));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (CssAtRule[])object;
    }

    @NotNull
    public CssRuleset[] getRulesets(@NotNull CssStubStylesheet styleSheet) {
        Intrinsics.checkNotNullParameter((Object)styleSheet, (String)"styleSheet");
        return this.getRulesets(styleSheet, false);
    }

    @NotNull
    public CssRuleset[] getRulesets(@NotNull CssStubStylesheet styleSheet, boolean allMedias) {
        Intrinsics.checkNotNullParameter((Object)styleSheet, (String)"styleSheet");
        return (CssRuleset[])this.getRulesetsAndDependentStylesheets(styleSheet, allMedias).getFirst();
    }

    @NotNull
    public List<CssStylesheet> getDependentStylesheets(@NotNull CssStubStylesheet styleSheet, boolean allMedias) {
        Intrinsics.checkNotNullParameter((Object)styleSheet, (String)"styleSheet");
        return (List)this.getRulesetsAndDependentStylesheets(styleSheet, allMedias).getSecond();
    }

    private final Pair<CssRuleset[], List<CssStylesheet>> getRulesetsAndDependentStylesheets(CssStubStylesheet styleSheet, boolean allMedias) {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)styleSheet), () -> CssStubStylesheetResolver.getRulesetsAndDependentStylesheets$lambda$0(this, styleSheet, allMedias));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (Pair)object;
    }

    private final CssRuleset[] getRulesets(CssStubStylesheet styleSheet, Set<CssStylesheet> includedFiles, boolean allMedias) {
        if (includedFiles.contains(styleSheet)) {
            Intrinsics.checkNotNullExpressionValue((Object)CssRuleset.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return CssRuleset.EMPTY_ARRAY;
        }
        includedFiles.add((CssStylesheet)styleSheet);
        Collection collection = new ArrayList();
        for (CssImport cssImport : styleSheet.getImports()) {
            PsiFile[] stylesheetFiles;
            if (!allMedias && !cssImport.isScreen()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)CssResolveUtil.resolveImport((CssImport)cssImport), (String)"resolveImport(...)");
            for (PsiFile stylesheetFile : stylesheetFiles) {
                CssStylesheet stylesheet;
                if (!(stylesheetFile instanceof StylesheetFile) || !((stylesheet = ((StylesheetFile)stylesheetFile).getStylesheet()) instanceof CssStubStylesheet)) continue;
                CollectionsKt.addAll((Collection)collection, (Object[])this.getRulesets((CssStubStylesheet)stylesheet, includedFiles, allMedias));
            }
        }
        Collection collection2 = collection;
        CssRuleset[] cssRulesetArray = styleSheet.getRulesetList().getRulesets(allMedias);
        Intrinsics.checkNotNullExpressionValue((Object)cssRulesetArray, (String)"getRulesets(...)");
        CollectionsKt.addAll((Collection)collection2, (Object[])cssRulesetArray);
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new CssRuleset[0]);
    }

    private final CssAtRule[] getAtRules(CssStubStylesheet styleSheet, Set<CssStylesheet> includedFiles) {
        if (includedFiles.contains(styleSheet)) {
            Intrinsics.checkNotNullExpressionValue((Object)CssAtRule.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return CssAtRule.EMPTY_ARRAY;
        }
        includedFiles.add((CssStylesheet)styleSheet);
        Collection atRules = new ArrayList();
        for (CssImport cssImport : styleSheet.getImports()) {
            PsiFile[] stylesheetFiles;
            if (!cssImport.isScreen()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)CssResolveUtil.resolveImport((CssImport)cssImport), (String)"resolveImport(...)");
            for (PsiFile stylesheetFile : stylesheetFiles) {
                CssStylesheet stylesheet;
                if (!(stylesheetFile instanceof StylesheetFile) || !((stylesheet = ((StylesheetFile)stylesheetFile).getStylesheet()) instanceof CssStubStylesheet)) continue;
                CollectionsKt.addAll((Collection)atRules, (Object[])this.getAtRules((CssStubStylesheet)stylesheet, includedFiles));
            }
        }
        Collection collection = atRules;
        CssAtRule[] cssAtRuleArray = styleSheet.getRulesetList().getAtRules();
        Intrinsics.checkNotNullExpressionValue((Object)cssAtRuleArray, (String)"getAtRules(...)");
        CollectionsKt.addAll((Collection)collection, (Object[])cssAtRuleArray);
        Collection $this$toTypedArray$iv = atRules;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new CssAtRule[0]);
    }

    private static final CachedValueProvider.Result getAtRules$lambda$0(CssStubStylesheetResolver this$0, CssStubStylesheet $styleSheet) {
        Set dependentStylesheets = new HashSet();
        Object[] objectArray = new Object[]{ArrayUtil.toObjectArray((Collection)dependentStylesheets)};
        return CachedValueProvider.Result.create((Object)this$0.getAtRules($styleSheet, dependentStylesheets), (Object[])objectArray);
    }

    private static final CachedValueProvider.Result getRulesetsAndDependentStylesheets$lambda$0(CssStubStylesheetResolver this$0, CssStubStylesheet $styleSheet, boolean $allMedias) {
        Set dependentStylesheets = new LinkedHashSet();
        Object[] objectArray = new Object[]{ArrayUtil.toObjectArray((Collection)dependentStylesheets)};
        return CachedValueProvider.Result.create((Object)TuplesKt.to((Object)this$0.getRulesets($styleSheet, dependentStylesheets, $allMedias), (Object)CollectionsKt.toList((Iterable)dependentStylesheets)), (Object[])objectArray);
    }
}

