/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.image;

import com.intellij.ide.CopyProvider;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterImageOutputComponentFactory;
import com.intellij.jupyter.core.jupyter.editor.outputs.JupyterImageOutputDataKey;
import com.intellij.jupyter.core.jupyter.editor.outputs.image.ImageColorThemeInverter;
import com.intellij.jupyter.core.jupyter.editor.outputs.image.ImageErrorPanel;
import com.intellij.jupyter.core.jupyter.editor.outputs.image.ImageInvertType;
import com.intellij.jupyter.core.jupyter.editor.outputs.image.ImagePanel;
import com.intellij.jupyter.core.jupyter.editor.outputs.image.JupyterImageErrorLogger;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.appBasedApi.scriptLoader.utils.JupyterCoroutineKt;
import com.intellij.notebooks.visualization.outputs.NotebookLazyOutputComponent;
import com.intellij.notebooks.visualization.outputs.NotebookOutputInlayShowable;
import com.intellij.notebooks.visualization.r.inlays.ClipboardUtils;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 72\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u00017B\u001d\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u001f\u001a\u0004\u0018\u00010 J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0016J\u0006\u0010$\u001a\u00020\"J\u0012\u0010%\u001a\u00020\"2\b\b\u0002\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\u000b\u0010-\u001a\u00070.\u00a2\u0006\u0002\b/J\u0010\u00100\u001a\u00020\"2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020\u00122\u0006\u00101\u001a\u000202H\u0016J\u0010\u00104\u001a\u00020\u00122\u0006\u00101\u001a\u000202H\u0016J\b\u00105\u001a\u000206H\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001bR$\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0015\"\u0004\b\u001e\u0010\u0017\u00a8\u00068"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/image/ImageComponentWrapper;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "Lcom/intellij/ide/CopyProvider;", "Lcom/intellij/notebooks/visualization/outputs/NotebookOutputInlayShowable;", "Lcom/intellij/notebooks/visualization/outputs/NotebookLazyOutputComponent;", "output", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterImageOutputDataKey;", "editorWidthProvider", "Lkotlin/Function0;", "", "<init>", "(Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterImageOutputDataKey;Lkotlin/jvm/functions/Function0;)V", "getOutput", "()Lcom/intellij/jupyter/core/jupyter/editor/outputs/JupyterImageOutputDataKey;", "imageComponent", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/image/ImagePanel;", "value", "", "shown", "getShown", "()Z", "setShown", "(Z)V", "ready", "getReady", "wasDarkEditor", "Ljava/lang/Boolean;", "maximized", "getMaximized", "setMaximized", "getImage", "Ljava/awt/image/BufferedImage;", "initImage", "", "updateUI", "invertImage", "updateImage", "invertType", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/image/ImageInvertType;", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "getPreferredSize", "Ljava/awt/Dimension;", "collapsedText", "", "Lorg/jetbrains/annotations/Nls;", "performCopy", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isCopyEnabled", "isCopyVisible", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "Companion", "intellij.jupyter.core"})
public final class ImageComponentWrapper
extends JPanel
implements UiDataProvider,
CopyProvider,
NotebookOutputInlayShowable,
NotebookLazyOutputComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JupyterImageOutputDataKey output;
    @NotNull
    private final Function0<Integer> editorWidthProvider;
    @Nullable
    private ImagePanel imageComponent;
    private boolean shown;
    @Nullable
    private Boolean wasDarkEditor;
    private boolean maximized;
    @NotNull
    private static final DataKey<Pair<String, String>> ORIGINAL_IMAGE = DataKey.Companion.create(JupyterImageOutputComponentFactory.class.getSimpleName() + ".ORIGINAL_IMAGE");
    @NotNull
    private static final DataKey<ImageComponentWrapper> IMAGE_COMPONENT = DataKey.Companion.create(JupyterImageOutputComponentFactory.class.getSimpleName() + ".IMAGE_COMPONENT");

    public ImageComponentWrapper(@NotNull JupyterImageOutputDataKey output, @NotNull Function0<Integer> editorWidthProvider) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter(editorWidthProvider, (String)"editorWidthProvider");
        super(new BorderLayout());
        this.output = output;
        this.editorWidthProvider = editorWidthProvider;
        this.setOpaque(false);
    }

    @NotNull
    public final JupyterImageOutputDataKey getOutput() {
        return this.output;
    }

    public boolean getShown() {
        return this.shown;
    }

    public void setShown(boolean value) {
        if (this.shown == value) {
            return;
        }
        this.shown = value;
        this.initImage();
    }

    public boolean getReady() {
        return this.imageComponent != null;
    }

    public final boolean getMaximized() {
        return this.maximized;
    }

    public final void setMaximized(boolean value) {
        if (this.maximized == value) {
            return;
        }
        boolean oldValue = this.maximized;
        this.maximized = value;
        this.firePropertyChange("maximized", oldValue, value);
        this.revalidate();
    }

    @Nullable
    public final BufferedImage getImage() {
        ImagePanel imagePanel = this.imageComponent;
        return imagePanel != null ? imagePanel.getImage() : null;
    }

    private final void initImage() {
        if (this.imageComponent != null) {
            return;
        }
        this.add((Component)BuilderKt.panel(ImageComponentWrapper::initImage$lambda$0), "Center");
        JupyterCoroutineKt.launchIO((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ ImageComponentWrapper this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        BufferedImage resultImage = ImageColorThemeInverter.invertImageIfNeeded$default(ImageColorThemeInverter.INSTANCE, this.this$0.getOutput().getData(), false, null, 6, null);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)resultImage);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, resultImage, null){
                            int label;
                            final /* synthetic */ ImageComponentWrapper this$0;
                            final /* synthetic */ BufferedImage $resultImage;
                            {
                                this.this$0 = $receiver;
                                this.$resultImage = $resultImage;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        ImagePanel imagePanel = new ImagePanel();
                                        BufferedImage bufferedImage = this.$resultImage;
                                        ImagePanel $this$invokeSuspend_u24lambda_u240 = imagePanel;
                                        boolean bl = false;
                                        $this$invokeSuspend_u24lambda_u240.setOpaque(false);
                                        $this$invokeSuspend_u24lambda_u240.setImage(bufferedImage);
                                        $this$invokeSuspend_u24lambda_u240.setCursor(Cursor.getDefaultCursor());
                                        ImagePanel imageComponent = imagePanel;
                                        ImageComponentWrapper.access$setImageComponent$p(this.this$0, imageComponent);
                                        this.this$0.removeAll();
                                        this.this$0.add((Component)((Object)imageComponent), "Center");
                                        ImageComponentWrapper.access$setWasDarkEditor$p(this.this$0, Boxing.boxBoolean((boolean)ImageColorThemeInverter.INSTANCE.isDarkEditor$intellij_jupyter_core()));
                                        new DoubleClickListener(this.this$0){
                                            final /* synthetic */ ImageComponentWrapper this$0;
                                            {
                                                this.this$0 = $receiver;
                                            }

                                            protected boolean onDoubleClick(MouseEvent e) {
                                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                                this.this$0.setMaximized(!this.this$0.getMaximized());
                                                return true;
                                            }
                                        }.installOn((Component)this.this$0);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        Object object3;
                        Object object2;
                        BufferedImage resultImage = (BufferedImage)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            object2 = $result;
                            return Unit.INSTANCE;
                        }
                        catch (Throwable err) {
                            this.L$0 = SpillingKt.nullOutSpilledVariable((Object)err);
                            this.label = 2;
                            object3 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(err, this.this$0, null){
                                int label;
                                final /* synthetic */ Throwable $err;
                                final /* synthetic */ ImageComponentWrapper this$0;
                                {
                                    this.$err = $err;
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            JupyterImageErrorLogger.INSTANCE.logError$intellij_jupyter_core(this.$err, "Failed to render an image of the " + this.this$0.getOutput().getImageFormat() + " format.", this.this$0.getOutput().getData());
                                            ImageComponentWrapper.access$setImageComponent$p(this.this$0, null);
                                            this.this$0.removeAll();
                                            this.this$0.add((Component)new ImageErrorPanel(), "Center");
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object) return Unit.INSTANCE;
                            return object;
                        }
                    }
                    case 2: {
                        Throwable err = (Throwable)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @Override
    public void updateUI() {
        super.updateUI();
        boolean isDarkEditor = ImageColorThemeInverter.INSTANCE.isDarkEditor$intellij_jupyter_core();
        if (this.imageComponent == null) {
            return;
        }
        if (Intrinsics.areEqual((Object)this.wasDarkEditor, (Object)isDarkEditor)) {
            return;
        }
        this.wasDarkEditor = isDarkEditor;
        ImageComponentWrapper.updateImage$default(this, null, 1, null);
    }

    public final void invertImage() {
        Boolean bl = this.wasDarkEditor;
        if (bl == null) {
            return;
        }
        boolean isNewLight = bl;
        this.wasDarkEditor = !isNewLight;
        ImageInvertType updateType = isNewLight ? ImageInvertType.FORCE_LIGHT : ImageInvertType.FORCE_DARK;
        this.updateImage(updateType);
    }

    private final void updateImage(ImageInvertType invertType) {
        JupyterCoroutineKt.launchIO((Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, invertType, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ ImageComponentWrapper this$0;
            final /* synthetic */ ImageInvertType $invertType;
            {
                this.this$0 = $receiver;
                this.$invertType = $invertType;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        String outputData = this.this$0.getOutput().getData();
                        BufferedImage invertedImage = ImageColorThemeInverter.invertImageIfNeeded$default(ImageColorThemeInverter.INSTANCE, outputData, false, this.$invertType, 2, null);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)outputData);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)invertedImage);
                        this.label = 1;
                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, invertedImage, null){
                            int label;
                            final /* synthetic */ ImageComponentWrapper this$0;
                            final /* synthetic */ BufferedImage $invertedImage;
                            {
                                this.this$0 = $receiver;
                                this.$invertedImage = $invertedImage;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        ImagePanel imagePanel = ImageComponentWrapper.access$getImageComponent$p(this.this$0);
                                        if (imagePanel != null) {
                                            imagePanel.setImage(this.$invertedImage);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        BufferedImage invertedImage = (BufferedImage)this.L$1;
                        String outputData = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    static /* synthetic */ void updateImage$default(ImageComponentWrapper imageComponentWrapper, ImageInvertType imageInvertType, int n, Object object) {
        if ((n & 1) != 0) {
            imageInvertType = ImageInvertType.AUTO;
        }
        imageComponentWrapper.updateImage(imageInvertType);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        ImagePanel imageComponent = this.imageComponent;
        if (imageComponent != null) {
            String string = this.output.getImageFormat().name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            sink.set(ORIGINAL_IMAGE, (Object)TuplesKt.to((Object)string2, (Object)this.output.getData()));
        }
        DataKey dataKey = PlatformDataKeys.COPY_PROVIDER;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"COPY_PROVIDER");
        sink.set(dataKey, (Object)this);
        sink.set(IMAGE_COMPONENT, (Object)this);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        BufferedImage image;
        if (!this.maximized && this.output.getSize() != null) {
            return new Dimension(this.output.getSize().getWidth(), this.output.getSize().getHeight());
        }
        ImagePanel imagePanel = this.imageComponent;
        BufferedImage bufferedImage = image = imagePanel != null ? imagePanel.getImage() : null;
        if (image == null) {
            Dimension size = super.getPreferredSize();
            return new Dimension(RangesKt.coerceAtLeast((int)size.width, (int)1), RangesKt.coerceAtLeast((int)size.height, (int)1));
        }
        int width = ((Number)this.editorWidthProvider.invoke()).intValue();
        return width == 0 || !this.maximized && image.getWidth() < width ? new Dimension(image.getWidth(), image.getHeight()) : new Dimension(width, image.getHeight() * width / image.getWidth());
    }

    @NotNull
    public final String collapsedText() {
        String string;
        BufferedImage image;
        ImagePanel imagePanel = this.imageComponent;
        BufferedImage bufferedImage = image = imagePanel != null ? imagePanel.getImage() : null;
        if (image == null) {
            string = JupyterBundle.message("notebook.collapsed.image.output.not.loaded.text", new Object[0]);
        } else {
            Object[] objectArray = new Object[]{image.getWidth(), image.getHeight()};
            string = JupyterBundle.message("notebook.collapsed.image.output.text", objectArray);
        }
        return string;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Object object = this.imageComponent;
        if (object == null || (object = object.getImage()) == null) {
            return;
        }
        Object image = object;
        ClipboardUtils.INSTANCE.copyImageToClipboard((Image)image);
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private static final Unit initImage$lambda$0(Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, ImageComponentWrapper::initImage$lambda$0$0, (int)1, null);
        return Unit.INSTANCE;
    }

    private static final Unit initImage$lambda$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell((JComponent)new AsyncProcessIcon("Loading"));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$setImageComponent$p(ImageComponentWrapper $this, ImagePanel imagePanel) {
        $this.imageComponent = imagePanel;
    }

    public static final /* synthetic */ void access$setWasDarkEditor$p(ImageComponentWrapper $this, Boolean bl) {
        $this.wasDarkEditor = bl;
    }

    public static final /* synthetic */ ImagePanel access$getImageComponent$p(ImageComponentWrapper $this) {
        return $this.imageComponent;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/image/ImageComponentWrapper$Companion;", "", "<init>", "()V", "ORIGINAL_IMAGE", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lkotlin/Pair;", "", "getORIGINAL_IMAGE", "()Lcom/intellij/openapi/actionSystem/DataKey;", "IMAGE_COMPONENT", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/image/ImageComponentWrapper;", "getIMAGE_COMPONENT", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataKey<Pair<String, String>> getORIGINAL_IMAGE() {
            return ORIGINAL_IMAGE;
        }

        @NotNull
        public final DataKey<ImageComponentWrapper> getIMAGE_COMPONENT() {
            return IMAGE_COMPONENT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

