/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.nbformat;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterAllMetadataAware;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterMetadataAware;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00040\u0003B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\n\u001a\u00020\u0004J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010\f\u001a\u00020\u0004H\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\b\u0010\u0016\u001a\u00020\u0004H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0004H\u0016R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterMetadataAwareBase;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterMetadataAware;", "Lcom/fasterxml/jackson/databind/JsonNode;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterAllMetadataAware;", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "<init>", "()V", "content", "getContent", "()Lcom/fasterxml/jackson/databind/node/ObjectNode;", "getOrCreateMetadata", "getMetadata", "createMetadata", "getKeys", "", "", "key", "removeMetadata", "", "cleanup", "setMetadata", "value", "getAllMetadataDeepCopy", "setAllMetadataFrom", "intellij.jupyter.core"})
public abstract class JupyterMetadataAwareBase
implements JupyterMetadataAware<JsonNode>,
JupyterAllMetadataAware<ObjectNode> {
    @NotNull
    protected abstract ObjectNode getContent();

    @NotNull
    public final ObjectNode getOrCreateMetadata() {
        ObjectNode objectNode = this.getMetadata();
        if (objectNode == null) {
            objectNode = this.createMetadata();
        }
        return objectNode;
    }

    @Nullable
    public ObjectNode getMetadata() {
        JsonNode jsonNode = this.getContent().get("metadata");
        return jsonNode instanceof ObjectNode ? (ObjectNode)jsonNode : null;
    }

    @NotNull
    public ObjectNode createMetadata() {
        if (!this.getContent().has("metadata") && !(this.getContent().get("metadata") instanceof ObjectNode)) {
            this.getContent().putObject("metadata");
        }
        JsonNode jsonNode = this.getContent().get("metadata");
        Intrinsics.checkNotNull((Object)jsonNode, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
        return (ObjectNode)jsonNode;
    }

    @Override
    @NotNull
    public Set<String> getKeys() {
        Object object = this.getMetadata();
        if (object == null || (object = object.fieldNames()) == null || (object = SequencesKt.asSequence((Iterator)object)) == null || (object = SequencesKt.toSet((Sequence)object)) == null) {
            object = SetsKt.emptySet();
        }
        return object;
    }

    @Override
    @Nullable
    public JsonNode getMetadata(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ObjectNode objectNode = this.getMetadata();
        return objectNode != null ? objectNode.get(key) : null;
    }

    @Override
    public void removeMetadata(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ObjectNode objectNode = this.getMetadata();
        if (objectNode != null) {
            objectNode.remove(key);
        }
        this.cleanup();
    }

    private final void cleanup() {
        JsonNode jsonNode = this.getContent().get("metadata").get("pycharm");
        if (jsonNode == null) {
            return;
        }
        JsonNode pycharmMetadata = jsonNode;
        if (pycharmMetadata.isEmpty()) {
            JsonNode jsonNode2 = this.getContent().get("metadata");
            Intrinsics.checkNotNull((Object)jsonNode2, (String)"null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            ((ObjectNode)jsonNode2).remove("pycharm");
        }
    }

    @Override
    public void setMetadata(@NotNull String key, @NotNull JsonNode value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getOrCreateMetadata().set(key, value);
    }

    @Override
    @NotNull
    public ObjectNode getAllMetadataDeepCopy() {
        ObjectNode objectNode = this.getOrCreateMetadata().deepCopy();
        Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"deepCopy(...)");
        return objectNode;
    }

    @Override
    public void setAllMetadataFrom(@NotNull ObjectNode value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.getContent().set("metadata", (JsonNode)value.deepCopy());
    }
}

