/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.manipulators;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.css.util.CssPsiUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssString;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public final class CssStringManipulator
implements ElementManipulator<CssString> {
    public CssString handleContentChange(@NotNull CssString element, String newContent) throws IncorrectOperationException {
        if (element == null) {
            CssStringManipulator.$$$reportNull$$$0(0);
        }
        return this.handleContentChange(element, this.getRangeInElement(element), newContent);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull CssString element) {
        if (element == null) {
            CssStringManipulator.$$$reportNull$$$0(1);
        }
        String text = element.getText();
        int length = text.length();
        int start = 0;
        if (length == 0) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                CssStringManipulator.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        char c = text.charAt(0);
        if (c == '~' && length > 1) {
            c = text.charAt(1);
            start = 1;
        }
        if (c == '\'' || c == '\"') {
            if (length == 1) {
                return new TextRange(1, 1);
            }
            ++start;
        } else {
            start = 0;
        }
        c = text.charAt(length - 1);
        return new TextRange(start, c == '\'' || c == '\"' ? length - 1 : length);
    }

    public CssString handleContentChange(@NotNull CssString element, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (element == null) {
            CssStringManipulator.$$$reportNull$$$0(3);
        }
        if (range == null) {
            CssStringManipulator.$$$reportNull$$$0(4);
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element})) {
            return element;
        }
        String newText = range.replace(element.getText(), newContent);
        char quoteChar = !newText.isEmpty() && newText.charAt(0) == '\'' && newText.charAt(newText.length() - 1) == '\'' ? (char)'\'' : '\"';
        CssElementFactory elementFactory = CssElementFactory.getInstance(element.getProject());
        element.getFirstChild().replace(elementFactory.createStringToken(quoteChar, StringUtil.unquoteString((String)newText), CssPsiUtilCore.getStylesheetLanguage((PsiElement)element)));
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/css/impl/manipulators/CssStringManipulator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/css/impl/manipulators/CssStringManipulator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleContentChange";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInElement";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

