/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.codeGen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharCategory;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dataframe.impl.codeGen.CodeGenResult;
import org.jetbrains.dataframe.keywords.HardKeywords;
import org.jetbrains.dataframe.keywords.ModifierKeywords;
import org.jetbrains.kotlinx.dataframe.codeGen.CodeWithConverter;
import org.jetbrains.kotlinx.dataframe.codeGen.Marker;
import org.jetbrains.kotlinx.dataframe.schema.DataFrameSchema;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\b\u0012\u0004\u0012\u00020\u00060\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0001H\u0000\u001a\f\u0010\u0015\u001a\u00020\u0003*\u00020\u0001H\u0000\u001a\n\u0010\u0016\u001a\u00020\u0003*\u00020\u0001\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\u0001\u001a\u0016\u0010\u0018\u001a\u00020\u0001*\f\u0012\b\u0012\u00060\u0001j\u0002`\u00190\u0005H\u0000\u001a \u0010\u001a\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u001a$\u0010\u001a\u001a\u00020\u0001*\u00060\u0001j\u0002`\u00192\u0006\u0010\u001b\u001a\u00020\u00012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\u001a \u0010\u001a\u001a\u00020\u0001*\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u00012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005\"\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\"\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"renderNullability", "", "nullable", "", "filterRequiredForSchema", "", "Lorg/jetbrains/kotlinx/dataframe/codeGen/Marker;", "", "schema", "Lorg/jetbrains/kotlinx/dataframe/schema/DataFrameSchema;", "charsToQuote", "Lkotlin/text/Regex;", "getCharsToQuote", "()Lkotlin/text/Regex;", "createCodeWithConverter", "Lorg/jetbrains/kotlinx/dataframe/codeGen/CodeWithConverter;", "code", "markerName", "letterCategories", "", "Lkotlin/text/CharCategory;", "needsQuoting", "isQuoted", "quoteIfNeeded", "join", "Lorg/jetbrains/kotlinx/jupyter/api/Code;", "toStandaloneSnippet", "packageName", "additionalImports", "Lorg/jetbrains/dataframe/impl/codeGen/CodeGenResult;", "core"})
@SourceDebugExtension(value={"SMAP\nCodeGeneratorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeGeneratorImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/codeGen/CodeGeneratorImplKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,585:1\n774#2:586\n865#2,2:587\n1863#2,2:593\n1069#3,2:589\n1088#3,2:591\n*S KotlinDebug\n*F\n+ 1 CodeGeneratorImpl.kt\norg/jetbrains/kotlinx/dataframe/impl/codeGen/CodeGeneratorImplKt\n*L\n41#1:586\n41#1:587,2\n576#1:593,2\n65#1:589,2\n66#1:591,2\n*E\n"})
public final class CodeGeneratorImplKt {
    @NotNull
    private static final Regex charsToQuote = new Regex("[ `(){}\\[\\].<>'\"/|\\\\!?@:;%^&*#$-]");
    @NotNull
    private static final Set<CharCategory> letterCategories;

    private static final String renderNullability(boolean nullable) {
        return nullable ? "?" : "";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Marker> filterRequiredForSchema(@NotNull Iterable<? extends Marker> $this$filterRequiredForSchema, @NotNull DataFrameSchema schema) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$filterRequiredForSchema, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Iterable<? extends Marker> $this$filter$iv = $this$filterRequiredForSchema;
        boolean $i$f$filter = false;
        Iterable<? extends Marker> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Marker it = (Marker)element$iv$iv;
            boolean bl = false;
            if (!(it.isOpen() && it.getSchema().compare(schema).isSuperOrEqual())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final Regex getCharsToQuote() {
        return charsToQuote;
    }

    @NotNull
    public static final CodeWithConverter createCodeWithConverter(@NotNull String code, @NotNull String markerName) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)markerName, (String)"markerName");
        return new CodeWithConverter(code, (Function1<? super String, String>)((Function1)arg_0 -> CodeGeneratorImplKt.createCodeWithConverter$lambda$1(markerName, arg_0)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean needsQuoting(@NotNull String $this$needsQuoting) {
        char it;
        char element$iv;
        int n;
        block6: {
            Intrinsics.checkNotNullParameter((Object)$this$needsQuoting, (String)"<this>");
            if (CodeGeneratorImplKt.isQuoted($this$needsQuoting)) {
                return false;
            }
            if (StringsKt.isBlank((CharSequence)$this$needsQuoting)) return true;
            if (Character.isDigit(StringsKt.first((CharSequence)$this$needsQuoting))) return true;
            CharSequence charSequence = $this$needsQuoting;
            if (charsToQuote.containsMatchIn(charSequence)) return true;
            if (HardKeywords.Companion.getVALUES().contains($this$needsQuoting)) return true;
            if (ModifierKeywords.Companion.getVALUES().contains($this$needsQuoting)) return true;
            CharSequence $this$all$iv = $this$needsQuoting;
            boolean $i$f$all = false;
            n = 0;
            while (n < $this$all$iv.length()) {
                it = element$iv = $this$all$iv.charAt(n);
                boolean bl = false;
                if (it == '_') {
                    ++n;
                    continue;
                }
                break block6;
            }
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        CharSequence $this$any$iv = $this$needsQuoting;
        boolean $i$f$any = false;
        n = 0;
        while (n < $this$any$iv.length()) {
            it = element$iv = $this$any$iv.charAt(n);
            boolean bl2 = false;
            if (it != '_' && !letterCategories.contains(CharsKt.getCategory((char)it))) {
                return true;
            }
            boolean bl3 = false;
            if (bl3) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final boolean isQuoted(@NotNull String $this$isQuoted) {
        Intrinsics.checkNotNullParameter((Object)$this$isQuoted, (String)"<this>");
        return StringsKt.startsWith$default((String)$this$isQuoted, (String)"`", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)$this$isQuoted, (String)"`", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String quoteIfNeeded(@NotNull String $this$quoteIfNeeded) {
        Intrinsics.checkNotNullParameter((Object)$this$quoteIfNeeded, (String)"<this>");
        return CodeGeneratorImplKt.needsQuoting($this$quoteIfNeeded) ? '`' + $this$quoteIfNeeded + '`' : $this$quoteIfNeeded;
    }

    @NotNull
    public static final String join(@NotNull List<String> $this$join) {
        Intrinsics.checkNotNullParameter($this$join, (String)"<this>");
        return CollectionsKt.joinToString$default((Iterable)$this$join, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final String toStandaloneSnippet(@NotNull CodeWithConverter $this$toStandaloneSnippet, @NotNull String packageName, @NotNull List<String> additionalImports) {
        Intrinsics.checkNotNullParameter((Object)$this$toStandaloneSnippet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(additionalImports, (String)"additionalImports");
        return CodeGeneratorImplKt.toStandaloneSnippet($this$toStandaloneSnippet.getDeclarations(), packageName, additionalImports);
    }

    @NotNull
    public static final String toStandaloneSnippet(@NotNull String $this$toStandaloneSnippet, @NotNull String packageName, @NotNull List<String> additionalImports) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$toStandaloneSnippet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(additionalImports, (String)"additionalImports");
        StringBuilder $this$toStandaloneSnippet_u24lambda_u245 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (((CharSequence)packageName).length() > 0) {
            StringBuilder stringBuilder2 = $this$toStandaloneSnippet_u24lambda_u245.append("package " + packageName);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)$this$toStandaloneSnippet_u24lambda_u245.append('\n'), (String)"append(...)");
        }
        StringBuilder stringBuilder3 = $this$toStandaloneSnippet_u24lambda_u245.append("import org.jetbrains.kotlinx.dataframe.ColumnsContainer");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = $this$toStandaloneSnippet_u24lambda_u245.append("import org.jetbrains.kotlinx.dataframe.DataColumn");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder5 = $this$toStandaloneSnippet_u24lambda_u245.append("import org.jetbrains.kotlinx.dataframe.DataFrame");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder6 = $this$toStandaloneSnippet_u24lambda_u245.append("import org.jetbrains.kotlinx.dataframe.DataRow");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder7 = $this$toStandaloneSnippet_u24lambda_u245.append("import org.jetbrains.kotlinx.dataframe.columns.ColumnGroup");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder8 = $this$toStandaloneSnippet_u24lambda_u245.append("import org.jetbrains.kotlinx.dataframe.annotations.ColumnName");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder8.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder9 = $this$toStandaloneSnippet_u24lambda_u245.append("import org.jetbrains.kotlinx.dataframe.annotations.DataSchema");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder10 = $this$toStandaloneSnippet_u24lambda_u245.append("import org.jetbrains.kotlinx.dataframe.api.cast");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder10.append('\n'), (String)"append(...)");
        Iterable $this$forEach$iv = additionalImports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl2 = false;
            StringBuilder stringBuilder11 = $this$toStandaloneSnippet_u24lambda_u245.append(it);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder11.append('\n'), (String)"append(...)");
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$toStandaloneSnippet_u24lambda_u245.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder12 = $this$toStandaloneSnippet_u24lambda_u245.append($this$toStandaloneSnippet);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder12.append('\n'), (String)"append(...)");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String toStandaloneSnippet(@NotNull CodeGenResult $this$toStandaloneSnippet, @NotNull String packageName, @NotNull List<String> additionalImports) {
        Intrinsics.checkNotNullParameter((Object)$this$toStandaloneSnippet, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter(additionalImports, (String)"additionalImports");
        return CodeGeneratorImplKt.toStandaloneSnippet($this$toStandaloneSnippet.getCode(), packageName, additionalImports);
    }

    private static final String createCodeWithConverter$lambda$1(String $markerName, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it + ".cast<" + $markerName + ">()";
    }

    public static final /* synthetic */ String access$renderNullability(boolean nullable) {
        return CodeGeneratorImplKt.renderNullability(nullable);
    }

    static {
        Object[] objectArray = new CharCategory[]{CharCategory.UPPERCASE_LETTER, CharCategory.TITLECASE_LETTER, CharCategory.MODIFIER_LETTER, CharCategory.LOWERCASE_LETTER, CharCategory.DECIMAL_DIGIT_NUMBER};
        letterCategories = SetsKt.setOf((Object[])objectArray);
    }
}

