/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.io;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.input.BOMInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.api.ToDataFrameKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.ConstructorsKt;
import org.jetbrains.kotlinx.dataframe.io.JsonKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a2\u0010\u0000\u001a\n\u0012\u0002\b\u00030\u0001j\u0002`\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u001a\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0002\b\u00030\u0001j\u0002`\u00020\u0006\u001a.\u0010\b\u001a\n\u0012\u0002\b\u00030\u0001j\u0002`\u0002\"\u0004\b\u0000\u0010\t*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\n0\n2\b\b\u0002\u0010\u000b\u001a\u00020\f\u001a\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007\u001a\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u000e\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u000f\u001a\n\u0010\u0018\u001a\u00020\u0007*\u00020\u0007\u00a8\u0006\u0019"}, d2={"catchHttpResponse", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "Lorg/jetbrains/kotlinx/dataframe/AnyFrame;", "url", "Ljava/net/URL;", "body", "Lkotlin/Function1;", "Ljava/io/InputStream;", "toDataFrame", "T", "", "containsColumns", "", "isURL", "path", "", "isUrl", "isFile", "asFileOrNull", "Ljava/io/File;", "urlAsFile", "isProtocolSupported", "asUrl", "fileOrUrl", "skippingBomCharacters", "core"})
@SourceDebugExtension(value={"SMAP\ncommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 common.kt\norg/jetbrains/kotlinx/dataframe/io/CommonKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1611#2,9:114\n1863#2:123\n1864#2:125\n1620#2:126\n1557#2:127\n1628#2,3:128\n1567#2:131\n1598#2,3:132\n1557#2:135\n1628#2,3:136\n1601#2:139\n1755#2,3:140\n1#3:124\n1#3:143\n*S KotlinDebug\n*F\n+ 1 common.kt\norg/jetbrains/kotlinx/dataframe/io/CommonKt\n*L\n50#1:114,9\n50#1:123\n50#1:125\n50#1:126\n61#1:127\n61#1:128,3\n63#1:131\n63#1:132,3\n64#1:135\n64#1:136,3\n63#1:139\n83#1:140,3\n50#1:124\n*E\n"})
public final class CommonKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final DataFrame<?> catchHttpResponse(@NotNull URL url, @NotNull Function1<? super InputStream, ? extends DataFrame<?>> body) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        URLConnection connection = url.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            Object object2;
            Closeable closeable = connection.getInputStream();
            Throwable throwable = null;
            try {
                object2 = body.invoke((Object)closeable);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return (DataFrame)object2;
        }
        ((HttpURLConnection)connection).connect();
        int code = ((HttpURLConnection)connection).getResponseCode();
        if (code != 200) {
            String response = ((HttpURLConnection)connection).getResponseMessage();
            try {
                InputStream inputStream = ((HttpURLConnection)connection).getErrorStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getErrorStream(...)");
                DataFrame dataFrame = JsonKt.readJson$default(DataFrame.Companion, inputStream, null, null, null, 14, null);
                return dataFrame;
            }
            catch (Exception exception) {
                throw new RuntimeException("Server returned HTTP response code: " + code + ". Response: " + response);
            }
        }
        Object object3 = ((HttpURLConnection)connection).getInputStream();
        Throwable throwable = null;
        try {
            object = body.invoke(object3);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)throwable);
        }
        object3 = (DataFrame)object;
        return object3;
        finally {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> DataFrame<?> toDataFrame(@NotNull List<? extends List<? extends T>> $this$toDataFrame, boolean containsColumns) {
        DataFrame<?> dataFrame;
        Intrinsics.checkNotNullParameter($this$toDataFrame, (String)"<this>");
        if (containsColumns) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = $this$toDataFrame;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                DataColumn dataColumn;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                List it = (List)element$iv$iv;
                boolean bl2 = false;
                if (it.isEmpty()) {
                    dataColumn = null;
                } else {
                    String name = String.valueOf(it.get(0));
                    List values = CollectionsKt.drop((Iterable)it, (int)1);
                    dataColumn = ConstructorsKt.createColumnGuessingType$default(name, values, null, null, null, false, false, 124, null);
                }
                if (dataColumn == null) continue;
                DataColumn it$iv$iv = dataColumn;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            dataFrame = ToDataFrameKt.toDataFrameAnyColumn((List)destination$iv$iv);
        } else if ($this$toDataFrame.isEmpty()) {
            dataFrame = DataFrame.Companion.getEmpty();
        } else {
            void $this$mapIndexedTo$iv$iv;
            Collection collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$toDataFrame.get(0);
            boolean $i$f$map = false;
            Iterable destination$iv$iv = $this$map$iv;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator $i$f$forEach = $this$mapTo$iv$iv.iterator();
            while ($i$f$forEach.hasNext()) {
                void it;
                Object item$iv$iv;
                Object element$iv$iv$iv = item$iv$iv = $i$f$forEach.next();
                collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(String.valueOf(it));
            }
            List header = (List)destination$iv$iv2;
            List data = CollectionsKt.drop((Iterable)$this$toDataFrame, (int)1);
            Iterable $this$mapIndexed$iv = header;
            boolean $i$f$mapIndexed = false;
            destination$iv$iv2 = $this$mapIndexed$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void name;
                void $this$mapTo$iv$iv2;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String it = (String)item$iv$iv;
                int bl2 = n;
                collection = destination$iv$iv3;
                boolean bl = false;
                Iterable $this$map$iv2 = data;
                boolean $i$f$map2 = false;
                Iterable bl3 = $this$map$iv2;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void colIndex;
                    void row;
                    List list = (List)item$iv$iv2;
                    Collection collection2 = destination$iv$iv4;
                    boolean bl4 = false;
                    collection2.add(row.size() <= colIndex ? null : (Object)row.get((int)colIndex));
                }
                List values = (List)destination$iv$iv4;
                collection.add(ConstructorsKt.createColumnGuessingType$default((String)name, values, null, null, null, false, false, 124, null));
            }
            dataFrame = ToDataFrameKt.toDataFrameAnyColumn((List)destination$iv$iv3);
        }
        return dataFrame;
    }

    public static /* synthetic */ DataFrame toDataFrame$default(List list, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return CommonKt.toDataFrame(list, bl);
    }

    @Deprecated(message="This function is replaced by `isUrl()`. Will be ERROR in 0.16.", replaceWith=@ReplaceWith(expression="isUrl(path)", imports={"org.jetbrains.kotlinx.dataframe.io.isUrl"}), level=DeprecationLevel.WARNING)
    public static final boolean isURL(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return CommonKt.isUrl(path);
    }

    public static final boolean isUrl(@NotNull String path) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Object[] objectArray = new String[]{"http:", "https:", "ftp:"};
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])objectArray);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.startsWith$default((String)path, (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static final boolean isFile(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return Intrinsics.areEqual((Object)url.getProtocol(), (Object)"file");
    }

    @Nullable
    public static final File asFileOrNull(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return CommonKt.isFile(url) ? new File(url.getPath()) : null;
    }

    @NotNull
    public static final File urlAsFile(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return new File(url.toURI());
    }

    public static final boolean isProtocolSupported(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Object[] objectArray = new String[]{"http", "https", "ftp"};
        return SetsKt.setOf((Object[])objectArray).contains(url.getProtocol());
    }

    @NotNull
    public static final URL asUrl(@NotNull String fileOrUrl) {
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)fileOrUrl, (String)"fileOrUrl");
        if (CommonKt.isUrl(fileOrUrl)) {
            uRI = new URL(fileOrUrl).toURI();
        } else {
            File file;
            File it = file = new File(fileOrUrl);
            boolean bl = false;
            if (!it.exists()) {
                boolean $i$a$-require-CommonKt$asUrl$1$32 = false;
                String $i$a$-require-CommonKt$asUrl$1$32 = "File not found: \"" + fileOrUrl + '\"';
                throw new IllegalArgumentException($i$a$-require-CommonKt$asUrl$1$32.toString());
            }
            if (!it.isFile()) {
                boolean bl2 = false;
                String string = "Not a file: \"" + fileOrUrl + '\"';
                throw new IllegalArgumentException(string.toString());
            }
            uRI = file.toURI();
        }
        URL uRL = uRI.toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURL(...)");
        return uRL;
    }

    @NotNull
    public static final InputStream skippingBomCharacters(@NotNull InputStream $this$skippingBomCharacters) {
        Intrinsics.checkNotNullParameter((Object)$this$skippingBomCharacters, (String)"<this>");
        BOMInputStream bOMInputStream = ((BOMInputStream.Builder)BOMInputStream.builder().setInputStream($this$skippingBomCharacters)).setInclude(false).get();
        Intrinsics.checkNotNullExpressionValue((Object)bOMInputStream, (String)"get(...)");
        return (InputStream)bOMInputStream;
    }
}

