/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.common;

import ai.grazie.rules.common.Argument;
import ai.grazie.rules.common.Valence;
import ai.grazie.rules.common.WordSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;

public abstract class ValenceParser {
    private final Map<String, Argument> predefined = new HashMap<String, Argument>();

    protected ValenceParser(Argument ... predefined) {
        for (Argument arg : predefined) {
            this.predefined.put(arg.toString(), arg);
        }
    }

    public abstract Argument arg(String var1);

    public Argument argWithPredefined(String argName) {
        Argument argument = this.predefined.get(argName);
        return argument != null ? argument : this.arg(argName);
    }

    public List<Valence> valences(String valences) {
        return StreamEx.of((Object[])valences.split(",")).map(String::trim).map(this::valence).toList();
    }

    public Valence valence(String args) {
        if (args.isEmpty()) {
            return new Valence(List.of());
        }
        return new Valence(StreamEx.of((Object[])args.split("\\+")).map(String::trim).map(this::argWithPredefined).toList());
    }

    public Map<String, List<Valence>> fromResource(String path) {
        List<String> lines = WordSet.loadLines(path);
        HashMap<String, List<Valence>> map = new HashMap<String, List<Valence>>();
        for (String line : lines) {
            String[] words;
            if (line.isBlank()) continue;
            String[] parts = line.split(":", 2);
            List<Valence> valences = this.valences(parts[1].trim());
            if (valences.isEmpty()) {
                throw new IllegalArgumentException("No valences found for: " + line);
            }
            for (String word : words = parts[0].split(",")) {
                map.put(word.trim(), valences);
            }
        }
        return map;
    }
}

