/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlText;
import java.util.List;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;

public final class PostFormatProcessorUtil {
    private PostFormatProcessorUtil() {
    }

    @NotNull
    public static PsiElement processElement(@NotNull PsiElement source, @NotNull BiFunction<? super PsiElement, ? super TextRange, ? extends TextRange> handler) {
        if (source == null) {
            PostFormatProcessorUtil.$$$reportNull$$$0(0);
        }
        if (handler == null) {
            PostFormatProcessorUtil.$$$reportNull$$$0(1);
        }
        if (source.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE)) {
            handler.apply((PsiElement)source, (TextRange)source.getTextRange());
            PsiElement psiElement = source;
            if (psiElement == null) {
                PostFormatProcessorUtil.$$$reportNull$$$0(2);
            }
            return psiElement;
        }
        if (source.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE)) {
            new InXmlProcessor(handler).processElementRange(source, source.getTextRange());
            PsiElement psiElement = source;
            if (psiElement == null) {
                PostFormatProcessorUtil.$$$reportNull$$$0(3);
            }
            return psiElement;
        }
        PsiElement psiElement = source;
        if (psiElement == null) {
            PostFormatProcessorUtil.$$$reportNull$$$0(4);
        }
        return psiElement;
    }

    @NotNull
    public static TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat, @NotNull BiFunction<? super PsiElement, ? super TextRange, ? extends TextRange> handler) {
        if (source == null) {
            PostFormatProcessorUtil.$$$reportNull$$$0(5);
        }
        if (rangeToReformat == null) {
            PostFormatProcessorUtil.$$$reportNull$$$0(6);
        }
        if (handler == null) {
            PostFormatProcessorUtil.$$$reportNull$$$0(7);
        }
        if (source.getLanguage().isKindOf((Language)JavascriptLanguage.INSTANCE)) {
            TextRange textRange = handler.apply((PsiElement)source, (TextRange)rangeToReformat);
            if (textRange == null) {
                PostFormatProcessorUtil.$$$reportNull$$$0(8);
            }
            return textRange;
        }
        if (source.getLanguage().isKindOf((Language)XMLLanguage.INSTANCE)) {
            TextRange textRange = new InXmlProcessor(handler).processElementRange((PsiElement)source, rangeToReformat);
            if (textRange == null) {
                PostFormatProcessorUtil.$$$reportNull$$$0(9);
            }
            return textRange;
        }
        List files = source.getViewProvider().getAllFiles();
        for (PsiFile file : files) {
            Language templateLang = file.getLanguage();
            if (templateLang.isKindOf((Language)JavascriptLanguage.INSTANCE)) {
                TextRange textRange = handler.apply((PsiElement)file, (TextRange)rangeToReformat);
                if (textRange == null) {
                    PostFormatProcessorUtil.$$$reportNull$$$0(10);
                }
                return textRange;
            }
            if (!(templateLang instanceof XMLLanguage)) continue;
            TextRange textRange = new InXmlProcessor(handler).processElementRange((PsiElement)file, rangeToReformat);
            if (textRange == null) {
                PostFormatProcessorUtil.$$$reportNull$$$0(11);
            }
            return textRange;
        }
        TextRange textRange = rangeToReformat;
        if (textRange == null) {
            PostFormatProcessorUtil.$$$reportNull$$$0(12);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 8, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/PostFormatProcessorUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/PostFormatProcessorUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 8, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }

    private static class InXmlProcessor
    extends XmlRecursiveElementVisitor {
        private TextRange currentRange;
        private final BiFunction<? super PsiElement, ? super TextRange, ? extends TextRange> myHandler;

        InXmlProcessor(BiFunction<? super PsiElement, ? super TextRange, ? extends TextRange> handler) {
            this.myHandler = handler;
        }

        public void visitXmlText(@NotNull XmlText text) {
            if (text == null) {
                InXmlProcessor.$$$reportNull$$$0(0);
            }
            this.processInjected((PsiElement)text);
        }

        public void processInjected(PsiElement element) {
            List pairs = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectedPsiFiles(element);
            if (pairs == null) {
                return;
            }
            for (Pair pair : pairs) {
                int relEnd;
                int relStart;
                Object object = pair.getFirst();
                if (!(object instanceof PsiFile)) continue;
                PsiFile jsFile = (PsiFile)object;
                int jsFileOffset = element.getTextOffset();
                TextRange initialRange = this.currentRange;
                if (initialRange != null) {
                    relStart = initialRange.getStartOffset() - jsFileOffset;
                    if (relStart < 0) {
                        relStart = 0;
                    }
                    if ((relEnd = initialRange.getEndOffset() - jsFileOffset) < 0) {
                        return;
                    }
                    if (relEnd > jsFile.getTextLength()) {
                        relEnd = jsFile.getTextLength();
                    }
                    if (relStart > relEnd) {
                        return;
                    }
                } else {
                    relStart = 0;
                    relEnd = jsFile.getTextLength();
                }
                this.myHandler.apply((PsiElement)jsFile, (TextRange)new TextRange(relStart, relEnd));
            }
        }

        public void visitElement(@NotNull PsiElement element) {
            ASTNode node;
            if (element == null) {
                InXmlProcessor.$$$reportNull$$$0(1);
            }
            if ((node = element.getNode()) != null && JSExtendedLanguagesTokenSetProvider.EMBEDDED_CONTENTS.contains(node.getElementType())) {
                this.myHandler.apply((PsiElement)element, (TextRange)this.currentRange);
            }
            super.visitElement(element);
        }

        public TextRange processElementRange(PsiElement source, TextRange rangeToReformat) {
            this.currentRange = rangeToReformat;
            source.accept((PsiElementVisitor)this);
            return this.currentRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/formatter/PostFormatProcessorUtil$InXmlProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitXmlText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

