/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.comments;

import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.comments.CommentLineData;
import com.intellij.formatting.comments.CommentLineDataBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineCommentLineDataBuilder
extends CommentLineDataBuilder {
    private final PsiComment myComment;
    private final IElementType myLineCommentType;
    private static final String LINE_COMMENT_PREFIX = "//";
    private TextRange myCommentBlockRange;
    private final CommonCodeStyleSettings.IndentOptions myIndentOptions;
    @Nullable
    private final TextRange myEnabledRange;
    private int myLeadingTabs;

    public LineCommentLineDataBuilder(@NotNull PsiComment comment, IElementType lineCommentType, @NotNull CommonCodeStyleSettings settings, @Nullable TextRange enabledRange) {
        if (comment == null) {
            LineCommentLineDataBuilder.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            LineCommentLineDataBuilder.$$$reportNull$$$0(1);
        }
        super(settings.getRootSettings());
        this.myComment = comment;
        this.myLineCommentType = lineCommentType;
        this.myIndentOptions = settings.getIndentOptions() != null ? settings.getIndentOptions() : new CommonCodeStyleSettings.IndentOptions();
        this.myEnabledRange = enabledRange;
    }

    public boolean canMerge(@NotNull PsiComment comment) {
        if (comment == null) {
            LineCommentLineDataBuilder.$$$reportNull$$$0(2);
        }
        return this.getFormatterTag(comment) == FormatterTagHandler.FormatterTag.NONE;
    }

    public boolean isMergedWithPrevious(@NotNull PsiComment comment) {
        if (comment == null) {
            LineCommentLineDataBuilder.$$$reportNull$$$0(3);
        }
        if (this.isAfterNonEmptyLine(comment.getNode())) {
            return false;
        }
        PsiElement prev = comment.getPrevSibling();
        if (prev instanceof PsiWhiteSpace) {
            PsiElement whitespaceBefore = prev;
            if ((prev = prev.getPrevSibling()) != null && prev.getNode().getElementType() == this.myLineCommentType && LineCommentLineDataBuilder.countLineBreaks(whitespaceBefore.getNode()) == 1) {
                int prevIndent;
                if (this.myEnabledRange != null && prev.getTextRange().getEndOffset() < this.myEnabledRange.getStartOffset() || prev instanceof PsiComment && this.getFormatterTag((PsiComment)prev) != FormatterTagHandler.FormatterTag.NONE) {
                    return false;
                }
                int currIndent = this.calcBlockLineIndent(comment.getNode());
                return currIndent == (prevIndent = this.calcBlockLineIndent(prev.getNode()));
            }
        }
        return false;
    }

    public List<CommentLineData> getLines() {
        ArrayList<CommentLineData> lines = new ArrayList<CommentLineData>();
        int startOffset = this.myComment.getTextRange().getStartOffset();
        int endOffset = this.myComment.getTextRange().getEndOffset();
        int blockIndent = this.calcBlockLineIndent(this.myComment.getNode());
        this.addLineDataFromComment(lines, (PsiElement)this.myComment, blockIndent, true);
        for (PsiElement next = this.myComment.getNextSibling(); next != null && (this.myEnabledRange == null || next.getTextRange().getStartOffset() <= this.myEnabledRange.getEndOffset()); next = next.getNextSibling()) {
            if (next.getNode().getElementType() == this.myLineCommentType) {
                int nextIndent;
                if (next instanceof PsiComment && this.getFormatterTag((PsiComment)next) != FormatterTagHandler.FormatterTag.NONE || (nextIndent = this.calcBlockLineIndent(next.getNode())) != blockIndent) break;
                endOffset = next.getTextRange().getEndOffset();
                this.addLineDataFromComment(lines, next, blockIndent, false);
                continue;
            }
            if (!(next instanceof PsiWhiteSpace) || LineCommentLineDataBuilder.countLineBreaks(next.getNode()) > 1) break;
        }
        this.myCommentBlockRange = new TextRange(startOffset, endOffset);
        return lines;
    }

    public TextRange getCommentBlockRange() {
        return this.myCommentBlockRange;
    }

    private void addLineDataFromComment(List<CommentLineData> lines, @NotNull PsiElement comment, int indent, boolean isEndOfLineComment) {
        if (comment == null) {
            LineCommentLineDataBuilder.$$$reportNull$$$0(4);
        }
        String line = new String(CharArrayUtil.fromSequence((CharSequence)comment.getNode().getChars()));
        LineCommentLineData lineData = (LineCommentLineData)this.parseLine(line);
        lineData.indent = indent;
        lineData.isFirst = isEndOfLineComment;
        lines.add(lineData);
    }

    @NotNull
    public CommentLineData parseLine(@NotNull String line) {
        int next;
        if (line == null) {
            LineCommentLineDataBuilder.$$$reportNull$$$0(5);
        }
        LineCommentLineData lineData = new LineCommentLineData(line);
        lineData.setCommentOffset(LineCommentLineDataBuilder.nextNonWhitespace((String)line, (int)0));
        if (lineData.getCommentOffset() >= 0 && (next = lineData.getCommentOffset() + LINE_COMMENT_PREFIX.length()) < line.length()) {
            lineData.setTextStartOffset(LineCommentLineDataBuilder.nextNonWhitespace((String)line, (int)next));
        }
        LineCommentLineData lineCommentLineData = lineData;
        if (lineCommentLineData == null) {
            LineCommentLineDataBuilder.$$$reportNull$$$0(6);
        }
        return lineCommentLineData;
    }

    public boolean isAfterNonEmptyLine(@NotNull ASTNode node) {
        ASTNode prev;
        if (node == null) {
            LineCommentLineDataBuilder.$$$reportNull$$$0(7);
        }
        if (node.getElementType() == this.myLineCommentType && (prev = node.getTreePrev()) != null) {
            return !(prev.getPsi() instanceof PsiWhiteSpace) || !prev.textContains('\n');
        }
        return false;
    }

    public static int countLineBreaks(@NotNull ASTNode node) {
        if (node == null) {
            LineCommentLineDataBuilder.$$$reportNull$$$0(8);
        }
        CharSequence sequence = node.getChars();
        int count = 0;
        for (int i = 0; i < sequence.length(); ++i) {
            if (sequence.charAt(i) != '\n') continue;
            ++count;
        }
        return count;
    }

    public int calcBlockLineIndent(@NotNull ASTNode node) {
        ASTNode prev;
        if (node == null) {
            LineCommentLineDataBuilder.$$$reportNull$$$0(9);
        }
        int indent = 0;
        for (prev = node.getTreePrev(); prev != null && !prev.textContains('\n'); prev = prev.getTreePrev()) {
            indent += prev.getTextLength();
        }
        if (prev != null) {
            int offset = 0;
            CharSequence prevSequence = prev.getChars();
            int lastEolOffset = CharArrayUtil.shiftBackwardUntil((CharSequence)prevSequence, (int)(prev.getTextLength() - 1), (String)"\r\n");
            if (lastEolOffset >= 0) {
                offset += prev.getTextLength() - lastEolOffset - 1;
            }
            char[] indentChars = CharArrayUtil.fromSequence((CharSequence)prevSequence, (int)(prev.getTextLength() - offset), (int)prev.getTextLength());
            this.myLeadingTabs = 0;
            boolean isTabIndent = indentChars.length > 0 && indentChars[0] == '\t';
            for (char c : indentChars) {
                if (c == '\t' && isTabIndent) {
                    indent += this.myIndentOptions.TAB_SIZE;
                    ++this.myLeadingTabs;
                    continue;
                }
                isTabIndent = false;
                ++indent;
            }
        }
        return indent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/comments/LineCommentLineDataBuilder";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/comments/LineCommentLineDataBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canMerge";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMergedWithPrevious";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addLineDataFromComment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseLine";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAfterNonEmptyLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "countLineBreaks";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcBlockLineIndent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }

    private class LineCommentLineData
    extends CommentLineData {
        private int indent;
        private boolean isFirst;

        LineCommentLineData(String line) {
            if (line == null) {
                LineCommentLineData.$$$reportNull$$$0(0);
            }
            super(line);
        }

        public int getLineLength() {
            return this.indent + super.getLineLength();
        }

        protected int calcWrapPos(int rightMargin) {
            if (this.indent < rightMargin) {
                return super.calcWrapPos(rightMargin - this.indent);
            }
            return -1;
        }

        public String getIndentString() {
            if (!LineCommentLineDataBuilder.this.myIndentOptions.USE_TAB_CHARACTER) {
                return StringUtil.repeatSymbol((char)' ', (int)this.indent);
            }
            int tabs = LineCommentLineDataBuilder.this.myIndentOptions.SMART_TABS ? LineCommentLineDataBuilder.this.myLeadingTabs : (LineCommentLineDataBuilder.this.myIndentOptions.TAB_SIZE > 0 ? this.indent / LineCommentLineDataBuilder.this.myIndentOptions.TAB_SIZE : 0);
            int spaces = this.indent - tabs * LineCommentLineDataBuilder.this.myIndentOptions.TAB_SIZE;
            return StringUtil.repeatSymbol((char)'\t', (int)tabs) + StringUtil.repeatSymbol((char)' ', (int)spaces);
        }

        @Nullable
        public Pair<String, String> splitLine(int rightMargin) {
            Pair newLines = super.splitLine(rightMargin);
            if (newLines != null && !this.isFirst && this.indent > 0) {
                return Pair.create((Object)(this.getIndentString() + (String)newLines.first), (Object)((String)newLines.second));
            }
            return newLines;
        }

        @NotNull
        public String getLinePrefix() {
            String string = (this.indent > 0 ? this.getIndentString() : this.line.substring(0, this.getCommentOffset())) + LineCommentLineDataBuilder.LINE_COMMENT_PREFIX;
            if (string == null) {
                LineCommentLineData.$$$reportNull$$$0(1);
            }
            return string;
        }

        protected int getTabSize() {
            return LineCommentLineDataBuilder.this.myIndentOptions.TAB_SIZE;
        }

        @NotNull
        public String getLine() {
            Object object = this.indent > 0 && !this.isFirst ? this.getIndentString() + this.line : this.line;
            if (object == null) {
                LineCommentLineData.$$$reportNull$$$0(2);
            }
            return object;
        }

        public boolean canBeMergedWithPrevious() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/formatter/comments/LineCommentLineDataBuilder$LineCommentLineData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/formatter/comments/LineCommentLineDataBuilder$LineCommentLineData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLinePrefix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLine";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

