/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd;

import com.intellij.ide.CopyPasteSupport;
import com.intellij.ide.CopyPasteUtil;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.CutProvider;
import com.intellij.ide.PasteProvider;
import com.intellij.ide.PsiCopyPasteManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.containers.ArrayListSet;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.dnd.RemoteMoveProvider;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Collection;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class MoveCopyPasteSupport
implements CopyPasteSupport {
    public CutProvider getCutProvider() {
        return new MyCutProvider();
    }

    public CopyProvider getCopyProvider() {
        return new MyCopyProvider();
    }

    public PasteProvider getPasteProvider() {
        return new MyPasteProvider();
    }

    private static class MyCutProvider
    implements CutProvider {
        private MyCutProvider() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyCutProvider.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void performCut(@NotNull DataContext dataContext) {
            ServerTree tree;
            if (dataContext == null) {
                MyCutProvider.$$$reportNull$$$0(1);
            }
            if ((tree = (ServerTree)((Object)WebDeploymentDataKeys.SERVER_TREE.getData(dataContext))) == null) {
                return;
            }
            PsiCopyPasteManager.getInstance().setElements(new PsiElement[]{RemoteMoveProvider.createPsiElementWithData(tree, false)}, false);
        }

        public boolean isCutEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyCutProvider.$$$reportNull$$$0(2);
            }
            return RemoteMoveProvider.checkNotEmpty((ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(dataContext), false);
        }

        public boolean isCutVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyCutProvider.$$$reportNull$$$0(3);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/MoveCopyPasteSupport$MyCutProvider";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/MoveCopyPasteSupport$MyCutProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "performCut";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isCutEnabled";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isCutVisible";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MyCopyProvider
    implements CopyProvider {
        private MyCopyProvider() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyCopyProvider.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void performCopy(@NotNull DataContext dataContext) {
            ServerTree tree;
            if (dataContext == null) {
                MyCopyProvider.$$$reportNull$$$0(1);
            }
            if ((tree = (ServerTree)((Object)WebDeploymentDataKeys.SERVER_TREE.getData(dataContext))) == null) {
                return;
            }
            PsiCopyPasteManager.getInstance().setElements(new PsiElement[]{RemoteMoveProvider.createPsiElementWithData(tree, false)}, true);
        }

        public boolean isCopyEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyCopyProvider.$$$reportNull$$$0(2);
            }
            return RemoteMoveProvider.checkNotEmpty((ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(dataContext), true);
        }

        public boolean isCopyVisible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyCopyProvider.$$$reportNull$$$0(3);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/MoveCopyPasteSupport$MyCopyProvider";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/MoveCopyPasteSupport$MyCopyProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "performCopy";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isCopyEnabled";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isCopyVisible";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class MyPasteProvider
    implements PasteProvider {
        private MyPasteProvider() {
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyPasteProvider.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void performPaste(@NotNull DataContext dataContext) {
            ServerTreeNode[] serverNodes;
            if (dataContext == null) {
                MyPasteProvider.$$$reportNull$$$0(1);
            }
            if ((serverNodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(dataContext)) == null || serverNodes.length == 0) {
                return;
            }
            ServerTreeNode targetNode = serverNodes[0];
            ServerTree tree = (ServerTree)((Object)WebDeploymentDataKeys.SERVER_TREE.getData(dataContext));
            if (tree == null) {
                return;
            }
            if (RemoteMoveProvider.isFromRemotePasteEnabled(dataContext, true)) {
                boolean[] copied = new boolean[1];
                PsiElement element = RemoteMoveProvider.getPsiElementWithData(copied);
                if (element == null) {
                    return;
                }
                RemoteMoveProvider.performRemoteToRemotePaste(element, targetNode, !copied[0], false);
                CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(""));
            } else if (MyPasteProvider.isFromProjectViewPasteEnabled(dataContext)) {
                boolean[] isCopied = new boolean[1];
                PsiElement[] elements = PsiCopyPasteManager.getInstance().getElements(isCopied);
                if (elements == null || elements.length == 0) {
                    return;
                }
                ArrayListSet sourceElements = new ArrayListSet();
                for (PsiElement element : elements) {
                    if (!(element instanceof PsiFileSystemItem)) {
                        return;
                    }
                    VirtualFile file = ((PsiFileSystemItem)element).getVirtualFile();
                    if (file == null || !file.isValid()) {
                        return;
                    }
                    sourceElements.add(file);
                }
                RemoteMoveProvider.performLocalToRemotePaste((Collection<VirtualFile>)sourceElements, targetNode, tree, tree.getProject(), tree.getServer(), !isCopied[0]);
            }
        }

        public boolean isPastePossible(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyPasteProvider.$$$reportNull$$$0(2);
            }
            return this.isPasteEnabled(dataContext);
        }

        public boolean isPasteEnabled(@NotNull DataContext dataContext) {
            if (dataContext == null) {
                MyPasteProvider.$$$reportNull$$$0(3);
            }
            return RemoteMoveProvider.isFromRemotePasteEnabled(dataContext, true) || MyPasteProvider.isFromProjectViewPasteEnabled(dataContext);
        }

        private static boolean isFromProjectViewPasteEnabled(@NotNull DataContext dataContext) {
            Deployable config;
            if (dataContext == null) {
                MyPasteProvider.$$$reportNull$$$0(4);
            }
            if ((config = (Deployable)WebDeploymentDataKeys.DEPLOYABLE.getData(dataContext)) == null) {
                return false;
            }
            ServerTreeNode[] treeNodes = (ServerTreeNode[])WebDeploymentDataKeys.SERVER_NODES.getData(dataContext);
            if (treeNodes == null || treeNodes.length != 1) {
                return false;
            }
            boolean[] isCopied = new boolean[1];
            PsiElement[] elements = PsiCopyPasteManager.getInstance().getElements(isCopied);
            if (elements == null || elements.length == 0) {
                return false;
            }
            if (treeNodes[0].getProject() != elements[0].getProject()) {
                return false;
            }
            for (PsiElement element : elements) {
                if (!(element instanceof PsiFileSystemItem)) {
                    return false;
                }
                VirtualFile file = ((PsiFileSystemItem)element).getVirtualFile();
                if (file != null && file.isValid() && file.isInLocalFileSystem()) continue;
                return false;
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/MoveCopyPasteSupport$MyPasteProvider";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/remotebrowser/dnd/MoveCopyPasteSupport$MyPasteProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "performPaste";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isPastePossible";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isPasteEnabled";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isFromProjectViewPasteEnabled";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    public static class RemoteHostCopyPasteListener
    implements CopyPasteManager.ContentChangedListener {
        private final JTree myTree;
        private final StructureTreeModel myModel;

        public RemoteHostCopyPasteListener(JTree tree, StructureTreeModel model) {
            this.myTree = tree;
            this.myModel = model;
        }

        public void contentChanged(Transferable oldTransferable, Transferable newTransferable) {
            this.updateByTransferable(oldTransferable);
            this.updateByTransferable(newTransferable);
        }

        private void updateByTransferable(Transferable t) {
            PsiElement[] elements = CopyPasteUtil.getElementsInTransferable((Transferable)t);
            if (elements.length == 0) {
                return;
            }
            PsiElement fileWithData = elements[0];
            Collection<WebServerConfig.RemotePath> paths = RemoteMoveProvider.getPaths(fileWithData);
            if (paths == null || paths.isEmpty()) {
                return;
            }
            Collection<ServerTreeNode> nodes = RemoteMoveProvider.getServerNodes(paths, this.myTree);
            if (nodes == null) {
                return;
            }
            for (ServerTreeNode serverTreeNode : nodes) {
                SimpleNode toUpdate = serverTreeNode.getParent();
                if (toUpdate == null) continue;
                this.myModel.invalidate((Object)toUpdate, true);
            }
        }
    }
}

