/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.pro.customization.aitoolkit;

import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/pycharm/pro/customization/aitoolkit/ResizableImageComponent;", "Ljavax/swing/JComponent;", "icon", "Ljavax/swing/Icon;", "<init>", "(Ljavax/swing/Icon;)V", "MAX_HEIGHT_PERCENTAGE", "", "image", "Ljava/awt/Image;", "kotlin.jvm.PlatformType", "getPreferredSize", "Ljava/awt/Dimension;", "getMinimumSize", "getMaximumSize", "paintComponent", "", "g", "Ljava/awt/Graphics;", "intellij.pycharm.pro.customization"})
public final class ResizableImageComponent
extends JComponent {
    @NotNull
    private final Icon icon;
    private final float MAX_HEIGHT_PERCENTAGE;
    private final Image image;

    /*
     * WARNING - void declaration
     */
    public ResizableImageComponent(@NotNull Icon icon) {
        Image image;
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        this.icon = icon;
        this.MAX_HEIGHT_PERCENTAGE = 0.6f;
        if (this.icon instanceof ImageIcon) {
            image = ((ImageIcon)this.icon).getImage();
        } else {
            void var2_2;
            BufferedImage bufferedImage = UIUtil.createImage((Component)this, (int)this.icon.getIconWidth(), (int)this.icon.getIconHeight(), (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
            BufferedImage bufferedImage2 = bufferedImage;
            Graphics2D imageG = bufferedImage2.createGraphics();
            this.icon.paintIcon(this, imageG, 0, 0);
            imageG.dispose();
            image = (Image)var2_2;
        }
        this.image = image;
        this.setAlignmentX(0.5f);
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight());
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return new Dimension(this.icon.getIconWidth() / 2, this.icon.getIconHeight() / 2);
    }

    @Override
    @NotNull
    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Graphics2D graphics2D;
        int availableWidth;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paintComponent(g);
        float ratio = (float)this.icon.getIconWidth() / (float)this.icon.getIconHeight();
        int scaledWidth = availableWidth = this.getWidth();
        int scaledHeight = (int)((float)availableWidth / ratio);
        int x = 0;
        Container container = this.getParent();
        int parentHeight = container != null && (container = container.getParent()) != null ? container.getHeight() : this.getHeight();
        int maxAllowedHeight = (int)((float)parentHeight * this.MAX_HEIGHT_PERCENTAGE);
        if (scaledHeight > maxAllowedHeight) {
            scaledHeight = maxAllowedHeight;
            scaledWidth = (int)((float)scaledHeight * ratio);
            x = (this.getWidth() - scaledWidth) / 2;
        }
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D $this$paintComponent_u24lambda_u240 = graphics2D = (Graphics2D)graphics;
        boolean bl = false;
        $this$paintComponent_u24lambda_u240.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        $this$paintComponent_u24lambda_u240.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        $this$paintComponent_u24lambda_u240.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Graphics2D g2d = graphics2D;
        g2d.drawImage(this.image, x, 0, scaledWidth, scaledHeight, null);
        g2d.dispose();
    }
}

