/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pycharm.pro.customization.aitoolkit.utility;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.pycharm.pro.customization.aitoolkit.services.Requirements;
import com.intellij.pycharm.pro.customization.aitoolkit.utility.PythonVersion;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.sdk.legacy.PythonSdkUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/pycharm/pro/customization/aitoolkit/utility/RunnerCommon;", "", "<init>", "()V", "isSupportedExecutor", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "supportedExecutors", "", "intellij.pycharm.pro.customization"})
public final class RunnerCommon {
    @NotNull
    public static final RunnerCommon INSTANCE = new RunnerCommon();

    private RunnerCommon() {
    }

    public final boolean isSupportedExecutor(@NotNull String executorId, @NotNull RunProfile profile, @NotNull Set<String> supportedExecutors) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        Intrinsics.checkNotNullParameter(supportedExecutors, (String)"supportedExecutors");
        if (!supportedExecutors.contains(executorId)) {
            return false;
        }
        PythonRunConfiguration pythonRunConfiguration = profile instanceof PythonRunConfiguration ? (PythonRunConfiguration)profile : null;
        if (pythonRunConfiguration == null) {
            return false;
        }
        PythonRunConfiguration profile2 = pythonRunConfiguration;
        Sdk sdk = profile2.getSdk();
        if (sdk == null) {
            return false;
        }
        Sdk sdk2 = sdk;
        String string = sdk2.getVersionString();
        if (string == null) {
            return false;
        }
        String versionString = string;
        PythonVersion pythonVersion = PythonVersion.Companion.parse(versionString);
        if (pythonVersion == null) {
            return false;
        }
        PythonVersion pythonVersion2 = pythonVersion;
        return pythonVersion2.compareTo(Requirements.INSTANCE.getMinimumPythonVersion()) >= 0 && !PythonSdkUtil.isRemote((Sdk)sdk2);
    }
}

