/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.hive;

import com.intellij.database.DatabaseBundle;
import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.hive.HiveDdlParsing;
import com.intellij.sql.dialects.hive.HiveDmlParsing;
import com.intellij.sql.dialects.hive.HiveExpressionParsing;
import com.intellij.sql.dialects.hive.HiveGeneratedParser;
import com.intellij.sql.dialects.hive.HiveTypes;
import com.intellij.sql.psi.SqlReferenceElementType;
import org.jetbrains.annotations.Nullable;

public abstract class HiveParserBase
extends SqlParser {
    protected HiveParserBase(SqlLanguageDialectEx language) {
        super(language);
    }

    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean first2) {
        if (SqlGeneratedParserUtil.isExternalParameterFirst((IElementType)builder.getTokenType())) {
            return true;
        }
        return SqlParserUtil.nextTokenIs((PsiBuilder)builder, (IElementType)SQL_STRING_TOKEN);
    }

    public boolean allowStringsAsIdentifiers(@Nullable SqlReferenceElementType refType) {
        return refType == SQL_FUNCTION_REFERENCE;
    }

    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        return HiveGeneratedParser.statement(builder, level);
    }

    public boolean parseOdbcSequence(PsiBuilder builder) {
        return false;
    }

    protected TokenSet[] getExtendsTokenSets() {
        return HiveGeneratedParser.EXTENDS_SETS_;
    }

    public boolean parseQueryExpression(PsiBuilder builder, int level) {
        return HiveDmlParsing.top_query_expression(builder, level);
    }

    public boolean parseDataType(PsiBuilder builder, int level, boolean ext) {
        return HiveDdlParsing.type_element(builder, level);
    }

    public boolean parseEvaluableExpression(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.parseAndRemapToGenericReference((PsiBuilder)builder, (int)level, HiveExpressionParsing::evaluable_expression);
    }

    public boolean parseValueExpression(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean result = HiveExpressionParsing.value_expression(builder, level);
        if (!result && !optional) {
            builder.error(DatabaseBundle.message((String)"parsing.error.expression.expected", (Object[])new Object[0]));
        }
        return result;
    }

    public boolean parseFunctionArgument(PsiBuilder builder, int level, boolean optional, boolean allowBoolean) {
        boolean distinct = SqlParserUtil.consumeToken((PsiBuilder)builder, (boolean)true, (IElementType)HiveTypes.HIVE_DISTINCT);
        boolean all = false;
        if (!distinct) {
            all = SqlParserUtil.consumeToken((PsiBuilder)builder, (boolean)true, (IElementType)HiveTypes.HIVE_ALL);
        }
        return super.parseFunctionArgument(builder, level, optional && !distinct && !all, allowBoolean);
    }

    public boolean parseFunctionCallTail(PsiBuilder builder, int level) {
        if (!super.parseFunctionCallTail(builder, level)) {
            return false;
        }
        HiveGeneratedParser.analytic_clause(builder, level);
        return true;
    }

    public boolean parseParenContentQorJ(PsiBuilder builder, int level) {
        return SqlGeneratedParserUtil.dispatchQandXconflict((PsiBuilder)builder, (int)level, HiveDmlParsing::parenthesized_aliased_join_expression, HiveDmlParsing::top_query_expression, HiveParserBase::parseTopQueryExpressionTail, (b, l) -> HiveDmlParsing.join_expression(b, l, -1), (b, l) -> HiveDmlParsing.join_expression_0(b, l, -1));
    }

    public boolean parseForeignKeyRefList(PsiBuilder builder, int level) {
        return HiveGeneratedParser.table_column_list(builder, level);
    }

    public static boolean parseTopQueryExpressionTail(PsiBuilder builder, int level) {
        HiveDmlParsing.query_expression_0(builder, level, -1);
        return HiveDmlParsing.left_inner_table_op_tail(builder, level);
    }

    protected boolean parseExtraRoots(IElementType root, PsiBuilder builder, int level) {
        return HiveGeneratedParser.parse_root_(root, builder, level);
    }
}

