/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.requests;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.RdPatchItemVersion;
import com.jetbrains.rd.ide.model.RdTransparentItem;
import com.jetbrains.rd.ide.requests.ChangeScope;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000fH\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rd/ide/requests/PatchBuilder;", "Lcom/jetbrains/rd/ide/requests/ChangeScope;", "featuresAllowed", "", "<init>", "(Z)V", "getFeaturesAllowed", "()Z", "expectedItems", "", "Lcom/jetbrains/rd/ide/model/RdPatchItemId;", "Lcom/jetbrains/rd/ide/model/RdPatchItemVersion;", "updatedItems", "changes", "", "Lcom/jetbrains/rd/ide/model/RdPatchItem;", "features", "buildPatchAndClear", "Lcom/jetbrains/rd/ide/model/RdPatch;", "pushExpected", "", "version", "pushUpdated", "pushChange", "step", "pushFeature", "getLastNonTransparentChange", "intellij.rd.platform"})
@SourceDebugExtension(value={"SMAP\nPatchBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchBuilder.kt\ncom/jetbrains/rd/ide/requests/PatchBuilder\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n23#2:49\n543#3,6:50\n*S KotlinDebug\n*F\n+ 1 PatchBuilder.kt\ncom/jetbrains/rd/ide/requests/PatchBuilder\n*L\n39#1:49\n46#1:50,6\n*E\n"})
public final class PatchBuilder
implements ChangeScope {
    private final boolean featuresAllowed;
    @NotNull
    private final Map<RdPatchItemId, RdPatchItemVersion> expectedItems;
    @NotNull
    private final Map<RdPatchItemId, RdPatchItemVersion> updatedItems;
    @NotNull
    private final List<RdPatchItem> changes;
    @NotNull
    private final List<RdPatchItem> features;

    public PatchBuilder(boolean featuresAllowed) {
        this.featuresAllowed = featuresAllowed;
        this.expectedItems = new LinkedHashMap();
        this.updatedItems = new LinkedHashMap();
        this.changes = new ArrayList();
        this.features = new ArrayList();
    }

    public final boolean getFeaturesAllowed() {
        return this.featuresAllowed;
    }

    @NotNull
    public final RdPatch buildPatchAndClear() {
        RdPatch rdPatch = new RdPatch(CollectionsKt.toList((Iterable)this.changes), CollectionsKt.toList((Iterable)this.features), CollectionsKt.toList((Iterable)this.expectedItems.values()), CollectionsKt.toList((Iterable)this.updatedItems.values()));
        this.expectedItems.clear();
        this.updatedItems.clear();
        this.changes.clear();
        this.features.clear();
        return rdPatch;
    }

    @Override
    public void pushExpected(@NotNull RdPatchItemVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.expectedItems.putIfAbsent(version.getId(), version);
    }

    @Override
    public void pushUpdated(@NotNull RdPatchItemVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.updatedItems.put(version.getId(), version);
    }

    @Override
    public void pushChange(@NotNull RdPatchItem step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        this.changes.add(step);
    }

    @Override
    public void pushFeature(@NotNull RdPatchItem step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        if (!this.featuresAllowed) {
            PatchBuilder $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(PatchBuilder.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("features not allowed");
        }
        this.features.add(step);
    }

    @Override
    @Nullable
    public RdPatchItem getLastNonTransparentChange() {
        RdPatchItem rdPatchItem;
        block1: {
            List<RdPatchItem> $this$lastOrNull$iv = this.changes;
            boolean $i$f$lastOrNull = false;
            ListIterator<RdPatchItem> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                RdPatchItem element$iv;
                RdPatchItem it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(!(it instanceof RdTransparentItem))) continue;
                rdPatchItem = element$iv;
                break block1;
            }
            rdPatchItem = null;
        }
        return rdPatchItem;
    }
}

