/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.constant;

import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.lang.javascript.psi.util.ExpressionUtil;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import java.math.BigInteger;
import org.intellij.idea.lang.javascript.intention.JSIntentionBundle;
import org.intellij.idea.lang.javascript.intention.JSMutablyNamedIntention;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSConstantExpressionIntention
extends JSMutablyNamedIntention {
    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        return new ConstantExpressionPredicate();
    }

    @Override
    public void processIntention(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            JSConstantExpressionIntention.$$$reportNull$$$0(0);
        }
        if (element == null) {
            JSConstantExpressionIntention.$$$reportNull$$$0(1);
        }
        JSExpression expression = (JSExpression)element;
        Object value = ExpressionUtil.computeConstantExpression((JSExpression)expression);
        String newExpression = JSConstantExpressionIntention.formatValue(value, expression);
        JSRefactoringUtil.replaceExpressionAndReformat((JSExpression)expression, (String)newExpression);
    }

    @Override
    protected String getTextForElement(PsiElement element) {
        if (element instanceof JSExpression && JSConstantExpressionIntention.isStringConcatenation((JSExpression)element)) {
            return JSIntentionBundle.message("string.join-concatenated-string-literals.display-name", new Object[0]);
        }
        return JSIntentionBundle.message("constant.constant-expression.display-name", new Object[0]);
    }

    @NotNull
    @IntentionFamilyName
    public String getFamilyName() {
        String string = JSIntentionBundle.message("constant.constant-expression.family-name", new Object[0]);
        if (string == null) {
            JSConstantExpressionIntention.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static boolean isStringConcatenation(JSExpression element) {
        return element instanceof JSBinaryExpression && ((JSBinaryExpression)element).getOperationSign() == JSTokenTypes.PLUS && JSConstantExpressionIntention.isLiteralOrConcatenation(((JSBinaryExpression)element).getLOperand()) && JSConstantExpressionIntention.isLiteralOrConcatenation(((JSBinaryExpression)element).getROperand());
    }

    private static boolean isLiteralOrConcatenation(JSExpression operand) {
        return operand instanceof JSLiteralExpression && ((JSLiteralExpression)operand).isQuotedLiteral() || JSConstantExpressionIntention.isStringConcatenation(operand) || operand instanceof JSParenthesizedExpression && JSConstantExpressionIntention.isLiteralOrConcatenation(((JSParenthesizedExpression)operand).getInnerExpression());
    }

    public static String formatValue(Object value, JSExpression expression) {
        if (value instanceof String) {
            String quote = JSCodeStyleSettings.getQuote((PsiElement)expression);
            String escapedValue = JSConstantExpressionIntention.escapeStringCharacters((String)value, quote);
            return quote + escapedValue + quote;
        }
        if (value instanceof BigInteger && DialectDetector.hasFeature((PsiElement)expression, (JSLanguageFeature)JSLanguageFeature.BIG_INT)) {
            return String.valueOf(value) + "n";
        }
        return String.valueOf(value);
    }

    @NotNull
    private static String escapeStringCharacters(String value, String quote) {
        StringBuilder buffer = new StringBuilder(value.length());
        String string = StringUtil.escapeStringCharacters((int)value.length(), (String)value, (String)quote, (boolean)false, (StringBuilder)buffer).toString();
        if (string == null) {
            JSConstantExpressionIntention.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static boolean shouldUseTemplateString(@NotNull JSExpression expression) {
        if (expression == null) {
            JSConstantExpressionIntention.$$$reportNull$$$0(4);
        }
        if (!DialectDetector.hasFeature((PsiElement)expression, (JSLanguageFeature)JSLanguageFeature.STRING_TEMPLATES)) {
            return false;
        }
        Ref result = new Ref();
        PsiTreeUtil.processElements((PsiElement)expression, element -> {
            if (!result.isNull()) {
                return false;
            }
            if (element instanceof JSStringTemplateExpression) {
                result.set((Object)true);
            }
            return true;
        });
        return Boolean.TRUE == result.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/idea/lang/javascript/intention/constant/JSConstantExpressionIntention";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/idea/lang/javascript/intention/constant/JSConstantExpressionIntention";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeStringCharacters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processIntention";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseTemplateString";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class ConstantExpressionPredicate
    implements JSElementPredicate {
        private ConstantExpressionPredicate() {
        }

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                ConstantExpressionPredicate.$$$reportNull$$$0(0);
            }
            if (!(element instanceof JSExpression)) {
                return false;
            }
            JSExpression expression = (JSExpression)element;
            if (PsiUtilCore.hasErrorElementChild((PsiElement)element)) {
                return false;
            }
            if (element instanceof JSLiteralExpression || element instanceof JSReferenceExpression && ((JSReferenceExpression)element).getQualifier() != null || expression instanceof JSCallExpression) {
                return false;
            }
            if (!ExpressionUtil.isConstantExpression((JSExpression)expression, (boolean)false)) {
                return false;
            }
            if (ExpressionUtil.computeConstantExpression((JSExpression)expression) == null) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (!(parent instanceof JSExpression)) {
                return true;
            }
            return !ExpressionUtil.isConstantExpression((JSExpression)((JSExpression)parent), (boolean)false) && !JSConstantExpressionIntention.shouldUseTemplateString(expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/constant/JSConstantExpressionIntention$ConstantExpressionPredicate", "satisfiedBy"));
        }
    }
}

