/*
 * Decompiled with CFR 0.152.
 */
package zmq.socket.clientserver;

import java.util.HashMap;
import java.util.Map;
import zmq.Ctx;
import zmq.Msg;
import zmq.SocketBase;
import zmq.pipe.Pipe;
import zmq.socket.FQ;
import zmq.util.Blob;
import zmq.util.Utils;
import zmq.util.ValueReference;

public class Server
extends SocketBase {
    private final FQ fq;
    private final Map<Integer, Outpipe> outpipes;
    private int nextRid = Utils.randomInt();

    public Server(Ctx parent, int tid, int sid) {
        super(parent, tid, sid, true);
        this.options.type = 12;
        this.options.canSendHelloMsg = true;
        this.options.canReceiveDisconnectMsg = true;
        this.fq = new FQ();
        this.outpipes = new HashMap<Integer, Outpipe>();
    }

    @Override
    protected void destroy() {
        assert (this.outpipes.isEmpty());
        super.destroy();
    }

    @Override
    public void xattachPipe(Pipe pipe, boolean subscribe2all, boolean isLocallyInitiated) {
        int routingId;
        assert (pipe != null);
        if ((routingId = this.nextRid++) == 0) {
            routingId = this.nextRid++;
        }
        pipe.setRoutingId(routingId);
        Outpipe outpipe = new Outpipe(pipe, true);
        Outpipe prev = this.outpipes.put(routingId, outpipe);
        assert (prev == null);
        this.fq.attach(pipe);
    }

    @Override
    public void xpipeTerminated(Pipe pipe) {
        Outpipe old = this.outpipes.remove(pipe.getRoutingId());
        assert (old != null);
        this.fq.terminated(pipe);
    }

    @Override
    public void xreadActivated(Pipe pipe) {
        this.fq.activated(pipe);
    }

    @Override
    public void xwriteActivated(Pipe pipe) {
        Outpipe out = this.outpipes.get(pipe.getRoutingId());
        assert (out != null);
        assert (!out.active);
        out.active = true;
    }

    @Override
    protected boolean xsend(Msg msg) {
        if (msg.hasMore()) {
            this.errno.set(22);
            return false;
        }
        int routingId = msg.getRoutingId();
        Outpipe out = this.outpipes.get(routingId);
        if (out != null) {
            if (!out.pipe.checkWrite()) {
                out.active = false;
                this.errno.set(35);
                return false;
            }
        } else {
            this.errno.set(65);
            return false;
        }
        msg.resetRoutingId();
        boolean ok = out.pipe.write(msg);
        if (ok) {
            out.pipe.flush();
        }
        return true;
    }

    @Override
    protected Msg xrecv() {
        ValueReference<Pipe> pipe = new ValueReference<Pipe>();
        Msg msg = this.fq.recvPipe(this.errno, pipe);
        while (msg != null && msg.hasMore()) {
            msg = this.fq.recvPipe(this.errno, null);
            while (msg != null && msg.hasMore()) {
                msg = this.fq.recvPipe(this.errno, null);
            }
            if (msg == null) continue;
            msg = this.fq.recvPipe(this.errno, pipe);
        }
        if (msg == null) {
            return msg;
        }
        assert (pipe.get() != null);
        int routingId = pipe.get().getRoutingId();
        msg.setRoutingId(routingId);
        return msg;
    }

    @Override
    protected boolean xhasIn() {
        return this.fq.hasIn();
    }

    @Override
    protected boolean xhasOut() {
        return true;
    }

    @Override
    protected Blob getCredential() {
        return this.fq.getCredential();
    }

    @Override
    protected boolean xdisconnectPeer(int routingId) {
        Outpipe out = this.outpipes.get(routingId);
        if (out != null) {
            out.pipe.terminate(false);
            return true;
        }
        this.errno.set(65);
        return false;
    }

    static class Outpipe {
        private final Pipe pipe;
        private boolean active;

        public Outpipe(Pipe pipe, boolean active) {
            this.pipe = pipe;
            this.active = active;
        }
    }
}

