/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.split.backend;

import com.intellij.jupyter.core.executor.JupyterExecutionState;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterOutputListener;
import com.intellij.jupyter.core.jupyter.nbformat.tags.JupyterTagsService;
import com.intellij.jupyter.split.backend.RemoteJupyterBackendCoroutineService;
import com.intellij.jupyter.split.backend.RemoteJupyterOutputsImpl;
import com.intellij.jupyter.split.common.CellExecutionStatus;
import com.intellij.jupyter.split.common.CellOutputsData;
import com.intellij.jupyter.split.common.utils.JupyterRemoteOutputsUtils;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.outputs.NotebookOutputDataKeyExtractor;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorId;
import com.intellij.openapi.editor.impl.EditorIdKt;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderEx;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.RdDocumentVersion;
import com.jetbrains.rdserver.document.BackendDocumentHost;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.EventListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.serialization.json.JsonElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0015\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u0004\u0018\u00010\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/jupyter/split/backend/BackendNotebookModel;", "Lcom/intellij/openapi/Disposable$Default;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterOutputListener;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/client/ClientProjectSession;Lcom/intellij/openapi/editor/Editor;)V", "outputUpdated", "", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "pointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "interval", "Lcom/intellij/notebooks/visualization/NotebookCellLines$Interval;", "allOutputsUpdated", "executionInfoUpdated", "createCellExecutionStatus", "Lcom/intellij/jupyter/split/common/CellExecutionStatus;", "createCellData", "Lcom/intellij/jupyter/split/common/CellOutputsData;", "currentDocumentVersion", "", "toEpochMilli", "", "Ljava/time/ZonedDateTime;", "(Ljava/time/ZonedDateTime;)Ljava/lang/Long;", "Companion", "intellij.jupyter.split.backend"})
@SourceDebugExtension(value={"SMAP\nBackendNotebookModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendNotebookModel.kt\ncom/intellij/jupyter/split/backend/BackendNotebookModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n1869#2,2:130\n1#3:132\n*S KotlinDebug\n*F\n+ 1 BackendNotebookModel.kt\ncom/intellij/jupyter/split/backend/BackendNotebookModel\n*L\n55#1:130,2\n*E\n"})
public final class BackendNotebookModel
implements Disposable.Default,
JupyterOutputListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final Editor editor;
    @NotNull
    private static final Key<BackendNotebookModel> INSTANCE_KEY = new Key("BackendNotebookModel");

    private BackendNotebookModel(ClientProjectSession session, Editor editor) {
        block0: {
            this.session = session;
            this.editor = editor;
            JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookOrNull((Editor)this.editor);
            if (jupyterNotebook == null) break block0;
            JupyterNotebook notebook = jupyterNotebook;
            boolean bl = false;
            notebook.getListeners().getOutputListeners().addListener((EventListener)((Object)this), (Disposable)this);
            this.allOutputsUpdated(notebook);
        }
    }

    public void outputUpdated(@NotNull JupyterNotebook notebook, @NotNull NotebookIntervalPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        NotebookCellLines.Interval interval = pointer.get();
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval interval2 = interval;
        this.outputUpdated(interval2);
    }

    private final void outputUpdated(NotebookCellLines.Interval interval) {
        CellOutputsData cellData = this.createCellData(interval);
        BuildersKt.launch$default((CoroutineScope)RemoteJupyterBackendCoroutineService.Companion.getInstance().getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(cellData, null){
            int label;
            final /* synthetic */ CellOutputsData $cellData;
            {
                this.$cellData = $cellData;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = RemoteJupyterOutputsImpl.INSTANCE.getResultUpdateFlow().emit((Object)this.$cellData, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public void allOutputsUpdated(@NotNull JupyterNotebook notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        NotebookCellLines cellLines = NotebookCellLines.Companion.get(this.editor);
        Iterable $this$forEach$iv = cellLines.getIntervals();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NotebookCellLines.Interval it = (NotebookCellLines.Interval)element$iv;
            boolean bl = false;
            this.outputUpdated(it);
            this.executionInfoUpdated(it);
        }
    }

    public void executionInfoUpdated(@NotNull JupyterNotebook notebook, @NotNull NotebookIntervalPointer pointer) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        Intrinsics.checkNotNullParameter((Object)pointer, (String)"pointer");
        NotebookCellLines.Interval interval = pointer.get();
        if (interval == null) {
            return;
        }
        NotebookCellLines.Interval interval2 = interval;
        this.executionInfoUpdated(interval2);
    }

    private final void executionInfoUpdated(NotebookCellLines.Interval interval) {
        CellExecutionStatus cellExecutionStatus = this.createCellExecutionStatus(interval);
        if (cellExecutionStatus == null) {
            return;
        }
        CellExecutionStatus cellExecutionStatus2 = cellExecutionStatus;
        BuildersKt.launch$default((CoroutineScope)RemoteJupyterBackendCoroutineService.Companion.getInstance().getCoroutineScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(cellExecutionStatus2, null){
            int label;
            final /* synthetic */ CellExecutionStatus $cellExecutionStatus;
            {
                this.$cellExecutionStatus = $cellExecutionStatus;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = RemoteJupyterOutputsImpl.INSTANCE.getStatusUpdateFlow().emit((Object)this.$cellExecutionStatus, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final CellExecutionStatus createCellExecutionStatus(NotebookCellLines.Interval interval) {
        int cellIndex = interval.getOrdinal();
        JupyterNotebook jupyterNotebook = JupyterEditorExtensionsKt.getNotebookOrNull((Editor)this.editor);
        if (jupyterNotebook == null || (jupyterNotebook = jupyterNotebook.getCellOrNull(cellIndex)) == null) {
            return null;
        }
        JupyterNotebook jupyterCell = jupyterNotebook;
        JupyterExecutionState jupyterExecutionState = JupyterExecutionState.Companion.getJupyterExecutionState(this.editor);
        ProgressStatus progressStatus = jupyterExecutionState != null ? jupyterExecutionState.getProgressStatus(cellIndex) : null;
        return new CellExecutionStatus(EditorIdKt.editorId((Editor)this.editor), cellIndex, this.currentDocumentVersion(), progressStatus, this.toEpochMilli(jupyterCell.getExecutionStartTime()), this.toEpochMilli(jupyterCell.getExecutionEndTime()), jupyterCell.getExecutionCount());
    }

    private final CellOutputsData createCellData(NotebookCellLines.Interval interval) {
        List result2;
        List list;
        int cellIndex;
        block2: {
            cellIndex = interval.getOrdinal();
            for (NotebookOutputDataKeyExtractor it : (Iterable)NotebookOutputDataKeyExtractor.EP_NAME.getExtensionList()) {
                boolean bl = false;
                Editor editor = this.editor;
                Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
                List list2 = it.extract((Editor)((EditorImpl)editor), interval);
                if (list2 == null) continue;
                list = list2;
                break block2;
            }
            list = null;
        }
        List list3 = result2 = list;
        List<JsonElement> encodedResult = list3 == null ? CollectionsKt.emptyList() : JupyterRemoteOutputsUtils.INSTANCE.encodeToJsonElementList(list3);
        EditorId editorId = EditorIdKt.editorId((Editor)this.editor);
        int n = this.currentDocumentVersion();
        List list4 = JupyterTagsService.Companion.getInstance().getTagsForCell(this.editor, cellIndex);
        if (list4 == null) {
            list4 = CollectionsKt.emptyList();
        }
        return new CellOutputsData(editorId, cellIndex, n, encodedResult, list4);
    }

    private final int currentDocumentVersion() {
        RdDocumentVersion documentVersion;
        BackendDocumentHost documentHost = BackendDocumentHost.Companion.getInstance(this.session.getAppSession());
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        DocumentSynchronizer documentSynchronizer = documentHost.tryGetSynchronizer(document);
        AbstractDocumentVersion abstractDocumentVersion = documentSynchronizer != null ? documentSynchronizer.getVersion() : null;
        RdDocumentVersion rdDocumentVersion = documentVersion = abstractDocumentVersion instanceof RdDocumentVersion ? (RdDocumentVersion)abstractDocumentVersion : null;
        return rdDocumentVersion != null ? rdDocumentVersion.getValue() : -1;
    }

    private final Long toEpochMilli(ZonedDateTime $this$toEpochMilli) {
        Comparable<ChronoZonedDateTime<?>> comparable = $this$toEpochMilli;
        return comparable != null && (comparable = comparable.toInstant()) != null ? Long.valueOf(((Instant)comparable).toEpochMilli()) : null;
    }

    public /* synthetic */ BackendNotebookModel(ClientProjectSession session, Editor editor, DefaultConstructorMarker $constructor_marker) {
        this(session, editor);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000b\u001a\u00020\u000eR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/jupyter/split/backend/BackendNotebookModel$Companion;", "", "<init>", "()V", "INSTANCE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/split/backend/BackendNotebookModel;", "install", "", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "get", "Lcom/intellij/openapi/editor/Editor;", "intellij.jupyter.split.backend"})
    @SourceDebugExtension(value={"SMAP\nBackendNotebookModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendNotebookModel.kt\ncom/intellij/jupyter/split/backend/BackendNotebookModel$Companion\n+ 2 UserDataHolderEx.kt\ncom/intellij/openapi/util/UserDataHolderExKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,129:1\n11#2:130\n12#2:132\n1#3:131\n*S KotlinDebug\n*F\n+ 1 BackendNotebookModel.kt\ncom/intellij/jupyter/split/backend/BackendNotebookModel$Companion\n*L\n120#1:130\n120#1:132\n120#1:131\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final void install(@NotNull ClientProjectSession session, @NotNull EditorImpl editor) {
            void $this$getOrCreateUserData$iv;
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            UserDataHolderEx userDataHolderEx = (UserDataHolderEx)editor;
            Key key$iv = INSTANCE_KEY;
            boolean $i$f$getOrCreateUserData = false;
            Object object = $this$getOrCreateUserData$iv.getUserData(key$iv);
            if (object != null) {
                Object it$iv = object;
                boolean bl = false;
                v1 = it$iv;
            } else {
                BackendNotebookModel backendNotebookModel;
                Key key = key$iv;
                void var12_9 = $this$getOrCreateUserData$iv;
                boolean bl = false;
                BackendNotebookModel $this$install_u24lambda_u240_u240 = backendNotebookModel = new BackendNotebookModel(session, (Editor)editor, null);
                boolean bl2 = false;
                Disposer.register((Disposable)editor.getDisposable(), (Disposable)((Disposable)$this$install_u24lambda_u240_u240));
                BackendNotebookModel backendNotebookModel2 = backendNotebookModel;
                Object object2 = var12_9.putUserDataIfAbsent(key, (Object)backendNotebookModel2);
                v1 = object2;
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"putUserDataIfAbsent(...)");
            }
        }

        @Nullable
        public final BackendNotebookModel get(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (BackendNotebookModel)editor.getUserData(INSTANCE_KEY);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

