/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class InspectionCommand
extends AbstractCommand {
    public static final String PREFIX = "%inspectCode";

    public InspectionCommand(@NotNull String text, int line) {
        if (text == null) {
            InspectionCommand.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(final @NotNull PlaybackContext context) {
        if (context == null) {
            InspectionCommand.$$$reportNull$$$0(1);
        }
        final ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String extension = this.extractCommandArgument(PREFIX);
        @NotNull Project project = context.getProject();
        DumbService.getInstance((Project)project).smartInvokeLater(() -> {
            InspectionManagerEx inspectionManagerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
            GlobalInspectionContextImpl inspectionContext = new GlobalInspectionContextImpl(project, inspectionManagerEx.getContentManager()){

                protected void notifyInspectionsFinished(@NotNull AnalysisScope scope) {
                    if (scope == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.notifyInspectionsFinished(scope);
                    context.message(PerformanceTestingBundle.message("command.inspection.finish", new Object[0]), InspectionCommand.this.getLine());
                    actionCallback.setDone();
                }

                protected void canceled() {
                    super.canceled();
                    context.message("inspection was canceled", InspectionCommand.this.getLine());
                    actionCallback.reject("inspection was canceled");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/jetbrains/performancePlugin/commands/InspectionCommand$1", "notifyInspectionsFinished"));
                }
            };
            AnalysisScope scope = InspectionCommand.getAnalysisScope(extension, project);
            if (scope == null) {
                context.message(PerformanceTestingBundle.message("command.inspection.extension", new Object[0]) + " " + extension, this.getLine());
            } else {
                inspectionContext.doInspections(scope);
            }
        });
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            InspectionCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    @Nullable
    public static AnalysisScope getAnalysisScope(String extension, @NotNull Project project) {
        AnalysisScope scope;
        if (project == null) {
            InspectionCommand.$$$reportNull$$$0(3);
        }
        if (extension.isEmpty()) {
            scope = new AnalysisScope(project);
        } else {
            Collection<VirtualFile> files = InspectionCommand.getFiles(extension, project);
            if (files.isEmpty()) {
                return null;
            }
            scope = new AnalysisScope(project, InspectionCommand.getFiles(extension, project));
        }
        return scope;
    }

    @NotNull
    private static Collection<VirtualFile> getFiles(@NotNull String extension, @NotNull Project project) {
        if (extension == null) {
            InspectionCommand.$$$reportNull$$$0(4);
        }
        if (project == null) {
            InspectionCommand.$$$reportNull$$$0(5);
        }
        HashSet<VirtualFile> files = new HashSet<VirtualFile>(100);
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project).getFileIndex();
        index.iterateContent(fileOrDir -> {
            if (StringUtil.equals((CharSequence)fileOrDir.getExtension(), (CharSequence)extension)) {
                files.add(fileOrDir);
            }
            return true;
        });
        HashSet<VirtualFile> hashSet = files;
        if (hashSet == null) {
            InspectionCommand.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/InspectionCommand";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/InspectionCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnalysisScope";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6 -> new IllegalStateException(string);
        };
    }
}

