/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.coverage;

import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.python.community.helpersLocator.PythonHelpersLocator;
import com.intellij.python.pro.coverage.PyCoverageEnabledConfiguration;
import com.intellij.python.pro.coverage.PyCoverageNotImportableException;
import com.intellij.python.pro.coverage.PyCoverageOptionsProvider;
import com.intellij.python.pro.coverage.PyCoverageTargetedCommandLineBuilderKt;
import com.intellij.python.pro.coverage.PyCoverageUtil;
import com.jetbrains.python.HelperPackage;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.run.PythonExecution;
import com.jetbrains.python.run.PythonScriptExecution;
import com.jetbrains.python.run.PythonScriptTargetedCommandLineBuilder;
import com.jetbrains.python.run.PythonScripts;
import com.jetbrains.python.run.target.HelpersAwareTargetEnvironmentRequest;
import java.io.File;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/python/pro/coverage/PyCoverageTargetedCommandLineBuilder;", "Lcom/jetbrains/python/run/PythonScriptTargetedCommandLineBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "interpreterParameters", "", "", "pyCoverageEnabledConfiguration", "Lcom/intellij/python/pro/coverage/PyCoverageEnabledConfiguration;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/util/List;Lcom/intellij/python/pro/coverage/PyCoverageEnabledConfiguration;)V", "build", "Lcom/jetbrains/python/run/PythonExecution;", "helpersAwareTargetRequest", "Lcom/jetbrains/python/run/target/HelpersAwareTargetEnvironmentRequest;", "pythonScript", "preparePyCoverageScriptExecution", "Lcom/jetbrains/python/run/PythonScriptExecution;", "Companion", "intellij.python"})
@SourceDebugExtension(value={"SMAP\nPyCoverageTargetedCommandLineBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyCoverageTargetedCommandLineBuilder.kt\ncom/intellij/python/pro/coverage/PyCoverageTargetedCommandLineBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1869#2,2:97\n*S KotlinDebug\n*F\n+ 1 PyCoverageTargetedCommandLineBuilder.kt\ncom/intellij/python/pro/coverage/PyCoverageTargetedCommandLineBuilder\n*L\n41#1:97,2\n*E\n"})
public final class PyCoverageTargetedCommandLineBuilder
implements PythonScriptTargetedCommandLineBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final Module module;
    @Nullable
    private final Sdk sdk;
    @NotNull
    private final List<String> interpreterParameters;
    @NotNull
    private final PyCoverageEnabledConfiguration pyCoverageEnabledConfiguration;
    @NotNull
    private static final String BUNDLED_COVERAGE_PATH = "BUNDLED_COVERAGE_PATH";

    public PyCoverageTargetedCommandLineBuilder(@NotNull Project project, @Nullable Module module, @Nullable Sdk sdk, @NotNull List<String> interpreterParameters, @NotNull PyCoverageEnabledConfiguration pyCoverageEnabledConfiguration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(interpreterParameters, (String)"interpreterParameters");
        Intrinsics.checkNotNullParameter((Object)((Object)pyCoverageEnabledConfiguration), (String)"pyCoverageEnabledConfiguration");
        this.project = project;
        this.module = module;
        this.sdk = sdk;
        this.interpreterParameters = interpreterParameters;
        this.pyCoverageEnabledConfiguration = pyCoverageEnabledConfiguration;
    }

    @NotNull
    public PythonExecution build(@NotNull HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest, @NotNull PythonExecution pythonScript) {
        Intrinsics.checkNotNullParameter((Object)helpersAwareTargetRequest, (String)"helpersAwareTargetRequest");
        Intrinsics.checkNotNullParameter((Object)pythonScript, (String)"pythonScript");
        return (PythonExecution)this.preparePyCoverageScriptExecution(pythonScript, helpersAwareTargetRequest);
    }

    private final PythonScriptExecution preparePyCoverageScriptExecution(PythonExecution pythonScript, HelpersAwareTargetEnvironmentRequest helpersAwareTargetRequest) {
        PythonScriptExecution coverageScript = PythonScripts.prepareHelperScriptExecution((HelperPackage)((HelperPackage)PythonHelper.COVERAGE), (HelpersAwareTargetEnvironmentRequest)helpersAwareTargetRequest);
        TargetEnvironmentRequest targetEnvironmentRequest = helpersAwareTargetRequest.getTargetEnvironmentRequest();
        PythonScripts.extendEnvs((PythonExecution)((PythonExecution)coverageScript), (Map)pythonScript.getEnvs(), (TargetPlatform)targetEnvironmentRequest.getTargetPlatform());
        coverageScript.setWorkingDir(pythonScript.getWorkingDir());
        String string = this.pyCoverageEnabledConfiguration.getCoverageFilePath();
        if (string == null) {
            throw new IllegalStateException("Coverage file path cannot be obtained");
        }
        String coverageFilePath = string;
        Iterable $this$forEach$iv = this.interpreterParameters;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            coverageScript.addParameter(it);
        }
        PyCoverageUtil.addRunCoverageEnv((PythonExecution)coverageScript);
        if (PyCoverageOptionsProvider.getInstance(this.project).isUseBundledCoveragePy()) {
            PyCoverageTargetedCommandLineBuilderKt.addBundledCoverageToTargetedCommandLine(this.sdk, (PythonExecution)coverageScript, helpersAwareTargetRequest);
        } else {
            String string2 = PythonHelper.COVERAGEPY_NEW.getPythonPathEntry();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPythonPathEntry(...)");
            coverageScript.addEnvironmentVariable(BUNDLED_COVERAGE_PATH, string2);
            Sdk sdk = this.sdk;
            if (!PyCoverageUtil.isCoverageAvailable(this.module, sdk != null ? sdk.getHomePath() : null)) {
                throw new PyCoverageNotImportableException(this.project, this.sdk);
            }
        }
        PythonScripts.disableBuiltinBreakpoint((PythonExecution)((PythonExecution)coverageScript), (Sdk)this.sdk);
        coverageScript.addParameter("run");
        if (PyCoverageOptionsProvider.getInstance(this.project).getBranchCoverage()) {
            coverageScript.addParameter("--branch");
        }
        coverageScript.addParameter("--omit=\"" + ((Object)PythonHelpersLocator.Companion.getCommunityHelpersRoot().toAbsolutePath()).toString() + "*\"");
        File coverageFile = new File(coverageFilePath);
        String coverageFileParentPath = coverageFile.getParent();
        String coverageFileName = coverageFile.getName();
        TargetEnvironment.DownloadRoot coverageDirDownloadRoot = new TargetEnvironment.DownloadRoot(Paths.get(coverageFileParentPath, new String[0]), (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(null, null, null, 7, null), null, 4, null);
        ((Collection)targetEnvironmentRequest.getDownloadVolumes()).add(coverageDirDownloadRoot);
        Function targetDownloadPath = TargetEnvironmentFunctions.getTargetDownloadPath((TargetEnvironment.DownloadRoot)coverageDirDownloadRoot);
        Intrinsics.checkNotNull((Object)coverageFileName);
        Function coverageTargetFile = TargetEnvironmentFunctions.getRelativeTargetPath((Function)targetDownloadPath, (String)coverageFileName);
        PyCoverageUtil.addCoverageFileEnv((PythonExecution)coverageScript, coverageTargetFile);
        PythonScripts.addPythonScriptAsParameter((PythonExecution)((PythonExecution)coverageScript), (PythonExecution)pythonScript);
        coverageScript.getParameters().addAll(pythonScript.getParameters());
        return coverageScript;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/python/pro/coverage/PyCoverageTargetedCommandLineBuilder$Companion;", "", "<init>", "()V", "BUNDLED_COVERAGE_PATH", "", "intellij.python"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

