/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pyramid.annotator;

import com.intellij.codeInsight.daemon.DefaultGutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.python.pyramid.project.PyramidUtils;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonProBundle;
import com.jetbrains.python.codeInsight.PyElementListCellRenderer;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyramidTemplateLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    private static final @NlsContexts.Tooltip String SELECT_VIEW_TOOLTIP = PythonProBundle.message((String)"pyramid.select.view.tooltip");
    private static final @NlsContexts.Label String VIEWS_GROUP = PythonProBundle.message((String)"pyramid.views.group");

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        if (element == null) {
            PyramidTemplateLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            PyramidTemplateLineMarkerProvider.$$$reportNull$$$0(1);
        }
        PyramidTemplateLineMarkerProvider.collectLineMarkersForElement(result, element);
    }

    private static void collectLineMarkersForElement(Collection<? super RelatedItemLineMarkerInfo<?>> result, PsiElement element) {
        RelatedItemLineMarkerInfo<XmlFile> info;
        if (element instanceof XmlFile && PyramidUtils.isPyramidProject(element) && (info = PyramidTemplateLineMarkerProvider.createLineMarker((XmlFile)element)) != null) {
            result.add(info);
        }
    }

    @Nullable
    private static RelatedItemLineMarkerInfo<XmlFile> createLineMarker(XmlFile file) {
        Set<PyStringLiteralExpression> result = PyramidTemplateLineMarkerProvider.getRenderers((PsiFile)file);
        if (!result.isEmpty()) {
            return new RelatedItemLineMarkerInfo((PsiElement)file, file.getTextRange(), PythonFileType.INSTANCE.getIcon(), (Function)new ConstantFunction((Object)SELECT_VIEW_TOOLTIP), (GutterIconNavigationHandler)new DefaultGutterIconNavigationHandler<XmlFile>(result, SELECT_VIEW_TOOLTIP){

                protected ListCellRenderer createListCellRenderer() {
                    return new PyElementListCellRenderer(){

                        public String getElementText(PsiElement element) {
                            String name = PyramidTemplateLineMarkerProvider.getReferenceViewName(element);
                            return name != null ? name : super.getElementText(element);
                        }
                    };
                }
            }, GutterIconRenderer.Alignment.RIGHT, () -> GotoRelatedItem.createItems((Collection)result, (String)VIEWS_GROUP));
        }
        return null;
    }

    public static Set<PyStringLiteralExpression> getRenderers(final PsiFile file) {
        PsiFile[] files;
        final HashSet<PyStringLiteralExpression> result = new HashSet<PyStringLiteralExpression>();
        Project project = file.getProject();
        for (PsiFile viewsFile : files = FilenameIndex.getFilesByName((Project)project, (String)"views.py", (GlobalSearchScope)ProjectScope.getProjectScope((Project)project))) {
            if (!(viewsFile instanceof PyFile)) continue;
            PyRecursiveElementVisitor visitor = new PyRecursiveElementVisitor(){

                public void visitPyStringLiteralExpression(@NotNull PyStringLiteralExpression node) {
                    String value2;
                    if (node == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if ((value2 = node.getStringValue()).endsWith(file.getName())) {
                        result.add(node);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/python/pyramid/annotator/PyramidTemplateLineMarkerProvider$2", "visitPyStringLiteralExpression"));
                }
            };
            viewsFile.accept((PsiElementVisitor)visitor);
        }
        return result;
    }

    private static String getReferenceViewName(PsiElement usage) {
        PyFunction func;
        PsiFile file = usage.getContainingFile();
        Object name = file.getName();
        PsiDirectory directory = file.getParent();
        if (directory != null) {
            name = directory.getName() + File.separator + (String)name;
        }
        if ((func = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)usage, PyFunction.class)) != null) {
            name = PythonProBundle.message((String)"pyramid.reference.view.name", (Object[])new Object[]{func.getName(), name});
        }
        return name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/pyramid/annotator/PyramidTemplateLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

