/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.remoteInterpreter.add.wizard;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.python.remoteInterpreter.PythonRemoteInterpreterBundle;
import com.intellij.python.remoteInterpreter.add.wizard.HandleSshSdkDisabledNotification;
import com.intellij.python.remoteInterpreter.add.wizard.HandleSshSdkSwitchNotification;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.ui.unified.SshConfigConfigurable;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.ui.config.DeploymentConfigurable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u001a\u001a\u0010\t\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001a\u0010\f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0012\u0010\u000f\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0012\u0010\u0010\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002\u001a\u0016\u0010\u0011\u001a\u00020\u00042\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00040\u0013H\u0002\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "kotlin.jvm.PlatformType", "handleSshSdkSwitch", "", "project", "Lcom/intellij/openapi/project/Project;", "webServerConfigId", "", "notifyLaterThatDeploymentConfigurationCreated", "webServerConfig", "Lcom/jetbrains/plugins/webDeployment/config/WebServerConfig;", "notifyLaterThatSshConfigurationCreated", "sshConfig", "Lcom/intellij/ssh/config/unified/SshConfig;", "showDeploymentOptions", "showSshOptions", "invokeLaterNonModal", "runnable", "Lkotlin/Function0;", "intellij.python.remoteInterpreter"})
@JvmName(name="DeploymentConfigurationUtil")
@SourceDebugExtension(value={"SMAP\ndeploymentConfigurationUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 deploymentConfigurationUtil.kt\ncom/intellij/python/remoteInterpreter/add/wizard/DeploymentConfigurationUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,158:1\n295#2,2:159\n*S KotlinDebug\n*F\n+ 1 deploymentConfigurationUtil.kt\ncom/intellij/python/remoteInterpreter/add/wizard/DeploymentConfigurationUtil\n*L\n41#1:159,2\n*E\n"})
public final class DeploymentConfigurationUtil {
    private static final NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Deployment");

    public static final void handleSshSdkSwitch(@NotNull Project project, @Nullable String webServerConfigId) {
        Notification notification;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (webServerConfigId != null) {
            Object v1;
            block4: {
                List list = GroupedServersConfigManager.getInstance((Project)project).getFlattenedServers();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFlattenedServers(...)");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    WebServerConfig it = (WebServerConfig)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)webServerConfigId)) continue;
                    v1 = element$iv;
                    break block4;
                }
                v1 = null;
            }
            WebServerConfig webServerConfig = v1;
            if (webServerConfig == null) {
                return;
            }
            WebServerConfig webServerConfig2 = webServerConfig;
            notification = new HandleSshSdkSwitchNotification(project, webServerConfig2);
        } else {
            notification = new HandleSshSdkDisabledNotification(project);
        }
        HandleSshSdkDisabledNotification notification2 = notification;
        ((Notification)notification2).notify(project);
    }

    public static final void notifyLaterThatDeploymentConfigurationCreated(@Nullable Project project, @NotNull WebServerConfig webServerConfig) {
        Intrinsics.checkNotNullParameter((Object)webServerConfig, (String)"webServerConfig");
        String host = webServerConfig.getFileTransferConfig().getHost();
        Object[] objectArray = new Object[]{host};
        String string = WDBundle.message((String)"deployment.configuration.message", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String message = string;
        DeploymentConfigurationUtil.invokeLaterNonModal((Function0<Unit>)((Function0)() -> DeploymentConfigurationUtil.notifyLaterThatDeploymentConfigurationCreated$lambda$0(message, project)));
    }

    public static final void notifyLaterThatSshConfigurationCreated(@Nullable Project project, @NotNull SshConfig sshConfig) {
        Intrinsics.checkNotNullParameter((Object)sshConfig, (String)"sshConfig");
        String string = sshConfig.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        String host = string;
        Object[] objectArray = new Object[]{host};
        String string2 = WDBundle.message((String)"ssh.configuration.message", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String message = string2;
        DeploymentConfigurationUtil.invokeLaterNonModal((Function0<Unit>)((Function0)() -> DeploymentConfigurationUtil.notifyLaterThatSshConfigurationCreated$lambda$0(message, project)));
    }

    private static final void showDeploymentOptions(Project project) {
        DeploymentConfigurationUtil.invokeLaterNonModal((Function0<Unit>)((Function0)() -> DeploymentConfigurationUtil.showDeploymentOptions$lambda$0(project)));
    }

    private static final void showSshOptions(Project project) {
        DeploymentConfigurationUtil.invokeLaterNonModal((Function0<Unit>)((Function0)() -> DeploymentConfigurationUtil.showSshOptions$lambda$0(project)));
    }

    private static final void invokeLaterNonModal(Function0<Unit> runnable) {
        ApplicationManager.getApplication().invokeLater(() -> DeploymentConfigurationUtil.invokeLaterNonModal$lambda$0(runnable), ModalityState.nonModal());
    }

    private static final Unit notifyLaterThatDeploymentConfigurationCreated$lambda$0(String $message, Project $project) {
        String string = PythonRemoteInterpreterBundle.message("deployment.configuration.action", new Object[0]);
        notificationGroup.createNotification($message, NotificationType.INFORMATION).setDisplayId("deployment.configuration.created").addAction(new AnAction($project, string){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DeploymentConfigurationUtil.access$showDeploymentOptions(this.$project);
            }
        }).notify($project);
        return Unit.INSTANCE;
    }

    private static final Unit notifyLaterThatSshConfigurationCreated$lambda$0(String $message, Project $project) {
        String string = WDBundle.message((String)"ssh.configuration.action.text", (Object[])new Object[0]);
        notificationGroup.createNotification($message, NotificationType.INFORMATION).setDisplayId("ssh.configuration.created").addAction(new AnAction($project, string){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super($super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                DeploymentConfigurationUtil.access$showSshOptions(this.$project);
            }
        }).notify($project);
        return Unit.INSTANCE;
    }

    private static final Unit showDeploymentOptions$lambda$0(Project $project) {
        ShowSettingsUtil.getInstance().showSettingsDialog($project, DeploymentConfigurable.class);
        return Unit.INSTANCE;
    }

    private static final Unit showSshOptions$lambda$0(Project $project) {
        ShowSettingsUtil.getInstance().showSettingsDialog($project, SshConfigConfigurable.Main.class);
        return Unit.INSTANCE;
    }

    private static final void invokeLaterNonModal$lambda$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    public static final /* synthetic */ NotificationGroup access$getNotificationGroup$p() {
        return notificationGroup;
    }

    public static final /* synthetic */ void access$showDeploymentOptions(Project project) {
        DeploymentConfigurationUtil.showDeploymentOptions(project);
    }

    public static final /* synthetic */ void access$showSshOptions(Project project) {
        DeploymentConfigurationUtil.showSshOptions(project);
    }
}

